/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMode;
import com.atlan.model.assets.IModeChart;
import com.atlan.model.assets.IModeQuery;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeChart
extends Asset
implements IModeChart,
IMode,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModeChart.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeChart";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    String modeChartType;
    @Attribute
    String modeId;
    @Attribute
    IModeQuery modeQuery;
    @Attribute
    String modeQueryName;
    @Attribute
    String modeQueryQualifiedName;
    @Attribute
    String modeReportName;
    @Attribute
    String modeReportQualifiedName;
    @Attribute
    String modeToken;
    @Attribute
    String modeWorkspaceName;
    @Attribute
    String modeWorkspaceQualifiedName;
    @Attribute
    String modeWorkspaceUsername;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public ModeChart trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ModeChart.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ModeChart.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ModeChart.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ModeChart.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ModeChart.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ModeChart.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return ModeChart.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return ModeChart.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return ModeChart.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static ModeChart refByGuid(String guid) {
        return ((ModeChartBuilder)ModeChart._internal().guid(guid)).build();
    }

    public static ModeChart refByQualifiedName(String qualifiedName) {
        return ((ModeChartBuilder)ModeChart._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static ModeChart get(String id) throws AtlanException {
        return ModeChart.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ModeChart get(AtlanClient client, String id) throws AtlanException {
        return ModeChart.get(client, id, true);
    }

    @JsonIgnore
    public static ModeChart get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ModeChart) {
                return (ModeChart)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ModeChart) {
            return (ModeChart)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static ModeChart retrieveByGuid(String guid) throws AtlanException {
        return ModeChart.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static ModeChart retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return ModeChart.get(client, guid);
    }

    @Deprecated
    public static ModeChart retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return ModeChart.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static ModeChart retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return ModeChart.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ModeChart.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ModeChartBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeChartBuilder)((ModeChartBuilder)((ModeChartBuilder)ModeChart._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ModeChartBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return ModeChart.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeChart removeDescription(String qualifiedName, String name) throws AtlanException {
        return ModeChart.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeChart removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeDescription(client, ModeChart.updater(qualifiedName, name));
    }

    public static ModeChart removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ModeChart.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeChart removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeUserDescription(client, ModeChart.updater(qualifiedName, name));
    }

    public static ModeChart removeOwners(String qualifiedName, String name) throws AtlanException {
        return ModeChart.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeChart removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeOwners(client, ModeChart.updater(qualifiedName, name));
    }

    public static ModeChart updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ModeChart.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ModeChart updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModeChart)Asset.updateCertificate(client, ModeChart._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeChart removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ModeChart.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeChart removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeCertificate(client, ModeChart.updater(qualifiedName, name));
    }

    public static ModeChart updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ModeChart.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ModeChart updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeChart)Asset.updateAnnouncement(client, ModeChart._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeChart removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ModeChart.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeChart removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeChart)Asset.removeAnnouncement(client, ModeChart.updater(qualifiedName, name));
    }

    public static ModeChart replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeChart.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ModeChart replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeChart)Asset.replaceTerms(client, ModeChart.updater(qualifiedName, name), terms);
    }

    public static ModeChart appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeChart.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ModeChart appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeChart)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ModeChart removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeChart.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ModeChart removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeChart)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ModeChart appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ModeChart.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ModeChart appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModeChart)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ModeChart appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ModeChart.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ModeChart appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModeChart)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        ModeChart.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        ModeChart.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ModeChart.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeChart(ModeChartBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeChart.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.modeChartType = b.modeChartType;
        this.modeId = b.modeId;
        this.modeQuery = b.modeQuery;
        this.modeQueryName = b.modeQueryName;
        this.modeQueryQualifiedName = b.modeQueryQualifiedName;
        this.modeReportName = b.modeReportName;
        this.modeReportQualifiedName = b.modeReportQualifiedName;
        this.modeToken = b.modeToken;
        this.modeWorkspaceName = b.modeWorkspaceName;
        this.modeWorkspaceQualifiedName = b.modeWorkspaceQualifiedName;
        this.modeWorkspaceUsername = b.modeWorkspaceUsername;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static ModeChartBuilder<?, ?> _internal() {
        return new ModeChartBuilderImpl();
    }

    @Generated
    public ModeChartBuilder<?, ?> toBuilder() {
        return new ModeChartBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public String getModeChartType() {
        return this.modeChartType;
    }

    @Override
    @Generated
    public String getModeId() {
        return this.modeId;
    }

    @Override
    @Generated
    public IModeQuery getModeQuery() {
        return this.modeQuery;
    }

    @Override
    @Generated
    public String getModeQueryName() {
        return this.modeQueryName;
    }

    @Override
    @Generated
    public String getModeQueryQualifiedName() {
        return this.modeQueryQualifiedName;
    }

    @Override
    @Generated
    public String getModeReportName() {
        return this.modeReportName;
    }

    @Override
    @Generated
    public String getModeReportQualifiedName() {
        return this.modeReportQualifiedName;
    }

    @Override
    @Generated
    public String getModeToken() {
        return this.modeToken;
    }

    @Override
    @Generated
    public String getModeWorkspaceName() {
        return this.modeWorkspaceName;
    }

    @Override
    @Generated
    public String getModeWorkspaceQualifiedName() {
        return this.modeWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public String getModeWorkspaceUsername() {
        return this.modeWorkspaceUsername;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeChart)) {
            return false;
        }
        ModeChart other = (ModeChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        String this$modeChartType = this.getModeChartType();
        String other$modeChartType = other.getModeChartType();
        if (this$modeChartType == null ? other$modeChartType != null : !this$modeChartType.equals(other$modeChartType)) {
            return false;
        }
        String this$modeId = this.getModeId();
        String other$modeId = other.getModeId();
        if (this$modeId == null ? other$modeId != null : !this$modeId.equals(other$modeId)) {
            return false;
        }
        IModeQuery this$modeQuery = this.getModeQuery();
        IModeQuery other$modeQuery = other.getModeQuery();
        if (this$modeQuery == null ? other$modeQuery != null : !this$modeQuery.equals(other$modeQuery)) {
            return false;
        }
        String this$modeQueryName = this.getModeQueryName();
        String other$modeQueryName = other.getModeQueryName();
        if (this$modeQueryName == null ? other$modeQueryName != null : !this$modeQueryName.equals(other$modeQueryName)) {
            return false;
        }
        String this$modeQueryQualifiedName = this.getModeQueryQualifiedName();
        String other$modeQueryQualifiedName = other.getModeQueryQualifiedName();
        if (this$modeQueryQualifiedName == null ? other$modeQueryQualifiedName != null : !this$modeQueryQualifiedName.equals(other$modeQueryQualifiedName)) {
            return false;
        }
        String this$modeReportName = this.getModeReportName();
        String other$modeReportName = other.getModeReportName();
        if (this$modeReportName == null ? other$modeReportName != null : !this$modeReportName.equals(other$modeReportName)) {
            return false;
        }
        String this$modeReportQualifiedName = this.getModeReportQualifiedName();
        String other$modeReportQualifiedName = other.getModeReportQualifiedName();
        if (this$modeReportQualifiedName == null ? other$modeReportQualifiedName != null : !this$modeReportQualifiedName.equals(other$modeReportQualifiedName)) {
            return false;
        }
        String this$modeToken = this.getModeToken();
        String other$modeToken = other.getModeToken();
        if (this$modeToken == null ? other$modeToken != null : !this$modeToken.equals(other$modeToken)) {
            return false;
        }
        String this$modeWorkspaceName = this.getModeWorkspaceName();
        String other$modeWorkspaceName = other.getModeWorkspaceName();
        if (this$modeWorkspaceName == null ? other$modeWorkspaceName != null : !this$modeWorkspaceName.equals(other$modeWorkspaceName)) {
            return false;
        }
        String this$modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        String other$modeWorkspaceQualifiedName = other.getModeWorkspaceQualifiedName();
        if (this$modeWorkspaceQualifiedName == null ? other$modeWorkspaceQualifiedName != null : !this$modeWorkspaceQualifiedName.equals(other$modeWorkspaceQualifiedName)) {
            return false;
        }
        String this$modeWorkspaceUsername = this.getModeWorkspaceUsername();
        String other$modeWorkspaceUsername = other.getModeWorkspaceUsername();
        if (this$modeWorkspaceUsername == null ? other$modeWorkspaceUsername != null : !this$modeWorkspaceUsername.equals(other$modeWorkspaceUsername)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeChart;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        String $modeChartType = this.getModeChartType();
        result = result * 59 + ($modeChartType == null ? 43 : $modeChartType.hashCode());
        String $modeId = this.getModeId();
        result = result * 59 + ($modeId == null ? 43 : $modeId.hashCode());
        IModeQuery $modeQuery = this.getModeQuery();
        result = result * 59 + ($modeQuery == null ? 43 : $modeQuery.hashCode());
        String $modeQueryName = this.getModeQueryName();
        result = result * 59 + ($modeQueryName == null ? 43 : $modeQueryName.hashCode());
        String $modeQueryQualifiedName = this.getModeQueryQualifiedName();
        result = result * 59 + ($modeQueryQualifiedName == null ? 43 : $modeQueryQualifiedName.hashCode());
        String $modeReportName = this.getModeReportName();
        result = result * 59 + ($modeReportName == null ? 43 : $modeReportName.hashCode());
        String $modeReportQualifiedName = this.getModeReportQualifiedName();
        result = result * 59 + ($modeReportQualifiedName == null ? 43 : $modeReportQualifiedName.hashCode());
        String $modeToken = this.getModeToken();
        result = result * 59 + ($modeToken == null ? 43 : $modeToken.hashCode());
        String $modeWorkspaceName = this.getModeWorkspaceName();
        result = result * 59 + ($modeWorkspaceName == null ? 43 : $modeWorkspaceName.hashCode());
        String $modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        result = result * 59 + ($modeWorkspaceQualifiedName == null ? 43 : $modeWorkspaceQualifiedName.hashCode());
        String $modeWorkspaceUsername = this.getModeWorkspaceUsername();
        result = result * 59 + ($modeWorkspaceUsername == null ? 43 : $modeWorkspaceUsername.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ModeChart(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", modeChartType=" + this.getModeChartType() + ", modeId=" + this.getModeId() + ", modeQuery=" + this.getModeQuery() + ", modeQueryName=" + this.getModeQueryName() + ", modeQueryQualifiedName=" + this.getModeQueryQualifiedName() + ", modeReportName=" + this.getModeReportName() + ", modeReportQualifiedName=" + this.getModeReportQualifiedName() + ", modeToken=" + this.getModeToken() + ", modeWorkspaceName=" + this.getModeWorkspaceName() + ", modeWorkspaceQualifiedName=" + this.getModeWorkspaceQualifiedName() + ", modeWorkspaceUsername=" + this.getModeWorkspaceUsername() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class ModeChartBuilderImpl
    extends ModeChartBuilder<ModeChart, ModeChartBuilderImpl> {
        @Generated
        private ModeChartBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeChartBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeChart build() {
            return new ModeChart(this);
        }
    }

    @Generated
    public static abstract class ModeChartBuilder<C extends ModeChart, B extends ModeChartBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private String modeChartType;
        @Generated
        private String modeId;
        @Generated
        private IModeQuery modeQuery;
        @Generated
        private String modeQueryName;
        @Generated
        private String modeQueryQualifiedName;
        @Generated
        private String modeReportName;
        @Generated
        private String modeReportQualifiedName;
        @Generated
        private String modeToken;
        @Generated
        private String modeWorkspaceName;
        @Generated
        private String modeWorkspaceQualifiedName;
        @Generated
        private String modeWorkspaceUsername;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeChartBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeChart instance, ModeChartBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.modeChartType(instance.modeChartType);
            b.modeId(instance.modeId);
            b.modeQuery(instance.modeQuery);
            b.modeQueryName(instance.modeQueryName);
            b.modeQueryQualifiedName(instance.modeQueryQualifiedName);
            b.modeReportName(instance.modeReportName);
            b.modeReportQualifiedName(instance.modeReportQualifiedName);
            b.modeToken(instance.modeToken);
            b.modeWorkspaceName(instance.modeWorkspaceName);
            b.modeWorkspaceQualifiedName(instance.modeWorkspaceQualifiedName);
            b.modeWorkspaceUsername(instance.modeWorkspaceUsername);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeChartType(String modeChartType) {
            this.modeChartType = modeChartType;
            return (B)this.self();
        }

        @Generated
        public B modeId(String modeId) {
            this.modeId = modeId;
            return (B)this.self();
        }

        @Generated
        public B modeQuery(IModeQuery modeQuery) {
            this.modeQuery = modeQuery;
            return (B)this.self();
        }

        @Generated
        public B modeQueryName(String modeQueryName) {
            this.modeQueryName = modeQueryName;
            return (B)this.self();
        }

        @Generated
        public B modeQueryQualifiedName(String modeQueryQualifiedName) {
            this.modeQueryQualifiedName = modeQueryQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeReportName(String modeReportName) {
            this.modeReportName = modeReportName;
            return (B)this.self();
        }

        @Generated
        public B modeReportQualifiedName(String modeReportQualifiedName) {
            this.modeReportQualifiedName = modeReportQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeToken(String modeToken) {
            this.modeToken = modeToken;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceName(String modeWorkspaceName) {
            this.modeWorkspaceName = modeWorkspaceName;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceQualifiedName(String modeWorkspaceQualifiedName) {
            this.modeWorkspaceQualifiedName = modeWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceUsername(String modeWorkspaceUsername) {
            this.modeWorkspaceUsername = modeWorkspaceUsername;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ModeChart.ModeChartBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", modeChartType=" + this.modeChartType + ", modeId=" + this.modeId + ", modeQuery=" + this.modeQuery + ", modeQueryName=" + this.modeQueryName + ", modeQueryQualifiedName=" + this.modeQueryQualifiedName + ", modeReportName=" + this.modeReportName + ", modeReportQualifiedName=" + this.modeReportQualifiedName + ", modeToken=" + this.modeToken + ", modeWorkspaceName=" + this.modeWorkspaceName + ", modeWorkspaceQualifiedName=" + this.modeWorkspaceQualifiedName + ", modeWorkspaceUsername=" + this.modeWorkspaceUsername + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

