/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMode;
import com.atlan.model.assets.IModeCollection;
import com.atlan.model.assets.IModeReport;
import com.atlan.model.assets.IModeWorkspace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeCollection
extends Asset
implements IModeCollection,
IMode,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModeCollection.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeCollection";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    String modeCollectionState;
    @Attribute
    String modeCollectionType;
    @Attribute
    String modeId;
    @Attribute
    String modeQueryName;
    @Attribute
    String modeQueryQualifiedName;
    @Attribute
    String modeReportName;
    @Attribute
    String modeReportQualifiedName;
    @Attribute
    SortedSet<IModeReport> modeReports;
    @Attribute
    String modeToken;
    @Attribute
    IModeWorkspace modeWorkspace;
    @Attribute
    String modeWorkspaceName;
    @Attribute
    String modeWorkspaceQualifiedName;
    @Attribute
    String modeWorkspaceUsername;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public ModeCollection trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ModeCollection.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ModeCollection.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ModeCollection.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ModeCollection.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ModeCollection.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ModeCollection.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return ModeCollection.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return ModeCollection.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return ModeCollection.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static ModeCollection refByGuid(String guid) {
        return ((ModeCollectionBuilder)ModeCollection._internal().guid(guid)).build();
    }

    public static ModeCollection refByQualifiedName(String qualifiedName) {
        return ((ModeCollectionBuilder)ModeCollection._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static ModeCollection get(String id) throws AtlanException {
        return ModeCollection.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ModeCollection get(AtlanClient client, String id) throws AtlanException {
        return ModeCollection.get(client, id, true);
    }

    @JsonIgnore
    public static ModeCollection get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ModeCollection) {
                return (ModeCollection)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ModeCollection) {
            return (ModeCollection)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static ModeCollection retrieveByGuid(String guid) throws AtlanException {
        return ModeCollection.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static ModeCollection retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return ModeCollection.get(client, guid);
    }

    @Deprecated
    public static ModeCollection retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return ModeCollection.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static ModeCollection retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return ModeCollection.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ModeCollection.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ModeCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeCollectionBuilder)((ModeCollectionBuilder)((ModeCollectionBuilder)ModeCollection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ModeCollectionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return ModeCollection.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeCollection removeDescription(String qualifiedName, String name) throws AtlanException {
        return ModeCollection.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeCollection removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeDescription(client, ModeCollection.updater(qualifiedName, name));
    }

    public static ModeCollection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ModeCollection.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeCollection removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeUserDescription(client, ModeCollection.updater(qualifiedName, name));
    }

    public static ModeCollection removeOwners(String qualifiedName, String name) throws AtlanException {
        return ModeCollection.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeCollection removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeOwners(client, ModeCollection.updater(qualifiedName, name));
    }

    public static ModeCollection updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ModeCollection.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ModeCollection updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModeCollection)Asset.updateCertificate(client, ModeCollection._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeCollection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ModeCollection.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeCollection removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeCertificate(client, ModeCollection.updater(qualifiedName, name));
    }

    public static ModeCollection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ModeCollection.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ModeCollection updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeCollection)Asset.updateAnnouncement(client, ModeCollection._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeCollection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ModeCollection.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeCollection removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection)Asset.removeAnnouncement(client, ModeCollection.updater(qualifiedName, name));
    }

    public static ModeCollection replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeCollection.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ModeCollection replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeCollection)Asset.replaceTerms(client, ModeCollection.updater(qualifiedName, name), terms);
    }

    public static ModeCollection appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeCollection.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ModeCollection appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeCollection)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ModeCollection removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeCollection.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ModeCollection removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeCollection)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ModeCollection appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ModeCollection.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ModeCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModeCollection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ModeCollection appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ModeCollection.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ModeCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModeCollection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        ModeCollection.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        ModeCollection.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ModeCollection.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeCollection(ModeCollectionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeCollection.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.modeCollectionState = b.modeCollectionState;
        this.modeCollectionType = b.modeCollectionType;
        this.modeId = b.modeId;
        this.modeQueryName = b.modeQueryName;
        this.modeQueryQualifiedName = b.modeQueryQualifiedName;
        this.modeReportName = b.modeReportName;
        this.modeReportQualifiedName = b.modeReportQualifiedName;
        SortedSet<IModeReport> modeReports = new TreeSet<IModeReport>();
        if (b.modeReports != null) {
            modeReports.addAll(b.modeReports);
        }
        modeReports = Collections.unmodifiableSortedSet(modeReports);
        this.modeReports = modeReports;
        this.modeToken = b.modeToken;
        this.modeWorkspace = b.modeWorkspace;
        this.modeWorkspaceName = b.modeWorkspaceName;
        this.modeWorkspaceQualifiedName = b.modeWorkspaceQualifiedName;
        this.modeWorkspaceUsername = b.modeWorkspaceUsername;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static ModeCollectionBuilder<?, ?> _internal() {
        return new ModeCollectionBuilderImpl();
    }

    @Generated
    public ModeCollectionBuilder<?, ?> toBuilder() {
        return new ModeCollectionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public String getModeCollectionState() {
        return this.modeCollectionState;
    }

    @Override
    @Generated
    public String getModeCollectionType() {
        return this.modeCollectionType;
    }

    @Override
    @Generated
    public String getModeId() {
        return this.modeId;
    }

    @Override
    @Generated
    public String getModeQueryName() {
        return this.modeQueryName;
    }

    @Override
    @Generated
    public String getModeQueryQualifiedName() {
        return this.modeQueryQualifiedName;
    }

    @Override
    @Generated
    public String getModeReportName() {
        return this.modeReportName;
    }

    @Override
    @Generated
    public String getModeReportQualifiedName() {
        return this.modeReportQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IModeReport> getModeReports() {
        return this.modeReports;
    }

    @Override
    @Generated
    public String getModeToken() {
        return this.modeToken;
    }

    @Override
    @Generated
    public IModeWorkspace getModeWorkspace() {
        return this.modeWorkspace;
    }

    @Override
    @Generated
    public String getModeWorkspaceName() {
        return this.modeWorkspaceName;
    }

    @Override
    @Generated
    public String getModeWorkspaceQualifiedName() {
        return this.modeWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public String getModeWorkspaceUsername() {
        return this.modeWorkspaceUsername;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeCollection)) {
            return false;
        }
        ModeCollection other = (ModeCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        String this$modeCollectionState = this.getModeCollectionState();
        String other$modeCollectionState = other.getModeCollectionState();
        if (this$modeCollectionState == null ? other$modeCollectionState != null : !this$modeCollectionState.equals(other$modeCollectionState)) {
            return false;
        }
        String this$modeCollectionType = this.getModeCollectionType();
        String other$modeCollectionType = other.getModeCollectionType();
        if (this$modeCollectionType == null ? other$modeCollectionType != null : !this$modeCollectionType.equals(other$modeCollectionType)) {
            return false;
        }
        String this$modeId = this.getModeId();
        String other$modeId = other.getModeId();
        if (this$modeId == null ? other$modeId != null : !this$modeId.equals(other$modeId)) {
            return false;
        }
        String this$modeQueryName = this.getModeQueryName();
        String other$modeQueryName = other.getModeQueryName();
        if (this$modeQueryName == null ? other$modeQueryName != null : !this$modeQueryName.equals(other$modeQueryName)) {
            return false;
        }
        String this$modeQueryQualifiedName = this.getModeQueryQualifiedName();
        String other$modeQueryQualifiedName = other.getModeQueryQualifiedName();
        if (this$modeQueryQualifiedName == null ? other$modeQueryQualifiedName != null : !this$modeQueryQualifiedName.equals(other$modeQueryQualifiedName)) {
            return false;
        }
        String this$modeReportName = this.getModeReportName();
        String other$modeReportName = other.getModeReportName();
        if (this$modeReportName == null ? other$modeReportName != null : !this$modeReportName.equals(other$modeReportName)) {
            return false;
        }
        String this$modeReportQualifiedName = this.getModeReportQualifiedName();
        String other$modeReportQualifiedName = other.getModeReportQualifiedName();
        if (this$modeReportQualifiedName == null ? other$modeReportQualifiedName != null : !this$modeReportQualifiedName.equals(other$modeReportQualifiedName)) {
            return false;
        }
        SortedSet<IModeReport> this$modeReports = this.getModeReports();
        SortedSet<IModeReport> other$modeReports = other.getModeReports();
        if (this$modeReports == null ? other$modeReports != null : !this$modeReports.equals(other$modeReports)) {
            return false;
        }
        String this$modeToken = this.getModeToken();
        String other$modeToken = other.getModeToken();
        if (this$modeToken == null ? other$modeToken != null : !this$modeToken.equals(other$modeToken)) {
            return false;
        }
        IModeWorkspace this$modeWorkspace = this.getModeWorkspace();
        IModeWorkspace other$modeWorkspace = other.getModeWorkspace();
        if (this$modeWorkspace == null ? other$modeWorkspace != null : !this$modeWorkspace.equals(other$modeWorkspace)) {
            return false;
        }
        String this$modeWorkspaceName = this.getModeWorkspaceName();
        String other$modeWorkspaceName = other.getModeWorkspaceName();
        if (this$modeWorkspaceName == null ? other$modeWorkspaceName != null : !this$modeWorkspaceName.equals(other$modeWorkspaceName)) {
            return false;
        }
        String this$modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        String other$modeWorkspaceQualifiedName = other.getModeWorkspaceQualifiedName();
        if (this$modeWorkspaceQualifiedName == null ? other$modeWorkspaceQualifiedName != null : !this$modeWorkspaceQualifiedName.equals(other$modeWorkspaceQualifiedName)) {
            return false;
        }
        String this$modeWorkspaceUsername = this.getModeWorkspaceUsername();
        String other$modeWorkspaceUsername = other.getModeWorkspaceUsername();
        if (this$modeWorkspaceUsername == null ? other$modeWorkspaceUsername != null : !this$modeWorkspaceUsername.equals(other$modeWorkspaceUsername)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeCollection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        String $modeCollectionState = this.getModeCollectionState();
        result = result * 59 + ($modeCollectionState == null ? 43 : $modeCollectionState.hashCode());
        String $modeCollectionType = this.getModeCollectionType();
        result = result * 59 + ($modeCollectionType == null ? 43 : $modeCollectionType.hashCode());
        String $modeId = this.getModeId();
        result = result * 59 + ($modeId == null ? 43 : $modeId.hashCode());
        String $modeQueryName = this.getModeQueryName();
        result = result * 59 + ($modeQueryName == null ? 43 : $modeQueryName.hashCode());
        String $modeQueryQualifiedName = this.getModeQueryQualifiedName();
        result = result * 59 + ($modeQueryQualifiedName == null ? 43 : $modeQueryQualifiedName.hashCode());
        String $modeReportName = this.getModeReportName();
        result = result * 59 + ($modeReportName == null ? 43 : $modeReportName.hashCode());
        String $modeReportQualifiedName = this.getModeReportQualifiedName();
        result = result * 59 + ($modeReportQualifiedName == null ? 43 : $modeReportQualifiedName.hashCode());
        SortedSet<IModeReport> $modeReports = this.getModeReports();
        result = result * 59 + ($modeReports == null ? 43 : $modeReports.hashCode());
        String $modeToken = this.getModeToken();
        result = result * 59 + ($modeToken == null ? 43 : $modeToken.hashCode());
        IModeWorkspace $modeWorkspace = this.getModeWorkspace();
        result = result * 59 + ($modeWorkspace == null ? 43 : $modeWorkspace.hashCode());
        String $modeWorkspaceName = this.getModeWorkspaceName();
        result = result * 59 + ($modeWorkspaceName == null ? 43 : $modeWorkspaceName.hashCode());
        String $modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        result = result * 59 + ($modeWorkspaceQualifiedName == null ? 43 : $modeWorkspaceQualifiedName.hashCode());
        String $modeWorkspaceUsername = this.getModeWorkspaceUsername();
        result = result * 59 + ($modeWorkspaceUsername == null ? 43 : $modeWorkspaceUsername.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ModeCollection(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", modeCollectionState=" + this.getModeCollectionState() + ", modeCollectionType=" + this.getModeCollectionType() + ", modeId=" + this.getModeId() + ", modeQueryName=" + this.getModeQueryName() + ", modeQueryQualifiedName=" + this.getModeQueryQualifiedName() + ", modeReportName=" + this.getModeReportName() + ", modeReportQualifiedName=" + this.getModeReportQualifiedName() + ", modeReports=" + this.getModeReports() + ", modeToken=" + this.getModeToken() + ", modeWorkspace=" + this.getModeWorkspace() + ", modeWorkspaceName=" + this.getModeWorkspaceName() + ", modeWorkspaceQualifiedName=" + this.getModeWorkspaceQualifiedName() + ", modeWorkspaceUsername=" + this.getModeWorkspaceUsername() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class ModeCollectionBuilderImpl
    extends ModeCollectionBuilder<ModeCollection, ModeCollectionBuilderImpl> {
        @Generated
        private ModeCollectionBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeCollectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeCollection build() {
            return new ModeCollection(this);
        }
    }

    @Generated
    public static abstract class ModeCollectionBuilder<C extends ModeCollection, B extends ModeCollectionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private String modeCollectionState;
        @Generated
        private String modeCollectionType;
        @Generated
        private String modeId;
        @Generated
        private String modeQueryName;
        @Generated
        private String modeQueryQualifiedName;
        @Generated
        private String modeReportName;
        @Generated
        private String modeReportQualifiedName;
        @Generated
        private ArrayList<IModeReport> modeReports;
        @Generated
        private String modeToken;
        @Generated
        private IModeWorkspace modeWorkspace;
        @Generated
        private String modeWorkspaceName;
        @Generated
        private String modeWorkspaceQualifiedName;
        @Generated
        private String modeWorkspaceUsername;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeCollection instance, ModeCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.modeCollectionState(instance.modeCollectionState);
            b.modeCollectionType(instance.modeCollectionType);
            b.modeId(instance.modeId);
            b.modeQueryName(instance.modeQueryName);
            b.modeQueryQualifiedName(instance.modeQueryQualifiedName);
            b.modeReportName(instance.modeReportName);
            b.modeReportQualifiedName(instance.modeReportQualifiedName);
            b.modeReports(instance.modeReports == null ? Collections.emptySortedSet() : instance.modeReports);
            b.modeToken(instance.modeToken);
            b.modeWorkspace(instance.modeWorkspace);
            b.modeWorkspaceName(instance.modeWorkspaceName);
            b.modeWorkspaceQualifiedName(instance.modeWorkspaceQualifiedName);
            b.modeWorkspaceUsername(instance.modeWorkspaceUsername);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeCollectionState(String modeCollectionState) {
            this.modeCollectionState = modeCollectionState;
            return (B)this.self();
        }

        @Generated
        public B modeCollectionType(String modeCollectionType) {
            this.modeCollectionType = modeCollectionType;
            return (B)this.self();
        }

        @Generated
        public B modeId(String modeId) {
            this.modeId = modeId;
            return (B)this.self();
        }

        @Generated
        public B modeQueryName(String modeQueryName) {
            this.modeQueryName = modeQueryName;
            return (B)this.self();
        }

        @Generated
        public B modeQueryQualifiedName(String modeQueryQualifiedName) {
            this.modeQueryQualifiedName = modeQueryQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeReportName(String modeReportName) {
            this.modeReportName = modeReportName;
            return (B)this.self();
        }

        @Generated
        public B modeReportQualifiedName(String modeReportQualifiedName) {
            this.modeReportQualifiedName = modeReportQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeReport(IModeReport modeReport) {
            if (this.modeReports == null) {
                this.modeReports = new ArrayList();
            }
            this.modeReports.add(modeReport);
            return (B)this.self();
        }

        @Generated
        public B modeReports(Collection<? extends IModeReport> modeReports) {
            if (modeReports == null) {
                throw new NullPointerException("modeReports cannot be null");
            }
            if (this.modeReports == null) {
                this.modeReports = new ArrayList();
            }
            this.modeReports.addAll(modeReports);
            return (B)this.self();
        }

        @Generated
        public B clearModeReports() {
            if (this.modeReports != null) {
                this.modeReports.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeToken(String modeToken) {
            this.modeToken = modeToken;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspace(IModeWorkspace modeWorkspace) {
            this.modeWorkspace = modeWorkspace;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceName(String modeWorkspaceName) {
            this.modeWorkspaceName = modeWorkspaceName;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceQualifiedName(String modeWorkspaceQualifiedName) {
            this.modeWorkspaceQualifiedName = modeWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceUsername(String modeWorkspaceUsername) {
            this.modeWorkspaceUsername = modeWorkspaceUsername;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ModeCollection.ModeCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", modeCollectionState=" + this.modeCollectionState + ", modeCollectionType=" + this.modeCollectionType + ", modeId=" + this.modeId + ", modeQueryName=" + this.modeQueryName + ", modeQueryQualifiedName=" + this.modeQueryQualifiedName + ", modeReportName=" + this.modeReportName + ", modeReportQualifiedName=" + this.modeReportQualifiedName + ", modeReports=" + this.modeReports + ", modeToken=" + this.modeToken + ", modeWorkspace=" + this.modeWorkspace + ", modeWorkspaceName=" + this.modeWorkspaceName + ", modeWorkspaceQualifiedName=" + this.modeWorkspaceQualifiedName + ", modeWorkspaceUsername=" + this.modeWorkspaceUsername + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

