/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.AuthPolicy;
import com.atlan.model.assets.IAccessControl;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAuthPolicy;
import com.atlan.model.assets.IPersona;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AssetSidebarTab;
import com.atlan.model.enums.AuthPolicyCategory;
import com.atlan.model.enums.AuthPolicyResourceCategory;
import com.atlan.model.enums.AuthPolicyType;
import com.atlan.model.enums.DataAction;
import com.atlan.model.enums.PersonaGlossaryAction;
import com.atlan.model.enums.PersonaMetadataAction;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persona
extends Asset
implements IPersona,
IAccessControl,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Persona.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Persona";
    String typeName;
    @Attribute
    String channelLink;
    @Attribute
    SortedSet<AssetSidebarTab> denyAssetTabs;
    @Attribute
    SortedSet<String> denyCustomMetadataGuids;
    @Attribute
    Boolean isAccessControlEnabled;
    @Attribute
    SortedSet<String> personaGroups;
    @Attribute
    SortedSet<String> personaUsers;
    @Attribute
    SortedSet<IAuthPolicy> policies;
    @Attribute
    String roleId;

    @Override
    public Persona trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Persona.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Persona.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Persona.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return Persona.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Persona.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return Persona.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return Persona.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return Persona.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return Persona.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static Persona refByGuid(String guid) {
        return ((PersonaBuilder)Persona._internal().guid(guid)).build();
    }

    public static Persona refByQualifiedName(String qualifiedName) {
        return ((PersonaBuilder)Persona._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static Persona get(String id) throws AtlanException {
        return Persona.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static Persona get(AtlanClient client, String id) throws AtlanException {
        return Persona.get(client, id, true);
    }

    @JsonIgnore
    public static Persona get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Persona) {
                return (Persona)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof Persona) {
            return (Persona)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static Persona retrieveByGuid(String guid) throws AtlanException {
        return Persona.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static Persona retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return Persona.get(client, guid);
    }

    @Deprecated
    public static Persona retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return Persona.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static Persona retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return Persona.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Persona.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PersonaBuilder<?, ?> creator(String name) {
        return (PersonaBuilder)((Asset.AssetBuilder)((PersonaBuilder)((PersonaBuilder)((PersonaBuilder)((PersonaBuilder)Persona._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(name)).name(name)).displayName(name)).isAccessControlEnabled(true)).description("");
    }

    public static PersonaBuilder<?, ?> updater(String qualifiedName, String name, boolean isEnabled) {
        return ((PersonaBuilder)((PersonaBuilder)((PersonaBuilder)Persona._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name)).isAccessControlEnabled(isEnabled);
    }

    public PersonaBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (this.getIsAccessControlEnabled() == null) {
            missing.add("isAccessControlEnabled");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return Persona.updater(this.getQualifiedName(), this.getName(), this.getIsAccessControlEnabled());
    }

    public static List<Persona> findByName(String name) throws AtlanException {
        return Persona.findByName(name, (List<AtlanField>)null);
    }

    public static List<Persona> findByName(String name, Collection<String> attributes) throws AtlanException {
        return Persona.findByName(Atlan.getDefaultClient(), name, attributes);
    }

    public static List<Persona> findByName(String name, List<AtlanField> attributes) throws AtlanException {
        return Persona.findByName(Atlan.getDefaultClient(), name, attributes);
    }

    public static List<Persona> findByName(AtlanClient client, String name) throws AtlanException {
        return Persona.findByName(client, name, (List<AtlanField>)null);
    }

    public static List<Persona> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        ArrayList<Persona> results = new ArrayList<Persona>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Persona.select(client).where(NAME.eq(name)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof Persona).forEach(p -> results.add((Persona)p));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.PERSONA_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static List<Persona> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        ArrayList<Persona> results = new ArrayList<Persona>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Persona.select(client).where(NAME.eq(name))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof Persona).forEach(p -> results.add((Persona)p));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.PERSONA_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createMetadataPolicy(String name, String personaId, AuthPolicyType policyType, Collection<PersonaMetadataAction> actions, String connectionQualifiedName, Collection<String> resources) {
        return ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((Asset.AssetBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyActions(actions)).policyCategory(AuthPolicyCategory.PERSONA)).policyType(policyType)).connectionQualifiedName(connectionQualifiedName)).policyResources(resources)).policyResourceCategory(AuthPolicyResourceCategory.CUSTOM)).policyServiceName("atlas")).policySubCategory("metadata")).accessControl(Persona.refByGuid(personaId));
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createDataPolicy(String name, String personaId, AuthPolicyType policyType, String connectionQualifiedName, Collection<String> resources) {
        return ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((Asset.AssetBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyAction(DataAction.SELECT)).policyCategory(AuthPolicyCategory.PERSONA)).policyType(policyType)).connectionQualifiedName(connectionQualifiedName)).policyResources(resources)).policyResource("entity-type:*")).policyResourceCategory(AuthPolicyResourceCategory.ENTITY)).policyServiceName("heka")).policySubCategory("data")).accessControl(Persona.refByGuid(personaId));
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createGlossaryPolicy(String name, String personaId, AuthPolicyType policyType, Collection<PersonaGlossaryAction> actions, Collection<String> resources) {
        return ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyActions(actions)).policyCategory(AuthPolicyCategory.PERSONA)).policyType(policyType)).policyResources(resources)).policyResourceCategory(AuthPolicyResourceCategory.CUSTOM)).policyServiceName("atlas")).policySubCategory("glossary")).accessControl(Persona.refByGuid(personaId));
    }

    public static Persona removeDescription(String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return Persona.removeDescription(Atlan.getDefaultClient(), qualifiedName, name, isEnabled);
    }

    public static Persona removeDescription(AtlanClient client, String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return (Persona)Asset.removeDescription(client, Persona.updater(qualifiedName, name, isEnabled));
    }

    public static Persona removeUserDescription(String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return Persona.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name, isEnabled);
    }

    public static Persona removeUserDescription(AtlanClient client, String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return (Persona)Asset.removeUserDescription(client, Persona.updater(qualifiedName, name, isEnabled));
    }

    public static Persona appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return Persona.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static Persona appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Persona)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static Persona appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return Persona.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static Persona appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Persona)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Persona.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Persona.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        Persona.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Persona(PersonaBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Persona.$default$typeName();
        this.channelLink = b.channelLink;
        SortedSet<AssetSidebarTab> denyAssetTabs = new TreeSet<AssetSidebarTab>();
        if (b.denyAssetTabs != null) {
            denyAssetTabs.addAll(b.denyAssetTabs);
        }
        denyAssetTabs = Collections.unmodifiableSortedSet(denyAssetTabs);
        this.denyAssetTabs = denyAssetTabs;
        SortedSet<String> denyCustomMetadataGuids = new TreeSet<String>();
        if (b.denyCustomMetadataGuids != null) {
            denyCustomMetadataGuids.addAll(b.denyCustomMetadataGuids);
        }
        denyCustomMetadataGuids = Collections.unmodifiableSortedSet(denyCustomMetadataGuids);
        this.denyCustomMetadataGuids = denyCustomMetadataGuids;
        this.isAccessControlEnabled = b.isAccessControlEnabled;
        SortedSet<String> personaGroups = new TreeSet<String>();
        if (b.personaGroups != null) {
            personaGroups.addAll(b.personaGroups);
        }
        personaGroups = Collections.unmodifiableSortedSet(personaGroups);
        this.personaGroups = personaGroups;
        SortedSet<String> personaUsers = new TreeSet<String>();
        if (b.personaUsers != null) {
            personaUsers.addAll(b.personaUsers);
        }
        personaUsers = Collections.unmodifiableSortedSet(personaUsers);
        this.personaUsers = personaUsers;
        SortedSet<IAuthPolicy> policies = new TreeSet<IAuthPolicy>();
        if (b.policies != null) {
            policies.addAll(b.policies);
        }
        policies = Collections.unmodifiableSortedSet(policies);
        this.policies = policies;
        this.roleId = b.roleId;
    }

    @Generated
    public static PersonaBuilder<?, ?> _internal() {
        return new PersonaBuilderImpl();
    }

    @Generated
    public PersonaBuilder<?, ?> toBuilder() {
        return new PersonaBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getChannelLink() {
        return this.channelLink;
    }

    @Override
    @Generated
    public SortedSet<AssetSidebarTab> getDenyAssetTabs() {
        return this.denyAssetTabs;
    }

    @Override
    @Generated
    public SortedSet<String> getDenyCustomMetadataGuids() {
        return this.denyCustomMetadataGuids;
    }

    @Override
    @Generated
    public Boolean getIsAccessControlEnabled() {
        return this.isAccessControlEnabled;
    }

    @Override
    @Generated
    public SortedSet<String> getPersonaGroups() {
        return this.personaGroups;
    }

    @Override
    @Generated
    public SortedSet<String> getPersonaUsers() {
        return this.personaUsers;
    }

    @Override
    @Generated
    public SortedSet<IAuthPolicy> getPolicies() {
        return this.policies;
    }

    @Override
    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Persona)) {
            return false;
        }
        Persona other = (Persona)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isAccessControlEnabled = this.getIsAccessControlEnabled();
        Boolean other$isAccessControlEnabled = other.getIsAccessControlEnabled();
        if (this$isAccessControlEnabled == null ? other$isAccessControlEnabled != null : !((Object)this$isAccessControlEnabled).equals(other$isAccessControlEnabled)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$channelLink = this.getChannelLink();
        String other$channelLink = other.getChannelLink();
        if (this$channelLink == null ? other$channelLink != null : !this$channelLink.equals(other$channelLink)) {
            return false;
        }
        SortedSet<AssetSidebarTab> this$denyAssetTabs = this.getDenyAssetTabs();
        SortedSet<AssetSidebarTab> other$denyAssetTabs = other.getDenyAssetTabs();
        if (this$denyAssetTabs == null ? other$denyAssetTabs != null : !this$denyAssetTabs.equals(other$denyAssetTabs)) {
            return false;
        }
        SortedSet<String> this$denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        SortedSet<String> other$denyCustomMetadataGuids = other.getDenyCustomMetadataGuids();
        if (this$denyCustomMetadataGuids == null ? other$denyCustomMetadataGuids != null : !this$denyCustomMetadataGuids.equals(other$denyCustomMetadataGuids)) {
            return false;
        }
        SortedSet<String> this$personaGroups = this.getPersonaGroups();
        SortedSet<String> other$personaGroups = other.getPersonaGroups();
        if (this$personaGroups == null ? other$personaGroups != null : !this$personaGroups.equals(other$personaGroups)) {
            return false;
        }
        SortedSet<String> this$personaUsers = this.getPersonaUsers();
        SortedSet<String> other$personaUsers = other.getPersonaUsers();
        if (this$personaUsers == null ? other$personaUsers != null : !this$personaUsers.equals(other$personaUsers)) {
            return false;
        }
        SortedSet<IAuthPolicy> this$policies = this.getPolicies();
        SortedSet<IAuthPolicy> other$policies = other.getPolicies();
        if (this$policies == null ? other$policies != null : !this$policies.equals(other$policies)) {
            return false;
        }
        String this$roleId = this.getRoleId();
        String other$roleId = other.getRoleId();
        return !(this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Persona;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isAccessControlEnabled = this.getIsAccessControlEnabled();
        result = result * 59 + ($isAccessControlEnabled == null ? 43 : ((Object)$isAccessControlEnabled).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $channelLink = this.getChannelLink();
        result = result * 59 + ($channelLink == null ? 43 : $channelLink.hashCode());
        SortedSet<AssetSidebarTab> $denyAssetTabs = this.getDenyAssetTabs();
        result = result * 59 + ($denyAssetTabs == null ? 43 : $denyAssetTabs.hashCode());
        SortedSet<String> $denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        result = result * 59 + ($denyCustomMetadataGuids == null ? 43 : $denyCustomMetadataGuids.hashCode());
        SortedSet<String> $personaGroups = this.getPersonaGroups();
        result = result * 59 + ($personaGroups == null ? 43 : $personaGroups.hashCode());
        SortedSet<String> $personaUsers = this.getPersonaUsers();
        result = result * 59 + ($personaUsers == null ? 43 : $personaUsers.hashCode());
        SortedSet<IAuthPolicy> $policies = this.getPolicies();
        result = result * 59 + ($policies == null ? 43 : $policies.hashCode());
        String $roleId = this.getRoleId();
        result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Persona(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", channelLink=" + this.getChannelLink() + ", denyAssetTabs=" + this.getDenyAssetTabs() + ", denyCustomMetadataGuids=" + this.getDenyCustomMetadataGuids() + ", isAccessControlEnabled=" + this.getIsAccessControlEnabled() + ", personaGroups=" + this.getPersonaGroups() + ", personaUsers=" + this.getPersonaUsers() + ", policies=" + this.getPolicies() + ", roleId=" + this.getRoleId() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class PersonaBuilderImpl
    extends PersonaBuilder<Persona, PersonaBuilderImpl> {
        @Generated
        private PersonaBuilderImpl() {
        }

        @Override
        @Generated
        protected PersonaBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Persona build() {
            return new Persona(this);
        }
    }

    @Generated
    public static abstract class PersonaBuilder<C extends Persona, B extends PersonaBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String channelLink;
        @Generated
        private ArrayList<AssetSidebarTab> denyAssetTabs;
        @Generated
        private ArrayList<String> denyCustomMetadataGuids;
        @Generated
        private Boolean isAccessControlEnabled;
        @Generated
        private ArrayList<String> personaGroups;
        @Generated
        private ArrayList<String> personaUsers;
        @Generated
        private ArrayList<IAuthPolicy> policies;
        @Generated
        private String roleId;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PersonaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Persona instance, PersonaBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.channelLink(instance.channelLink);
            b.denyAssetTabs(instance.denyAssetTabs == null ? Collections.emptySortedSet() : instance.denyAssetTabs);
            b.denyCustomMetadataGuids(instance.denyCustomMetadataGuids == null ? Collections.emptySortedSet() : instance.denyCustomMetadataGuids);
            b.isAccessControlEnabled(instance.isAccessControlEnabled);
            b.personaGroups(instance.personaGroups == null ? Collections.emptySortedSet() : instance.personaGroups);
            b.personaUsers(instance.personaUsers == null ? Collections.emptySortedSet() : instance.personaUsers);
            b.policies(instance.policies == null ? Collections.emptySortedSet() : instance.policies);
            b.roleId(instance.roleId);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B channelLink(String channelLink) {
            this.channelLink = channelLink;
            return (B)this.self();
        }

        @Generated
        public B denyAssetTab(AssetSidebarTab denyAssetTab) {
            if (this.denyAssetTabs == null) {
                this.denyAssetTabs = new ArrayList();
            }
            this.denyAssetTabs.add(denyAssetTab);
            return (B)this.self();
        }

        @Generated
        public B denyAssetTabs(Collection<? extends AssetSidebarTab> denyAssetTabs) {
            if (denyAssetTabs == null) {
                throw new NullPointerException("denyAssetTabs cannot be null");
            }
            if (this.denyAssetTabs == null) {
                this.denyAssetTabs = new ArrayList();
            }
            this.denyAssetTabs.addAll(denyAssetTabs);
            return (B)this.self();
        }

        @Generated
        public B clearDenyAssetTabs() {
            if (this.denyAssetTabs != null) {
                this.denyAssetTabs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B denyCustomMetadataGuid(String denyCustomMetadataGuid) {
            if (this.denyCustomMetadataGuids == null) {
                this.denyCustomMetadataGuids = new ArrayList();
            }
            this.denyCustomMetadataGuids.add(denyCustomMetadataGuid);
            return (B)this.self();
        }

        @Generated
        public B denyCustomMetadataGuids(Collection<? extends String> denyCustomMetadataGuids) {
            if (denyCustomMetadataGuids == null) {
                throw new NullPointerException("denyCustomMetadataGuids cannot be null");
            }
            if (this.denyCustomMetadataGuids == null) {
                this.denyCustomMetadataGuids = new ArrayList();
            }
            this.denyCustomMetadataGuids.addAll(denyCustomMetadataGuids);
            return (B)this.self();
        }

        @Generated
        public B clearDenyCustomMetadataGuids() {
            if (this.denyCustomMetadataGuids != null) {
                this.denyCustomMetadataGuids.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isAccessControlEnabled(Boolean isAccessControlEnabled) {
            this.isAccessControlEnabled = isAccessControlEnabled;
            return (B)this.self();
        }

        @Generated
        public B personaGroup(String personaGroup) {
            if (this.personaGroups == null) {
                this.personaGroups = new ArrayList();
            }
            this.personaGroups.add(personaGroup);
            return (B)this.self();
        }

        @Generated
        public B personaGroups(Collection<? extends String> personaGroups) {
            if (personaGroups == null) {
                throw new NullPointerException("personaGroups cannot be null");
            }
            if (this.personaGroups == null) {
                this.personaGroups = new ArrayList();
            }
            this.personaGroups.addAll(personaGroups);
            return (B)this.self();
        }

        @Generated
        public B clearPersonaGroups() {
            if (this.personaGroups != null) {
                this.personaGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B personaUser(String personaUser) {
            if (this.personaUsers == null) {
                this.personaUsers = new ArrayList();
            }
            this.personaUsers.add(personaUser);
            return (B)this.self();
        }

        @Generated
        public B personaUsers(Collection<? extends String> personaUsers) {
            if (personaUsers == null) {
                throw new NullPointerException("personaUsers cannot be null");
            }
            if (this.personaUsers == null) {
                this.personaUsers = new ArrayList();
            }
            this.personaUsers.addAll(personaUsers);
            return (B)this.self();
        }

        @Generated
        public B clearPersonaUsers() {
            if (this.personaUsers != null) {
                this.personaUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B policy(IAuthPolicy policy) {
            if (this.policies == null) {
                this.policies = new ArrayList();
            }
            this.policies.add(policy);
            return (B)this.self();
        }

        @Generated
        public B policies(Collection<? extends IAuthPolicy> policies) {
            if (policies == null) {
                throw new NullPointerException("policies cannot be null");
            }
            if (this.policies == null) {
                this.policies = new ArrayList();
            }
            this.policies.addAll(policies);
            return (B)this.self();
        }

        @Generated
        public B clearPolicies() {
            if (this.policies != null) {
                this.policies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B roleId(String roleId) {
            this.roleId = roleId;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Persona.PersonaBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", channelLink=" + this.channelLink + ", denyAssetTabs=" + this.denyAssetTabs + ", denyCustomMetadataGuids=" + this.denyCustomMetadataGuids + ", isAccessControlEnabled=" + this.isAccessControlEnabled + ", personaGroups=" + this.personaGroups + ", personaUsers=" + this.personaUsers + ", policies=" + this.policies + ", roleId=" + this.roleId + ")";
        }
    }
}

