/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IPowerBI;
import com.atlan.model.assets.IPowerBIColumn;
import com.atlan.model.assets.IPowerBITable;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerBIColumn
extends Asset
implements IPowerBIColumn,
IPowerBI,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerBIColumn.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIColumn";
    String typeName;
    @Attribute
    String datasetQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    String powerBIColumnDataCategory;
    @Attribute
    String powerBIColumnDataType;
    @Attribute
    String powerBIColumnSummarizeBy;
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    @Attribute
    String powerBIFormatString;
    @Attribute
    Boolean powerBIIsHidden;
    @Attribute
    String powerBISortByColumn;
    @Attribute
    String powerBITableQualifiedName;
    @Attribute
    IPowerBITable table;
    @Attribute
    String workspaceQualifiedName;

    @Override
    public PowerBIColumn trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PowerBIColumn.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PowerBIColumn.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PowerBIColumn.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return PowerBIColumn.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PowerBIColumn.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return PowerBIColumn.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return PowerBIColumn.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return PowerBIColumn.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return PowerBIColumn.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static PowerBIColumn refByGuid(String guid) {
        return ((PowerBIColumnBuilder)PowerBIColumn._internal().guid(guid)).build();
    }

    public static PowerBIColumn refByQualifiedName(String qualifiedName) {
        return ((PowerBIColumnBuilder)PowerBIColumn._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static PowerBIColumn get(String id) throws AtlanException {
        return PowerBIColumn.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static PowerBIColumn get(AtlanClient client, String id) throws AtlanException {
        return PowerBIColumn.get(client, id, true);
    }

    @JsonIgnore
    public static PowerBIColumn get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PowerBIColumn) {
                return (PowerBIColumn)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof PowerBIColumn) {
            return (PowerBIColumn)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static PowerBIColumn retrieveByGuid(String guid) throws AtlanException {
        return PowerBIColumn.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static PowerBIColumn retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return PowerBIColumn.get(client, guid);
    }

    @Deprecated
    public static PowerBIColumn retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return PowerBIColumn.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static PowerBIColumn retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return PowerBIColumn.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return PowerBIColumn.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PowerBIColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIColumnBuilder)((PowerBIColumnBuilder)((PowerBIColumnBuilder)PowerBIColumn._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PowerBIColumnBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return PowerBIColumn.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIColumn removeDescription(String qualifiedName, String name) throws AtlanException {
        return PowerBIColumn.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIColumn removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeDescription(client, PowerBIColumn.updater(qualifiedName, name));
    }

    public static PowerBIColumn removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return PowerBIColumn.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIColumn removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeUserDescription(client, PowerBIColumn.updater(qualifiedName, name));
    }

    public static PowerBIColumn removeOwners(String qualifiedName, String name) throws AtlanException {
        return PowerBIColumn.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIColumn removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeOwners(client, PowerBIColumn.updater(qualifiedName, name));
    }

    public static PowerBIColumn updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return PowerBIColumn.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static PowerBIColumn updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIColumn)Asset.updateCertificate(client, PowerBIColumn._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIColumn removeCertificate(String qualifiedName, String name) throws AtlanException {
        return PowerBIColumn.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIColumn removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeCertificate(client, PowerBIColumn.updater(qualifiedName, name));
    }

    public static PowerBIColumn updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return PowerBIColumn.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static PowerBIColumn updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIColumn)Asset.updateAnnouncement(client, PowerBIColumn._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIColumn removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return PowerBIColumn.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIColumn removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIColumn)Asset.removeAnnouncement(client, PowerBIColumn.updater(qualifiedName, name));
    }

    public static PowerBIColumn replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBIColumn.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static PowerBIColumn replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIColumn)Asset.replaceTerms(client, PowerBIColumn.updater(qualifiedName, name), terms);
    }

    public static PowerBIColumn appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBIColumn.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PowerBIColumn appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIColumn)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIColumn removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBIColumn.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PowerBIColumn removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIColumn)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIColumn appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return PowerBIColumn.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static PowerBIColumn appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBIColumn)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static PowerBIColumn appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return PowerBIColumn.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static PowerBIColumn appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBIColumn)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        PowerBIColumn.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        PowerBIColumn.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        PowerBIColumn.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIColumn(PowerBIColumnBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIColumn.$default$typeName();
        this.datasetQualifiedName = b.datasetQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.powerBIColumnDataCategory = b.powerBIColumnDataCategory;
        this.powerBIColumnDataType = b.powerBIColumnDataType;
        this.powerBIColumnSummarizeBy = b.powerBIColumnSummarizeBy;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        this.powerBISortByColumn = b.powerBISortByColumn;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
        this.table = b.table;
        this.workspaceQualifiedName = b.workspaceQualifiedName;
    }

    @Generated
    public static PowerBIColumnBuilder<?, ?> _internal() {
        return new PowerBIColumnBuilderImpl();
    }

    @Generated
    public PowerBIColumnBuilder<?, ?> toBuilder() {
        return new PowerBIColumnBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getDatasetQualifiedName() {
        return this.datasetQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public String getPowerBIColumnDataCategory() {
        return this.powerBIColumnDataCategory;
    }

    @Override
    @Generated
    public String getPowerBIColumnDataType() {
        return this.powerBIColumnDataType;
    }

    @Override
    @Generated
    public String getPowerBIColumnSummarizeBy() {
        return this.powerBIColumnSummarizeBy;
    }

    @Override
    @Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    @Override
    @Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    @Override
    @Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    @Override
    @Generated
    public String getPowerBISortByColumn() {
        return this.powerBISortByColumn;
    }

    @Override
    @Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    @Override
    @Generated
    public IPowerBITable getTable() {
        return this.table;
    }

    @Override
    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIColumn)) {
            return false;
        }
        PowerBIColumn other = (PowerBIColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$powerBIIsHidden = this.getPowerBIIsHidden();
        Boolean other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !((Object)this$powerBIIsHidden).equals(other$powerBIIsHidden)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$datasetQualifiedName = this.getDatasetQualifiedName();
        String other$datasetQualifiedName = other.getDatasetQualifiedName();
        if (this$datasetQualifiedName == null ? other$datasetQualifiedName != null : !this$datasetQualifiedName.equals(other$datasetQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        String this$powerBIColumnDataCategory = this.getPowerBIColumnDataCategory();
        String other$powerBIColumnDataCategory = other.getPowerBIColumnDataCategory();
        if (this$powerBIColumnDataCategory == null ? other$powerBIColumnDataCategory != null : !this$powerBIColumnDataCategory.equals(other$powerBIColumnDataCategory)) {
            return false;
        }
        String this$powerBIColumnDataType = this.getPowerBIColumnDataType();
        String other$powerBIColumnDataType = other.getPowerBIColumnDataType();
        if (this$powerBIColumnDataType == null ? other$powerBIColumnDataType != null : !this$powerBIColumnDataType.equals(other$powerBIColumnDataType)) {
            return false;
        }
        String this$powerBIColumnSummarizeBy = this.getPowerBIColumnSummarizeBy();
        String other$powerBIColumnSummarizeBy = other.getPowerBIColumnSummarizeBy();
        if (this$powerBIColumnSummarizeBy == null ? other$powerBIColumnSummarizeBy != null : !this$powerBIColumnSummarizeBy.equals(other$powerBIColumnSummarizeBy)) {
            return false;
        }
        PowerBIEndorsementType this$powerBIEndorsement = this.getPowerBIEndorsement();
        PowerBIEndorsementType other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) {
            return false;
        }
        String this$powerBIFormatString = this.getPowerBIFormatString();
        String other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) {
            return false;
        }
        String this$powerBISortByColumn = this.getPowerBISortByColumn();
        String other$powerBISortByColumn = other.getPowerBISortByColumn();
        if (this$powerBISortByColumn == null ? other$powerBISortByColumn != null : !this$powerBISortByColumn.equals(other$powerBISortByColumn)) {
            return false;
        }
        String this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        String other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        if (this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName)) {
            return false;
        }
        IPowerBITable this$table = this.getTable();
        IPowerBITable other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        return !(this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIColumn;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * 59 + ($powerBIIsHidden == null ? 43 : ((Object)$powerBIIsHidden).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $datasetQualifiedName = this.getDatasetQualifiedName();
        result = result * 59 + ($datasetQualifiedName == null ? 43 : $datasetQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        String $powerBIColumnDataCategory = this.getPowerBIColumnDataCategory();
        result = result * 59 + ($powerBIColumnDataCategory == null ? 43 : $powerBIColumnDataCategory.hashCode());
        String $powerBIColumnDataType = this.getPowerBIColumnDataType();
        result = result * 59 + ($powerBIColumnDataType == null ? 43 : $powerBIColumnDataType.hashCode());
        String $powerBIColumnSummarizeBy = this.getPowerBIColumnSummarizeBy();
        result = result * 59 + ($powerBIColumnSummarizeBy == null ? 43 : $powerBIColumnSummarizeBy.hashCode());
        PowerBIEndorsementType $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * 59 + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        String $powerBIFormatString = this.getPowerBIFormatString();
        result = result * 59 + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        String $powerBISortByColumn = this.getPowerBISortByColumn();
        result = result * 59 + ($powerBISortByColumn == null ? 43 : $powerBISortByColumn.hashCode());
        String $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * 59 + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        IPowerBITable $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PowerBIColumn(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", datasetQualifiedName=" + this.getDatasetQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", powerBIColumnDataCategory=" + this.getPowerBIColumnDataCategory() + ", powerBIColumnDataType=" + this.getPowerBIColumnDataType() + ", powerBIColumnSummarizeBy=" + this.getPowerBIColumnSummarizeBy() + ", powerBIEndorsement=" + this.getPowerBIEndorsement() + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBISortByColumn=" + this.getPowerBISortByColumn() + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ", table=" + this.getTable() + ", workspaceQualifiedName=" + this.getWorkspaceQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class PowerBIColumnBuilderImpl
    extends PowerBIColumnBuilder<PowerBIColumn, PowerBIColumnBuilderImpl> {
        @Generated
        private PowerBIColumnBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIColumnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIColumn build() {
            return new PowerBIColumn(this);
        }
    }

    @Generated
    public static abstract class PowerBIColumnBuilder<C extends PowerBIColumn, B extends PowerBIColumnBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String datasetQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private String powerBIColumnDataCategory;
        @Generated
        private String powerBIColumnDataType;
        @Generated
        private String powerBIColumnSummarizeBy;
        @Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @Generated
        private String powerBIFormatString;
        @Generated
        private Boolean powerBIIsHidden;
        @Generated
        private String powerBISortByColumn;
        @Generated
        private String powerBITableQualifiedName;
        @Generated
        private IPowerBITable table;
        @Generated
        private String workspaceQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIColumn instance, PowerBIColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.datasetQualifiedName(instance.datasetQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.powerBIColumnDataCategory(instance.powerBIColumnDataCategory);
            b.powerBIColumnDataType(instance.powerBIColumnDataType);
            b.powerBIColumnSummarizeBy(instance.powerBIColumnSummarizeBy);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBISortByColumn(instance.powerBISortByColumn);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
            b.table(instance.table);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B datasetQualifiedName(String datasetQualifiedName) {
            this.datasetQualifiedName = datasetQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIColumnDataCategory(String powerBIColumnDataCategory) {
            this.powerBIColumnDataCategory = powerBIColumnDataCategory;
            return (B)this.self();
        }

        @Generated
        public B powerBIColumnDataType(String powerBIColumnDataType) {
            this.powerBIColumnDataType = powerBIColumnDataType;
            return (B)this.self();
        }

        @Generated
        public B powerBIColumnSummarizeBy(String powerBIColumnSummarizeBy) {
            this.powerBIColumnSummarizeBy = powerBIColumnSummarizeBy;
            return (B)this.self();
        }

        @Generated
        public B powerBIEndorsement(PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return (B)this.self();
        }

        @Generated
        public B powerBIFormatString(String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return (B)this.self();
        }

        @Generated
        public B powerBIIsHidden(Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return (B)this.self();
        }

        @Generated
        public B powerBISortByColumn(String powerBISortByColumn) {
            this.powerBISortByColumn = powerBISortByColumn;
            return (B)this.self();
        }

        @Generated
        public B powerBITableQualifiedName(String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B table(IPowerBITable table) {
            this.table = table;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "PowerBIColumn.PowerBIColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", datasetQualifiedName=" + this.datasetQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", powerBIColumnDataCategory=" + this.powerBIColumnDataCategory + ", powerBIColumnDataType=" + this.powerBIColumnDataType + ", powerBIColumnSummarizeBy=" + this.powerBIColumnSummarizeBy + ", powerBIEndorsement=" + this.powerBIEndorsement + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBISortByColumn=" + this.powerBISortByColumn + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ", table=" + this.table + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ")";
        }
    }
}

