/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.AuthPolicy;
import com.atlan.model.assets.IAccessControl;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAuthPolicy;
import com.atlan.model.assets.IPurpose;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AssetSidebarTab;
import com.atlan.model.enums.AuthPolicyCategory;
import com.atlan.model.enums.AuthPolicyResourceCategory;
import com.atlan.model.enums.AuthPolicyType;
import com.atlan.model.enums.DataAction;
import com.atlan.model.enums.PurposeMetadataAction;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Purpose
extends Asset
implements IPurpose,
IAccessControl,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Purpose.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Purpose";
    String typeName;
    @Attribute
    String channelLink;
    @Attribute
    SortedSet<AssetSidebarTab> denyAssetTabs;
    @Attribute
    SortedSet<String> denyCustomMetadataGuids;
    @Attribute
    Boolean isAccessControlEnabled;
    @Attribute
    SortedSet<IAuthPolicy> policies;
    @Attribute
    @JsonProperty(value="purposeClassifications")
    SortedSet<String> purposeAtlanTags;

    @Override
    public Purpose trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Purpose.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Purpose.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Purpose.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return Purpose.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Purpose.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return Purpose.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return Purpose.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return Purpose.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return Purpose.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static Purpose refByGuid(String guid) {
        return ((PurposeBuilder)Purpose._internal().guid(guid)).build();
    }

    public static Purpose refByQualifiedName(String qualifiedName) {
        return ((PurposeBuilder)Purpose._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static Purpose get(String id) throws AtlanException {
        return Purpose.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static Purpose get(AtlanClient client, String id) throws AtlanException {
        return Purpose.get(client, id, true);
    }

    @JsonIgnore
    public static Purpose get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Purpose) {
                return (Purpose)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof Purpose) {
            return (Purpose)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static Purpose retrieveByGuid(String guid) throws AtlanException {
        return Purpose.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static Purpose retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return Purpose.get(client, guid);
    }

    @Deprecated
    public static Purpose retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return Purpose.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static Purpose retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return Purpose.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Purpose.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PurposeBuilder<?, ?> creator(String name, Collection<String> atlanTags) throws InvalidRequestException {
        if (atlanTags == null || atlanTags.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_TAG_FOR_PURPOSE);
        }
        return ((PurposeBuilder)((Asset.AssetBuilder)((PurposeBuilder)((PurposeBuilder)((PurposeBuilder)((PurposeBuilder)Purpose._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(name)).name(name)).displayName(name)).isAccessControlEnabled(true)).description("")).purposeAtlanTags(atlanTags);
    }

    public static PurposeBuilder<?, ?> updater(String qualifiedName, String name, boolean isEnabled) {
        return ((PurposeBuilder)((PurposeBuilder)((PurposeBuilder)Purpose._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name)).isAccessControlEnabled(isEnabled);
    }

    public PurposeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (this.getIsAccessControlEnabled() == null) {
            missing.add("isAccessControlEnabled");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return Purpose.updater(this.getQualifiedName(), this.getName(), this.getIsAccessControlEnabled());
    }

    public static List<Purpose> findByName(String name) throws AtlanException {
        return Purpose.findByName(name, (List<AtlanField>)null);
    }

    public static List<Purpose> findByName(String name, Collection<String> attributes) throws AtlanException {
        return Purpose.findByName(Atlan.getDefaultClient(), name, attributes);
    }

    public static List<Purpose> findByName(String name, List<AtlanField> attributes) throws AtlanException {
        return Purpose.findByName(Atlan.getDefaultClient(), name, attributes);
    }

    public static List<Purpose> findByName(AtlanClient client, String name) throws AtlanException {
        return Purpose.findByName(client, name, (List<AtlanField>)null);
    }

    public static List<Purpose> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        ArrayList<Purpose> results = new ArrayList<Purpose>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Purpose.select(client).where(NAME.eq(name)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof Purpose).forEach(p -> results.add((Purpose)p));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.PURPOSE_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static List<Purpose> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        ArrayList<Purpose> results = new ArrayList<Purpose>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Purpose.select(client).where(NAME.eq(name))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof Purpose).forEach(p -> results.add((Purpose)p));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.PURPOSE_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createMetadataPolicy(String name, String purposeId, AuthPolicyType policyType, Collection<PurposeMetadataAction> actions, Collection<String> policyGroups, Collection<String> policyUsers, boolean allUsers) throws AtlanException {
        return Purpose.createMetadataPolicy(Atlan.getDefaultClient(), name, purposeId, policyType, actions, policyGroups, policyUsers, allUsers);
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createMetadataPolicy(AtlanClient client, String name, String purposeId, AuthPolicyType policyType, Collection<PurposeMetadataAction> actions, Collection<String> policyGroups, Collection<String> policyUsers, boolean allUsers) throws AtlanException {
        boolean targetFound = false;
        Object builder = ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyActions(actions)).policyCategory(AuthPolicyCategory.PURPOSE)).policyType(policyType)).policyResourceCategory(AuthPolicyResourceCategory.TAG)).policyServiceName("atlas_tag")).policySubCategory("metadata")).accessControl(Purpose.refByGuid(purposeId));
        if (allUsers) {
            targetFound = true;
            ((AuthPolicy.AuthPolicyBuilder)builder).policyGroup("public");
        } else {
            if (policyGroups != null && !policyGroups.isEmpty()) {
                for (String groupAlias : policyGroups) {
                    client.getGroupCache().getIdForAlias(groupAlias);
                }
                targetFound = true;
                ((AuthPolicy.AuthPolicyBuilder)builder).policyGroups(policyGroups);
            } else {
                ((Asset.AssetBuilder)builder).nullField("policyGroups");
            }
            if (policyUsers != null && !policyUsers.isEmpty()) {
                for (String userName : policyUsers) {
                    client.getUserCache().getIdForName(userName);
                }
                targetFound = true;
                ((AuthPolicy.AuthPolicyBuilder)builder).policyUsers(policyUsers);
            } else {
                ((Asset.AssetBuilder)builder).nullField("policyUsers");
            }
        }
        if (targetFound) {
            return builder;
        }
        throw new InvalidRequestException(ErrorCode.NO_USERS_FOR_POLICY);
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createDataPolicy(String name, String purposeId, AuthPolicyType policyType, Collection<String> policyGroups, Collection<String> policyUsers, boolean allUsers) throws AtlanException {
        return Purpose.createDataPolicy(Atlan.getDefaultClient(), name, purposeId, policyType, policyGroups, policyUsers, allUsers);
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createDataPolicy(AtlanClient client, String name, String purposeId, AuthPolicyType policyType, Collection<String> policyGroups, Collection<String> policyUsers, boolean allUsers) throws AtlanException {
        boolean targetFound = false;
        Object builder = ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyAction(DataAction.SELECT)).policyCategory(AuthPolicyCategory.PURPOSE)).policyType(policyType)).policyResourceCategory(AuthPolicyResourceCategory.TAG)).policyServiceName("atlas_tag")).policySubCategory("data")).accessControl(Purpose.refByGuid(purposeId));
        if (allUsers) {
            targetFound = true;
            ((AuthPolicy.AuthPolicyBuilder)builder).policyGroup("public");
        } else {
            if (policyGroups != null && !policyGroups.isEmpty()) {
                for (String groupAlias : policyGroups) {
                    client.getGroupCache().getIdForAlias(groupAlias);
                }
                targetFound = true;
                ((AuthPolicy.AuthPolicyBuilder)builder).policyGroups(policyGroups);
            } else {
                ((Asset.AssetBuilder)builder).nullField("policyGroups");
            }
            if (policyUsers != null && !policyUsers.isEmpty()) {
                for (String userName : policyUsers) {
                    client.getUserCache().getIdForName(userName);
                }
                targetFound = true;
                ((AuthPolicy.AuthPolicyBuilder)builder).policyUsers(policyUsers);
            } else {
                ((Asset.AssetBuilder)builder).nullField("policyUsers");
            }
        }
        if (targetFound) {
            return builder;
        }
        throw new InvalidRequestException(ErrorCode.NO_USERS_FOR_POLICY);
    }

    public static Purpose removeDescription(String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return Purpose.removeDescription(Atlan.getDefaultClient(), qualifiedName, name, isEnabled);
    }

    public static Purpose removeDescription(AtlanClient client, String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return (Purpose)Asset.removeDescription(client, Purpose.updater(qualifiedName, name, isEnabled));
    }

    public static Purpose removeUserDescription(String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return Purpose.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name, isEnabled);
    }

    public static Purpose removeUserDescription(AtlanClient client, String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return (Purpose)Asset.removeUserDescription(client, Purpose.updater(qualifiedName, name, isEnabled));
    }

    public static Purpose appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return Purpose.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static Purpose appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Purpose)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static Purpose appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return Purpose.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static Purpose appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Purpose)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Purpose.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Purpose.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        Purpose.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Purpose(PurposeBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Purpose.$default$typeName();
        this.channelLink = b.channelLink;
        SortedSet<AssetSidebarTab> denyAssetTabs = new TreeSet<AssetSidebarTab>();
        if (b.denyAssetTabs != null) {
            denyAssetTabs.addAll(b.denyAssetTabs);
        }
        denyAssetTabs = Collections.unmodifiableSortedSet(denyAssetTabs);
        this.denyAssetTabs = denyAssetTabs;
        SortedSet<String> denyCustomMetadataGuids = new TreeSet<String>();
        if (b.denyCustomMetadataGuids != null) {
            denyCustomMetadataGuids.addAll(b.denyCustomMetadataGuids);
        }
        denyCustomMetadataGuids = Collections.unmodifiableSortedSet(denyCustomMetadataGuids);
        this.denyCustomMetadataGuids = denyCustomMetadataGuids;
        this.isAccessControlEnabled = b.isAccessControlEnabled;
        SortedSet<IAuthPolicy> policies = new TreeSet<IAuthPolicy>();
        if (b.policies != null) {
            policies.addAll(b.policies);
        }
        policies = Collections.unmodifiableSortedSet(policies);
        this.policies = policies;
        SortedSet<String> purposeAtlanTags = new TreeSet<String>();
        if (b.purposeAtlanTags != null) {
            purposeAtlanTags.addAll(b.purposeAtlanTags);
        }
        purposeAtlanTags = Collections.unmodifiableSortedSet(purposeAtlanTags);
        this.purposeAtlanTags = purposeAtlanTags;
    }

    @Generated
    public static PurposeBuilder<?, ?> _internal() {
        return new PurposeBuilderImpl();
    }

    @Generated
    public PurposeBuilder<?, ?> toBuilder() {
        return new PurposeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getChannelLink() {
        return this.channelLink;
    }

    @Override
    @Generated
    public SortedSet<AssetSidebarTab> getDenyAssetTabs() {
        return this.denyAssetTabs;
    }

    @Override
    @Generated
    public SortedSet<String> getDenyCustomMetadataGuids() {
        return this.denyCustomMetadataGuids;
    }

    @Override
    @Generated
    public Boolean getIsAccessControlEnabled() {
        return this.isAccessControlEnabled;
    }

    @Override
    @Generated
    public SortedSet<IAuthPolicy> getPolicies() {
        return this.policies;
    }

    @Override
    @Generated
    public SortedSet<String> getPurposeAtlanTags() {
        return this.purposeAtlanTags;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Purpose)) {
            return false;
        }
        Purpose other = (Purpose)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isAccessControlEnabled = this.getIsAccessControlEnabled();
        Boolean other$isAccessControlEnabled = other.getIsAccessControlEnabled();
        if (this$isAccessControlEnabled == null ? other$isAccessControlEnabled != null : !((Object)this$isAccessControlEnabled).equals(other$isAccessControlEnabled)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$channelLink = this.getChannelLink();
        String other$channelLink = other.getChannelLink();
        if (this$channelLink == null ? other$channelLink != null : !this$channelLink.equals(other$channelLink)) {
            return false;
        }
        SortedSet<AssetSidebarTab> this$denyAssetTabs = this.getDenyAssetTabs();
        SortedSet<AssetSidebarTab> other$denyAssetTabs = other.getDenyAssetTabs();
        if (this$denyAssetTabs == null ? other$denyAssetTabs != null : !this$denyAssetTabs.equals(other$denyAssetTabs)) {
            return false;
        }
        SortedSet<String> this$denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        SortedSet<String> other$denyCustomMetadataGuids = other.getDenyCustomMetadataGuids();
        if (this$denyCustomMetadataGuids == null ? other$denyCustomMetadataGuids != null : !this$denyCustomMetadataGuids.equals(other$denyCustomMetadataGuids)) {
            return false;
        }
        SortedSet<IAuthPolicy> this$policies = this.getPolicies();
        SortedSet<IAuthPolicy> other$policies = other.getPolicies();
        if (this$policies == null ? other$policies != null : !this$policies.equals(other$policies)) {
            return false;
        }
        SortedSet<String> this$purposeAtlanTags = this.getPurposeAtlanTags();
        SortedSet<String> other$purposeAtlanTags = other.getPurposeAtlanTags();
        return !(this$purposeAtlanTags == null ? other$purposeAtlanTags != null : !this$purposeAtlanTags.equals(other$purposeAtlanTags));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Purpose;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isAccessControlEnabled = this.getIsAccessControlEnabled();
        result = result * 59 + ($isAccessControlEnabled == null ? 43 : ((Object)$isAccessControlEnabled).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $channelLink = this.getChannelLink();
        result = result * 59 + ($channelLink == null ? 43 : $channelLink.hashCode());
        SortedSet<AssetSidebarTab> $denyAssetTabs = this.getDenyAssetTabs();
        result = result * 59 + ($denyAssetTabs == null ? 43 : $denyAssetTabs.hashCode());
        SortedSet<String> $denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        result = result * 59 + ($denyCustomMetadataGuids == null ? 43 : $denyCustomMetadataGuids.hashCode());
        SortedSet<IAuthPolicy> $policies = this.getPolicies();
        result = result * 59 + ($policies == null ? 43 : $policies.hashCode());
        SortedSet<String> $purposeAtlanTags = this.getPurposeAtlanTags();
        result = result * 59 + ($purposeAtlanTags == null ? 43 : $purposeAtlanTags.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Purpose(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", channelLink=" + this.getChannelLink() + ", denyAssetTabs=" + this.getDenyAssetTabs() + ", denyCustomMetadataGuids=" + this.getDenyCustomMetadataGuids() + ", isAccessControlEnabled=" + this.getIsAccessControlEnabled() + ", policies=" + this.getPolicies() + ", purposeAtlanTags=" + this.getPurposeAtlanTags() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class PurposeBuilderImpl
    extends PurposeBuilder<Purpose, PurposeBuilderImpl> {
        @Generated
        private PurposeBuilderImpl() {
        }

        @Override
        @Generated
        protected PurposeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Purpose build() {
            return new Purpose(this);
        }
    }

    @Generated
    public static abstract class PurposeBuilder<C extends Purpose, B extends PurposeBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String channelLink;
        @Generated
        private ArrayList<AssetSidebarTab> denyAssetTabs;
        @Generated
        private ArrayList<String> denyCustomMetadataGuids;
        @Generated
        private Boolean isAccessControlEnabled;
        @Generated
        private ArrayList<IAuthPolicy> policies;
        @Generated
        private ArrayList<String> purposeAtlanTags;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PurposeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Purpose instance, PurposeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.channelLink(instance.channelLink);
            b.denyAssetTabs(instance.denyAssetTabs == null ? Collections.emptySortedSet() : instance.denyAssetTabs);
            b.denyCustomMetadataGuids(instance.denyCustomMetadataGuids == null ? Collections.emptySortedSet() : instance.denyCustomMetadataGuids);
            b.isAccessControlEnabled(instance.isAccessControlEnabled);
            b.policies(instance.policies == null ? Collections.emptySortedSet() : instance.policies);
            b.purposeAtlanTags(instance.purposeAtlanTags == null ? Collections.emptySortedSet() : instance.purposeAtlanTags);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B channelLink(String channelLink) {
            this.channelLink = channelLink;
            return (B)this.self();
        }

        @Generated
        public B denyAssetTab(AssetSidebarTab denyAssetTab) {
            if (this.denyAssetTabs == null) {
                this.denyAssetTabs = new ArrayList();
            }
            this.denyAssetTabs.add(denyAssetTab);
            return (B)this.self();
        }

        @Generated
        public B denyAssetTabs(Collection<? extends AssetSidebarTab> denyAssetTabs) {
            if (denyAssetTabs == null) {
                throw new NullPointerException("denyAssetTabs cannot be null");
            }
            if (this.denyAssetTabs == null) {
                this.denyAssetTabs = new ArrayList();
            }
            this.denyAssetTabs.addAll(denyAssetTabs);
            return (B)this.self();
        }

        @Generated
        public B clearDenyAssetTabs() {
            if (this.denyAssetTabs != null) {
                this.denyAssetTabs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B denyCustomMetadataGuid(String denyCustomMetadataGuid) {
            if (this.denyCustomMetadataGuids == null) {
                this.denyCustomMetadataGuids = new ArrayList();
            }
            this.denyCustomMetadataGuids.add(denyCustomMetadataGuid);
            return (B)this.self();
        }

        @Generated
        public B denyCustomMetadataGuids(Collection<? extends String> denyCustomMetadataGuids) {
            if (denyCustomMetadataGuids == null) {
                throw new NullPointerException("denyCustomMetadataGuids cannot be null");
            }
            if (this.denyCustomMetadataGuids == null) {
                this.denyCustomMetadataGuids = new ArrayList();
            }
            this.denyCustomMetadataGuids.addAll(denyCustomMetadataGuids);
            return (B)this.self();
        }

        @Generated
        public B clearDenyCustomMetadataGuids() {
            if (this.denyCustomMetadataGuids != null) {
                this.denyCustomMetadataGuids.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isAccessControlEnabled(Boolean isAccessControlEnabled) {
            this.isAccessControlEnabled = isAccessControlEnabled;
            return (B)this.self();
        }

        @Generated
        public B policy(IAuthPolicy policy) {
            if (this.policies == null) {
                this.policies = new ArrayList();
            }
            this.policies.add(policy);
            return (B)this.self();
        }

        @Generated
        public B policies(Collection<? extends IAuthPolicy> policies) {
            if (policies == null) {
                throw new NullPointerException("policies cannot be null");
            }
            if (this.policies == null) {
                this.policies = new ArrayList();
            }
            this.policies.addAll(policies);
            return (B)this.self();
        }

        @Generated
        public B clearPolicies() {
            if (this.policies != null) {
                this.policies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B purposeAtlanTag(String purposeAtlanTag) {
            if (this.purposeAtlanTags == null) {
                this.purposeAtlanTags = new ArrayList();
            }
            this.purposeAtlanTags.add(purposeAtlanTag);
            return (B)this.self();
        }

        @JsonProperty(value="purposeClassifications")
        @Generated
        public B purposeAtlanTags(Collection<? extends String> purposeAtlanTags) {
            if (purposeAtlanTags == null) {
                throw new NullPointerException("purposeAtlanTags cannot be null");
            }
            if (this.purposeAtlanTags == null) {
                this.purposeAtlanTags = new ArrayList();
            }
            this.purposeAtlanTags.addAll(purposeAtlanTags);
            return (B)this.self();
        }

        @Generated
        public B clearPurposeAtlanTags() {
            if (this.purposeAtlanTags != null) {
                this.purposeAtlanTags.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Purpose.PurposeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", channelLink=" + this.channelLink + ", denyAssetTabs=" + this.denyAssetTabs + ", denyCustomMetadataGuids=" + this.denyCustomMetadataGuids + ", isAccessControlEnabled=" + this.isAccessControlEnabled + ", policies=" + this.policies + ", purposeAtlanTags=" + this.purposeAtlanTags + ")";
        }
    }
}

