/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IQlik;
import com.atlan.model.assets.IQlikApp;
import com.atlan.model.assets.IQlikSheet;
import com.atlan.model.assets.IQlikSpace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QlikApp
extends Asset
implements IQlikApp,
IQlik,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QlikApp.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QlikApp";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    String qlikAppId;
    @Attribute
    String qlikAppQualifiedName;
    @Attribute
    Long qlikAppStaticByteSize;
    @Attribute
    Boolean qlikHasSectionAccess;
    @Attribute
    String qlikId;
    @Attribute
    Boolean qlikIsDirectQueryMode;
    @Attribute
    Boolean qlikIsEncrypted;
    @Attribute
    Boolean qlikIsPublished;
    @Attribute
    String qlikOriginAppId;
    @Attribute
    String qlikOwnerId;
    @Attribute
    String qlikQRI;
    @Attribute
    SortedSet<IQlikSheet> qlikSheets;
    @Attribute
    IQlikSpace qlikSpace;
    @Attribute
    String qlikSpaceId;
    @Attribute
    String qlikSpaceQualifiedName;

    @Override
    public QlikApp trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return QlikApp.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return QlikApp.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return QlikApp.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return QlikApp.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return QlikApp.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return QlikApp.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return QlikApp.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return QlikApp.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return QlikApp.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static QlikApp refByGuid(String guid) {
        return ((QlikAppBuilder)QlikApp._internal().guid(guid)).build();
    }

    public static QlikApp refByQualifiedName(String qualifiedName) {
        return ((QlikAppBuilder)QlikApp._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static QlikApp get(String id) throws AtlanException {
        return QlikApp.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static QlikApp get(AtlanClient client, String id) throws AtlanException {
        return QlikApp.get(client, id, true);
    }

    @JsonIgnore
    public static QlikApp get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof QlikApp) {
                return (QlikApp)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof QlikApp) {
            return (QlikApp)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static QlikApp retrieveByGuid(String guid) throws AtlanException {
        return QlikApp.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static QlikApp retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return QlikApp.get(client, guid);
    }

    @Deprecated
    public static QlikApp retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return QlikApp.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static QlikApp retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return QlikApp.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return QlikApp.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static QlikAppBuilder<?, ?> updater(String qualifiedName, String name) {
        return (QlikAppBuilder)((QlikAppBuilder)((QlikAppBuilder)QlikApp._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public QlikAppBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return QlikApp.updater(this.getQualifiedName(), this.getName());
    }

    public static QlikApp removeDescription(String qualifiedName, String name) throws AtlanException {
        return QlikApp.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikApp removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp)Asset.removeDescription(client, QlikApp.updater(qualifiedName, name));
    }

    public static QlikApp removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return QlikApp.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikApp removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp)Asset.removeUserDescription(client, QlikApp.updater(qualifiedName, name));
    }

    public static QlikApp removeOwners(String qualifiedName, String name) throws AtlanException {
        return QlikApp.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikApp removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp)Asset.removeOwners(client, QlikApp.updater(qualifiedName, name));
    }

    public static QlikApp updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return QlikApp.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static QlikApp updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QlikApp)Asset.updateCertificate(client, QlikApp._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static QlikApp removeCertificate(String qualifiedName, String name) throws AtlanException {
        return QlikApp.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikApp removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp)Asset.removeCertificate(client, QlikApp.updater(qualifiedName, name));
    }

    public static QlikApp updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return QlikApp.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static QlikApp updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QlikApp)Asset.updateAnnouncement(client, QlikApp._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static QlikApp removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return QlikApp.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikApp removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp)Asset.removeAnnouncement(client, QlikApp.updater(qualifiedName, name));
    }

    public static QlikApp replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return QlikApp.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static QlikApp replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikApp)Asset.replaceTerms(client, QlikApp.updater(qualifiedName, name), terms);
    }

    public static QlikApp appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QlikApp.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QlikApp appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikApp)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QlikApp removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QlikApp.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QlikApp removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikApp)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QlikApp appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return QlikApp.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static QlikApp appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QlikApp)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static QlikApp appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return QlikApp.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static QlikApp appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QlikApp)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        QlikApp.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        QlikApp.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        QlikApp.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected QlikApp(QlikAppBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : QlikApp.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.qlikAppId = b.qlikAppId;
        this.qlikAppQualifiedName = b.qlikAppQualifiedName;
        this.qlikAppStaticByteSize = b.qlikAppStaticByteSize;
        this.qlikHasSectionAccess = b.qlikHasSectionAccess;
        this.qlikId = b.qlikId;
        this.qlikIsDirectQueryMode = b.qlikIsDirectQueryMode;
        this.qlikIsEncrypted = b.qlikIsEncrypted;
        this.qlikIsPublished = b.qlikIsPublished;
        this.qlikOriginAppId = b.qlikOriginAppId;
        this.qlikOwnerId = b.qlikOwnerId;
        this.qlikQRI = b.qlikQRI;
        SortedSet<IQlikSheet> qlikSheets = new TreeSet<IQlikSheet>();
        if (b.qlikSheets != null) {
            qlikSheets.addAll(b.qlikSheets);
        }
        qlikSheets = Collections.unmodifiableSortedSet(qlikSheets);
        this.qlikSheets = qlikSheets;
        this.qlikSpace = b.qlikSpace;
        this.qlikSpaceId = b.qlikSpaceId;
        this.qlikSpaceQualifiedName = b.qlikSpaceQualifiedName;
    }

    @Generated
    public static QlikAppBuilder<?, ?> _internal() {
        return new QlikAppBuilderImpl();
    }

    @Generated
    public QlikAppBuilder<?, ?> toBuilder() {
        return new QlikAppBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public String getQlikAppId() {
        return this.qlikAppId;
    }

    @Override
    @Generated
    public String getQlikAppQualifiedName() {
        return this.qlikAppQualifiedName;
    }

    @Override
    @Generated
    public Long getQlikAppStaticByteSize() {
        return this.qlikAppStaticByteSize;
    }

    @Override
    @Generated
    public Boolean getQlikHasSectionAccess() {
        return this.qlikHasSectionAccess;
    }

    @Override
    @Generated
    public String getQlikId() {
        return this.qlikId;
    }

    @Override
    @Generated
    public Boolean getQlikIsDirectQueryMode() {
        return this.qlikIsDirectQueryMode;
    }

    @Override
    @Generated
    public Boolean getQlikIsEncrypted() {
        return this.qlikIsEncrypted;
    }

    @Override
    @Generated
    public Boolean getQlikIsPublished() {
        return this.qlikIsPublished;
    }

    @Override
    @Generated
    public String getQlikOriginAppId() {
        return this.qlikOriginAppId;
    }

    @Override
    @Generated
    public String getQlikOwnerId() {
        return this.qlikOwnerId;
    }

    @Override
    @Generated
    public String getQlikQRI() {
        return this.qlikQRI;
    }

    @Override
    @Generated
    public SortedSet<IQlikSheet> getQlikSheets() {
        return this.qlikSheets;
    }

    @Override
    @Generated
    public IQlikSpace getQlikSpace() {
        return this.qlikSpace;
    }

    @Override
    @Generated
    public String getQlikSpaceId() {
        return this.qlikSpaceId;
    }

    @Override
    @Generated
    public String getQlikSpaceQualifiedName() {
        return this.qlikSpaceQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QlikApp)) {
            return false;
        }
        QlikApp other = (QlikApp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$qlikAppStaticByteSize = this.getQlikAppStaticByteSize();
        Long other$qlikAppStaticByteSize = other.getQlikAppStaticByteSize();
        if (this$qlikAppStaticByteSize == null ? other$qlikAppStaticByteSize != null : !((Object)this$qlikAppStaticByteSize).equals(other$qlikAppStaticByteSize)) {
            return false;
        }
        Boolean this$qlikHasSectionAccess = this.getQlikHasSectionAccess();
        Boolean other$qlikHasSectionAccess = other.getQlikHasSectionAccess();
        if (this$qlikHasSectionAccess == null ? other$qlikHasSectionAccess != null : !((Object)this$qlikHasSectionAccess).equals(other$qlikHasSectionAccess)) {
            return false;
        }
        Boolean this$qlikIsDirectQueryMode = this.getQlikIsDirectQueryMode();
        Boolean other$qlikIsDirectQueryMode = other.getQlikIsDirectQueryMode();
        if (this$qlikIsDirectQueryMode == null ? other$qlikIsDirectQueryMode != null : !((Object)this$qlikIsDirectQueryMode).equals(other$qlikIsDirectQueryMode)) {
            return false;
        }
        Boolean this$qlikIsEncrypted = this.getQlikIsEncrypted();
        Boolean other$qlikIsEncrypted = other.getQlikIsEncrypted();
        if (this$qlikIsEncrypted == null ? other$qlikIsEncrypted != null : !((Object)this$qlikIsEncrypted).equals(other$qlikIsEncrypted)) {
            return false;
        }
        Boolean this$qlikIsPublished = this.getQlikIsPublished();
        Boolean other$qlikIsPublished = other.getQlikIsPublished();
        if (this$qlikIsPublished == null ? other$qlikIsPublished != null : !((Object)this$qlikIsPublished).equals(other$qlikIsPublished)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        String this$qlikAppId = this.getQlikAppId();
        String other$qlikAppId = other.getQlikAppId();
        if (this$qlikAppId == null ? other$qlikAppId != null : !this$qlikAppId.equals(other$qlikAppId)) {
            return false;
        }
        String this$qlikAppQualifiedName = this.getQlikAppQualifiedName();
        String other$qlikAppQualifiedName = other.getQlikAppQualifiedName();
        if (this$qlikAppQualifiedName == null ? other$qlikAppQualifiedName != null : !this$qlikAppQualifiedName.equals(other$qlikAppQualifiedName)) {
            return false;
        }
        String this$qlikId = this.getQlikId();
        String other$qlikId = other.getQlikId();
        if (this$qlikId == null ? other$qlikId != null : !this$qlikId.equals(other$qlikId)) {
            return false;
        }
        String this$qlikOriginAppId = this.getQlikOriginAppId();
        String other$qlikOriginAppId = other.getQlikOriginAppId();
        if (this$qlikOriginAppId == null ? other$qlikOriginAppId != null : !this$qlikOriginAppId.equals(other$qlikOriginAppId)) {
            return false;
        }
        String this$qlikOwnerId = this.getQlikOwnerId();
        String other$qlikOwnerId = other.getQlikOwnerId();
        if (this$qlikOwnerId == null ? other$qlikOwnerId != null : !this$qlikOwnerId.equals(other$qlikOwnerId)) {
            return false;
        }
        String this$qlikQRI = this.getQlikQRI();
        String other$qlikQRI = other.getQlikQRI();
        if (this$qlikQRI == null ? other$qlikQRI != null : !this$qlikQRI.equals(other$qlikQRI)) {
            return false;
        }
        SortedSet<IQlikSheet> this$qlikSheets = this.getQlikSheets();
        SortedSet<IQlikSheet> other$qlikSheets = other.getQlikSheets();
        if (this$qlikSheets == null ? other$qlikSheets != null : !this$qlikSheets.equals(other$qlikSheets)) {
            return false;
        }
        IQlikSpace this$qlikSpace = this.getQlikSpace();
        IQlikSpace other$qlikSpace = other.getQlikSpace();
        if (this$qlikSpace == null ? other$qlikSpace != null : !this$qlikSpace.equals(other$qlikSpace)) {
            return false;
        }
        String this$qlikSpaceId = this.getQlikSpaceId();
        String other$qlikSpaceId = other.getQlikSpaceId();
        if (this$qlikSpaceId == null ? other$qlikSpaceId != null : !this$qlikSpaceId.equals(other$qlikSpaceId)) {
            return false;
        }
        String this$qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        String other$qlikSpaceQualifiedName = other.getQlikSpaceQualifiedName();
        return !(this$qlikSpaceQualifiedName == null ? other$qlikSpaceQualifiedName != null : !this$qlikSpaceQualifiedName.equals(other$qlikSpaceQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QlikApp;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $qlikAppStaticByteSize = this.getQlikAppStaticByteSize();
        result = result * 59 + ($qlikAppStaticByteSize == null ? 43 : ((Object)$qlikAppStaticByteSize).hashCode());
        Boolean $qlikHasSectionAccess = this.getQlikHasSectionAccess();
        result = result * 59 + ($qlikHasSectionAccess == null ? 43 : ((Object)$qlikHasSectionAccess).hashCode());
        Boolean $qlikIsDirectQueryMode = this.getQlikIsDirectQueryMode();
        result = result * 59 + ($qlikIsDirectQueryMode == null ? 43 : ((Object)$qlikIsDirectQueryMode).hashCode());
        Boolean $qlikIsEncrypted = this.getQlikIsEncrypted();
        result = result * 59 + ($qlikIsEncrypted == null ? 43 : ((Object)$qlikIsEncrypted).hashCode());
        Boolean $qlikIsPublished = this.getQlikIsPublished();
        result = result * 59 + ($qlikIsPublished == null ? 43 : ((Object)$qlikIsPublished).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        String $qlikAppId = this.getQlikAppId();
        result = result * 59 + ($qlikAppId == null ? 43 : $qlikAppId.hashCode());
        String $qlikAppQualifiedName = this.getQlikAppQualifiedName();
        result = result * 59 + ($qlikAppQualifiedName == null ? 43 : $qlikAppQualifiedName.hashCode());
        String $qlikId = this.getQlikId();
        result = result * 59 + ($qlikId == null ? 43 : $qlikId.hashCode());
        String $qlikOriginAppId = this.getQlikOriginAppId();
        result = result * 59 + ($qlikOriginAppId == null ? 43 : $qlikOriginAppId.hashCode());
        String $qlikOwnerId = this.getQlikOwnerId();
        result = result * 59 + ($qlikOwnerId == null ? 43 : $qlikOwnerId.hashCode());
        String $qlikQRI = this.getQlikQRI();
        result = result * 59 + ($qlikQRI == null ? 43 : $qlikQRI.hashCode());
        SortedSet<IQlikSheet> $qlikSheets = this.getQlikSheets();
        result = result * 59 + ($qlikSheets == null ? 43 : $qlikSheets.hashCode());
        IQlikSpace $qlikSpace = this.getQlikSpace();
        result = result * 59 + ($qlikSpace == null ? 43 : $qlikSpace.hashCode());
        String $qlikSpaceId = this.getQlikSpaceId();
        result = result * 59 + ($qlikSpaceId == null ? 43 : $qlikSpaceId.hashCode());
        String $qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        result = result * 59 + ($qlikSpaceQualifiedName == null ? 43 : $qlikSpaceQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QlikApp(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", qlikAppId=" + this.getQlikAppId() + ", qlikAppQualifiedName=" + this.getQlikAppQualifiedName() + ", qlikAppStaticByteSize=" + this.getQlikAppStaticByteSize() + ", qlikHasSectionAccess=" + this.getQlikHasSectionAccess() + ", qlikId=" + this.getQlikId() + ", qlikIsDirectQueryMode=" + this.getQlikIsDirectQueryMode() + ", qlikIsEncrypted=" + this.getQlikIsEncrypted() + ", qlikIsPublished=" + this.getQlikIsPublished() + ", qlikOriginAppId=" + this.getQlikOriginAppId() + ", qlikOwnerId=" + this.getQlikOwnerId() + ", qlikQRI=" + this.getQlikQRI() + ", qlikSheets=" + this.getQlikSheets() + ", qlikSpace=" + this.getQlikSpace() + ", qlikSpaceId=" + this.getQlikSpaceId() + ", qlikSpaceQualifiedName=" + this.getQlikSpaceQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class QlikAppBuilderImpl
    extends QlikAppBuilder<QlikApp, QlikAppBuilderImpl> {
        @Generated
        private QlikAppBuilderImpl() {
        }

        @Override
        @Generated
        protected QlikAppBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QlikApp build() {
            return new QlikApp(this);
        }
    }

    @Generated
    public static abstract class QlikAppBuilder<C extends QlikApp, B extends QlikAppBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private String qlikAppId;
        @Generated
        private String qlikAppQualifiedName;
        @Generated
        private Long qlikAppStaticByteSize;
        @Generated
        private Boolean qlikHasSectionAccess;
        @Generated
        private String qlikId;
        @Generated
        private Boolean qlikIsDirectQueryMode;
        @Generated
        private Boolean qlikIsEncrypted;
        @Generated
        private Boolean qlikIsPublished;
        @Generated
        private String qlikOriginAppId;
        @Generated
        private String qlikOwnerId;
        @Generated
        private String qlikQRI;
        @Generated
        private ArrayList<IQlikSheet> qlikSheets;
        @Generated
        private IQlikSpace qlikSpace;
        @Generated
        private String qlikSpaceId;
        @Generated
        private String qlikSpaceQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QlikAppBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(QlikApp instance, QlikAppBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.qlikAppId(instance.qlikAppId);
            b.qlikAppQualifiedName(instance.qlikAppQualifiedName);
            b.qlikAppStaticByteSize(instance.qlikAppStaticByteSize);
            b.qlikHasSectionAccess(instance.qlikHasSectionAccess);
            b.qlikId(instance.qlikId);
            b.qlikIsDirectQueryMode(instance.qlikIsDirectQueryMode);
            b.qlikIsEncrypted(instance.qlikIsEncrypted);
            b.qlikIsPublished(instance.qlikIsPublished);
            b.qlikOriginAppId(instance.qlikOriginAppId);
            b.qlikOwnerId(instance.qlikOwnerId);
            b.qlikQRI(instance.qlikQRI);
            b.qlikSheets(instance.qlikSheets == null ? Collections.emptySortedSet() : instance.qlikSheets);
            b.qlikSpace(instance.qlikSpace);
            b.qlikSpaceId(instance.qlikSpaceId);
            b.qlikSpaceQualifiedName(instance.qlikSpaceQualifiedName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B qlikAppId(String qlikAppId) {
            this.qlikAppId = qlikAppId;
            return (B)this.self();
        }

        @Generated
        public B qlikAppQualifiedName(String qlikAppQualifiedName) {
            this.qlikAppQualifiedName = qlikAppQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B qlikAppStaticByteSize(Long qlikAppStaticByteSize) {
            this.qlikAppStaticByteSize = qlikAppStaticByteSize;
            return (B)this.self();
        }

        @Generated
        public B qlikHasSectionAccess(Boolean qlikHasSectionAccess) {
            this.qlikHasSectionAccess = qlikHasSectionAccess;
            return (B)this.self();
        }

        @Generated
        public B qlikId(String qlikId) {
            this.qlikId = qlikId;
            return (B)this.self();
        }

        @Generated
        public B qlikIsDirectQueryMode(Boolean qlikIsDirectQueryMode) {
            this.qlikIsDirectQueryMode = qlikIsDirectQueryMode;
            return (B)this.self();
        }

        @Generated
        public B qlikIsEncrypted(Boolean qlikIsEncrypted) {
            this.qlikIsEncrypted = qlikIsEncrypted;
            return (B)this.self();
        }

        @Generated
        public B qlikIsPublished(Boolean qlikIsPublished) {
            this.qlikIsPublished = qlikIsPublished;
            return (B)this.self();
        }

        @Generated
        public B qlikOriginAppId(String qlikOriginAppId) {
            this.qlikOriginAppId = qlikOriginAppId;
            return (B)this.self();
        }

        @Generated
        public B qlikOwnerId(String qlikOwnerId) {
            this.qlikOwnerId = qlikOwnerId;
            return (B)this.self();
        }

        @Generated
        public B qlikQRI(String qlikQRI) {
            this.qlikQRI = qlikQRI;
            return (B)this.self();
        }

        @Generated
        public B qlikSheet(IQlikSheet qlikSheet) {
            if (this.qlikSheets == null) {
                this.qlikSheets = new ArrayList();
            }
            this.qlikSheets.add(qlikSheet);
            return (B)this.self();
        }

        @Generated
        public B qlikSheets(Collection<? extends IQlikSheet> qlikSheets) {
            if (qlikSheets == null) {
                throw new NullPointerException("qlikSheets cannot be null");
            }
            if (this.qlikSheets == null) {
                this.qlikSheets = new ArrayList();
            }
            this.qlikSheets.addAll(qlikSheets);
            return (B)this.self();
        }

        @Generated
        public B clearQlikSheets() {
            if (this.qlikSheets != null) {
                this.qlikSheets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B qlikSpace(IQlikSpace qlikSpace) {
            this.qlikSpace = qlikSpace;
            return (B)this.self();
        }

        @Generated
        public B qlikSpaceId(String qlikSpaceId) {
            this.qlikSpaceId = qlikSpaceId;
            return (B)this.self();
        }

        @Generated
        public B qlikSpaceQualifiedName(String qlikSpaceQualifiedName) {
            this.qlikSpaceQualifiedName = qlikSpaceQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "QlikApp.QlikAppBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", qlikAppId=" + this.qlikAppId + ", qlikAppQualifiedName=" + this.qlikAppQualifiedName + ", qlikAppStaticByteSize=" + this.qlikAppStaticByteSize + ", qlikHasSectionAccess=" + this.qlikHasSectionAccess + ", qlikId=" + this.qlikId + ", qlikIsDirectQueryMode=" + this.qlikIsDirectQueryMode + ", qlikIsEncrypted=" + this.qlikIsEncrypted + ", qlikIsPublished=" + this.qlikIsPublished + ", qlikOriginAppId=" + this.qlikOriginAppId + ", qlikOwnerId=" + this.qlikOwnerId + ", qlikQRI=" + this.qlikQRI + ", qlikSheets=" + this.qlikSheets + ", qlikSpace=" + this.qlikSpace + ", qlikSpaceId=" + this.qlikSpaceId + ", qlikSpaceQualifiedName=" + this.qlikSpaceQualifiedName + ")";
        }
    }
}

