/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IQuickSight;
import com.atlan.model.assets.IQuickSightDashboard;
import com.atlan.model.assets.IQuickSightDashboardVisual;
import com.atlan.model.assets.IQuickSightFolder;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickSightDashboard
extends Asset
implements IQuickSightDashboard,
IQuickSight,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickSightDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QuickSightDashboard";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<IQuickSightFolder> quickSightDashboardFolders;
    @Attribute
    Long quickSightDashboardLastPublishedTime;
    @Attribute
    Long quickSightDashboardPublishedVersionNumber;
    @Attribute
    SortedSet<IQuickSightDashboardVisual> quickSightDashboardVisuals;
    @Attribute
    String quickSightId;
    @Attribute
    String quickSightSheetId;
    @Attribute
    String quickSightSheetName;

    @Override
    public QuickSightDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return QuickSightDashboard.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return QuickSightDashboard.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return QuickSightDashboard.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return QuickSightDashboard.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return QuickSightDashboard.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return QuickSightDashboard.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return QuickSightDashboard.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return QuickSightDashboard.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return QuickSightDashboard.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static QuickSightDashboard refByGuid(String guid) {
        return ((QuickSightDashboardBuilder)QuickSightDashboard._internal().guid(guid)).build();
    }

    public static QuickSightDashboard refByQualifiedName(String qualifiedName) {
        return ((QuickSightDashboardBuilder)QuickSightDashboard._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static QuickSightDashboard get(String id) throws AtlanException {
        return QuickSightDashboard.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static QuickSightDashboard get(AtlanClient client, String id) throws AtlanException {
        return QuickSightDashboard.get(client, id, true);
    }

    @JsonIgnore
    public static QuickSightDashboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof QuickSightDashboard) {
                return (QuickSightDashboard)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof QuickSightDashboard) {
            return (QuickSightDashboard)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static QuickSightDashboard retrieveByGuid(String guid) throws AtlanException {
        return QuickSightDashboard.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static QuickSightDashboard retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return QuickSightDashboard.get(client, guid);
    }

    @Deprecated
    public static QuickSightDashboard retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return QuickSightDashboard.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static QuickSightDashboard retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return QuickSightDashboard.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return QuickSightDashboard.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static QuickSightDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (QuickSightDashboardBuilder)((QuickSightDashboardBuilder)((QuickSightDashboardBuilder)QuickSightDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public QuickSightDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return QuickSightDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static QuickSightDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return QuickSightDashboard.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboard)Asset.removeDescription(client, QuickSightDashboard.updater(qualifiedName, name));
    }

    public static QuickSightDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return QuickSightDashboard.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboard)Asset.removeUserDescription(client, QuickSightDashboard.updater(qualifiedName, name));
    }

    public static QuickSightDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return QuickSightDashboard.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboard)Asset.removeOwners(client, QuickSightDashboard.updater(qualifiedName, name));
    }

    public static QuickSightDashboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return QuickSightDashboard.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static QuickSightDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QuickSightDashboard)Asset.updateCertificate(client, QuickSightDashboard._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static QuickSightDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return QuickSightDashboard.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboard)Asset.removeCertificate(client, QuickSightDashboard.updater(qualifiedName, name));
    }

    public static QuickSightDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return QuickSightDashboard.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static QuickSightDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QuickSightDashboard)Asset.updateAnnouncement(client, QuickSightDashboard._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static QuickSightDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return QuickSightDashboard.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboard)Asset.removeAnnouncement(client, QuickSightDashboard.updater(qualifiedName, name));
    }

    public static QuickSightDashboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightDashboard.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static QuickSightDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDashboard)Asset.replaceTerms(client, QuickSightDashboard.updater(qualifiedName, name), terms);
    }

    public static QuickSightDashboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightDashboard.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QuickSightDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDashboard)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QuickSightDashboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightDashboard.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QuickSightDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDashboard)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QuickSightDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return QuickSightDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static QuickSightDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QuickSightDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static QuickSightDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return QuickSightDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static QuickSightDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QuickSightDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        QuickSightDashboard.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        QuickSightDashboard.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        QuickSightDashboard.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected QuickSightDashboard(QuickSightDashboardBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : QuickSightDashboard.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<IQuickSightFolder> quickSightDashboardFolders = new TreeSet<IQuickSightFolder>();
        if (b.quickSightDashboardFolders != null) {
            quickSightDashboardFolders.addAll(b.quickSightDashboardFolders);
        }
        quickSightDashboardFolders = Collections.unmodifiableSortedSet(quickSightDashboardFolders);
        this.quickSightDashboardFolders = quickSightDashboardFolders;
        this.quickSightDashboardLastPublishedTime = b.quickSightDashboardLastPublishedTime;
        this.quickSightDashboardPublishedVersionNumber = b.quickSightDashboardPublishedVersionNumber;
        SortedSet<IQuickSightDashboardVisual> quickSightDashboardVisuals = new TreeSet<IQuickSightDashboardVisual>();
        if (b.quickSightDashboardVisuals != null) {
            quickSightDashboardVisuals.addAll(b.quickSightDashboardVisuals);
        }
        quickSightDashboardVisuals = Collections.unmodifiableSortedSet(quickSightDashboardVisuals);
        this.quickSightDashboardVisuals = quickSightDashboardVisuals;
        this.quickSightId = b.quickSightId;
        this.quickSightSheetId = b.quickSightSheetId;
        this.quickSightSheetName = b.quickSightSheetName;
    }

    @Generated
    public static QuickSightDashboardBuilder<?, ?> _internal() {
        return new QuickSightDashboardBuilderImpl();
    }

    @Generated
    public QuickSightDashboardBuilder<?, ?> toBuilder() {
        return new QuickSightDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<IQuickSightFolder> getQuickSightDashboardFolders() {
        return this.quickSightDashboardFolders;
    }

    @Override
    @Generated
    public Long getQuickSightDashboardLastPublishedTime() {
        return this.quickSightDashboardLastPublishedTime;
    }

    @Override
    @Generated
    public Long getQuickSightDashboardPublishedVersionNumber() {
        return this.quickSightDashboardPublishedVersionNumber;
    }

    @Override
    @Generated
    public SortedSet<IQuickSightDashboardVisual> getQuickSightDashboardVisuals() {
        return this.quickSightDashboardVisuals;
    }

    @Override
    @Generated
    public String getQuickSightId() {
        return this.quickSightId;
    }

    @Override
    @Generated
    public String getQuickSightSheetId() {
        return this.quickSightSheetId;
    }

    @Override
    @Generated
    public String getQuickSightSheetName() {
        return this.quickSightSheetName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuickSightDashboard)) {
            return false;
        }
        QuickSightDashboard other = (QuickSightDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$quickSightDashboardLastPublishedTime = this.getQuickSightDashboardLastPublishedTime();
        Long other$quickSightDashboardLastPublishedTime = other.getQuickSightDashboardLastPublishedTime();
        if (this$quickSightDashboardLastPublishedTime == null ? other$quickSightDashboardLastPublishedTime != null : !((Object)this$quickSightDashboardLastPublishedTime).equals(other$quickSightDashboardLastPublishedTime)) {
            return false;
        }
        Long this$quickSightDashboardPublishedVersionNumber = this.getQuickSightDashboardPublishedVersionNumber();
        Long other$quickSightDashboardPublishedVersionNumber = other.getQuickSightDashboardPublishedVersionNumber();
        if (this$quickSightDashboardPublishedVersionNumber == null ? other$quickSightDashboardPublishedVersionNumber != null : !((Object)this$quickSightDashboardPublishedVersionNumber).equals(other$quickSightDashboardPublishedVersionNumber)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<IQuickSightFolder> this$quickSightDashboardFolders = this.getQuickSightDashboardFolders();
        SortedSet<IQuickSightFolder> other$quickSightDashboardFolders = other.getQuickSightDashboardFolders();
        if (this$quickSightDashboardFolders == null ? other$quickSightDashboardFolders != null : !this$quickSightDashboardFolders.equals(other$quickSightDashboardFolders)) {
            return false;
        }
        SortedSet<IQuickSightDashboardVisual> this$quickSightDashboardVisuals = this.getQuickSightDashboardVisuals();
        SortedSet<IQuickSightDashboardVisual> other$quickSightDashboardVisuals = other.getQuickSightDashboardVisuals();
        if (this$quickSightDashboardVisuals == null ? other$quickSightDashboardVisuals != null : !this$quickSightDashboardVisuals.equals(other$quickSightDashboardVisuals)) {
            return false;
        }
        String this$quickSightId = this.getQuickSightId();
        String other$quickSightId = other.getQuickSightId();
        if (this$quickSightId == null ? other$quickSightId != null : !this$quickSightId.equals(other$quickSightId)) {
            return false;
        }
        String this$quickSightSheetId = this.getQuickSightSheetId();
        String other$quickSightSheetId = other.getQuickSightSheetId();
        if (this$quickSightSheetId == null ? other$quickSightSheetId != null : !this$quickSightSheetId.equals(other$quickSightSheetId)) {
            return false;
        }
        String this$quickSightSheetName = this.getQuickSightSheetName();
        String other$quickSightSheetName = other.getQuickSightSheetName();
        return !(this$quickSightSheetName == null ? other$quickSightSheetName != null : !this$quickSightSheetName.equals(other$quickSightSheetName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuickSightDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $quickSightDashboardLastPublishedTime = this.getQuickSightDashboardLastPublishedTime();
        result = result * 59 + ($quickSightDashboardLastPublishedTime == null ? 43 : ((Object)$quickSightDashboardLastPublishedTime).hashCode());
        Long $quickSightDashboardPublishedVersionNumber = this.getQuickSightDashboardPublishedVersionNumber();
        result = result * 59 + ($quickSightDashboardPublishedVersionNumber == null ? 43 : ((Object)$quickSightDashboardPublishedVersionNumber).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<IQuickSightFolder> $quickSightDashboardFolders = this.getQuickSightDashboardFolders();
        result = result * 59 + ($quickSightDashboardFolders == null ? 43 : $quickSightDashboardFolders.hashCode());
        SortedSet<IQuickSightDashboardVisual> $quickSightDashboardVisuals = this.getQuickSightDashboardVisuals();
        result = result * 59 + ($quickSightDashboardVisuals == null ? 43 : $quickSightDashboardVisuals.hashCode());
        String $quickSightId = this.getQuickSightId();
        result = result * 59 + ($quickSightId == null ? 43 : $quickSightId.hashCode());
        String $quickSightSheetId = this.getQuickSightSheetId();
        result = result * 59 + ($quickSightSheetId == null ? 43 : $quickSightSheetId.hashCode());
        String $quickSightSheetName = this.getQuickSightSheetName();
        result = result * 59 + ($quickSightSheetName == null ? 43 : $quickSightSheetName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QuickSightDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", quickSightDashboardFolders=" + this.getQuickSightDashboardFolders() + ", quickSightDashboardLastPublishedTime=" + this.getQuickSightDashboardLastPublishedTime() + ", quickSightDashboardPublishedVersionNumber=" + this.getQuickSightDashboardPublishedVersionNumber() + ", quickSightDashboardVisuals=" + this.getQuickSightDashboardVisuals() + ", quickSightId=" + this.getQuickSightId() + ", quickSightSheetId=" + this.getQuickSightSheetId() + ", quickSightSheetName=" + this.getQuickSightSheetName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class QuickSightDashboardBuilderImpl
    extends QuickSightDashboardBuilder<QuickSightDashboard, QuickSightDashboardBuilderImpl> {
        @Generated
        private QuickSightDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected QuickSightDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QuickSightDashboard build() {
            return new QuickSightDashboard(this);
        }
    }

    @Generated
    public static abstract class QuickSightDashboardBuilder<C extends QuickSightDashboard, B extends QuickSightDashboardBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<IQuickSightFolder> quickSightDashboardFolders;
        @Generated
        private Long quickSightDashboardLastPublishedTime;
        @Generated
        private Long quickSightDashboardPublishedVersionNumber;
        @Generated
        private ArrayList<IQuickSightDashboardVisual> quickSightDashboardVisuals;
        @Generated
        private String quickSightId;
        @Generated
        private String quickSightSheetId;
        @Generated
        private String quickSightSheetName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QuickSightDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(QuickSightDashboard instance, QuickSightDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.quickSightDashboardFolders(instance.quickSightDashboardFolders == null ? Collections.emptySortedSet() : instance.quickSightDashboardFolders);
            b.quickSightDashboardLastPublishedTime(instance.quickSightDashboardLastPublishedTime);
            b.quickSightDashboardPublishedVersionNumber(instance.quickSightDashboardPublishedVersionNumber);
            b.quickSightDashboardVisuals(instance.quickSightDashboardVisuals == null ? Collections.emptySortedSet() : instance.quickSightDashboardVisuals);
            b.quickSightId(instance.quickSightId);
            b.quickSightSheetId(instance.quickSightSheetId);
            b.quickSightSheetName(instance.quickSightSheetName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightDashboardFolder(IQuickSightFolder quickSightDashboardFolder) {
            if (this.quickSightDashboardFolders == null) {
                this.quickSightDashboardFolders = new ArrayList();
            }
            this.quickSightDashboardFolders.add(quickSightDashboardFolder);
            return (B)this.self();
        }

        @Generated
        public B quickSightDashboardFolders(Collection<? extends IQuickSightFolder> quickSightDashboardFolders) {
            if (quickSightDashboardFolders == null) {
                throw new NullPointerException("quickSightDashboardFolders cannot be null");
            }
            if (this.quickSightDashboardFolders == null) {
                this.quickSightDashboardFolders = new ArrayList();
            }
            this.quickSightDashboardFolders.addAll(quickSightDashboardFolders);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightDashboardFolders() {
            if (this.quickSightDashboardFolders != null) {
                this.quickSightDashboardFolders.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightDashboardLastPublishedTime(Long quickSightDashboardLastPublishedTime) {
            this.quickSightDashboardLastPublishedTime = quickSightDashboardLastPublishedTime;
            return (B)this.self();
        }

        @Generated
        public B quickSightDashboardPublishedVersionNumber(Long quickSightDashboardPublishedVersionNumber) {
            this.quickSightDashboardPublishedVersionNumber = quickSightDashboardPublishedVersionNumber;
            return (B)this.self();
        }

        @Generated
        public B quickSightDashboardVisual(IQuickSightDashboardVisual quickSightDashboardVisual) {
            if (this.quickSightDashboardVisuals == null) {
                this.quickSightDashboardVisuals = new ArrayList();
            }
            this.quickSightDashboardVisuals.add(quickSightDashboardVisual);
            return (B)this.self();
        }

        @Generated
        public B quickSightDashboardVisuals(Collection<? extends IQuickSightDashboardVisual> quickSightDashboardVisuals) {
            if (quickSightDashboardVisuals == null) {
                throw new NullPointerException("quickSightDashboardVisuals cannot be null");
            }
            if (this.quickSightDashboardVisuals == null) {
                this.quickSightDashboardVisuals = new ArrayList();
            }
            this.quickSightDashboardVisuals.addAll(quickSightDashboardVisuals);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightDashboardVisuals() {
            if (this.quickSightDashboardVisuals != null) {
                this.quickSightDashboardVisuals.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightId(String quickSightId) {
            this.quickSightId = quickSightId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetId(String quickSightSheetId) {
            this.quickSightSheetId = quickSightSheetId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetName(String quickSightSheetName) {
            this.quickSightSheetName = quickSightSheetName;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "QuickSightDashboard.QuickSightDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", quickSightDashboardFolders=" + this.quickSightDashboardFolders + ", quickSightDashboardLastPublishedTime=" + this.quickSightDashboardLastPublishedTime + ", quickSightDashboardPublishedVersionNumber=" + this.quickSightDashboardPublishedVersionNumber + ", quickSightDashboardVisuals=" + this.quickSightDashboardVisuals + ", quickSightId=" + this.quickSightId + ", quickSightSheetId=" + this.quickSightSheetId + ", quickSightSheetName=" + this.quickSightSheetName + ")";
        }
    }
}

