/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReadmeTemplate;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IResource;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.IconType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadmeTemplate
extends Asset
implements IReadmeTemplate,
IResource,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadmeTemplate.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ReadmeTemplate";
    String typeName;
    @Attribute
    String icon;
    @Attribute
    IconType iconType;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    Boolean isGlobal;
    @Attribute
    String link;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    String reference;
    @Attribute
    Map<String, String> resourceMetadata;

    @Override
    public ReadmeTemplate trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ReadmeTemplate.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ReadmeTemplate.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ReadmeTemplate.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ReadmeTemplate.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ReadmeTemplate.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ReadmeTemplate.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return ReadmeTemplate.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return ReadmeTemplate.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return ReadmeTemplate.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static ReadmeTemplate refByGuid(String guid) {
        return ((ReadmeTemplateBuilder)ReadmeTemplate._internal().guid(guid)).build();
    }

    public static ReadmeTemplate refByQualifiedName(String qualifiedName) {
        return ((ReadmeTemplateBuilder)ReadmeTemplate._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static ReadmeTemplate get(String id) throws AtlanException {
        return ReadmeTemplate.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ReadmeTemplate get(AtlanClient client, String id) throws AtlanException {
        return ReadmeTemplate.get(client, id, true);
    }

    @JsonIgnore
    public static ReadmeTemplate get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ReadmeTemplate) {
                return (ReadmeTemplate)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ReadmeTemplate) {
            return (ReadmeTemplate)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static ReadmeTemplate retrieveByGuid(String guid) throws AtlanException {
        return ReadmeTemplate.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static ReadmeTemplate retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return ReadmeTemplate.get(client, guid);
    }

    @Deprecated
    public static ReadmeTemplate retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return ReadmeTemplate.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static ReadmeTemplate retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return ReadmeTemplate.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ReadmeTemplate.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ReadmeTemplateBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ReadmeTemplateBuilder)((ReadmeTemplateBuilder)((ReadmeTemplateBuilder)ReadmeTemplate._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ReadmeTemplateBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return ReadmeTemplate.updater(this.getQualifiedName(), this.getName());
    }

    public static ReadmeTemplate removeDescription(String qualifiedName, String name) throws AtlanException {
        return ReadmeTemplate.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ReadmeTemplate removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ReadmeTemplate)Asset.removeDescription(client, ReadmeTemplate.updater(qualifiedName, name));
    }

    public static ReadmeTemplate removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ReadmeTemplate.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ReadmeTemplate removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ReadmeTemplate)Asset.removeUserDescription(client, ReadmeTemplate.updater(qualifiedName, name));
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ReadmeTemplate(ReadmeTemplateBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> resourceMetadata;
        this.typeName = b.typeName$set ? b.typeName$value : ReadmeTemplate.$default$typeName();
        this.icon = b.icon;
        this.iconType = b.iconType;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.isGlobal = b.isGlobal;
        this.link = b.link;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.reference = b.reference;
        switch (b.resourceMetadata$key == null ? 0 : b.resourceMetadata$key.size()) {
            case 0: {
                resourceMetadata = Collections.emptyMap();
                break;
            }
            case 1: {
                resourceMetadata = Collections.singletonMap(b.resourceMetadata$key.get(0), b.resourceMetadata$value.get(0));
                break;
            }
            default: {
                resourceMetadata = new LinkedHashMap(b.resourceMetadata$key.size() < 0x40000000 ? 1 + b.resourceMetadata$key.size() + (b.resourceMetadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.resourceMetadata$key.size(); ++$i) {
                    resourceMetadata.put(b.resourceMetadata$key.get($i), b.resourceMetadata$value.get($i));
                }
                resourceMetadata = Collections.unmodifiableMap(resourceMetadata);
            }
        }
        this.resourceMetadata = resourceMetadata;
    }

    @Generated
    public static ReadmeTemplateBuilder<?, ?> _internal() {
        return new ReadmeTemplateBuilderImpl();
    }

    @Generated
    public ReadmeTemplateBuilder<?, ?> toBuilder() {
        return new ReadmeTemplateBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Generated
    public IconType getIconType() {
        return this.iconType;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public Boolean getIsGlobal() {
        return this.isGlobal;
    }

    @Override
    @Generated
    public String getLink() {
        return this.link;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public String getReference() {
        return this.reference;
    }

    @Override
    @Generated
    public Map<String, String> getResourceMetadata() {
        return this.resourceMetadata;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadmeTemplate)) {
            return false;
        }
        ReadmeTemplate other = (ReadmeTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isGlobal = this.getIsGlobal();
        Boolean other$isGlobal = other.getIsGlobal();
        if (this$isGlobal == null ? other$isGlobal != null : !((Object)this$isGlobal).equals(other$isGlobal)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        IconType this$iconType = this.getIconType();
        IconType other$iconType = other.getIconType();
        if (this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        Map<String, String> this$resourceMetadata = this.getResourceMetadata();
        Map<String, String> other$resourceMetadata = other.getResourceMetadata();
        return !(this$resourceMetadata == null ? other$resourceMetadata != null : !((Object)this$resourceMetadata).equals(other$resourceMetadata));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReadmeTemplate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isGlobal = this.getIsGlobal();
        result = result * 59 + ($isGlobal == null ? 43 : ((Object)$isGlobal).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        IconType $iconType = this.getIconType();
        result = result * 59 + ($iconType == null ? 43 : $iconType.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        Map<String, String> $resourceMetadata = this.getResourceMetadata();
        result = result * 59 + ($resourceMetadata == null ? 43 : ((Object)$resourceMetadata).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ReadmeTemplate(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", icon=" + this.getIcon() + ", iconType=" + this.getIconType() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", isGlobal=" + this.getIsGlobal() + ", link=" + this.getLink() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", reference=" + this.getReference() + ", resourceMetadata=" + this.getResourceMetadata() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class ReadmeTemplateBuilderImpl
    extends ReadmeTemplateBuilder<ReadmeTemplate, ReadmeTemplateBuilderImpl> {
        @Generated
        private ReadmeTemplateBuilderImpl() {
        }

        @Override
        @Generated
        protected ReadmeTemplateBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ReadmeTemplate build() {
            return new ReadmeTemplate(this);
        }
    }

    @Generated
    public static abstract class ReadmeTemplateBuilder<C extends ReadmeTemplate, B extends ReadmeTemplateBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String icon;
        @Generated
        private IconType iconType;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private Boolean isGlobal;
        @Generated
        private String link;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private String reference;
        @Generated
        private ArrayList<String> resourceMetadata$key;
        @Generated
        private ArrayList<String> resourceMetadata$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadmeTemplateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ReadmeTemplate instance, ReadmeTemplateBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.icon(instance.icon);
            b.iconType(instance.iconType);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.isGlobal(instance.isGlobal);
            b.link(instance.link);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.reference(instance.reference);
            b.resourceMetadata(instance.resourceMetadata == null ? Collections.emptyMap() : instance.resourceMetadata);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B icon(String icon) {
            this.icon = icon;
            return (B)this.self();
        }

        @Generated
        public B iconType(IconType iconType) {
            this.iconType = iconType;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            return (B)this.self();
        }

        @Generated
        public B link(String link) {
            this.link = link;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B reference(String reference) {
            this.reference = reference;
            return (B)this.self();
        }

        @Generated
        public B putResourceMetadata(String putResourceMetadataKey, String putResourceMetadataValue) {
            if (this.resourceMetadata$key == null) {
                this.resourceMetadata$key = new ArrayList();
                this.resourceMetadata$value = new ArrayList();
            }
            this.resourceMetadata$key.add(putResourceMetadataKey);
            this.resourceMetadata$value.add(putResourceMetadataValue);
            return (B)this.self();
        }

        @Generated
        public B resourceMetadata(Map<? extends String, ? extends String> resourceMetadata) {
            if (resourceMetadata == null) {
                throw new NullPointerException("resourceMetadata cannot be null");
            }
            if (this.resourceMetadata$key == null) {
                this.resourceMetadata$key = new ArrayList();
                this.resourceMetadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : resourceMetadata.entrySet()) {
                this.resourceMetadata$key.add($lombokEntry.getKey());
                this.resourceMetadata$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearResourceMetadata() {
            if (this.resourceMetadata$key != null) {
                this.resourceMetadata$key.clear();
                this.resourceMetadata$value.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ReadmeTemplate.ReadmeTemplateBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", icon=" + this.icon + ", iconType=" + this.iconType + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", isGlobal=" + this.isGlobal + ", link=" + this.link + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", reference=" + this.reference + ", resourceMetadata$key=" + this.resourceMetadata$key + ", resourceMetadata$value=" + this.resourceMetadata$value + ")";
        }
    }
}

