/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IRedash;
import com.atlan.model.assets.IRedashDashboard;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedashDashboard
extends Asset
implements IRedashDashboard,
IRedash,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedashDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "RedashDashboard";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    Long redashDashboardWidgetCount;
    @Attribute
    Boolean redashIsPublished;

    @Override
    public RedashDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return RedashDashboard.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return RedashDashboard.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return RedashDashboard.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return RedashDashboard.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return RedashDashboard.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return RedashDashboard.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return RedashDashboard.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return RedashDashboard.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return RedashDashboard.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static RedashDashboard refByGuid(String guid) {
        return ((RedashDashboardBuilder)RedashDashboard._internal().guid(guid)).build();
    }

    public static RedashDashboard refByQualifiedName(String qualifiedName) {
        return ((RedashDashboardBuilder)RedashDashboard._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static RedashDashboard get(String id) throws AtlanException {
        return RedashDashboard.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static RedashDashboard get(AtlanClient client, String id) throws AtlanException {
        return RedashDashboard.get(client, id, true);
    }

    @JsonIgnore
    public static RedashDashboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof RedashDashboard) {
                return (RedashDashboard)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof RedashDashboard) {
            return (RedashDashboard)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static RedashDashboard retrieveByGuid(String guid) throws AtlanException {
        return RedashDashboard.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static RedashDashboard retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return RedashDashboard.get(client, guid);
    }

    @Deprecated
    public static RedashDashboard retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return RedashDashboard.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static RedashDashboard retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return RedashDashboard.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return RedashDashboard.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static RedashDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (RedashDashboardBuilder)((RedashDashboardBuilder)((RedashDashboardBuilder)RedashDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public RedashDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return RedashDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static RedashDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return RedashDashboard.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashDashboard)Asset.removeDescription(client, RedashDashboard.updater(qualifiedName, name));
    }

    public static RedashDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return RedashDashboard.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashDashboard)Asset.removeUserDescription(client, RedashDashboard.updater(qualifiedName, name));
    }

    public static RedashDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return RedashDashboard.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashDashboard)Asset.removeOwners(client, RedashDashboard.updater(qualifiedName, name));
    }

    public static RedashDashboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return RedashDashboard.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static RedashDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (RedashDashboard)Asset.updateCertificate(client, RedashDashboard._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static RedashDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return RedashDashboard.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashDashboard)Asset.removeCertificate(client, RedashDashboard.updater(qualifiedName, name));
    }

    public static RedashDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return RedashDashboard.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static RedashDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (RedashDashboard)Asset.updateAnnouncement(client, RedashDashboard._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static RedashDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return RedashDashboard.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashDashboard)Asset.removeAnnouncement(client, RedashDashboard.updater(qualifiedName, name));
    }

    public static RedashDashboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return RedashDashboard.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static RedashDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashDashboard)Asset.replaceTerms(client, RedashDashboard.updater(qualifiedName, name), terms);
    }

    public static RedashDashboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return RedashDashboard.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static RedashDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashDashboard)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static RedashDashboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return RedashDashboard.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static RedashDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashDashboard)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static RedashDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return RedashDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static RedashDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (RedashDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static RedashDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return RedashDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static RedashDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (RedashDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        RedashDashboard.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        RedashDashboard.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        RedashDashboard.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected RedashDashboard(RedashDashboardBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : RedashDashboard.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.redashDashboardWidgetCount = b.redashDashboardWidgetCount;
        this.redashIsPublished = b.redashIsPublished;
    }

    @Generated
    public static RedashDashboardBuilder<?, ?> _internal() {
        return new RedashDashboardBuilderImpl();
    }

    @Generated
    public RedashDashboardBuilder<?, ?> toBuilder() {
        return new RedashDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public Long getRedashDashboardWidgetCount() {
        return this.redashDashboardWidgetCount;
    }

    @Override
    @Generated
    public Boolean getRedashIsPublished() {
        return this.redashIsPublished;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedashDashboard)) {
            return false;
        }
        RedashDashboard other = (RedashDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$redashDashboardWidgetCount = this.getRedashDashboardWidgetCount();
        Long other$redashDashboardWidgetCount = other.getRedashDashboardWidgetCount();
        if (this$redashDashboardWidgetCount == null ? other$redashDashboardWidgetCount != null : !((Object)this$redashDashboardWidgetCount).equals(other$redashDashboardWidgetCount)) {
            return false;
        }
        Boolean this$redashIsPublished = this.getRedashIsPublished();
        Boolean other$redashIsPublished = other.getRedashIsPublished();
        if (this$redashIsPublished == null ? other$redashIsPublished != null : !((Object)this$redashIsPublished).equals(other$redashIsPublished)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedashDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $redashDashboardWidgetCount = this.getRedashDashboardWidgetCount();
        result = result * 59 + ($redashDashboardWidgetCount == null ? 43 : ((Object)$redashDashboardWidgetCount).hashCode());
        Boolean $redashIsPublished = this.getRedashIsPublished();
        result = result * 59 + ($redashIsPublished == null ? 43 : ((Object)$redashIsPublished).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RedashDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", redashDashboardWidgetCount=" + this.getRedashDashboardWidgetCount() + ", redashIsPublished=" + this.getRedashIsPublished() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class RedashDashboardBuilderImpl
    extends RedashDashboardBuilder<RedashDashboard, RedashDashboardBuilderImpl> {
        @Generated
        private RedashDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected RedashDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RedashDashboard build() {
            return new RedashDashboard(this);
        }
    }

    @Generated
    public static abstract class RedashDashboardBuilder<C extends RedashDashboard, B extends RedashDashboardBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private Long redashDashboardWidgetCount;
        @Generated
        private Boolean redashIsPublished;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RedashDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RedashDashboard instance, RedashDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.redashDashboardWidgetCount(instance.redashDashboardWidgetCount);
            b.redashIsPublished(instance.redashIsPublished);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B redashDashboardWidgetCount(Long redashDashboardWidgetCount) {
            this.redashDashboardWidgetCount = redashDashboardWidgetCount;
            return (B)this.self();
        }

        @Generated
        public B redashIsPublished(Boolean redashIsPublished) {
            this.redashIsPublished = redashIsPublished;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "RedashDashboard.RedashDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", redashDashboardWidgetCount=" + this.redashDashboardWidgetCount + ", redashIsPublished=" + this.redashIsPublished + ")";
        }
    }
}

