/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISaaS;
import com.atlan.model.assets.ISalesforce;
import com.atlan.model.assets.ISalesforceField;
import com.atlan.model.assets.ISalesforceObject;
import com.atlan.model.assets.ISalesforceOrganization;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceObject
extends Asset
implements ISalesforceObject,
ISalesforce,
ISaaS,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SalesforceObject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceObject";
    String typeName;
    @Attribute
    String apiName;
    @Attribute
    Long fieldCount;
    @Attribute
    SortedSet<ISalesforceField> fields;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    Boolean isCustom;
    @Attribute
    Boolean isMergable;
    @Attribute
    Boolean isQueryable;
    @Attribute
    SortedSet<ISalesforceField> lookupFields;
    @Attribute
    ISalesforceOrganization organization;
    @Attribute
    String organizationQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;

    @Override
    public SalesforceObject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SalesforceObject.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SalesforceObject.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SalesforceObject.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SalesforceObject.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SalesforceObject.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SalesforceObject.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return SalesforceObject.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return SalesforceObject.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return SalesforceObject.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static SalesforceObject refByGuid(String guid) {
        return ((SalesforceObjectBuilder)SalesforceObject._internal().guid(guid)).build();
    }

    public static SalesforceObject refByQualifiedName(String qualifiedName) {
        return ((SalesforceObjectBuilder)SalesforceObject._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static SalesforceObject get(String id) throws AtlanException {
        return SalesforceObject.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SalesforceObject get(AtlanClient client, String id) throws AtlanException {
        return SalesforceObject.get(client, id, true);
    }

    @JsonIgnore
    public static SalesforceObject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SalesforceObject) {
                return (SalesforceObject)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SalesforceObject) {
            return (SalesforceObject)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static SalesforceObject retrieveByGuid(String guid) throws AtlanException {
        return SalesforceObject.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static SalesforceObject retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return SalesforceObject.get(client, guid);
    }

    @Deprecated
    public static SalesforceObject retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return SalesforceObject.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static SalesforceObject retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return SalesforceObject.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SalesforceObject.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SalesforceObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceObjectBuilder)((SalesforceObjectBuilder)((SalesforceObjectBuilder)SalesforceObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SalesforceObjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return SalesforceObject.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceObject removeDescription(String qualifiedName, String name) throws AtlanException {
        return SalesforceObject.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceObject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeDescription(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SalesforceObject.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceObject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeUserDescription(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject removeOwners(String qualifiedName, String name) throws AtlanException {
        return SalesforceObject.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceObject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeOwners(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SalesforceObject.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SalesforceObject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceObject)Asset.updateCertificate(client, SalesforceObject._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceObject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SalesforceObject.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceObject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeCertificate(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SalesforceObject.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SalesforceObject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceObject)Asset.updateAnnouncement(client, SalesforceObject._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceObject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SalesforceObject.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceObject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceObject)Asset.removeAnnouncement(client, SalesforceObject.updater(qualifiedName, name));
    }

    public static SalesforceObject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceObject.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SalesforceObject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.replaceTerms(client, SalesforceObject.updater(qualifiedName, name), terms);
    }

    public static SalesforceObject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceObject.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SalesforceObject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceObject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceObject.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SalesforceObject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceObject)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceObject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SalesforceObject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SalesforceObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SalesforceObject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SalesforceObject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SalesforceObject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SalesforceObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SalesforceObject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        SalesforceObject.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        SalesforceObject.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SalesforceObject.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceObject(SalesforceObjectBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceObject.$default$typeName();
        this.apiName = b.apiName;
        this.fieldCount = b.fieldCount;
        SortedSet<ISalesforceField> fields = new TreeSet<ISalesforceField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.isCustom = b.isCustom;
        this.isMergable = b.isMergable;
        this.isQueryable = b.isQueryable;
        SortedSet<ISalesforceField> lookupFields = new TreeSet<ISalesforceField>();
        if (b.lookupFields != null) {
            lookupFields.addAll(b.lookupFields);
        }
        lookupFields = Collections.unmodifiableSortedSet(lookupFields);
        this.lookupFields = lookupFields;
        this.organization = b.organization;
        this.organizationQualifiedName = b.organizationQualifiedName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static SalesforceObjectBuilder<?, ?> _internal() {
        return new SalesforceObjectBuilderImpl();
    }

    @Generated
    public SalesforceObjectBuilder<?, ?> toBuilder() {
        return new SalesforceObjectBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getApiName() {
        return this.apiName;
    }

    @Override
    @Generated
    public Long getFieldCount() {
        return this.fieldCount;
    }

    @Override
    @Generated
    public SortedSet<ISalesforceField> getFields() {
        return this.fields;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public Boolean getIsCustom() {
        return this.isCustom;
    }

    @Override
    @Generated
    public Boolean getIsMergable() {
        return this.isMergable;
    }

    @Override
    @Generated
    public Boolean getIsQueryable() {
        return this.isQueryable;
    }

    @Override
    @Generated
    public SortedSet<ISalesforceField> getLookupFields() {
        return this.lookupFields;
    }

    @Override
    @Generated
    public ISalesforceOrganization getOrganization() {
        return this.organization;
    }

    @Override
    @Generated
    public String getOrganizationQualifiedName() {
        return this.organizationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceObject)) {
            return false;
        }
        SalesforceObject other = (SalesforceObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$fieldCount = this.getFieldCount();
        Long other$fieldCount = other.getFieldCount();
        if (this$fieldCount == null ? other$fieldCount != null : !((Object)this$fieldCount).equals(other$fieldCount)) {
            return false;
        }
        Boolean this$isCustom = this.getIsCustom();
        Boolean other$isCustom = other.getIsCustom();
        if (this$isCustom == null ? other$isCustom != null : !((Object)this$isCustom).equals(other$isCustom)) {
            return false;
        }
        Boolean this$isMergable = this.getIsMergable();
        Boolean other$isMergable = other.getIsMergable();
        if (this$isMergable == null ? other$isMergable != null : !((Object)this$isMergable).equals(other$isMergable)) {
            return false;
        }
        Boolean this$isQueryable = this.getIsQueryable();
        Boolean other$isQueryable = other.getIsQueryable();
        if (this$isQueryable == null ? other$isQueryable != null : !((Object)this$isQueryable).equals(other$isQueryable)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$apiName = this.getApiName();
        String other$apiName = other.getApiName();
        if (this$apiName == null ? other$apiName != null : !this$apiName.equals(other$apiName)) {
            return false;
        }
        SortedSet<ISalesforceField> this$fields = this.getFields();
        SortedSet<ISalesforceField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISalesforceField> this$lookupFields = this.getLookupFields();
        SortedSet<ISalesforceField> other$lookupFields = other.getLookupFields();
        if (this$lookupFields == null ? other$lookupFields != null : !this$lookupFields.equals(other$lookupFields)) {
            return false;
        }
        ISalesforceOrganization this$organization = this.getOrganization();
        ISalesforceOrganization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$organizationQualifiedName = this.getOrganizationQualifiedName();
        String other$organizationQualifiedName = other.getOrganizationQualifiedName();
        if (this$organizationQualifiedName == null ? other$organizationQualifiedName != null : !this$organizationQualifiedName.equals(other$organizationQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceObject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $fieldCount = this.getFieldCount();
        result = result * 59 + ($fieldCount == null ? 43 : ((Object)$fieldCount).hashCode());
        Boolean $isCustom = this.getIsCustom();
        result = result * 59 + ($isCustom == null ? 43 : ((Object)$isCustom).hashCode());
        Boolean $isMergable = this.getIsMergable();
        result = result * 59 + ($isMergable == null ? 43 : ((Object)$isMergable).hashCode());
        Boolean $isQueryable = this.getIsQueryable();
        result = result * 59 + ($isQueryable == null ? 43 : ((Object)$isQueryable).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $apiName = this.getApiName();
        result = result * 59 + ($apiName == null ? 43 : $apiName.hashCode());
        SortedSet<ISalesforceField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISalesforceField> $lookupFields = this.getLookupFields();
        result = result * 59 + ($lookupFields == null ? 43 : $lookupFields.hashCode());
        ISalesforceOrganization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $organizationQualifiedName = this.getOrganizationQualifiedName();
        result = result * 59 + ($organizationQualifiedName == null ? 43 : $organizationQualifiedName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SalesforceObject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiName=" + this.getApiName() + ", fieldCount=" + this.getFieldCount() + ", fields=" + this.getFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", isCustom=" + this.getIsCustom() + ", isMergable=" + this.getIsMergable() + ", isQueryable=" + this.getIsQueryable() + ", lookupFields=" + this.getLookupFields() + ", organization=" + this.getOrganization() + ", organizationQualifiedName=" + this.getOrganizationQualifiedName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class SalesforceObjectBuilderImpl
    extends SalesforceObjectBuilder<SalesforceObject, SalesforceObjectBuilderImpl> {
        @Generated
        private SalesforceObjectBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceObjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceObject build() {
            return new SalesforceObject(this);
        }
    }

    @Generated
    public static abstract class SalesforceObjectBuilder<C extends SalesforceObject, B extends SalesforceObjectBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String apiName;
        @Generated
        private Long fieldCount;
        @Generated
        private ArrayList<ISalesforceField> fields;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private Boolean isCustom;
        @Generated
        private Boolean isMergable;
        @Generated
        private Boolean isQueryable;
        @Generated
        private ArrayList<ISalesforceField> lookupFields;
        @Generated
        private ISalesforceOrganization organization;
        @Generated
        private String organizationQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceObject instance, SalesforceObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiName(instance.apiName);
            b.fieldCount(instance.fieldCount);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.isCustom(instance.isCustom);
            b.isMergable(instance.isMergable);
            b.isQueryable(instance.isQueryable);
            b.lookupFields(instance.lookupFields == null ? Collections.emptySortedSet() : instance.lookupFields);
            b.organization(instance.organization);
            b.organizationQualifiedName(instance.organizationQualifiedName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiName(String apiName) {
            this.apiName = apiName;
            return (B)this.self();
        }

        @Generated
        public B fieldCount(Long fieldCount) {
            this.fieldCount = fieldCount;
            return (B)this.self();
        }

        @Generated
        public B field(ISalesforceField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends ISalesforceField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isCustom(Boolean isCustom) {
            this.isCustom = isCustom;
            return (B)this.self();
        }

        @Generated
        public B isMergable(Boolean isMergable) {
            this.isMergable = isMergable;
            return (B)this.self();
        }

        @Generated
        public B isQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
            return (B)this.self();
        }

        @Generated
        public B lookupField(ISalesforceField lookupField) {
            if (this.lookupFields == null) {
                this.lookupFields = new ArrayList();
            }
            this.lookupFields.add(lookupField);
            return (B)this.self();
        }

        @Generated
        public B lookupFields(Collection<? extends ISalesforceField> lookupFields) {
            if (lookupFields == null) {
                throw new NullPointerException("lookupFields cannot be null");
            }
            if (this.lookupFields == null) {
                this.lookupFields = new ArrayList();
            }
            this.lookupFields.addAll(lookupFields);
            return (B)this.self();
        }

        @Generated
        public B clearLookupFields() {
            if (this.lookupFields != null) {
                this.lookupFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B organization(ISalesforceOrganization organization) {
            this.organization = organization;
            return (B)this.self();
        }

        @Generated
        public B organizationQualifiedName(String organizationQualifiedName) {
            this.organizationQualifiedName = organizationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SalesforceObject.SalesforceObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiName=" + this.apiName + ", fieldCount=" + this.fieldCount + ", fields=" + this.fields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", isCustom=" + this.isCustom + ", isMergable=" + this.isMergable + ", isQueryable=" + this.isQueryable + ", lookupFields=" + this.lookupFields + ", organization=" + this.organization + ", organizationQualifiedName=" + this.organizationQualifiedName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

