/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISaaS;
import com.atlan.model.assets.ISalesforce;
import com.atlan.model.assets.ISalesforceDashboard;
import com.atlan.model.assets.ISalesforceObject;
import com.atlan.model.assets.ISalesforceOrganization;
import com.atlan.model.assets.ISalesforceReport;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceOrganization
extends Asset
implements ISalesforceOrganization,
ISalesforce,
ISaaS,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SalesforceOrganization.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceOrganization";
    String typeName;
    @Attribute
    String apiName;
    @Attribute
    SortedSet<ISalesforceDashboard> dashboards;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISalesforceObject> objects;
    @Attribute
    String organizationQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISalesforceReport> reports;
    @Attribute
    String sourceId;

    @Override
    public SalesforceOrganization trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SalesforceOrganization.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SalesforceOrganization.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SalesforceOrganization.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SalesforceOrganization.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SalesforceOrganization.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SalesforceOrganization.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return SalesforceOrganization.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return SalesforceOrganization.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return SalesforceOrganization.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static SalesforceOrganization refByGuid(String guid) {
        return ((SalesforceOrganizationBuilder)SalesforceOrganization._internal().guid(guid)).build();
    }

    public static SalesforceOrganization refByQualifiedName(String qualifiedName) {
        return ((SalesforceOrganizationBuilder)SalesforceOrganization._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static SalesforceOrganization get(String id) throws AtlanException {
        return SalesforceOrganization.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SalesforceOrganization get(AtlanClient client, String id) throws AtlanException {
        return SalesforceOrganization.get(client, id, true);
    }

    @JsonIgnore
    public static SalesforceOrganization get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SalesforceOrganization) {
                return (SalesforceOrganization)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SalesforceOrganization) {
            return (SalesforceOrganization)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static SalesforceOrganization retrieveByGuid(String guid) throws AtlanException {
        return SalesforceOrganization.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static SalesforceOrganization retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return SalesforceOrganization.get(client, guid);
    }

    @Deprecated
    public static SalesforceOrganization retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return SalesforceOrganization.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static SalesforceOrganization retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return SalesforceOrganization.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SalesforceOrganization.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SalesforceOrganizationBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceOrganizationBuilder)((SalesforceOrganizationBuilder)((SalesforceOrganizationBuilder)SalesforceOrganization._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SalesforceOrganizationBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return SalesforceOrganization.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceOrganization removeDescription(String qualifiedName, String name) throws AtlanException {
        return SalesforceOrganization.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceOrganization removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeDescription(client, SalesforceOrganization.updater(qualifiedName, name));
    }

    public static SalesforceOrganization removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SalesforceOrganization.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceOrganization removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeUserDescription(client, SalesforceOrganization.updater(qualifiedName, name));
    }

    public static SalesforceOrganization removeOwners(String qualifiedName, String name) throws AtlanException {
        return SalesforceOrganization.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceOrganization removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeOwners(client, SalesforceOrganization.updater(qualifiedName, name));
    }

    public static SalesforceOrganization updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SalesforceOrganization.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SalesforceOrganization updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceOrganization)Asset.updateCertificate(client, SalesforceOrganization._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceOrganization removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SalesforceOrganization.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceOrganization removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeCertificate(client, SalesforceOrganization.updater(qualifiedName, name));
    }

    public static SalesforceOrganization updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SalesforceOrganization.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SalesforceOrganization updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceOrganization)Asset.updateAnnouncement(client, SalesforceOrganization._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceOrganization removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SalesforceOrganization.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceOrganization removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceOrganization)Asset.removeAnnouncement(client, SalesforceOrganization.updater(qualifiedName, name));
    }

    public static SalesforceOrganization replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceOrganization.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SalesforceOrganization replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceOrganization)Asset.replaceTerms(client, SalesforceOrganization.updater(qualifiedName, name), terms);
    }

    public static SalesforceOrganization appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceOrganization.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SalesforceOrganization appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceOrganization)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceOrganization removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceOrganization.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SalesforceOrganization removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceOrganization)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceOrganization appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SalesforceOrganization.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SalesforceOrganization appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SalesforceOrganization)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SalesforceOrganization appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SalesforceOrganization.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SalesforceOrganization appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SalesforceOrganization)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        SalesforceOrganization.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        SalesforceOrganization.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SalesforceOrganization.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceOrganization(SalesforceOrganizationBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceOrganization.$default$typeName();
        this.apiName = b.apiName;
        SortedSet<ISalesforceDashboard> dashboards = new TreeSet<ISalesforceDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISalesforceObject> objects = new TreeSet<ISalesforceObject>();
        if (b.objects != null) {
            objects.addAll(b.objects);
        }
        objects = Collections.unmodifiableSortedSet(objects);
        this.objects = objects;
        this.organizationQualifiedName = b.organizationQualifiedName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISalesforceReport> reports = new TreeSet<ISalesforceReport>();
        if (b.reports != null) {
            reports.addAll(b.reports);
        }
        reports = Collections.unmodifiableSortedSet(reports);
        this.reports = reports;
        this.sourceId = b.sourceId;
    }

    @Generated
    public static SalesforceOrganizationBuilder<?, ?> _internal() {
        return new SalesforceOrganizationBuilderImpl();
    }

    @Generated
    public SalesforceOrganizationBuilder<?, ?> toBuilder() {
        return new SalesforceOrganizationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getApiName() {
        return this.apiName;
    }

    @Override
    @Generated
    public SortedSet<ISalesforceDashboard> getDashboards() {
        return this.dashboards;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISalesforceObject> getObjects() {
        return this.objects;
    }

    @Override
    @Generated
    public String getOrganizationQualifiedName() {
        return this.organizationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISalesforceReport> getReports() {
        return this.reports;
    }

    @Override
    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceOrganization)) {
            return false;
        }
        SalesforceOrganization other = (SalesforceOrganization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$apiName = this.getApiName();
        String other$apiName = other.getApiName();
        if (this$apiName == null ? other$apiName != null : !this$apiName.equals(other$apiName)) {
            return false;
        }
        SortedSet<ISalesforceDashboard> this$dashboards = this.getDashboards();
        SortedSet<ISalesforceDashboard> other$dashboards = other.getDashboards();
        if (this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISalesforceObject> this$objects = this.getObjects();
        SortedSet<ISalesforceObject> other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !this$objects.equals(other$objects)) {
            return false;
        }
        String this$organizationQualifiedName = this.getOrganizationQualifiedName();
        String other$organizationQualifiedName = other.getOrganizationQualifiedName();
        if (this$organizationQualifiedName == null ? other$organizationQualifiedName != null : !this$organizationQualifiedName.equals(other$organizationQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISalesforceReport> this$reports = this.getReports();
        SortedSet<ISalesforceReport> other$reports = other.getReports();
        if (this$reports == null ? other$reports != null : !this$reports.equals(other$reports)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        return !(this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceOrganization;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $apiName = this.getApiName();
        result = result * 59 + ($apiName == null ? 43 : $apiName.hashCode());
        SortedSet<ISalesforceDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISalesforceObject> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : $objects.hashCode());
        String $organizationQualifiedName = this.getOrganizationQualifiedName();
        result = result * 59 + ($organizationQualifiedName == null ? 43 : $organizationQualifiedName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISalesforceReport> $reports = this.getReports();
        result = result * 59 + ($reports == null ? 43 : $reports.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SalesforceOrganization(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiName=" + this.getApiName() + ", dashboards=" + this.getDashboards() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", objects=" + this.getObjects() + ", organizationQualifiedName=" + this.getOrganizationQualifiedName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", reports=" + this.getReports() + ", sourceId=" + this.getSourceId() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class SalesforceOrganizationBuilderImpl
    extends SalesforceOrganizationBuilder<SalesforceOrganization, SalesforceOrganizationBuilderImpl> {
        @Generated
        private SalesforceOrganizationBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceOrganizationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceOrganization build() {
            return new SalesforceOrganization(this);
        }
    }

    @Generated
    public static abstract class SalesforceOrganizationBuilder<C extends SalesforceOrganization, B extends SalesforceOrganizationBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String apiName;
        @Generated
        private ArrayList<ISalesforceDashboard> dashboards;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISalesforceObject> objects;
        @Generated
        private String organizationQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISalesforceReport> reports;
        @Generated
        private String sourceId;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceOrganizationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceOrganization instance, SalesforceOrganizationBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiName(instance.apiName);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.objects(instance.objects == null ? Collections.emptySortedSet() : instance.objects);
            b.organizationQualifiedName(instance.organizationQualifiedName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.reports(instance.reports == null ? Collections.emptySortedSet() : instance.reports);
            b.sourceId(instance.sourceId);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiName(String apiName) {
            this.apiName = apiName;
            return (B)this.self();
        }

        @Generated
        public B dashboard(ISalesforceDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends ISalesforceDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B object(ISalesforceObject object) {
            if (this.objects == null) {
                this.objects = new ArrayList();
            }
            this.objects.add(object);
            return (B)this.self();
        }

        @Generated
        public B objects(Collection<? extends ISalesforceObject> objects) {
            if (objects == null) {
                throw new NullPointerException("objects cannot be null");
            }
            if (this.objects == null) {
                this.objects = new ArrayList();
            }
            this.objects.addAll(objects);
            return (B)this.self();
        }

        @Generated
        public B clearObjects() {
            if (this.objects != null) {
                this.objects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B organizationQualifiedName(String organizationQualifiedName) {
            this.organizationQualifiedName = organizationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B report(ISalesforceReport report) {
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.add(report);
            return (B)this.self();
        }

        @Generated
        public B reports(Collection<? extends ISalesforceReport> reports) {
            if (reports == null) {
                throw new NullPointerException("reports cannot be null");
            }
            if (this.reports == null) {
                this.reports = new ArrayList();
            }
            this.reports.addAll(reports);
            return (B)this.self();
        }

        @Generated
        public B clearReports() {
            if (this.reports != null) {
                this.reports.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceId(String sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SalesforceOrganization.SalesforceOrganizationBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiName=" + this.apiName + ", dashboards=" + this.dashboards + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", objects=" + this.objects + ", organizationQualifiedName=" + this.organizationQualifiedName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", reports=" + this.reports + ", sourceId=" + this.sourceId + ")";
        }
    }
}

