/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISchemaRegistry;
import com.atlan.model.assets.ISchemaRegistrySubject;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.SchemaRegistrySchemaCompatibility;
import com.atlan.model.enums.SchemaRegistrySchemaType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistrySubject
extends Asset
implements ISchemaRegistrySubject,
ISchemaRegistry,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistrySubject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SchemaRegistrySubject";
    String typeName;
    @Attribute
    SortedSet<IAsset> assets;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    String schemaRegistrySchemaId;
    @Attribute
    SchemaRegistrySchemaType schemaRegistrySchemaType;
    @Attribute
    String schemaRegistrySubjectBaseName;
    @Attribute
    SortedSet<String> schemaRegistrySubjectGoverningAssetQualifiedNames;
    @Attribute
    Boolean schemaRegistrySubjectIsKeySchema;
    @Attribute
    String schemaRegistrySubjectLatestSchemaDefinition;
    @Attribute
    String schemaRegistrySubjectLatestSchemaVersion;
    @Attribute
    SchemaRegistrySchemaCompatibility schemaRegistrySubjectSchemaCompatibility;

    @Override
    public SchemaRegistrySubject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SchemaRegistrySubject.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SchemaRegistrySubject.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SchemaRegistrySubject.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SchemaRegistrySubject.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SchemaRegistrySubject.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SchemaRegistrySubject.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return SchemaRegistrySubject.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return SchemaRegistrySubject.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return SchemaRegistrySubject.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static SchemaRegistrySubject refByGuid(String guid) {
        return ((SchemaRegistrySubjectBuilder)SchemaRegistrySubject._internal().guid(guid)).build();
    }

    public static SchemaRegistrySubject refByQualifiedName(String qualifiedName) {
        return ((SchemaRegistrySubjectBuilder)SchemaRegistrySubject._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static SchemaRegistrySubject get(String id) throws AtlanException {
        return SchemaRegistrySubject.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SchemaRegistrySubject get(AtlanClient client, String id) throws AtlanException {
        return SchemaRegistrySubject.get(client, id, true);
    }

    @JsonIgnore
    public static SchemaRegistrySubject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SchemaRegistrySubject) {
                return (SchemaRegistrySubject)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SchemaRegistrySubject) {
            return (SchemaRegistrySubject)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static SchemaRegistrySubject retrieveByGuid(String guid) throws AtlanException {
        return SchemaRegistrySubject.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static SchemaRegistrySubject retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return SchemaRegistrySubject.get(client, guid);
    }

    @Deprecated
    public static SchemaRegistrySubject retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return SchemaRegistrySubject.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static SchemaRegistrySubject retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return SchemaRegistrySubject.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SchemaRegistrySubject.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SchemaRegistrySubjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SchemaRegistrySubjectBuilder)((SchemaRegistrySubjectBuilder)((SchemaRegistrySubjectBuilder)SchemaRegistrySubject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SchemaRegistrySubjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return SchemaRegistrySubject.updater(this.getQualifiedName(), this.getName());
    }

    public static SchemaRegistrySubject removeDescription(String qualifiedName, String name) throws AtlanException {
        return SchemaRegistrySubject.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SchemaRegistrySubject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject)Asset.removeDescription(client, SchemaRegistrySubject.updater(qualifiedName, name));
    }

    public static SchemaRegistrySubject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SchemaRegistrySubject.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SchemaRegistrySubject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject)Asset.removeUserDescription(client, SchemaRegistrySubject.updater(qualifiedName, name));
    }

    public static SchemaRegistrySubject removeOwners(String qualifiedName, String name) throws AtlanException {
        return SchemaRegistrySubject.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SchemaRegistrySubject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject)Asset.removeOwners(client, SchemaRegistrySubject.updater(qualifiedName, name));
    }

    public static SchemaRegistrySubject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SchemaRegistrySubject.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SchemaRegistrySubject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SchemaRegistrySubject)Asset.updateCertificate(client, SchemaRegistrySubject._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SchemaRegistrySubject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SchemaRegistrySubject.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SchemaRegistrySubject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject)Asset.removeCertificate(client, SchemaRegistrySubject.updater(qualifiedName, name));
    }

    public static SchemaRegistrySubject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SchemaRegistrySubject.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SchemaRegistrySubject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SchemaRegistrySubject)Asset.updateAnnouncement(client, SchemaRegistrySubject._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SchemaRegistrySubject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SchemaRegistrySubject.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SchemaRegistrySubject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject)Asset.removeAnnouncement(client, SchemaRegistrySubject.updater(qualifiedName, name));
    }

    public static SchemaRegistrySubject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SchemaRegistrySubject.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SchemaRegistrySubject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SchemaRegistrySubject)Asset.replaceTerms(client, SchemaRegistrySubject.updater(qualifiedName, name), terms);
    }

    public static SchemaRegistrySubject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SchemaRegistrySubject.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SchemaRegistrySubject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SchemaRegistrySubject)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SchemaRegistrySubject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SchemaRegistrySubject.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SchemaRegistrySubject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SchemaRegistrySubject)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SchemaRegistrySubject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SchemaRegistrySubject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SchemaRegistrySubject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SchemaRegistrySubject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SchemaRegistrySubject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SchemaRegistrySubject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SchemaRegistrySubject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SchemaRegistrySubject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        SchemaRegistrySubject.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        SchemaRegistrySubject.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SchemaRegistrySubject.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SchemaRegistrySubject(SchemaRegistrySubjectBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SchemaRegistrySubject.$default$typeName();
        SortedSet<IAsset> assets = new TreeSet<IAsset>();
        if (b.assets != null) {
            assets.addAll(b.assets);
        }
        assets = Collections.unmodifiableSortedSet(assets);
        this.assets = assets;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.schemaRegistrySchemaId = b.schemaRegistrySchemaId;
        this.schemaRegistrySchemaType = b.schemaRegistrySchemaType;
        this.schemaRegistrySubjectBaseName = b.schemaRegistrySubjectBaseName;
        SortedSet<String> schemaRegistrySubjectGoverningAssetQualifiedNames = new TreeSet<String>();
        if (b.schemaRegistrySubjectGoverningAssetQualifiedNames != null) {
            schemaRegistrySubjectGoverningAssetQualifiedNames.addAll(b.schemaRegistrySubjectGoverningAssetQualifiedNames);
        }
        schemaRegistrySubjectGoverningAssetQualifiedNames = Collections.unmodifiableSortedSet(schemaRegistrySubjectGoverningAssetQualifiedNames);
        this.schemaRegistrySubjectGoverningAssetQualifiedNames = schemaRegistrySubjectGoverningAssetQualifiedNames;
        this.schemaRegistrySubjectIsKeySchema = b.schemaRegistrySubjectIsKeySchema;
        this.schemaRegistrySubjectLatestSchemaDefinition = b.schemaRegistrySubjectLatestSchemaDefinition;
        this.schemaRegistrySubjectLatestSchemaVersion = b.schemaRegistrySubjectLatestSchemaVersion;
        this.schemaRegistrySubjectSchemaCompatibility = b.schemaRegistrySubjectSchemaCompatibility;
    }

    @Generated
    public static SchemaRegistrySubjectBuilder<?, ?> _internal() {
        return new SchemaRegistrySubjectBuilderImpl();
    }

    @Generated
    public SchemaRegistrySubjectBuilder<?, ?> toBuilder() {
        return new SchemaRegistrySubjectBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAsset> getAssets() {
        return this.assets;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public String getSchemaRegistrySchemaId() {
        return this.schemaRegistrySchemaId;
    }

    @Override
    @Generated
    public SchemaRegistrySchemaType getSchemaRegistrySchemaType() {
        return this.schemaRegistrySchemaType;
    }

    @Override
    @Generated
    public String getSchemaRegistrySubjectBaseName() {
        return this.schemaRegistrySubjectBaseName;
    }

    @Override
    @Generated
    public SortedSet<String> getSchemaRegistrySubjectGoverningAssetQualifiedNames() {
        return this.schemaRegistrySubjectGoverningAssetQualifiedNames;
    }

    @Override
    @Generated
    public Boolean getSchemaRegistrySubjectIsKeySchema() {
        return this.schemaRegistrySubjectIsKeySchema;
    }

    @Override
    @Generated
    public String getSchemaRegistrySubjectLatestSchemaDefinition() {
        return this.schemaRegistrySubjectLatestSchemaDefinition;
    }

    @Override
    @Generated
    public String getSchemaRegistrySubjectLatestSchemaVersion() {
        return this.schemaRegistrySubjectLatestSchemaVersion;
    }

    @Override
    @Generated
    public SchemaRegistrySchemaCompatibility getSchemaRegistrySubjectSchemaCompatibility() {
        return this.schemaRegistrySubjectSchemaCompatibility;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaRegistrySubject)) {
            return false;
        }
        SchemaRegistrySubject other = (SchemaRegistrySubject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$schemaRegistrySubjectIsKeySchema = this.getSchemaRegistrySubjectIsKeySchema();
        Boolean other$schemaRegistrySubjectIsKeySchema = other.getSchemaRegistrySubjectIsKeySchema();
        if (this$schemaRegistrySubjectIsKeySchema == null ? other$schemaRegistrySubjectIsKeySchema != null : !((Object)this$schemaRegistrySubjectIsKeySchema).equals(other$schemaRegistrySubjectIsKeySchema)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAsset> this$assets = this.getAssets();
        SortedSet<IAsset> other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !this$assets.equals(other$assets)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        String this$schemaRegistrySchemaId = this.getSchemaRegistrySchemaId();
        String other$schemaRegistrySchemaId = other.getSchemaRegistrySchemaId();
        if (this$schemaRegistrySchemaId == null ? other$schemaRegistrySchemaId != null : !this$schemaRegistrySchemaId.equals(other$schemaRegistrySchemaId)) {
            return false;
        }
        SchemaRegistrySchemaType this$schemaRegistrySchemaType = this.getSchemaRegistrySchemaType();
        SchemaRegistrySchemaType other$schemaRegistrySchemaType = other.getSchemaRegistrySchemaType();
        if (this$schemaRegistrySchemaType == null ? other$schemaRegistrySchemaType != null : !this$schemaRegistrySchemaType.equals(other$schemaRegistrySchemaType)) {
            return false;
        }
        String this$schemaRegistrySubjectBaseName = this.getSchemaRegistrySubjectBaseName();
        String other$schemaRegistrySubjectBaseName = other.getSchemaRegistrySubjectBaseName();
        if (this$schemaRegistrySubjectBaseName == null ? other$schemaRegistrySubjectBaseName != null : !this$schemaRegistrySubjectBaseName.equals(other$schemaRegistrySubjectBaseName)) {
            return false;
        }
        SortedSet<String> this$schemaRegistrySubjectGoverningAssetQualifiedNames = this.getSchemaRegistrySubjectGoverningAssetQualifiedNames();
        SortedSet<String> other$schemaRegistrySubjectGoverningAssetQualifiedNames = other.getSchemaRegistrySubjectGoverningAssetQualifiedNames();
        if (this$schemaRegistrySubjectGoverningAssetQualifiedNames == null ? other$schemaRegistrySubjectGoverningAssetQualifiedNames != null : !this$schemaRegistrySubjectGoverningAssetQualifiedNames.equals(other$schemaRegistrySubjectGoverningAssetQualifiedNames)) {
            return false;
        }
        String this$schemaRegistrySubjectLatestSchemaDefinition = this.getSchemaRegistrySubjectLatestSchemaDefinition();
        String other$schemaRegistrySubjectLatestSchemaDefinition = other.getSchemaRegistrySubjectLatestSchemaDefinition();
        if (this$schemaRegistrySubjectLatestSchemaDefinition == null ? other$schemaRegistrySubjectLatestSchemaDefinition != null : !this$schemaRegistrySubjectLatestSchemaDefinition.equals(other$schemaRegistrySubjectLatestSchemaDefinition)) {
            return false;
        }
        String this$schemaRegistrySubjectLatestSchemaVersion = this.getSchemaRegistrySubjectLatestSchemaVersion();
        String other$schemaRegistrySubjectLatestSchemaVersion = other.getSchemaRegistrySubjectLatestSchemaVersion();
        if (this$schemaRegistrySubjectLatestSchemaVersion == null ? other$schemaRegistrySubjectLatestSchemaVersion != null : !this$schemaRegistrySubjectLatestSchemaVersion.equals(other$schemaRegistrySubjectLatestSchemaVersion)) {
            return false;
        }
        SchemaRegistrySchemaCompatibility this$schemaRegistrySubjectSchemaCompatibility = this.getSchemaRegistrySubjectSchemaCompatibility();
        SchemaRegistrySchemaCompatibility other$schemaRegistrySubjectSchemaCompatibility = other.getSchemaRegistrySubjectSchemaCompatibility();
        return !(this$schemaRegistrySubjectSchemaCompatibility == null ? other$schemaRegistrySubjectSchemaCompatibility != null : !this$schemaRegistrySubjectSchemaCompatibility.equals(other$schemaRegistrySubjectSchemaCompatibility));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchemaRegistrySubject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $schemaRegistrySubjectIsKeySchema = this.getSchemaRegistrySubjectIsKeySchema();
        result = result * 59 + ($schemaRegistrySubjectIsKeySchema == null ? 43 : ((Object)$schemaRegistrySubjectIsKeySchema).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAsset> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : $assets.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        String $schemaRegistrySchemaId = this.getSchemaRegistrySchemaId();
        result = result * 59 + ($schemaRegistrySchemaId == null ? 43 : $schemaRegistrySchemaId.hashCode());
        SchemaRegistrySchemaType $schemaRegistrySchemaType = this.getSchemaRegistrySchemaType();
        result = result * 59 + ($schemaRegistrySchemaType == null ? 43 : $schemaRegistrySchemaType.hashCode());
        String $schemaRegistrySubjectBaseName = this.getSchemaRegistrySubjectBaseName();
        result = result * 59 + ($schemaRegistrySubjectBaseName == null ? 43 : $schemaRegistrySubjectBaseName.hashCode());
        SortedSet<String> $schemaRegistrySubjectGoverningAssetQualifiedNames = this.getSchemaRegistrySubjectGoverningAssetQualifiedNames();
        result = result * 59 + ($schemaRegistrySubjectGoverningAssetQualifiedNames == null ? 43 : $schemaRegistrySubjectGoverningAssetQualifiedNames.hashCode());
        String $schemaRegistrySubjectLatestSchemaDefinition = this.getSchemaRegistrySubjectLatestSchemaDefinition();
        result = result * 59 + ($schemaRegistrySubjectLatestSchemaDefinition == null ? 43 : $schemaRegistrySubjectLatestSchemaDefinition.hashCode());
        String $schemaRegistrySubjectLatestSchemaVersion = this.getSchemaRegistrySubjectLatestSchemaVersion();
        result = result * 59 + ($schemaRegistrySubjectLatestSchemaVersion == null ? 43 : $schemaRegistrySubjectLatestSchemaVersion.hashCode());
        SchemaRegistrySchemaCompatibility $schemaRegistrySubjectSchemaCompatibility = this.getSchemaRegistrySubjectSchemaCompatibility();
        result = result * 59 + ($schemaRegistrySubjectSchemaCompatibility == null ? 43 : $schemaRegistrySubjectSchemaCompatibility.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SchemaRegistrySubject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", assets=" + this.getAssets() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", schemaRegistrySchemaId=" + this.getSchemaRegistrySchemaId() + ", schemaRegistrySchemaType=" + this.getSchemaRegistrySchemaType() + ", schemaRegistrySubjectBaseName=" + this.getSchemaRegistrySubjectBaseName() + ", schemaRegistrySubjectGoverningAssetQualifiedNames=" + this.getSchemaRegistrySubjectGoverningAssetQualifiedNames() + ", schemaRegistrySubjectIsKeySchema=" + this.getSchemaRegistrySubjectIsKeySchema() + ", schemaRegistrySubjectLatestSchemaDefinition=" + this.getSchemaRegistrySubjectLatestSchemaDefinition() + ", schemaRegistrySubjectLatestSchemaVersion=" + this.getSchemaRegistrySubjectLatestSchemaVersion() + ", schemaRegistrySubjectSchemaCompatibility=" + this.getSchemaRegistrySubjectSchemaCompatibility() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class SchemaRegistrySubjectBuilderImpl
    extends SchemaRegistrySubjectBuilder<SchemaRegistrySubject, SchemaRegistrySubjectBuilderImpl> {
        @Generated
        private SchemaRegistrySubjectBuilderImpl() {
        }

        @Override
        @Generated
        protected SchemaRegistrySubjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SchemaRegistrySubject build() {
            return new SchemaRegistrySubject(this);
        }
    }

    @Generated
    public static abstract class SchemaRegistrySubjectBuilder<C extends SchemaRegistrySubject, B extends SchemaRegistrySubjectBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAsset> assets;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private String schemaRegistrySchemaId;
        @Generated
        private SchemaRegistrySchemaType schemaRegistrySchemaType;
        @Generated
        private String schemaRegistrySubjectBaseName;
        @Generated
        private ArrayList<String> schemaRegistrySubjectGoverningAssetQualifiedNames;
        @Generated
        private Boolean schemaRegistrySubjectIsKeySchema;
        @Generated
        private String schemaRegistrySubjectLatestSchemaDefinition;
        @Generated
        private String schemaRegistrySubjectLatestSchemaVersion;
        @Generated
        private SchemaRegistrySchemaCompatibility schemaRegistrySubjectSchemaCompatibility;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SchemaRegistrySubjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SchemaRegistrySubject instance, SchemaRegistrySubjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.assets(instance.assets == null ? Collections.emptySortedSet() : instance.assets);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.schemaRegistrySchemaId(instance.schemaRegistrySchemaId);
            b.schemaRegistrySchemaType(instance.schemaRegistrySchemaType);
            b.schemaRegistrySubjectBaseName(instance.schemaRegistrySubjectBaseName);
            b.schemaRegistrySubjectGoverningAssetQualifiedNames(instance.schemaRegistrySubjectGoverningAssetQualifiedNames == null ? Collections.emptySortedSet() : instance.schemaRegistrySubjectGoverningAssetQualifiedNames);
            b.schemaRegistrySubjectIsKeySchema(instance.schemaRegistrySubjectIsKeySchema);
            b.schemaRegistrySubjectLatestSchemaDefinition(instance.schemaRegistrySubjectLatestSchemaDefinition);
            b.schemaRegistrySubjectLatestSchemaVersion(instance.schemaRegistrySubjectLatestSchemaVersion);
            b.schemaRegistrySubjectSchemaCompatibility(instance.schemaRegistrySubjectSchemaCompatibility);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B asset(IAsset asset) {
            if (this.assets == null) {
                this.assets = new ArrayList();
            }
            this.assets.add(asset);
            return (B)this.self();
        }

        @Generated
        public B assets(Collection<? extends IAsset> assets) {
            if (assets == null) {
                throw new NullPointerException("assets cannot be null");
            }
            if (this.assets == null) {
                this.assets = new ArrayList();
            }
            this.assets.addAll(assets);
            return (B)this.self();
        }

        @Generated
        public B clearAssets() {
            if (this.assets != null) {
                this.assets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySchemaId(String schemaRegistrySchemaId) {
            this.schemaRegistrySchemaId = schemaRegistrySchemaId;
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySchemaType(SchemaRegistrySchemaType schemaRegistrySchemaType) {
            this.schemaRegistrySchemaType = schemaRegistrySchemaType;
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubjectBaseName(String schemaRegistrySubjectBaseName) {
            this.schemaRegistrySubjectBaseName = schemaRegistrySubjectBaseName;
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubjectGoverningAssetQualifiedName(String schemaRegistrySubjectGoverningAssetQualifiedName) {
            if (this.schemaRegistrySubjectGoverningAssetQualifiedNames == null) {
                this.schemaRegistrySubjectGoverningAssetQualifiedNames = new ArrayList();
            }
            this.schemaRegistrySubjectGoverningAssetQualifiedNames.add(schemaRegistrySubjectGoverningAssetQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubjectGoverningAssetQualifiedNames(Collection<? extends String> schemaRegistrySubjectGoverningAssetQualifiedNames) {
            if (schemaRegistrySubjectGoverningAssetQualifiedNames == null) {
                throw new NullPointerException("schemaRegistrySubjectGoverningAssetQualifiedNames cannot be null");
            }
            if (this.schemaRegistrySubjectGoverningAssetQualifiedNames == null) {
                this.schemaRegistrySubjectGoverningAssetQualifiedNames = new ArrayList();
            }
            this.schemaRegistrySubjectGoverningAssetQualifiedNames.addAll(schemaRegistrySubjectGoverningAssetQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearSchemaRegistrySubjectGoverningAssetQualifiedNames() {
            if (this.schemaRegistrySubjectGoverningAssetQualifiedNames != null) {
                this.schemaRegistrySubjectGoverningAssetQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubjectIsKeySchema(Boolean schemaRegistrySubjectIsKeySchema) {
            this.schemaRegistrySubjectIsKeySchema = schemaRegistrySubjectIsKeySchema;
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubjectLatestSchemaDefinition(String schemaRegistrySubjectLatestSchemaDefinition) {
            this.schemaRegistrySubjectLatestSchemaDefinition = schemaRegistrySubjectLatestSchemaDefinition;
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubjectLatestSchemaVersion(String schemaRegistrySubjectLatestSchemaVersion) {
            this.schemaRegistrySubjectLatestSchemaVersion = schemaRegistrySubjectLatestSchemaVersion;
            return (B)this.self();
        }

        @Generated
        public B schemaRegistrySubjectSchemaCompatibility(SchemaRegistrySchemaCompatibility schemaRegistrySubjectSchemaCompatibility) {
            this.schemaRegistrySubjectSchemaCompatibility = schemaRegistrySubjectSchemaCompatibility;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SchemaRegistrySubject.SchemaRegistrySubjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", assets=" + this.assets + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", schemaRegistrySchemaId=" + this.schemaRegistrySchemaId + ", schemaRegistrySchemaType=" + this.schemaRegistrySchemaType + ", schemaRegistrySubjectBaseName=" + this.schemaRegistrySubjectBaseName + ", schemaRegistrySubjectGoverningAssetQualifiedNames=" + this.schemaRegistrySubjectGoverningAssetQualifiedNames + ", schemaRegistrySubjectIsKeySchema=" + this.schemaRegistrySubjectIsKeySchema + ", schemaRegistrySubjectLatestSchemaDefinition=" + this.schemaRegistrySubjectLatestSchemaDefinition + ", schemaRegistrySubjectLatestSchemaVersion=" + this.schemaRegistrySubjectLatestSchemaVersion + ", schemaRegistrySubjectSchemaCompatibility=" + this.schemaRegistrySubjectSchemaCompatibility + ")";
        }
    }
}

