/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISigma;
import com.atlan.model.assets.ISigmaDataElement;
import com.atlan.model.assets.ISigmaPage;
import com.atlan.model.assets.ISigmaWorkbook;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigmaPage
extends Asset
implements ISigmaPage,
ISigma,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigmaPage.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SigmaPage";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    Long sigmaDataElementCount;
    @Attribute
    String sigmaDataElementName;
    @Attribute
    String sigmaDataElementQualifiedName;
    @Attribute
    SortedSet<ISigmaDataElement> sigmaDataElements;
    @Attribute
    String sigmaPageName;
    @Attribute
    String sigmaPageQualifiedName;
    @Attribute
    ISigmaWorkbook sigmaWorkbook;
    @Attribute
    String sigmaWorkbookName;
    @Attribute
    String sigmaWorkbookQualifiedName;

    @Override
    public SigmaPage trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SigmaPage.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SigmaPage.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SigmaPage.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SigmaPage.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SigmaPage.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SigmaPage.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return SigmaPage.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return SigmaPage.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return SigmaPage.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static SigmaPage refByGuid(String guid) {
        return ((SigmaPageBuilder)SigmaPage._internal().guid(guid)).build();
    }

    public static SigmaPage refByQualifiedName(String qualifiedName) {
        return ((SigmaPageBuilder)SigmaPage._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static SigmaPage get(String id) throws AtlanException {
        return SigmaPage.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SigmaPage get(AtlanClient client, String id) throws AtlanException {
        return SigmaPage.get(client, id, true);
    }

    @JsonIgnore
    public static SigmaPage get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SigmaPage) {
                return (SigmaPage)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SigmaPage) {
            return (SigmaPage)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static SigmaPage retrieveByGuid(String guid) throws AtlanException {
        return SigmaPage.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static SigmaPage retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return SigmaPage.get(client, guid);
    }

    @Deprecated
    public static SigmaPage retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return SigmaPage.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static SigmaPage retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return SigmaPage.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SigmaPage.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SigmaPageBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SigmaPageBuilder)((SigmaPageBuilder)((SigmaPageBuilder)SigmaPage._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SigmaPageBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return SigmaPage.updater(this.getQualifiedName(), this.getName());
    }

    public static SigmaPage removeDescription(String qualifiedName, String name) throws AtlanException {
        return SigmaPage.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaPage removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage)Asset.removeDescription(client, SigmaPage.updater(qualifiedName, name));
    }

    public static SigmaPage removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SigmaPage.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaPage removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage)Asset.removeUserDescription(client, SigmaPage.updater(qualifiedName, name));
    }

    public static SigmaPage removeOwners(String qualifiedName, String name) throws AtlanException {
        return SigmaPage.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaPage removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage)Asset.removeOwners(client, SigmaPage.updater(qualifiedName, name));
    }

    public static SigmaPage updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SigmaPage.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SigmaPage updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SigmaPage)Asset.updateCertificate(client, SigmaPage._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SigmaPage removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SigmaPage.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaPage removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage)Asset.removeCertificate(client, SigmaPage.updater(qualifiedName, name));
    }

    public static SigmaPage updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SigmaPage.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SigmaPage updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SigmaPage)Asset.updateAnnouncement(client, SigmaPage._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SigmaPage removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SigmaPage.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaPage removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage)Asset.removeAnnouncement(client, SigmaPage.updater(qualifiedName, name));
    }

    public static SigmaPage replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaPage.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SigmaPage replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaPage)Asset.replaceTerms(client, SigmaPage.updater(qualifiedName, name), terms);
    }

    public static SigmaPage appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaPage.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SigmaPage appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaPage)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SigmaPage removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaPage.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SigmaPage removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaPage)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SigmaPage appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SigmaPage.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SigmaPage appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SigmaPage)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SigmaPage appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SigmaPage.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SigmaPage appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SigmaPage)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        SigmaPage.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        SigmaPage.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SigmaPage.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SigmaPage(SigmaPageBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SigmaPage.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.sigmaDataElementCount = b.sigmaDataElementCount;
        this.sigmaDataElementName = b.sigmaDataElementName;
        this.sigmaDataElementQualifiedName = b.sigmaDataElementQualifiedName;
        SortedSet<ISigmaDataElement> sigmaDataElements = new TreeSet<ISigmaDataElement>();
        if (b.sigmaDataElements != null) {
            sigmaDataElements.addAll(b.sigmaDataElements);
        }
        sigmaDataElements = Collections.unmodifiableSortedSet(sigmaDataElements);
        this.sigmaDataElements = sigmaDataElements;
        this.sigmaPageName = b.sigmaPageName;
        this.sigmaPageQualifiedName = b.sigmaPageQualifiedName;
        this.sigmaWorkbook = b.sigmaWorkbook;
        this.sigmaWorkbookName = b.sigmaWorkbookName;
        this.sigmaWorkbookQualifiedName = b.sigmaWorkbookQualifiedName;
    }

    @Generated
    public static SigmaPageBuilder<?, ?> _internal() {
        return new SigmaPageBuilderImpl();
    }

    @Generated
    public SigmaPageBuilder<?, ?> toBuilder() {
        return new SigmaPageBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public Long getSigmaDataElementCount() {
        return this.sigmaDataElementCount;
    }

    @Override
    @Generated
    public String getSigmaDataElementName() {
        return this.sigmaDataElementName;
    }

    @Override
    @Generated
    public String getSigmaDataElementQualifiedName() {
        return this.sigmaDataElementQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ISigmaDataElement> getSigmaDataElements() {
        return this.sigmaDataElements;
    }

    @Override
    @Generated
    public String getSigmaPageName() {
        return this.sigmaPageName;
    }

    @Override
    @Generated
    public String getSigmaPageQualifiedName() {
        return this.sigmaPageQualifiedName;
    }

    @Override
    @Generated
    public ISigmaWorkbook getSigmaWorkbook() {
        return this.sigmaWorkbook;
    }

    @Override
    @Generated
    public String getSigmaWorkbookName() {
        return this.sigmaWorkbookName;
    }

    @Override
    @Generated
    public String getSigmaWorkbookQualifiedName() {
        return this.sigmaWorkbookQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigmaPage)) {
            return false;
        }
        SigmaPage other = (SigmaPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sigmaDataElementCount = this.getSigmaDataElementCount();
        Long other$sigmaDataElementCount = other.getSigmaDataElementCount();
        if (this$sigmaDataElementCount == null ? other$sigmaDataElementCount != null : !((Object)this$sigmaDataElementCount).equals(other$sigmaDataElementCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        String this$sigmaDataElementName = this.getSigmaDataElementName();
        String other$sigmaDataElementName = other.getSigmaDataElementName();
        if (this$sigmaDataElementName == null ? other$sigmaDataElementName != null : !this$sigmaDataElementName.equals(other$sigmaDataElementName)) {
            return false;
        }
        String this$sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        String other$sigmaDataElementQualifiedName = other.getSigmaDataElementQualifiedName();
        if (this$sigmaDataElementQualifiedName == null ? other$sigmaDataElementQualifiedName != null : !this$sigmaDataElementQualifiedName.equals(other$sigmaDataElementQualifiedName)) {
            return false;
        }
        SortedSet<ISigmaDataElement> this$sigmaDataElements = this.getSigmaDataElements();
        SortedSet<ISigmaDataElement> other$sigmaDataElements = other.getSigmaDataElements();
        if (this$sigmaDataElements == null ? other$sigmaDataElements != null : !this$sigmaDataElements.equals(other$sigmaDataElements)) {
            return false;
        }
        String this$sigmaPageName = this.getSigmaPageName();
        String other$sigmaPageName = other.getSigmaPageName();
        if (this$sigmaPageName == null ? other$sigmaPageName != null : !this$sigmaPageName.equals(other$sigmaPageName)) {
            return false;
        }
        String this$sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        String other$sigmaPageQualifiedName = other.getSigmaPageQualifiedName();
        if (this$sigmaPageQualifiedName == null ? other$sigmaPageQualifiedName != null : !this$sigmaPageQualifiedName.equals(other$sigmaPageQualifiedName)) {
            return false;
        }
        ISigmaWorkbook this$sigmaWorkbook = this.getSigmaWorkbook();
        ISigmaWorkbook other$sigmaWorkbook = other.getSigmaWorkbook();
        if (this$sigmaWorkbook == null ? other$sigmaWorkbook != null : !this$sigmaWorkbook.equals(other$sigmaWorkbook)) {
            return false;
        }
        String this$sigmaWorkbookName = this.getSigmaWorkbookName();
        String other$sigmaWorkbookName = other.getSigmaWorkbookName();
        if (this$sigmaWorkbookName == null ? other$sigmaWorkbookName != null : !this$sigmaWorkbookName.equals(other$sigmaWorkbookName)) {
            return false;
        }
        String this$sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        String other$sigmaWorkbookQualifiedName = other.getSigmaWorkbookQualifiedName();
        return !(this$sigmaWorkbookQualifiedName == null ? other$sigmaWorkbookQualifiedName != null : !this$sigmaWorkbookQualifiedName.equals(other$sigmaWorkbookQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SigmaPage;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sigmaDataElementCount = this.getSigmaDataElementCount();
        result = result * 59 + ($sigmaDataElementCount == null ? 43 : ((Object)$sigmaDataElementCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        String $sigmaDataElementName = this.getSigmaDataElementName();
        result = result * 59 + ($sigmaDataElementName == null ? 43 : $sigmaDataElementName.hashCode());
        String $sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        result = result * 59 + ($sigmaDataElementQualifiedName == null ? 43 : $sigmaDataElementQualifiedName.hashCode());
        SortedSet<ISigmaDataElement> $sigmaDataElements = this.getSigmaDataElements();
        result = result * 59 + ($sigmaDataElements == null ? 43 : $sigmaDataElements.hashCode());
        String $sigmaPageName = this.getSigmaPageName();
        result = result * 59 + ($sigmaPageName == null ? 43 : $sigmaPageName.hashCode());
        String $sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        result = result * 59 + ($sigmaPageQualifiedName == null ? 43 : $sigmaPageQualifiedName.hashCode());
        ISigmaWorkbook $sigmaWorkbook = this.getSigmaWorkbook();
        result = result * 59 + ($sigmaWorkbook == null ? 43 : $sigmaWorkbook.hashCode());
        String $sigmaWorkbookName = this.getSigmaWorkbookName();
        result = result * 59 + ($sigmaWorkbookName == null ? 43 : $sigmaWorkbookName.hashCode());
        String $sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        result = result * 59 + ($sigmaWorkbookQualifiedName == null ? 43 : $sigmaWorkbookQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SigmaPage(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", sigmaDataElementCount=" + this.getSigmaDataElementCount() + ", sigmaDataElementName=" + this.getSigmaDataElementName() + ", sigmaDataElementQualifiedName=" + this.getSigmaDataElementQualifiedName() + ", sigmaDataElements=" + this.getSigmaDataElements() + ", sigmaPageName=" + this.getSigmaPageName() + ", sigmaPageQualifiedName=" + this.getSigmaPageQualifiedName() + ", sigmaWorkbook=" + this.getSigmaWorkbook() + ", sigmaWorkbookName=" + this.getSigmaWorkbookName() + ", sigmaWorkbookQualifiedName=" + this.getSigmaWorkbookQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class SigmaPageBuilderImpl
    extends SigmaPageBuilder<SigmaPage, SigmaPageBuilderImpl> {
        @Generated
        private SigmaPageBuilderImpl() {
        }

        @Override
        @Generated
        protected SigmaPageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SigmaPage build() {
            return new SigmaPage(this);
        }
    }

    @Generated
    public static abstract class SigmaPageBuilder<C extends SigmaPage, B extends SigmaPageBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private Long sigmaDataElementCount;
        @Generated
        private String sigmaDataElementName;
        @Generated
        private String sigmaDataElementQualifiedName;
        @Generated
        private ArrayList<ISigmaDataElement> sigmaDataElements;
        @Generated
        private String sigmaPageName;
        @Generated
        private String sigmaPageQualifiedName;
        @Generated
        private ISigmaWorkbook sigmaWorkbook;
        @Generated
        private String sigmaWorkbookName;
        @Generated
        private String sigmaWorkbookQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SigmaPageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SigmaPage instance, SigmaPageBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.sigmaDataElementCount(instance.sigmaDataElementCount);
            b.sigmaDataElementName(instance.sigmaDataElementName);
            b.sigmaDataElementQualifiedName(instance.sigmaDataElementQualifiedName);
            b.sigmaDataElements(instance.sigmaDataElements == null ? Collections.emptySortedSet() : instance.sigmaDataElements);
            b.sigmaPageName(instance.sigmaPageName);
            b.sigmaPageQualifiedName(instance.sigmaPageQualifiedName);
            b.sigmaWorkbook(instance.sigmaWorkbook);
            b.sigmaWorkbookName(instance.sigmaWorkbookName);
            b.sigmaWorkbookQualifiedName(instance.sigmaWorkbookQualifiedName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementCount(Long sigmaDataElementCount) {
            this.sigmaDataElementCount = sigmaDataElementCount;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementName(String sigmaDataElementName) {
            this.sigmaDataElementName = sigmaDataElementName;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementQualifiedName(String sigmaDataElementQualifiedName) {
            this.sigmaDataElementQualifiedName = sigmaDataElementQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElement(ISigmaDataElement sigmaDataElement) {
            if (this.sigmaDataElements == null) {
                this.sigmaDataElements = new ArrayList();
            }
            this.sigmaDataElements.add(sigmaDataElement);
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElements(Collection<? extends ISigmaDataElement> sigmaDataElements) {
            if (sigmaDataElements == null) {
                throw new NullPointerException("sigmaDataElements cannot be null");
            }
            if (this.sigmaDataElements == null) {
                this.sigmaDataElements = new ArrayList();
            }
            this.sigmaDataElements.addAll(sigmaDataElements);
            return (B)this.self();
        }

        @Generated
        public B clearSigmaDataElements() {
            if (this.sigmaDataElements != null) {
                this.sigmaDataElements.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sigmaPageName(String sigmaPageName) {
            this.sigmaPageName = sigmaPageName;
            return (B)this.self();
        }

        @Generated
        public B sigmaPageQualifiedName(String sigmaPageQualifiedName) {
            this.sigmaPageQualifiedName = sigmaPageQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbook(ISigmaWorkbook sigmaWorkbook) {
            this.sigmaWorkbook = sigmaWorkbook;
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbookName(String sigmaWorkbookName) {
            this.sigmaWorkbookName = sigmaWorkbookName;
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbookQualifiedName(String sigmaWorkbookQualifiedName) {
            this.sigmaWorkbookQualifiedName = sigmaWorkbookQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SigmaPage.SigmaPageBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", sigmaDataElementCount=" + this.sigmaDataElementCount + ", sigmaDataElementName=" + this.sigmaDataElementName + ", sigmaDataElementQualifiedName=" + this.sigmaDataElementQualifiedName + ", sigmaDataElements=" + this.sigmaDataElements + ", sigmaPageName=" + this.sigmaPageName + ", sigmaPageQualifiedName=" + this.sigmaPageQualifiedName + ", sigmaWorkbook=" + this.sigmaWorkbook + ", sigmaWorkbookName=" + this.sigmaWorkbookName + ", sigmaWorkbookQualifiedName=" + this.sigmaWorkbookQualifiedName + ")";
        }
    }
}

