/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IDataQuality;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISoda;
import com.atlan.model.assets.ISodaCheck;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodaCheck
extends Asset
implements ISodaCheck,
ISoda,
IDataQuality,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SodaCheck.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SodaCheck";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<IAsset> sodaCheckAssets;
    @Attribute
    SortedSet<IColumn> sodaCheckColumns;
    @Attribute
    String sodaCheckDefinition;
    @Attribute
    String sodaCheckEvaluationStatus;
    @Attribute
    String sodaCheckId;
    @Attribute
    Long sodaCheckIncidentCount;
    @Attribute
    Long sodaCheckLastScanAt;

    @Override
    public SodaCheck trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SodaCheck.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SodaCheck.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SodaCheck.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SodaCheck.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SodaCheck.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SodaCheck.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return SodaCheck.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return SodaCheck.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return SodaCheck.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static SodaCheck refByGuid(String guid) {
        return ((SodaCheckBuilder)SodaCheck._internal().guid(guid)).build();
    }

    public static SodaCheck refByQualifiedName(String qualifiedName) {
        return ((SodaCheckBuilder)SodaCheck._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static SodaCheck get(String id) throws AtlanException {
        return SodaCheck.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SodaCheck get(AtlanClient client, String id) throws AtlanException {
        return SodaCheck.get(client, id, true);
    }

    @JsonIgnore
    public static SodaCheck get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SodaCheck) {
                return (SodaCheck)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SodaCheck) {
            return (SodaCheck)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static SodaCheck retrieveByGuid(String guid) throws AtlanException {
        return SodaCheck.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static SodaCheck retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return SodaCheck.get(client, guid);
    }

    @Deprecated
    public static SodaCheck retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return SodaCheck.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static SodaCheck retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return SodaCheck.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SodaCheck.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SodaCheckBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SodaCheckBuilder)((SodaCheckBuilder)((SodaCheckBuilder)SodaCheck._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SodaCheckBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return SodaCheck.updater(this.getQualifiedName(), this.getName());
    }

    public static SodaCheck removeDescription(String qualifiedName, String name) throws AtlanException {
        return SodaCheck.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SodaCheck removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck)Asset.removeDescription(client, SodaCheck.updater(qualifiedName, name));
    }

    public static SodaCheck removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SodaCheck.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SodaCheck removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck)Asset.removeUserDescription(client, SodaCheck.updater(qualifiedName, name));
    }

    public static SodaCheck removeOwners(String qualifiedName, String name) throws AtlanException {
        return SodaCheck.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SodaCheck removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck)Asset.removeOwners(client, SodaCheck.updater(qualifiedName, name));
    }

    public static SodaCheck updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SodaCheck.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SodaCheck updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SodaCheck)Asset.updateCertificate(client, SodaCheck._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SodaCheck removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SodaCheck.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SodaCheck removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck)Asset.removeCertificate(client, SodaCheck.updater(qualifiedName, name));
    }

    public static SodaCheck updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SodaCheck.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SodaCheck updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SodaCheck)Asset.updateAnnouncement(client, SodaCheck._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SodaCheck removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SodaCheck.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SodaCheck removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck)Asset.removeAnnouncement(client, SodaCheck.updater(qualifiedName, name));
    }

    public static SodaCheck replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SodaCheck.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SodaCheck replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SodaCheck)Asset.replaceTerms(client, SodaCheck.updater(qualifiedName, name), terms);
    }

    public static SodaCheck appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SodaCheck.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SodaCheck appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SodaCheck)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SodaCheck removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SodaCheck.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SodaCheck removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SodaCheck)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SodaCheck appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SodaCheck.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SodaCheck appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SodaCheck)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SodaCheck appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SodaCheck.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SodaCheck appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SodaCheck)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        SodaCheck.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        SodaCheck.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SodaCheck.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SodaCheck(SodaCheckBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SodaCheck.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<IAsset> sodaCheckAssets = new TreeSet<IAsset>();
        if (b.sodaCheckAssets != null) {
            sodaCheckAssets.addAll(b.sodaCheckAssets);
        }
        sodaCheckAssets = Collections.unmodifiableSortedSet(sodaCheckAssets);
        this.sodaCheckAssets = sodaCheckAssets;
        SortedSet<IColumn> sodaCheckColumns = new TreeSet<IColumn>();
        if (b.sodaCheckColumns != null) {
            sodaCheckColumns.addAll(b.sodaCheckColumns);
        }
        sodaCheckColumns = Collections.unmodifiableSortedSet(sodaCheckColumns);
        this.sodaCheckColumns = sodaCheckColumns;
        this.sodaCheckDefinition = b.sodaCheckDefinition;
        this.sodaCheckEvaluationStatus = b.sodaCheckEvaluationStatus;
        this.sodaCheckId = b.sodaCheckId;
        this.sodaCheckIncidentCount = b.sodaCheckIncidentCount;
        this.sodaCheckLastScanAt = b.sodaCheckLastScanAt;
    }

    @Generated
    public static SodaCheckBuilder<?, ?> _internal() {
        return new SodaCheckBuilderImpl();
    }

    @Generated
    public SodaCheckBuilder<?, ?> toBuilder() {
        return new SodaCheckBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAsset> getSodaCheckAssets() {
        return this.sodaCheckAssets;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getSodaCheckColumns() {
        return this.sodaCheckColumns;
    }

    @Override
    @Generated
    public String getSodaCheckDefinition() {
        return this.sodaCheckDefinition;
    }

    @Override
    @Generated
    public String getSodaCheckEvaluationStatus() {
        return this.sodaCheckEvaluationStatus;
    }

    @Override
    @Generated
    public String getSodaCheckId() {
        return this.sodaCheckId;
    }

    @Override
    @Generated
    public Long getSodaCheckIncidentCount() {
        return this.sodaCheckIncidentCount;
    }

    @Override
    @Generated
    public Long getSodaCheckLastScanAt() {
        return this.sodaCheckLastScanAt;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SodaCheck)) {
            return false;
        }
        SodaCheck other = (SodaCheck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sodaCheckIncidentCount = this.getSodaCheckIncidentCount();
        Long other$sodaCheckIncidentCount = other.getSodaCheckIncidentCount();
        if (this$sodaCheckIncidentCount == null ? other$sodaCheckIncidentCount != null : !((Object)this$sodaCheckIncidentCount).equals(other$sodaCheckIncidentCount)) {
            return false;
        }
        Long this$sodaCheckLastScanAt = this.getSodaCheckLastScanAt();
        Long other$sodaCheckLastScanAt = other.getSodaCheckLastScanAt();
        if (this$sodaCheckLastScanAt == null ? other$sodaCheckLastScanAt != null : !((Object)this$sodaCheckLastScanAt).equals(other$sodaCheckLastScanAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<IAsset> this$sodaCheckAssets = this.getSodaCheckAssets();
        SortedSet<IAsset> other$sodaCheckAssets = other.getSodaCheckAssets();
        if (this$sodaCheckAssets == null ? other$sodaCheckAssets != null : !this$sodaCheckAssets.equals(other$sodaCheckAssets)) {
            return false;
        }
        SortedSet<IColumn> this$sodaCheckColumns = this.getSodaCheckColumns();
        SortedSet<IColumn> other$sodaCheckColumns = other.getSodaCheckColumns();
        if (this$sodaCheckColumns == null ? other$sodaCheckColumns != null : !this$sodaCheckColumns.equals(other$sodaCheckColumns)) {
            return false;
        }
        String this$sodaCheckDefinition = this.getSodaCheckDefinition();
        String other$sodaCheckDefinition = other.getSodaCheckDefinition();
        if (this$sodaCheckDefinition == null ? other$sodaCheckDefinition != null : !this$sodaCheckDefinition.equals(other$sodaCheckDefinition)) {
            return false;
        }
        String this$sodaCheckEvaluationStatus = this.getSodaCheckEvaluationStatus();
        String other$sodaCheckEvaluationStatus = other.getSodaCheckEvaluationStatus();
        if (this$sodaCheckEvaluationStatus == null ? other$sodaCheckEvaluationStatus != null : !this$sodaCheckEvaluationStatus.equals(other$sodaCheckEvaluationStatus)) {
            return false;
        }
        String this$sodaCheckId = this.getSodaCheckId();
        String other$sodaCheckId = other.getSodaCheckId();
        return !(this$sodaCheckId == null ? other$sodaCheckId != null : !this$sodaCheckId.equals(other$sodaCheckId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SodaCheck;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sodaCheckIncidentCount = this.getSodaCheckIncidentCount();
        result = result * 59 + ($sodaCheckIncidentCount == null ? 43 : ((Object)$sodaCheckIncidentCount).hashCode());
        Long $sodaCheckLastScanAt = this.getSodaCheckLastScanAt();
        result = result * 59 + ($sodaCheckLastScanAt == null ? 43 : ((Object)$sodaCheckLastScanAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<IAsset> $sodaCheckAssets = this.getSodaCheckAssets();
        result = result * 59 + ($sodaCheckAssets == null ? 43 : $sodaCheckAssets.hashCode());
        SortedSet<IColumn> $sodaCheckColumns = this.getSodaCheckColumns();
        result = result * 59 + ($sodaCheckColumns == null ? 43 : $sodaCheckColumns.hashCode());
        String $sodaCheckDefinition = this.getSodaCheckDefinition();
        result = result * 59 + ($sodaCheckDefinition == null ? 43 : $sodaCheckDefinition.hashCode());
        String $sodaCheckEvaluationStatus = this.getSodaCheckEvaluationStatus();
        result = result * 59 + ($sodaCheckEvaluationStatus == null ? 43 : $sodaCheckEvaluationStatus.hashCode());
        String $sodaCheckId = this.getSodaCheckId();
        result = result * 59 + ($sodaCheckId == null ? 43 : $sodaCheckId.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SodaCheck(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", sodaCheckAssets=" + this.getSodaCheckAssets() + ", sodaCheckColumns=" + this.getSodaCheckColumns() + ", sodaCheckDefinition=" + this.getSodaCheckDefinition() + ", sodaCheckEvaluationStatus=" + this.getSodaCheckEvaluationStatus() + ", sodaCheckId=" + this.getSodaCheckId() + ", sodaCheckIncidentCount=" + this.getSodaCheckIncidentCount() + ", sodaCheckLastScanAt=" + this.getSodaCheckLastScanAt() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class SodaCheckBuilderImpl
    extends SodaCheckBuilder<SodaCheck, SodaCheckBuilderImpl> {
        @Generated
        private SodaCheckBuilderImpl() {
        }

        @Override
        @Generated
        protected SodaCheckBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SodaCheck build() {
            return new SodaCheck(this);
        }
    }

    @Generated
    public static abstract class SodaCheckBuilder<C extends SodaCheck, B extends SodaCheckBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<IAsset> sodaCheckAssets;
        @Generated
        private ArrayList<IColumn> sodaCheckColumns;
        @Generated
        private String sodaCheckDefinition;
        @Generated
        private String sodaCheckEvaluationStatus;
        @Generated
        private String sodaCheckId;
        @Generated
        private Long sodaCheckIncidentCount;
        @Generated
        private Long sodaCheckLastScanAt;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SodaCheckBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SodaCheck instance, SodaCheckBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.sodaCheckAssets(instance.sodaCheckAssets == null ? Collections.emptySortedSet() : instance.sodaCheckAssets);
            b.sodaCheckColumns(instance.sodaCheckColumns == null ? Collections.emptySortedSet() : instance.sodaCheckColumns);
            b.sodaCheckDefinition(instance.sodaCheckDefinition);
            b.sodaCheckEvaluationStatus(instance.sodaCheckEvaluationStatus);
            b.sodaCheckId(instance.sodaCheckId);
            b.sodaCheckIncidentCount(instance.sodaCheckIncidentCount);
            b.sodaCheckLastScanAt(instance.sodaCheckLastScanAt);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sodaCheckAsset(IAsset sodaCheckAsset) {
            if (this.sodaCheckAssets == null) {
                this.sodaCheckAssets = new ArrayList();
            }
            this.sodaCheckAssets.add(sodaCheckAsset);
            return (B)this.self();
        }

        @Generated
        public B sodaCheckAssets(Collection<? extends IAsset> sodaCheckAssets) {
            if (sodaCheckAssets == null) {
                throw new NullPointerException("sodaCheckAssets cannot be null");
            }
            if (this.sodaCheckAssets == null) {
                this.sodaCheckAssets = new ArrayList();
            }
            this.sodaCheckAssets.addAll(sodaCheckAssets);
            return (B)this.self();
        }

        @Generated
        public B clearSodaCheckAssets() {
            if (this.sodaCheckAssets != null) {
                this.sodaCheckAssets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sodaCheckColumn(IColumn sodaCheckColumn) {
            if (this.sodaCheckColumns == null) {
                this.sodaCheckColumns = new ArrayList();
            }
            this.sodaCheckColumns.add(sodaCheckColumn);
            return (B)this.self();
        }

        @Generated
        public B sodaCheckColumns(Collection<? extends IColumn> sodaCheckColumns) {
            if (sodaCheckColumns == null) {
                throw new NullPointerException("sodaCheckColumns cannot be null");
            }
            if (this.sodaCheckColumns == null) {
                this.sodaCheckColumns = new ArrayList();
            }
            this.sodaCheckColumns.addAll(sodaCheckColumns);
            return (B)this.self();
        }

        @Generated
        public B clearSodaCheckColumns() {
            if (this.sodaCheckColumns != null) {
                this.sodaCheckColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sodaCheckDefinition(String sodaCheckDefinition) {
            this.sodaCheckDefinition = sodaCheckDefinition;
            return (B)this.self();
        }

        @Generated
        public B sodaCheckEvaluationStatus(String sodaCheckEvaluationStatus) {
            this.sodaCheckEvaluationStatus = sodaCheckEvaluationStatus;
            return (B)this.self();
        }

        @Generated
        public B sodaCheckId(String sodaCheckId) {
            this.sodaCheckId = sodaCheckId;
            return (B)this.self();
        }

        @Generated
        public B sodaCheckIncidentCount(Long sodaCheckIncidentCount) {
            this.sodaCheckIncidentCount = sodaCheckIncidentCount;
            return (B)this.self();
        }

        @Generated
        public B sodaCheckLastScanAt(Long sodaCheckLastScanAt) {
            this.sodaCheckLastScanAt = sodaCheckLastScanAt;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "SodaCheck.SodaCheckBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", sodaCheckAssets=" + this.sodaCheckAssets + ", sodaCheckColumns=" + this.sodaCheckColumns + ", sodaCheckDefinition=" + this.sodaCheckDefinition + ", sodaCheckEvaluationStatus=" + this.sodaCheckEvaluationStatus + ", sodaCheckId=" + this.sodaCheckId + ", sodaCheckIncidentCount=" + this.sodaCheckIncidentCount + ", sodaCheckLastScanAt=" + this.sodaCheckLastScanAt + ")";
        }
    }
}

