/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ITableau;
import com.atlan.model.assets.ITableauDatasource;
import com.atlan.model.assets.ITableauField;
import com.atlan.model.assets.ITableauProject;
import com.atlan.model.assets.ITableauWorkbook;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableauDatasource
extends Asset
implements ITableauDatasource,
ITableau,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableauDatasource.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauDatasource";
    String typeName;
    @Attribute
    String certificationNote;
    @Attribute
    Map<String, String> certifier;
    @Attribute
    String certifierDisplayName;
    @Attribute
    SortedSet<ITableauField> fields;
    @Attribute
    Boolean hasExtracts;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    Boolean isCertified;
    @Attribute
    Boolean isPublished;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    ITableauProject project;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    List<Map<String, String>> upstreamDatasources;
    @Attribute
    List<Map<String, String>> upstreamTables;
    @Attribute
    ITableauWorkbook workbook;
    @Attribute
    String workbookQualifiedName;

    @Override
    public TableauDatasource trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return TableauDatasource.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return TableauDatasource.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return TableauDatasource.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return TableauDatasource.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return TableauDatasource.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return TableauDatasource.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return TableauDatasource.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return TableauDatasource.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return TableauDatasource.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static TableauDatasource refByGuid(String guid) {
        return ((TableauDatasourceBuilder)TableauDatasource._internal().guid(guid)).build();
    }

    public static TableauDatasource refByQualifiedName(String qualifiedName) {
        return ((TableauDatasourceBuilder)TableauDatasource._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static TableauDatasource get(String id) throws AtlanException {
        return TableauDatasource.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static TableauDatasource get(AtlanClient client, String id) throws AtlanException {
        return TableauDatasource.get(client, id, true);
    }

    @JsonIgnore
    public static TableauDatasource get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof TableauDatasource) {
                return (TableauDatasource)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof TableauDatasource) {
            return (TableauDatasource)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static TableauDatasource retrieveByGuid(String guid) throws AtlanException {
        return TableauDatasource.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static TableauDatasource retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return TableauDatasource.get(client, guid);
    }

    @Deprecated
    public static TableauDatasource retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return TableauDatasource.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static TableauDatasource retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return TableauDatasource.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return TableauDatasource.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TableauDatasourceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauDatasourceBuilder)((TableauDatasourceBuilder)((TableauDatasourceBuilder)TableauDatasource._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TableauDatasourceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return TableauDatasource.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauDatasource removeDescription(String qualifiedName, String name) throws AtlanException {
        return TableauDatasource.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauDatasource removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeDescription(client, TableauDatasource.updater(qualifiedName, name));
    }

    public static TableauDatasource removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return TableauDatasource.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauDatasource removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeUserDescription(client, TableauDatasource.updater(qualifiedName, name));
    }

    public static TableauDatasource removeOwners(String qualifiedName, String name) throws AtlanException {
        return TableauDatasource.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauDatasource removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeOwners(client, TableauDatasource.updater(qualifiedName, name));
    }

    public static TableauDatasource updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return TableauDatasource.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static TableauDatasource updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauDatasource)Asset.updateCertificate(client, TableauDatasource._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauDatasource removeCertificate(String qualifiedName, String name) throws AtlanException {
        return TableauDatasource.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauDatasource removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeCertificate(client, TableauDatasource.updater(qualifiedName, name));
    }

    public static TableauDatasource updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return TableauDatasource.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static TableauDatasource updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauDatasource)Asset.updateAnnouncement(client, TableauDatasource._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauDatasource removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return TableauDatasource.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauDatasource removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource)Asset.removeAnnouncement(client, TableauDatasource.updater(qualifiedName, name));
    }

    public static TableauDatasource replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauDatasource.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static TableauDatasource replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource)Asset.replaceTerms(client, TableauDatasource.updater(qualifiedName, name), terms);
    }

    public static TableauDatasource appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauDatasource.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static TableauDatasource appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static TableauDatasource removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauDatasource.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static TableauDatasource removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static TableauDatasource appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return TableauDatasource.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static TableauDatasource appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauDatasource)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static TableauDatasource appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return TableauDatasource.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static TableauDatasource appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauDatasource)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        TableauDatasource.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        TableauDatasource.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        TableauDatasource.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauDatasource(TableauDatasourceBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        List<Object> upstreamTables;
        List<Object> upstreamDatasources;
        List<Object> projectHierarchy;
        Map<Object, Object> certifier;
        this.typeName = b.typeName$set ? b.typeName$value : TableauDatasource.$default$typeName();
        this.certificationNote = b.certificationNote;
        switch (b.certifier$key == null ? 0 : b.certifier$key.size()) {
            case 0: {
                certifier = Collections.emptyMap();
                break;
            }
            case 1: {
                certifier = Collections.singletonMap(b.certifier$key.get(0), b.certifier$value.get(0));
                break;
            }
            default: {
                certifier = new LinkedHashMap(b.certifier$key.size() < 0x40000000 ? 1 + b.certifier$key.size() + (b.certifier$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.certifier$key.size(); ++$i) {
                    certifier.put(b.certifier$key.get($i), b.certifier$value.get($i));
                }
                certifier = Collections.unmodifiableMap(certifier);
            }
        }
        this.certifier = certifier;
        this.certifierDisplayName = b.certifierDisplayName;
        SortedSet<ITableauField> fields = new TreeSet<ITableauField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        this.hasExtracts = b.hasExtracts;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        this.isCertified = b.isCertified;
        this.isPublished = b.isPublished;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.project = b.project;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        this.projectQualifiedName = b.projectQualifiedName;
        this.siteQualifiedName = b.siteQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        switch (b.upstreamDatasources == null ? 0 : b.upstreamDatasources.size()) {
            case 0: {
                upstreamDatasources = Collections.emptyList();
                break;
            }
            case 1: {
                upstreamDatasources = Collections.singletonList(b.upstreamDatasources.get(0));
                break;
            }
            default: {
                upstreamDatasources = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamDatasources));
            }
        }
        this.upstreamDatasources = upstreamDatasources;
        switch (b.upstreamTables == null ? 0 : b.upstreamTables.size()) {
            case 0: {
                upstreamTables = Collections.emptyList();
                break;
            }
            case 1: {
                upstreamTables = Collections.singletonList(b.upstreamTables.get(0));
                break;
            }
            default: {
                upstreamTables = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamTables));
            }
        }
        this.upstreamTables = upstreamTables;
        this.workbook = b.workbook;
        this.workbookQualifiedName = b.workbookQualifiedName;
    }

    @Generated
    public static TableauDatasourceBuilder<?, ?> _internal() {
        return new TableauDatasourceBuilderImpl();
    }

    @Generated
    public TableauDatasourceBuilder<?, ?> toBuilder() {
        return new TableauDatasourceBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getCertificationNote() {
        return this.certificationNote;
    }

    @Override
    @Generated
    public Map<String, String> getCertifier() {
        return this.certifier;
    }

    @Override
    @Generated
    public String getCertifierDisplayName() {
        return this.certifierDisplayName;
    }

    @Override
    @Generated
    public SortedSet<ITableauField> getFields() {
        return this.fields;
    }

    @Override
    @Generated
    public Boolean getHasExtracts() {
        return this.hasExtracts;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public Boolean getIsCertified() {
        return this.isCertified;
    }

    @Override
    @Generated
    public Boolean getIsPublished() {
        return this.isPublished;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public ITableauProject getProject() {
        return this.project;
    }

    @Override
    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Override
    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Override
    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Override
    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Override
    @Generated
    public List<Map<String, String>> getUpstreamDatasources() {
        return this.upstreamDatasources;
    }

    @Override
    @Generated
    public List<Map<String, String>> getUpstreamTables() {
        return this.upstreamTables;
    }

    @Override
    @Generated
    public ITableauWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    @Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauDatasource)) {
            return false;
        }
        TableauDatasource other = (TableauDatasource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$hasExtracts = this.getHasExtracts();
        Boolean other$hasExtracts = other.getHasExtracts();
        if (this$hasExtracts == null ? other$hasExtracts != null : !((Object)this$hasExtracts).equals(other$hasExtracts)) {
            return false;
        }
        Boolean this$isCertified = this.getIsCertified();
        Boolean other$isCertified = other.getIsCertified();
        if (this$isCertified == null ? other$isCertified != null : !((Object)this$isCertified).equals(other$isCertified)) {
            return false;
        }
        Boolean this$isPublished = this.getIsPublished();
        Boolean other$isPublished = other.getIsPublished();
        if (this$isPublished == null ? other$isPublished != null : !((Object)this$isPublished).equals(other$isPublished)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$certificationNote = this.getCertificationNote();
        String other$certificationNote = other.getCertificationNote();
        if (this$certificationNote == null ? other$certificationNote != null : !this$certificationNote.equals(other$certificationNote)) {
            return false;
        }
        Map<String, String> this$certifier = this.getCertifier();
        Map<String, String> other$certifier = other.getCertifier();
        if (this$certifier == null ? other$certifier != null : !((Object)this$certifier).equals(other$certifier)) {
            return false;
        }
        String this$certifierDisplayName = this.getCertifierDisplayName();
        String other$certifierDisplayName = other.getCertifierDisplayName();
        if (this$certifierDisplayName == null ? other$certifierDisplayName != null : !this$certifierDisplayName.equals(other$certifierDisplayName)) {
            return false;
        }
        SortedSet<ITableauField> this$fields = this.getFields();
        SortedSet<ITableauField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        ITableauProject this$project = this.getProject();
        ITableauProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$upstreamDatasources = this.getUpstreamDatasources();
        List<Map<String, String>> other$upstreamDatasources = other.getUpstreamDatasources();
        if (this$upstreamDatasources == null ? other$upstreamDatasources != null : !((Object)this$upstreamDatasources).equals(other$upstreamDatasources)) {
            return false;
        }
        List<Map<String, String>> this$upstreamTables = this.getUpstreamTables();
        List<Map<String, String>> other$upstreamTables = other.getUpstreamTables();
        if (this$upstreamTables == null ? other$upstreamTables != null : !((Object)this$upstreamTables).equals(other$upstreamTables)) {
            return false;
        }
        ITableauWorkbook this$workbook = this.getWorkbook();
        ITableauWorkbook other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !this$workbook.equals(other$workbook)) {
            return false;
        }
        String this$workbookQualifiedName = this.getWorkbookQualifiedName();
        String other$workbookQualifiedName = other.getWorkbookQualifiedName();
        return !(this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauDatasource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $hasExtracts = this.getHasExtracts();
        result = result * 59 + ($hasExtracts == null ? 43 : ((Object)$hasExtracts).hashCode());
        Boolean $isCertified = this.getIsCertified();
        result = result * 59 + ($isCertified == null ? 43 : ((Object)$isCertified).hashCode());
        Boolean $isPublished = this.getIsPublished();
        result = result * 59 + ($isPublished == null ? 43 : ((Object)$isPublished).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $certificationNote = this.getCertificationNote();
        result = result * 59 + ($certificationNote == null ? 43 : $certificationNote.hashCode());
        Map<String, String> $certifier = this.getCertifier();
        result = result * 59 + ($certifier == null ? 43 : ((Object)$certifier).hashCode());
        String $certifierDisplayName = this.getCertifierDisplayName();
        result = result * 59 + ($certifierDisplayName == null ? 43 : $certifierDisplayName.hashCode());
        SortedSet<ITableauField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        ITableauProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $upstreamDatasources = this.getUpstreamDatasources();
        result = result * 59 + ($upstreamDatasources == null ? 43 : ((Object)$upstreamDatasources).hashCode());
        List<Map<String, String>> $upstreamTables = this.getUpstreamTables();
        result = result * 59 + ($upstreamTables == null ? 43 : ((Object)$upstreamTables).hashCode());
        ITableauWorkbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : $workbook.hashCode());
        String $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * 59 + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TableauDatasource(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", certificationNote=" + this.getCertificationNote() + ", certifier=" + this.getCertifier() + ", certifierDisplayName=" + this.getCertifierDisplayName() + ", fields=" + this.getFields() + ", hasExtracts=" + this.getHasExtracts() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", isCertified=" + this.getIsCertified() + ", isPublished=" + this.getIsPublished() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", project=" + this.getProject() + ", projectHierarchy=" + this.getProjectHierarchy() + ", projectQualifiedName=" + this.getProjectQualifiedName() + ", siteQualifiedName=" + this.getSiteQualifiedName() + ", topLevelProjectQualifiedName=" + this.getTopLevelProjectQualifiedName() + ", upstreamDatasources=" + this.getUpstreamDatasources() + ", upstreamTables=" + this.getUpstreamTables() + ", workbook=" + this.getWorkbook() + ", workbookQualifiedName=" + this.getWorkbookQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class TableauDatasourceBuilderImpl
    extends TableauDatasourceBuilder<TableauDatasource, TableauDatasourceBuilderImpl> {
        @Generated
        private TableauDatasourceBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauDatasourceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauDatasource build() {
            return new TableauDatasource(this);
        }
    }

    @Generated
    public static abstract class TableauDatasourceBuilder<C extends TableauDatasource, B extends TableauDatasourceBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String certificationNote;
        @Generated
        private ArrayList<String> certifier$key;
        @Generated
        private ArrayList<String> certifier$value;
        @Generated
        private String certifierDisplayName;
        @Generated
        private ArrayList<ITableauField> fields;
        @Generated
        private Boolean hasExtracts;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private Boolean isCertified;
        @Generated
        private Boolean isPublished;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ITableauProject project;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> upstreamDatasources;
        @Generated
        private ArrayList<Map<String, String>> upstreamTables;
        @Generated
        private ITableauWorkbook workbook;
        @Generated
        private String workbookQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauDatasourceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauDatasource instance, TableauDatasourceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.certificationNote(instance.certificationNote);
            b.certifier(instance.certifier == null ? Collections.emptyMap() : instance.certifier);
            b.certifierDisplayName(instance.certifierDisplayName);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.hasExtracts(instance.hasExtracts);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.isCertified(instance.isCertified);
            b.isPublished(instance.isPublished);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.project(instance.project);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.upstreamDatasources(instance.upstreamDatasources == null ? Collections.emptyList() : instance.upstreamDatasources);
            b.upstreamTables(instance.upstreamTables == null ? Collections.emptyList() : instance.upstreamTables);
            b.workbook(instance.workbook);
            b.workbookQualifiedName(instance.workbookQualifiedName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B certificationNote(String certificationNote) {
            this.certificationNote = certificationNote;
            return (B)this.self();
        }

        @Generated
        public B putCertifier(String putCertifierKey, String putCertifierValue) {
            if (this.certifier$key == null) {
                this.certifier$key = new ArrayList();
                this.certifier$value = new ArrayList();
            }
            this.certifier$key.add(putCertifierKey);
            this.certifier$value.add(putCertifierValue);
            return (B)this.self();
        }

        @Generated
        public B certifier(Map<? extends String, ? extends String> certifier) {
            if (certifier == null) {
                throw new NullPointerException("certifier cannot be null");
            }
            if (this.certifier$key == null) {
                this.certifier$key = new ArrayList();
                this.certifier$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : certifier.entrySet()) {
                this.certifier$key.add($lombokEntry.getKey());
                this.certifier$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearCertifier() {
            if (this.certifier$key != null) {
                this.certifier$key.clear();
                this.certifier$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B certifierDisplayName(String certifierDisplayName) {
            this.certifierDisplayName = certifierDisplayName;
            return (B)this.self();
        }

        @Generated
        public B field(ITableauField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends ITableauField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B hasExtracts(Boolean hasExtracts) {
            this.hasExtracts = hasExtracts;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isCertified(Boolean isCertified) {
            this.isCertified = isCertified;
            return (B)this.self();
        }

        @Generated
        public B isPublished(Boolean isPublished) {
            this.isPublished = isPublished;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(ITableauProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B upstreamDatasource(Map<String, String> upstreamDatasource) {
            if (this.upstreamDatasources == null) {
                this.upstreamDatasources = new ArrayList();
            }
            this.upstreamDatasources.add(upstreamDatasource);
            return (B)this.self();
        }

        @Generated
        public B upstreamDatasources(Collection<? extends Map<String, String>> upstreamDatasources) {
            if (upstreamDatasources == null) {
                throw new NullPointerException("upstreamDatasources cannot be null");
            }
            if (this.upstreamDatasources == null) {
                this.upstreamDatasources = new ArrayList();
            }
            this.upstreamDatasources.addAll(upstreamDatasources);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamDatasources() {
            if (this.upstreamDatasources != null) {
                this.upstreamDatasources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B upstreamTable(Map<String, String> upstreamTable) {
            if (this.upstreamTables == null) {
                this.upstreamTables = new ArrayList();
            }
            this.upstreamTables.add(upstreamTable);
            return (B)this.self();
        }

        @Generated
        public B upstreamTables(Collection<? extends Map<String, String>> upstreamTables) {
            if (upstreamTables == null) {
                throw new NullPointerException("upstreamTables cannot be null");
            }
            if (this.upstreamTables == null) {
                this.upstreamTables = new ArrayList();
            }
            this.upstreamTables.addAll(upstreamTables);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamTables() {
            if (this.upstreamTables != null) {
                this.upstreamTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workbook(ITableauWorkbook workbook) {
            this.workbook = workbook;
            return (B)this.self();
        }

        @Generated
        public B workbookQualifiedName(String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauDatasource.TableauDatasourceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", certificationNote=" + this.certificationNote + ", certifier$key=" + this.certifier$key + ", certifier$value=" + this.certifier$value + ", certifierDisplayName=" + this.certifierDisplayName + ", fields=" + this.fields + ", hasExtracts=" + this.hasExtracts + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", isCertified=" + this.isCertified + ", isPublished=" + this.isPublished + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", project=" + this.project + ", projectHierarchy=" + this.projectHierarchy + ", projectQualifiedName=" + this.projectQualifiedName + ", siteQualifiedName=" + this.siteQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", upstreamDatasources=" + this.upstreamDatasources + ", upstreamTables=" + this.upstreamTables + ", workbook=" + this.workbook + ", workbookQualifiedName=" + this.workbookQualifiedName + ")";
        }
    }
}

