/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ITableau;
import com.atlan.model.assets.ITableauFlow;
import com.atlan.model.assets.ITableauProject;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableauFlow
extends Asset
implements ITableauFlow,
ITableau,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableauFlow.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauFlow";
    String typeName;
    @Attribute
    List<Map<String, String>> inputFields;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    List<Map<String, String>> outputFields;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    List<Map<String, String>> outputSteps;
    @Attribute
    ITableauProject project;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;

    @Override
    public TableauFlow trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return TableauFlow.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return TableauFlow.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return TableauFlow.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return TableauFlow.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return TableauFlow.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return TableauFlow.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return TableauFlow.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return TableauFlow.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return TableauFlow.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static TableauFlow refByGuid(String guid) {
        return ((TableauFlowBuilder)TableauFlow._internal().guid(guid)).build();
    }

    public static TableauFlow refByQualifiedName(String qualifiedName) {
        return ((TableauFlowBuilder)TableauFlow._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static TableauFlow get(String id) throws AtlanException {
        return TableauFlow.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static TableauFlow get(AtlanClient client, String id) throws AtlanException {
        return TableauFlow.get(client, id, true);
    }

    @JsonIgnore
    public static TableauFlow get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof TableauFlow) {
                return (TableauFlow)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof TableauFlow) {
            return (TableauFlow)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static TableauFlow retrieveByGuid(String guid) throws AtlanException {
        return TableauFlow.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static TableauFlow retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return TableauFlow.get(client, guid);
    }

    @Deprecated
    public static TableauFlow retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return TableauFlow.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static TableauFlow retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return TableauFlow.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return TableauFlow.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TableauFlowBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauFlowBuilder)((TableauFlowBuilder)((TableauFlowBuilder)TableauFlow._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TableauFlowBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return TableauFlow.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauFlow removeDescription(String qualifiedName, String name) throws AtlanException {
        return TableauFlow.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauFlow removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeDescription(client, TableauFlow.updater(qualifiedName, name));
    }

    public static TableauFlow removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return TableauFlow.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauFlow removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeUserDescription(client, TableauFlow.updater(qualifiedName, name));
    }

    public static TableauFlow removeOwners(String qualifiedName, String name) throws AtlanException {
        return TableauFlow.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauFlow removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeOwners(client, TableauFlow.updater(qualifiedName, name));
    }

    public static TableauFlow updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return TableauFlow.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static TableauFlow updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauFlow)Asset.updateCertificate(client, TableauFlow._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauFlow removeCertificate(String qualifiedName, String name) throws AtlanException {
        return TableauFlow.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauFlow removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeCertificate(client, TableauFlow.updater(qualifiedName, name));
    }

    public static TableauFlow updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return TableauFlow.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static TableauFlow updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauFlow)Asset.updateAnnouncement(client, TableauFlow._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauFlow removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return TableauFlow.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauFlow removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow)Asset.removeAnnouncement(client, TableauFlow.updater(qualifiedName, name));
    }

    public static TableauFlow replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauFlow.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static TableauFlow replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauFlow)Asset.replaceTerms(client, TableauFlow.updater(qualifiedName, name), terms);
    }

    public static TableauFlow appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauFlow.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static TableauFlow appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauFlow)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static TableauFlow removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauFlow.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static TableauFlow removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauFlow)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static TableauFlow appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return TableauFlow.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static TableauFlow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauFlow)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static TableauFlow appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return TableauFlow.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static TableauFlow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauFlow)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        TableauFlow.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        TableauFlow.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        TableauFlow.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauFlow(TableauFlowBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        List<Object> projectHierarchy;
        List<Object> outputSteps;
        List<Object> outputFields;
        List<Object> inputFields;
        this.typeName = b.typeName$set ? b.typeName$value : TableauFlow.$default$typeName();
        switch (b.inputFields == null ? 0 : b.inputFields.size()) {
            case 0: {
                inputFields = Collections.emptyList();
                break;
            }
            case 1: {
                inputFields = Collections.singletonList(b.inputFields.get(0));
                break;
            }
            default: {
                inputFields = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.inputFields));
            }
        }
        this.inputFields = inputFields;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        switch (b.outputFields == null ? 0 : b.outputFields.size()) {
            case 0: {
                outputFields = Collections.emptyList();
                break;
            }
            case 1: {
                outputFields = Collections.singletonList(b.outputFields.get(0));
                break;
            }
            default: {
                outputFields = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.outputFields));
            }
        }
        this.outputFields = outputFields;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        switch (b.outputSteps == null ? 0 : b.outputSteps.size()) {
            case 0: {
                outputSteps = Collections.emptyList();
                break;
            }
            case 1: {
                outputSteps = Collections.singletonList(b.outputSteps.get(0));
                break;
            }
            default: {
                outputSteps = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.outputSteps));
            }
        }
        this.outputSteps = outputSteps;
        this.project = b.project;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0: {
                projectHierarchy = Collections.emptyList();
                break;
            }
            case 1: {
                projectHierarchy = Collections.singletonList(b.projectHierarchy.get(0));
                break;
            }
            default: {
                projectHierarchy = Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
            }
        }
        this.projectHierarchy = projectHierarchy;
        this.projectQualifiedName = b.projectQualifiedName;
        this.siteQualifiedName = b.siteQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
    }

    @Generated
    public static TableauFlowBuilder<?, ?> _internal() {
        return new TableauFlowBuilderImpl();
    }

    @Generated
    public TableauFlowBuilder<?, ?> toBuilder() {
        return new TableauFlowBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public List<Map<String, String>> getInputFields() {
        return this.inputFields;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public List<Map<String, String>> getOutputFields() {
        return this.outputFields;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public List<Map<String, String>> getOutputSteps() {
        return this.outputSteps;
    }

    @Override
    @Generated
    public ITableauProject getProject() {
        return this.project;
    }

    @Override
    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Override
    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Override
    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Override
    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauFlow)) {
            return false;
        }
        TableauFlow other = (TableauFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<Map<String, String>> this$inputFields = this.getInputFields();
        List<Map<String, String>> other$inputFields = other.getInputFields();
        if (this$inputFields == null ? other$inputFields != null : !((Object)this$inputFields).equals(other$inputFields)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        List<Map<String, String>> this$outputFields = this.getOutputFields();
        List<Map<String, String>> other$outputFields = other.getOutputFields();
        if (this$outputFields == null ? other$outputFields != null : !((Object)this$outputFields).equals(other$outputFields)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        List<Map<String, String>> this$outputSteps = this.getOutputSteps();
        List<Map<String, String>> other$outputSteps = other.getOutputSteps();
        if (this$outputSteps == null ? other$outputSteps != null : !((Object)this$outputSteps).equals(other$outputSteps)) {
            return false;
        }
        ITableauProject this$project = this.getProject();
        ITableauProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        return !(this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauFlow;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<Map<String, String>> $inputFields = this.getInputFields();
        result = result * 59 + ($inputFields == null ? 43 : ((Object)$inputFields).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        List<Map<String, String>> $outputFields = this.getOutputFields();
        result = result * 59 + ($outputFields == null ? 43 : ((Object)$outputFields).hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        List<Map<String, String>> $outputSteps = this.getOutputSteps();
        result = result * 59 + ($outputSteps == null ? 43 : ((Object)$outputSteps).hashCode());
        ITableauProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TableauFlow(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputFields=" + this.getInputFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFields=" + this.getOutputFields() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputSteps=" + this.getOutputSteps() + ", project=" + this.getProject() + ", projectHierarchy=" + this.getProjectHierarchy() + ", projectQualifiedName=" + this.getProjectQualifiedName() + ", siteQualifiedName=" + this.getSiteQualifiedName() + ", topLevelProjectQualifiedName=" + this.getTopLevelProjectQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class TableauFlowBuilderImpl
    extends TableauFlowBuilder<TableauFlow, TableauFlowBuilderImpl> {
        @Generated
        private TableauFlowBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauFlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauFlow build() {
            return new TableauFlow(this);
        }
    }

    @Generated
    public static abstract class TableauFlowBuilder<C extends TableauFlow, B extends TableauFlowBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<Map<String, String>> inputFields;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<Map<String, String>> outputFields;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<Map<String, String>> outputSteps;
        @Generated
        private ITableauProject project;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauFlowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauFlow instance, TableauFlowBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputFields(instance.inputFields == null ? Collections.emptyList() : instance.inputFields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFields(instance.outputFields == null ? Collections.emptyList() : instance.outputFields);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputSteps(instance.outputSteps == null ? Collections.emptyList() : instance.outputSteps);
            b.project(instance.project);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputField(Map<String, String> inputField) {
            if (this.inputFields == null) {
                this.inputFields = new ArrayList();
            }
            this.inputFields.add(inputField);
            return (B)this.self();
        }

        @Generated
        public B inputFields(Collection<? extends Map<String, String>> inputFields) {
            if (inputFields == null) {
                throw new NullPointerException("inputFields cannot be null");
            }
            if (this.inputFields == null) {
                this.inputFields = new ArrayList();
            }
            this.inputFields.addAll(inputFields);
            return (B)this.self();
        }

        @Generated
        public B clearInputFields() {
            if (this.inputFields != null) {
                this.inputFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputField(Map<String, String> outputField) {
            if (this.outputFields == null) {
                this.outputFields = new ArrayList();
            }
            this.outputFields.add(outputField);
            return (B)this.self();
        }

        @Generated
        public B outputFields(Collection<? extends Map<String, String>> outputFields) {
            if (outputFields == null) {
                throw new NullPointerException("outputFields cannot be null");
            }
            if (this.outputFields == null) {
                this.outputFields = new ArrayList();
            }
            this.outputFields.addAll(outputFields);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFields() {
            if (this.outputFields != null) {
                this.outputFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputStep(Map<String, String> outputStep) {
            if (this.outputSteps == null) {
                this.outputSteps = new ArrayList();
            }
            this.outputSteps.add(outputStep);
            return (B)this.self();
        }

        @Generated
        public B outputSteps(Collection<? extends Map<String, String>> outputSteps) {
            if (outputSteps == null) {
                throw new NullPointerException("outputSteps cannot be null");
            }
            if (this.outputSteps == null) {
                this.outputSteps = new ArrayList();
            }
            this.outputSteps.addAll(outputSteps);
            return (B)this.self();
        }

        @Generated
        public B clearOutputSteps() {
            if (this.outputSteps != null) {
                this.outputSteps.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(ITableauProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TableauFlow.TableauFlowBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputFields=" + this.inputFields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFields=" + this.outputFields + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputSteps=" + this.outputSteps + ", project=" + this.project + ", projectHierarchy=" + this.projectHierarchy + ", projectQualifiedName=" + this.projectQualifiedName + ", siteQualifiedName=" + this.siteQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ")";
        }
    }
}

