/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IThoughtspot;
import com.atlan.model.assets.IThoughtspotAnswer;
import com.atlan.model.core.AssetFilter;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.QueryFactory;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThoughtspotAnswer
extends Asset
implements IThoughtspotAnswer,
IThoughtspot,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThoughtspotAnswer.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ThoughtspotAnswer";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    String thoughtspotChartType;
    @Attribute
    String thoughtspotQuestionText;

    @Override
    public ThoughtspotAnswer trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ThoughtspotAnswer.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ThoughtspotAnswer.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ThoughtspotAnswer.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ThoughtspotAnswer.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ThoughtspotAnswer.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ThoughtspotAnswer.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(CompoundQuery.assetType(TYPE_NAME));
        if (!includeArchived) {
            builder.where(CompoundQuery.ACTIVE);
        }
        return builder;
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all() {
        return ThoughtspotAnswer.all(Atlan.getDefaultClient());
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client) {
        return ThoughtspotAnswer.all(client, false);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(boolean includeArchived) {
        return ThoughtspotAnswer.all(Atlan.getDefaultClient(), includeArchived);
    }

    @Deprecated
    public static AssetFilter.AssetFilterBuilder all(AtlanClient client, boolean includeArchived) {
        AssetFilter.AssetFilterBuilder builder = AssetFilter.builder().client(client).filter(QueryFactory.type(TYPE_NAME));
        if (!includeArchived) {
            builder.filter(QueryFactory.active());
        }
        return builder;
    }

    public static ThoughtspotAnswer refByGuid(String guid) {
        return ((ThoughtspotAnswerBuilder)ThoughtspotAnswer._internal().guid(guid)).build();
    }

    public static ThoughtspotAnswer refByQualifiedName(String qualifiedName) {
        return ((ThoughtspotAnswerBuilder)ThoughtspotAnswer._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    @JsonIgnore
    public static ThoughtspotAnswer get(String id) throws AtlanException {
        return ThoughtspotAnswer.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ThoughtspotAnswer get(AtlanClient client, String id) throws AtlanException {
        return ThoughtspotAnswer.get(client, id, true);
    }

    @JsonIgnore
    public static ThoughtspotAnswer get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ThoughtspotAnswer) {
                return (ThoughtspotAnswer)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ThoughtspotAnswer) {
            return (ThoughtspotAnswer)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @Deprecated
    public static ThoughtspotAnswer retrieveByGuid(String guid) throws AtlanException {
        return ThoughtspotAnswer.get(Atlan.getDefaultClient(), guid);
    }

    @Deprecated
    public static ThoughtspotAnswer retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return ThoughtspotAnswer.get(client, guid);
    }

    @Deprecated
    public static ThoughtspotAnswer retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        return ThoughtspotAnswer.get(Atlan.getDefaultClient(), qualifiedName);
    }

    @Deprecated
    public static ThoughtspotAnswer retrieveByQualifiedName(AtlanClient client, String qualifiedName) throws AtlanException {
        return ThoughtspotAnswer.get(client, qualifiedName);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ThoughtspotAnswer.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ThoughtspotAnswerBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ThoughtspotAnswerBuilder)((ThoughtspotAnswerBuilder)((ThoughtspotAnswerBuilder)ThoughtspotAnswer._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ThoughtspotAnswerBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ArrayList<String> missing = new ArrayList<String>();
        if (this.getQualifiedName() == null || this.getQualifiedName().length() == 0) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, String.join((CharSequence)",", missing));
        }
        return ThoughtspotAnswer.updater(this.getQualifiedName(), this.getName());
    }

    public static ThoughtspotAnswer removeDescription(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotAnswer.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotAnswer removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotAnswer)Asset.removeDescription(client, ThoughtspotAnswer.updater(qualifiedName, name));
    }

    public static ThoughtspotAnswer removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotAnswer.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotAnswer removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotAnswer)Asset.removeUserDescription(client, ThoughtspotAnswer.updater(qualifiedName, name));
    }

    public static ThoughtspotAnswer removeOwners(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotAnswer.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotAnswer removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotAnswer)Asset.removeOwners(client, ThoughtspotAnswer.updater(qualifiedName, name));
    }

    public static ThoughtspotAnswer updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ThoughtspotAnswer.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ThoughtspotAnswer updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ThoughtspotAnswer)Asset.updateCertificate(client, ThoughtspotAnswer._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ThoughtspotAnswer removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotAnswer.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotAnswer removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotAnswer)Asset.removeCertificate(client, ThoughtspotAnswer.updater(qualifiedName, name));
    }

    public static ThoughtspotAnswer updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ThoughtspotAnswer.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ThoughtspotAnswer updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ThoughtspotAnswer)Asset.updateAnnouncement(client, ThoughtspotAnswer._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ThoughtspotAnswer removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotAnswer.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotAnswer removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotAnswer)Asset.removeAnnouncement(client, ThoughtspotAnswer.updater(qualifiedName, name));
    }

    public static ThoughtspotAnswer replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotAnswer.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ThoughtspotAnswer replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotAnswer)Asset.replaceTerms(client, ThoughtspotAnswer.updater(qualifiedName, name), terms);
    }

    public static ThoughtspotAnswer appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotAnswer.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ThoughtspotAnswer appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotAnswer)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ThoughtspotAnswer removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotAnswer.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ThoughtspotAnswer removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotAnswer)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ThoughtspotAnswer appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ThoughtspotAnswer.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ThoughtspotAnswer appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ThoughtspotAnswer)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ThoughtspotAnswer appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ThoughtspotAnswer.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ThoughtspotAnswer appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ThoughtspotAnswer)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        ThoughtspotAnswer.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static void addAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        ThoughtspotAnswer.addAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void addAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        Asset.addAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ThoughtspotAnswer.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ThoughtspotAnswer(ThoughtspotAnswerBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ThoughtspotAnswer.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        this.thoughtspotChartType = b.thoughtspotChartType;
        this.thoughtspotQuestionText = b.thoughtspotQuestionText;
    }

    @Generated
    public static ThoughtspotAnswerBuilder<?, ?> _internal() {
        return new ThoughtspotAnswerBuilderImpl();
    }

    @Generated
    public ThoughtspotAnswerBuilder<?, ?> toBuilder() {
        return new ThoughtspotAnswerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public String getThoughtspotChartType() {
        return this.thoughtspotChartType;
    }

    @Override
    @Generated
    public String getThoughtspotQuestionText() {
        return this.thoughtspotQuestionText;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThoughtspotAnswer)) {
            return false;
        }
        ThoughtspotAnswer other = (ThoughtspotAnswer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        String this$thoughtspotChartType = this.getThoughtspotChartType();
        String other$thoughtspotChartType = other.getThoughtspotChartType();
        if (this$thoughtspotChartType == null ? other$thoughtspotChartType != null : !this$thoughtspotChartType.equals(other$thoughtspotChartType)) {
            return false;
        }
        String this$thoughtspotQuestionText = this.getThoughtspotQuestionText();
        String other$thoughtspotQuestionText = other.getThoughtspotQuestionText();
        return !(this$thoughtspotQuestionText == null ? other$thoughtspotQuestionText != null : !this$thoughtspotQuestionText.equals(other$thoughtspotQuestionText));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ThoughtspotAnswer;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        String $thoughtspotChartType = this.getThoughtspotChartType();
        result = result * 59 + ($thoughtspotChartType == null ? 43 : $thoughtspotChartType.hashCode());
        String $thoughtspotQuestionText = this.getThoughtspotQuestionText();
        result = result * 59 + ($thoughtspotQuestionText == null ? 43 : $thoughtspotQuestionText.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ThoughtspotAnswer(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", thoughtspotChartType=" + this.getThoughtspotChartType() + ", thoughtspotQuestionText=" + this.getThoughtspotQuestionText() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    private static final class ThoughtspotAnswerBuilderImpl
    extends ThoughtspotAnswerBuilder<ThoughtspotAnswer, ThoughtspotAnswerBuilderImpl> {
        @Generated
        private ThoughtspotAnswerBuilderImpl() {
        }

        @Override
        @Generated
        protected ThoughtspotAnswerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ThoughtspotAnswer build() {
            return new ThoughtspotAnswer(this);
        }
    }

    @Generated
    public static abstract class ThoughtspotAnswerBuilder<C extends ThoughtspotAnswer, B extends ThoughtspotAnswerBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private String thoughtspotChartType;
        @Generated
        private String thoughtspotQuestionText;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ThoughtspotAnswerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ThoughtspotAnswer instance, ThoughtspotAnswerBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.thoughtspotChartType(instance.thoughtspotChartType);
            b.thoughtspotQuestionText(instance.thoughtspotQuestionText);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B thoughtspotChartType(String thoughtspotChartType) {
            this.thoughtspotChartType = thoughtspotChartType;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotQuestionText(String thoughtspotQuestionText) {
            this.thoughtspotQuestionText = thoughtspotQuestionText;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ThoughtspotAnswer.ThoughtspotAnswerBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", thoughtspotChartType=" + this.thoughtspotChartType + ", thoughtspotQuestionText=" + this.thoughtspotQuestionText + ")";
        }
    }
}

