/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.core;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.util.QueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

@Deprecated
public class AssetFilter {
    AtlanClient client;
    List<Query> filters;
    List<Query> excludes;
    List<SortOptions> sorts;
    Integer batch;
    List<String> attributes;
    List<String> relationAttributes;

    @Generated
    AssetFilter(AtlanClient client, List<Query> filters, List<Query> excludes, List<SortOptions> sorts, Integer batch, List<String> attributes, List<String> relationAttributes) {
        this.client = client;
        this.filters = filters;
        this.excludes = excludes;
        this.sorts = sorts;
        this.batch = batch;
        this.attributes = attributes;
        this.relationAttributes = relationAttributes;
    }

    @Generated
    public static AssetFilterBuilder builder() {
        return new AssetFilterBuilder();
    }

    public static class AssetFilterBuilder {
        @Generated
        private AtlanClient client;
        @Generated
        private ArrayList<Query> filters;
        @Generated
        private ArrayList<Query> excludes;
        @Generated
        private ArrayList<SortOptions> sorts;
        @Generated
        private Integer batch;
        @Generated
        private ArrayList<String> attributes;
        @Generated
        private ArrayList<String> relationAttributes;

        public long count() throws AtlanException {
            if (this.client == null) {
                throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
            }
            QueryFactory.CompoundQuery.CompoundQueryBuilder query = QueryFactory.CompoundQuery.builder();
            if (this.filters != null) {
                query.musts(this.filters);
            }
            if (this.excludes != null) {
                query.mustNots(this.excludes);
            }
            Object dsl = IndexSearchDSL.builder(query.build()._toQuery()).size(1);
            IndexSearchRequest.IndexSearchRequestBuilder<?, ?> request = IndexSearchRequest.builder((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)dsl).build());
            return ((IndexSearchRequest)request.build()).search(this.client).getApproximateCount();
        }

        public Stream<Asset> stream() throws AtlanException {
            return this.stream(false);
        }

        public Stream<Asset> stream(boolean parallel) throws AtlanException {
            if (this.client == null) {
                throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
            }
            QueryFactory.CompoundQuery.CompoundQueryBuilder query = QueryFactory.CompoundQuery.builder();
            if (this.filters != null) {
                query.musts(this.filters);
            }
            if (this.excludes != null) {
                query.mustNots(this.excludes);
            }
            IndexSearchDSL.IndexSearchDSLBuilder<?, ?> dsl = IndexSearchDSL.builder(query.build()._toQuery());
            if (this.sorts != null) {
                dsl.sort(this.sorts);
            }
            if (this.batch == null) {
                this.batch = 50;
            }
            dsl.size(this.batch);
            IndexSearchRequest.IndexSearchRequestBuilder<?, ?> request = IndexSearchRequest.builder((IndexSearchDSL)dsl.build());
            if (this.attributes != null) {
                request.attributes(this.attributes);
            }
            if (this.relationAttributes != null) {
                request.relationAttributes(this.relationAttributes);
            }
            if (parallel) {
                return ((IndexSearchRequest)request.build()).search(this.client).parallelStream();
            }
            return ((IndexSearchRequest)request.build()).search(this.client).stream();
        }

        @Generated
        AssetFilterBuilder() {
        }

        @Generated
        public AssetFilterBuilder client(AtlanClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public AssetFilterBuilder filter(Query filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(filter);
            return this;
        }

        @Generated
        public AssetFilterBuilder filters(Collection<? extends Query> filters) {
            if (filters == null) {
                throw new NullPointerException("filters cannot be null");
            }
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.addAll(filters);
            return this;
        }

        @Generated
        public AssetFilterBuilder clearFilters() {
            if (this.filters != null) {
                this.filters.clear();
            }
            return this;
        }

        @Generated
        public AssetFilterBuilder exclude(Query exclude) {
            if (this.excludes == null) {
                this.excludes = new ArrayList();
            }
            this.excludes.add(exclude);
            return this;
        }

        @Generated
        public AssetFilterBuilder excludes(Collection<? extends Query> excludes) {
            if (excludes == null) {
                throw new NullPointerException("excludes cannot be null");
            }
            if (this.excludes == null) {
                this.excludes = new ArrayList();
            }
            this.excludes.addAll(excludes);
            return this;
        }

        @Generated
        public AssetFilterBuilder clearExcludes() {
            if (this.excludes != null) {
                this.excludes.clear();
            }
            return this;
        }

        @Generated
        public AssetFilterBuilder sort(SortOptions sort) {
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.add(sort);
            return this;
        }

        @Generated
        public AssetFilterBuilder sorts(Collection<? extends SortOptions> sorts) {
            if (sorts == null) {
                throw new NullPointerException("sorts cannot be null");
            }
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.addAll(sorts);
            return this;
        }

        @Generated
        public AssetFilterBuilder clearSorts() {
            if (this.sorts != null) {
                this.sorts.clear();
            }
            return this;
        }

        @Generated
        public AssetFilterBuilder batch(Integer batch) {
            this.batch = batch;
            return this;
        }

        @Generated
        public AssetFilterBuilder attribute(String attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return this;
        }

        @Generated
        public AssetFilterBuilder attributes(Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return this;
        }

        @Generated
        public AssetFilterBuilder clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return this;
        }

        @Generated
        public AssetFilterBuilder relationAttribute(String relationAttribute) {
            if (this.relationAttributes == null) {
                this.relationAttributes = new ArrayList();
            }
            this.relationAttributes.add(relationAttribute);
            return this;
        }

        @Generated
        public AssetFilterBuilder relationAttributes(Collection<? extends String> relationAttributes) {
            if (relationAttributes == null) {
                throw new NullPointerException("relationAttributes cannot be null");
            }
            if (this.relationAttributes == null) {
                this.relationAttributes = new ArrayList();
            }
            this.relationAttributes.addAll(relationAttributes);
            return this;
        }

        @Generated
        public AssetFilterBuilder clearRelationAttributes() {
            if (this.relationAttributes != null) {
                this.relationAttributes.clear();
            }
            return this;
        }

        @Generated
        public AssetFilter build() {
            List<String> relationAttributes;
            List<String> attributes;
            List<SortOptions> sorts;
            List<Query> excludes;
            List<Query> filters;
            switch (this.filters == null ? 0 : this.filters.size()) {
                case 0: {
                    filters = Collections.emptyList();
                    break;
                }
                case 1: {
                    filters = Collections.singletonList(this.filters.get(0));
                    break;
                }
                default: {
                    filters = Collections.unmodifiableList(new ArrayList<Query>(this.filters));
                }
            }
            switch (this.excludes == null ? 0 : this.excludes.size()) {
                case 0: {
                    excludes = Collections.emptyList();
                    break;
                }
                case 1: {
                    excludes = Collections.singletonList(this.excludes.get(0));
                    break;
                }
                default: {
                    excludes = Collections.unmodifiableList(new ArrayList<Query>(this.excludes));
                }
            }
            switch (this.sorts == null ? 0 : this.sorts.size()) {
                case 0: {
                    sorts = Collections.emptyList();
                    break;
                }
                case 1: {
                    sorts = Collections.singletonList(this.sorts.get(0));
                    break;
                }
                default: {
                    sorts = Collections.unmodifiableList(new ArrayList<SortOptions>(this.sorts));
                }
            }
            switch (this.attributes == null ? 0 : this.attributes.size()) {
                case 0: {
                    attributes = Collections.emptyList();
                    break;
                }
                case 1: {
                    attributes = Collections.singletonList(this.attributes.get(0));
                    break;
                }
                default: {
                    attributes = Collections.unmodifiableList(new ArrayList<String>(this.attributes));
                }
            }
            switch (this.relationAttributes == null ? 0 : this.relationAttributes.size()) {
                case 0: {
                    relationAttributes = Collections.emptyList();
                    break;
                }
                case 1: {
                    relationAttributes = Collections.singletonList(this.relationAttributes.get(0));
                    break;
                }
                default: {
                    relationAttributes = Collections.unmodifiableList(new ArrayList<String>(this.relationAttributes));
                }
            }
            return new AssetFilter(this.client, filters, excludes, sorts, this.batch, attributes, relationAttributes);
        }

        @Generated
        public String toString() {
            return "AssetFilter.AssetFilterBuilder(client=" + this.client + ", filters=" + this.filters + ", excludes=" + this.excludes + ", sorts=" + this.sorts + ", batch=" + this.batch + ", attributes=" + this.attributes + ", relationAttributes=" + this.relationAttributes + ")";
        }
    }
}

