/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.core;

import com.atlan.model.assets.Asset;
import com.atlan.model.core.MutatedAssets;
import com.atlan.net.ApiResource;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class AssetMutationResponse
extends ApiResource {
    private static final long serialVersionUID = 2L;
    @JsonProperty(value="mutatedEntities")
    MutatedAssets mutatedAssets;
    Map<String, String> guidAssignments;
    @JsonProperty(value="partialUpdatedEntities")
    List<Asset> partialUpdatedAssets;

    @JsonIgnore
    public List<Asset> getCreatedAssets() {
        return this.mutatedAssets == null ? Collections.emptyList() : this.sublist(this.mutatedAssets.getCREATE(), Asset.class);
    }

    @JsonIgnore
    public <T extends Asset> List<T> getCreatedAssets(Class<T> type) {
        return this.mutatedAssets == null ? Collections.emptyList() : this.sublist(this.mutatedAssets.getCREATE(), type);
    }

    @JsonIgnore
    public List<Asset> getUpdatedAssets() {
        return this.mutatedAssets == null ? Collections.emptyList() : this.sublist(this.mutatedAssets.getUPDATE(), Asset.class);
    }

    @JsonIgnore
    public <T extends Asset> List<T> getUpdatedAssets(Class<T> type) {
        return this.mutatedAssets == null ? Collections.emptyList() : this.sublist(this.mutatedAssets.getUPDATE(), type);
    }

    @JsonIgnore
    public List<Asset> getPartiallyUpdatedAssets() {
        return this.mutatedAssets == null ? Collections.emptyList() : this.sublist(this.mutatedAssets.getPARTIAL_UPDATE(), Asset.class);
    }

    @JsonIgnore
    public <T extends Asset> List<T> getPartiallyUpdatedAssets(Class<T> type) {
        return this.mutatedAssets == null ? Collections.emptyList() : this.sublist(this.mutatedAssets.getPARTIAL_UPDATE(), type);
    }

    @JsonIgnore
    public List<Asset> getDeletedAssets() {
        return this.mutatedAssets == null ? Collections.emptyList() : this.sublist(this.mutatedAssets.getDELETE(), Asset.class);
    }

    @JsonIgnore
    public <T extends Asset> List<T> getDeletedAssets(Class<T> type) {
        return this.mutatedAssets == null ? Collections.emptyList() : this.sublist(this.mutatedAssets.getDELETE(), type);
    }

    private <T extends Asset> List<T> sublist(List<Asset> list, Class<T> type) {
        if (type == Asset.class) {
            return list == null ? Collections.emptyList() : list;
        }
        return list == null ? Collections.emptyList() : list.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    @JsonIgnore
    public String getAssignedGuid(Asset input) {
        if (input == null || this.guidAssignments == null || this.guidAssignments.isEmpty()) {
            return null;
        }
        String guid = input.getGuid();
        return StringUtils.isUUID(guid) ? guid : (String)this.guidAssignments.getOrDefault(guid, null);
    }

    @JsonIgnore
    public MutationType getMutation(Asset input) {
        String guid = this.getAssignedGuid(input);
        MutationType type = MutationType.UNKNOWN;
        if (guid != null) {
            type = this.getCreatedAssets().stream().anyMatch(a -> guid.equals(a.getGuid())) ? MutationType.CREATED : (this.getUpdatedAssets().stream().anyMatch(a -> guid.equals(a.getGuid())) || this.getPartiallyUpdatedAssets().stream().anyMatch(a -> guid.equals(a.getGuid())) ? MutationType.UPDATED : (this.getDeletedAssets().stream().anyMatch(a -> guid.equals(a.getGuid())) ? MutationType.DELETED : MutationType.NOOP));
        }
        return type;
    }

    @JsonIgnore
    public <T extends Asset> T getResult(T input) {
        String guid = this.getAssignedGuid(input);
        List found = this.getCreatedAssets().stream().filter(a -> guid.equals(a.getGuid())).collect(Collectors.toList());
        if (found.isEmpty()) {
            found = this.getUpdatedAssets().stream().filter(a -> guid.equals(a.getGuid())).collect(Collectors.toList());
        }
        if (found.isEmpty()) {
            found = this.getPartiallyUpdatedAssets().stream().filter(a -> guid.equals(a.getGuid())).collect(Collectors.toList());
        }
        if (found.isEmpty()) {
            found = this.getDeletedAssets().stream().filter(a -> guid.equals(a.getGuid())).collect(Collectors.toList());
        }
        return (T)(found.isEmpty() ? null : (Asset)found.get(0));
    }

    @Generated
    public MutatedAssets getMutatedAssets() {
        return this.mutatedAssets;
    }

    @Generated
    public Map<String, String> getGuidAssignments() {
        return this.guidAssignments;
    }

    @Generated
    public List<Asset> getPartialUpdatedAssets() {
        return this.partialUpdatedAssets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetMutationResponse)) {
            return false;
        }
        AssetMutationResponse other = (AssetMutationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MutatedAssets this$mutatedAssets = this.getMutatedAssets();
        MutatedAssets other$mutatedAssets = other.getMutatedAssets();
        if (this$mutatedAssets == null ? other$mutatedAssets != null : !((Object)this$mutatedAssets).equals(other$mutatedAssets)) {
            return false;
        }
        Map<String, String> this$guidAssignments = this.getGuidAssignments();
        Map<String, String> other$guidAssignments = other.getGuidAssignments();
        if (this$guidAssignments == null ? other$guidAssignments != null : !((Object)this$guidAssignments).equals(other$guidAssignments)) {
            return false;
        }
        List<Asset> this$partialUpdatedAssets = this.getPartialUpdatedAssets();
        List<Asset> other$partialUpdatedAssets = other.getPartialUpdatedAssets();
        return !(this$partialUpdatedAssets == null ? other$partialUpdatedAssets != null : !((Object)this$partialUpdatedAssets).equals(other$partialUpdatedAssets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetMutationResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MutatedAssets $mutatedAssets = this.getMutatedAssets();
        result = result * 59 + ($mutatedAssets == null ? 43 : ((Object)$mutatedAssets).hashCode());
        Map<String, String> $guidAssignments = this.getGuidAssignments();
        result = result * 59 + ($guidAssignments == null ? 43 : ((Object)$guidAssignments).hashCode());
        List<Asset> $partialUpdatedAssets = this.getPartialUpdatedAssets();
        result = result * 59 + ($partialUpdatedAssets == null ? 43 : ((Object)$partialUpdatedAssets).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AssetMutationResponse(super=" + super.toString() + ", mutatedAssets=" + this.getMutatedAssets() + ", guidAssignments=" + this.getGuidAssignments() + ", partialUpdatedAssets=" + this.getPartialUpdatedAssets() + ")";
    }

    public static enum MutationType {
        CREATED,
        UPDATED,
        DELETED,
        NOOP,
        UNKNOWN;

    }
}

