/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.core;

import com.atlan.AtlanClient;
import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.PermissionException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AssetResponse;
import com.atlan.model.core.AtlanAsyncMutator;
import com.atlan.net.HttpClient;
import com.atlan.net.RequestOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCreationResponse
extends AssetMutationResponse
implements AtlanAsyncMutator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionCreationResponse.class);
    private static final long serialVersionUID = 2L;
    @JsonIgnore
    private transient AtlanClient client;

    @Override
    public AssetMutationResponse block() throws ApiException {
        List<Asset> toCheck = this.getCreatedAssets();
        if (toCheck != null && !toCheck.isEmpty()) {
            try {
                this.retrieveAndCheck(toCheck, 0);
            }
            catch (InterruptedException e) {
                throw new ApiException(ErrorCode.RETRIES_INTERRUPTED, (Throwable)e, new String[0]);
            }
        }
        return this;
    }

    private void retrieveAndCheck(List<Asset> toCheck, int retryCount) throws InterruptedException, ApiException {
        ArrayList<Asset> leftovers = new ArrayList<Asset>();
        for (Asset one : toCheck) {
            if (!(one instanceof Connection)) continue;
            try {
                AssetResponse candidate = this.client.assets.get(one.getGuid(), false, false, RequestOptions.from(this.client).maxNetworkRetries(20).build());
                if (candidate != null && candidate.getAsset() != null) continue;
                throw new ApiException(ErrorCode.RETRY_OVERRUN, null, new String[0]);
            }
            catch (PermissionException e) {
                throw new ApiException(ErrorCode.RETRY_OVERRUN, (Throwable)e, new String[0]);
            }
            catch (AtlanException e) {
                leftovers.add(one);
            }
        }
        if (!leftovers.isEmpty()) {
            if (retryCount == this.client.getMaxNetworkRetries()) {
                throw new ApiException(ErrorCode.RETRY_OVERRUN, null, new String[0]);
            }
            Thread.sleep(HttpClient.waitTime(retryCount).toMillis());
            this.retrieveAndCheck(leftovers, retryCount + 1);
        }
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionCreationResponse)) {
            return false;
        }
        ConnectionCreationResponse other = (ConnectionCreationResponse)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConnectionCreationResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "ConnectionCreationResponse(super=" + super.toString() + ", client=" + this.getClient() + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }
}

