/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.fields;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanEnum;
import com.atlan.model.fields.IBooleanSearchable;
import com.atlan.model.fields.IKeywordSearchable;
import com.atlan.model.fields.INumericallySearchable;
import com.atlan.model.fields.ITextSearchable;
import com.atlan.model.fields.SearchableField;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.util.TypeUtils;
import java.util.Collection;
import lombok.Generated;

public class CustomMetadataField
extends SearchableField {
    private final String setName;
    private final String attributeName;
    private final AttributeDef attributeDef;

    public CustomMetadataField(AtlanClient client, String setName, String attributeName) throws AtlanException {
        super(client.getCustomMetadataCache().getAttributeForSearchResults(setName, attributeName), client.getCustomMetadataCache().getAttrIdForName(setName, attributeName));
        this.setName = setName;
        this.attributeName = attributeName;
        this.attributeDef = client.getCustomMetadataCache().getAttributeDef(this.getElasticFieldName());
    }

    public static CustomMetadataField of(AtlanClient client, String set, String attr) throws AtlanException {
        return new CustomMetadataField(client, set, attr);
    }

    public Query startsWith(String value, boolean caseInsensitive) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.STRING)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "startsWith", this.setName + "." + this.attributeName);
        }
        return IKeywordSearchable.startsWith(this.getElasticFieldName(), value, caseInsensitive);
    }

    public Query eq(AtlanEnum value) throws InvalidRequestException {
        if (this.attributeDef.getEnumValues() != null && !this.attributeDef.getEnumValues().isEmpty()) {
            return this.eq(value.getValue(), false);
        }
        return IKeywordSearchable.eq(this.getElasticFieldName(), value);
    }

    public Query eq(boolean value) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.BOOLEAN)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "eq", this.setName + "." + this.attributeName);
        }
        return IBooleanSearchable.eq(this.getElasticFieldName(), value);
    }

    public Query eq(String value, boolean caseInsensitive) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.STRING)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "eq", this.setName + "." + this.attributeName);
        }
        return IKeywordSearchable.eq(this.getElasticFieldName(), value, caseInsensitive);
    }

    public Query in(Collection<String> values) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.STRING)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "in", this.setName + "." + this.attributeName);
        }
        return IKeywordSearchable.in(this.getElasticFieldName(), values);
    }

    public <T extends Number> Query eq(T value) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.NUMBER)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "eq", this.setName + "." + this.attributeName);
        }
        return INumericallySearchable.eq(this.getElasticFieldName(), value);
    }

    public <T extends Number> Query gt(T value) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.NUMBER)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "gt", this.setName + "." + this.attributeName);
        }
        return INumericallySearchable.gt(this.getElasticFieldName(), value);
    }

    public <T extends Number> Query gte(T value) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.NUMBER)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "gte", this.setName + "." + this.attributeName);
        }
        return INumericallySearchable.gte(this.getElasticFieldName(), value);
    }

    public <T extends Number> Query lt(T value) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.NUMBER)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "lt", this.setName + "." + this.attributeName);
        }
        return INumericallySearchable.lt(this.getElasticFieldName(), value);
    }

    public <T extends Number> Query lte(T value) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.NUMBER)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "lte", this.setName + "." + this.attributeName);
        }
        return INumericallySearchable.lte(this.getElasticFieldName(), value);
    }

    public <T extends Number> Query between(T min, T max) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.NUMBER)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "between", this.setName + "." + this.attributeName);
        }
        return INumericallySearchable.between(this.getElasticFieldName(), min, max);
    }

    public Query match(String value) throws InvalidRequestException {
        if (!TypeUtils.isComparable(this.attributeDef.getTypeName(), TypeUtils.ComparisonCategory.STRING)) {
            throw new InvalidRequestException(ErrorCode.INVALID_QUERY, "match", this.setName + "." + this.attributeName);
        }
        return ITextSearchable.match(this.getElasticFieldName(), value);
    }

    @Generated
    public String getSetName() {
        return this.setName;
    }

    @Generated
    public String getAttributeName() {
        return this.attributeName;
    }
}

