/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.fields;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.PrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import com.atlan.model.enums.AtlanEnum;
import java.util.ArrayList;
import java.util.Collection;

public interface IKeywordSearchable {
    public String getKeywordFieldName();

    default public Query startsWith(String value) {
        return this.startsWith(value, false);
    }

    public Query startsWith(String var1, boolean var2);

    public static Query startsWith(String field, String value, boolean caseInsensitive) {
        return PrefixQuery.of(t -> t.field(field).value(value).caseInsensitive(Boolean.valueOf(caseInsensitive)))._toQuery();
    }

    public Query eq(AtlanEnum var1);

    public static Query eq(String field, AtlanEnum value) {
        return TermQuery.of(t -> t.field(field).value(value.getValue()))._toQuery();
    }

    default public Query eq(String value) {
        return this.eq(value, false);
    }

    public Query eq(String var1, boolean var2);

    public static Query eq(String field, String value, boolean caseInsensitive) {
        return TermQuery.of(t -> t.field(field).value(value).caseInsensitive(Boolean.valueOf(caseInsensitive)))._toQuery();
    }

    public Query in(Collection<String> var1);

    public static Query in(String field, Collection<String> values) {
        ArrayList<FieldValue> list = new ArrayList<FieldValue>();
        for (String value : values) {
            list.add(FieldValue.of((String)value));
        }
        return TermsQuery.of(t -> t.field(field).terms(TermsQueryField.of(f -> f.value(list))))._toQuery();
    }
}

