/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.lineage;

import com.atlan.model.lineage.LineageRelation;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

class LineageGraph {
    private final Map<String, Set<DirectedPair>> downstreamList = new LinkedHashMap<String, Set<DirectedPair>>();
    private final Map<String, Set<DirectedPair>> upstreamList = new LinkedHashMap<String, Set<DirectedPair>>();

    private void addEdges(String sourceGuid, String processGuid, String targetGuid) {
        if (!this.downstreamList.containsKey(sourceGuid)) {
            this.downstreamList.put(sourceGuid, new LinkedHashSet());
        }
        if (!this.upstreamList.containsKey(targetGuid)) {
            this.upstreamList.put(targetGuid, new LinkedHashSet());
        }
        this.downstreamList.get(sourceGuid).add(new DirectedPair(processGuid, targetGuid));
        this.upstreamList.get(targetGuid).add(new DirectedPair(processGuid, sourceGuid));
    }

    public void addRelation(LineageRelation relation) {
        this.addEdges(relation.getFromEntityId(), relation.getProcessId(), relation.getToEntityId());
    }

    public Set<String> getDownstreamAssetGuids(String guid) {
        if (this.downstreamList.containsKey(guid)) {
            return this.downstreamList.get(guid).stream().map(DirectedPair::getTargetGuid).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public Set<String> getDownstreamProcessGuids(String guid) {
        if (this.downstreamList.containsKey(guid)) {
            return this.downstreamList.get(guid).stream().map(DirectedPair::getProcessGuid).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public List<String> getAllDownstreamAssetGuidsDFS(String guid) {
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push(guid);
        while (!stack.isEmpty()) {
            String toTraverse = (String)stack.pop();
            if (visited.contains(toTraverse)) continue;
            visited.add(toTraverse);
            Set<String> downstreamGuids = this.getDownstreamAssetGuids(toTraverse);
            for (String downstream : downstreamGuids) {
                if (visited.contains(downstream)) continue;
                stack.push(downstream);
            }
        }
        return List.copyOf(visited);
    }

    public Set<String> getUpstreamAssetGuids(String guid) {
        if (this.upstreamList.containsKey(guid)) {
            return this.upstreamList.get(guid).stream().map(DirectedPair::getTargetGuid).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public Set<String> getUpstreamProcessGuids(String guid) {
        if (this.upstreamList.containsKey(guid)) {
            return this.upstreamList.get(guid).stream().map(DirectedPair::getProcessGuid).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public List<String> getAllUpstreamAssetGuidsDFS(String guid) {
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push(guid);
        while (!stack.isEmpty()) {
            String toTraverse = (String)stack.pop();
            if (visited.contains(toTraverse)) continue;
            visited.add(toTraverse);
            Set<String> upstreamGuids = this.getUpstreamAssetGuids(toTraverse);
            for (String upstream : upstreamGuids) {
                if (visited.contains(upstream)) continue;
                stack.push(upstream);
            }
        }
        return List.copyOf(visited);
    }

    @Generated
    public String toString() {
        return "LineageGraph(super=" + super.toString() + ", downstreamList=" + this.downstreamList + ", upstreamList=" + this.upstreamList + ")";
    }

    static class DirectedPair {
        String processGuid;
        String targetGuid;

        DirectedPair(String processGuid, String targetGuid) {
            this.processGuid = processGuid;
            this.targetGuid = targetGuid;
        }

        @Generated
        public String getProcessGuid() {
            return this.processGuid;
        }

        @Generated
        public String getTargetGuid() {
            return this.targetGuid;
        }

        @Generated
        public String toString() {
            return "LineageGraph.DirectedPair(super=" + super.toString() + ", processGuid=" + this.getProcessGuid() + ", targetGuid=" + this.getTargetGuid() + ")";
        }
    }
}

