/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.lineage;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanLineageDirection;
import com.atlan.model.lineage.FilterList;
import com.atlan.model.lineage.LineageListResponse;
import com.atlan.model.relations.Reference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=LineageListRequestBuilderImpl.class)
public class LineageListRequest
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String guid;
    Integer depth;
    AtlanLineageDirection direction;
    FilterList entityFilters;
    FilterList entityTraversalFilters;
    FilterList relationshipTraversalFilters;
    List<String> attributes;
    Integer from;
    Integer size;
    Boolean excludeMeanings;
    @JsonProperty(value="excludeClassifications")
    Boolean excludeAtlanTags;

    public static LineageListRequestBuilder<?, ?> builder(Reference ref) {
        return LineageListRequest.builder(ref.getGuid());
    }

    public static LineageListRequestBuilder<?, ?> builder(String guid) {
        return LineageListRequest._internal().guid(guid);
    }

    public LineageListResponse fetch() throws AtlanException {
        return this.fetch(Atlan.getDefaultClient());
    }

    public LineageListResponse fetch(AtlanClient client) throws AtlanException {
        if (this.direction == AtlanLineageDirection.BOTH) {
            throw new InvalidRequestException(ErrorCode.INVALID_LINEAGE_DIRECTION);
        }
        return client.assets.lineage(this);
    }

    @Generated
    private static Integer $default$depth() {
        return 1000000;
    }

    @Generated
    private static AtlanLineageDirection $default$direction() {
        return AtlanLineageDirection.DOWNSTREAM;
    }

    @Generated
    private static Integer $default$from() {
        return 0;
    }

    @Generated
    private static Integer $default$size() {
        return 10;
    }

    @Generated
    private static Boolean $default$excludeMeanings() {
        return true;
    }

    @Generated
    private static Boolean $default$excludeAtlanTags() {
        return true;
    }

    @Generated
    protected LineageListRequest(LineageListRequestBuilder<?, ?> b) {
        super(b);
        List<Object> attributes;
        this.guid = b.guid;
        this.depth = b.depth$set ? b.depth$value : LineageListRequest.$default$depth();
        this.direction = b.direction$set ? b.direction$value : LineageListRequest.$default$direction();
        this.entityFilters = b.entityFilters;
        this.entityTraversalFilters = b.entityTraversalFilters;
        this.relationshipTraversalFilters = b.relationshipTraversalFilters;
        switch (b.attributes == null ? 0 : b.attributes.size()) {
            case 0: {
                attributes = Collections.emptyList();
                break;
            }
            case 1: {
                attributes = Collections.singletonList(b.attributes.get(0));
                break;
            }
            default: {
                attributes = Collections.unmodifiableList(new ArrayList<String>(b.attributes));
            }
        }
        this.attributes = attributes;
        this.from = b.from$set ? b.from$value : LineageListRequest.$default$from();
        this.size = b.size$set ? b.size$value : LineageListRequest.$default$size();
        this.excludeMeanings = b.excludeMeanings$set ? b.excludeMeanings$value : LineageListRequest.$default$excludeMeanings();
        this.excludeAtlanTags = b.excludeAtlanTags$set ? b.excludeAtlanTags$value : LineageListRequest.$default$excludeAtlanTags();
    }

    @Generated
    public static LineageListRequestBuilder<?, ?> _internal() {
        return new LineageListRequestBuilderImpl();
    }

    @Generated
    public LineageListRequestBuilder<?, ?> toBuilder() {
        return new LineageListRequestBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getGuid() {
        return this.guid;
    }

    @Generated
    public Integer getDepth() {
        return this.depth;
    }

    @Generated
    public AtlanLineageDirection getDirection() {
        return this.direction;
    }

    @Generated
    public FilterList getEntityFilters() {
        return this.entityFilters;
    }

    @Generated
    public FilterList getEntityTraversalFilters() {
        return this.entityTraversalFilters;
    }

    @Generated
    public FilterList getRelationshipTraversalFilters() {
        return this.relationshipTraversalFilters;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Integer getFrom() {
        return this.from;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }

    @Generated
    public Boolean getExcludeMeanings() {
        return this.excludeMeanings;
    }

    @Generated
    public Boolean getExcludeAtlanTags() {
        return this.excludeAtlanTags;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageListRequest)) {
            return false;
        }
        LineageListRequest other = (LineageListRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$depth = this.getDepth();
        Integer other$depth = other.getDepth();
        if (this$depth == null ? other$depth != null : !((Object)this$depth).equals(other$depth)) {
            return false;
        }
        Integer this$from = this.getFrom();
        Integer other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Boolean this$excludeMeanings = this.getExcludeMeanings();
        Boolean other$excludeMeanings = other.getExcludeMeanings();
        if (this$excludeMeanings == null ? other$excludeMeanings != null : !((Object)this$excludeMeanings).equals(other$excludeMeanings)) {
            return false;
        }
        Boolean this$excludeAtlanTags = this.getExcludeAtlanTags();
        Boolean other$excludeAtlanTags = other.getExcludeAtlanTags();
        if (this$excludeAtlanTags == null ? other$excludeAtlanTags != null : !((Object)this$excludeAtlanTags).equals(other$excludeAtlanTags)) {
            return false;
        }
        String this$guid = this.getGuid();
        String other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) {
            return false;
        }
        AtlanLineageDirection this$direction = this.getDirection();
        AtlanLineageDirection other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        FilterList this$entityFilters = this.getEntityFilters();
        FilterList other$entityFilters = other.getEntityFilters();
        if (this$entityFilters == null ? other$entityFilters != null : !((Object)this$entityFilters).equals(other$entityFilters)) {
            return false;
        }
        FilterList this$entityTraversalFilters = this.getEntityTraversalFilters();
        FilterList other$entityTraversalFilters = other.getEntityTraversalFilters();
        if (this$entityTraversalFilters == null ? other$entityTraversalFilters != null : !((Object)this$entityTraversalFilters).equals(other$entityTraversalFilters)) {
            return false;
        }
        FilterList this$relationshipTraversalFilters = this.getRelationshipTraversalFilters();
        FilterList other$relationshipTraversalFilters = other.getRelationshipTraversalFilters();
        if (this$relationshipTraversalFilters == null ? other$relationshipTraversalFilters != null : !((Object)this$relationshipTraversalFilters).equals(other$relationshipTraversalFilters)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LineageListRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $depth = this.getDepth();
        result = result * 59 + ($depth == null ? 43 : ((Object)$depth).hashCode());
        Integer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Boolean $excludeMeanings = this.getExcludeMeanings();
        result = result * 59 + ($excludeMeanings == null ? 43 : ((Object)$excludeMeanings).hashCode());
        Boolean $excludeAtlanTags = this.getExcludeAtlanTags();
        result = result * 59 + ($excludeAtlanTags == null ? 43 : ((Object)$excludeAtlanTags).hashCode());
        String $guid = this.getGuid();
        result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
        AtlanLineageDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        FilterList $entityFilters = this.getEntityFilters();
        result = result * 59 + ($entityFilters == null ? 43 : ((Object)$entityFilters).hashCode());
        FilterList $entityTraversalFilters = this.getEntityTraversalFilters();
        result = result * 59 + ($entityTraversalFilters == null ? 43 : ((Object)$entityTraversalFilters).hashCode());
        FilterList $relationshipTraversalFilters = this.getRelationshipTraversalFilters();
        result = result * 59 + ($relationshipTraversalFilters == null ? 43 : ((Object)$relationshipTraversalFilters).hashCode());
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LineageListRequest(super=" + super.toString() + ", guid=" + this.getGuid() + ", depth=" + this.getDepth() + ", direction=" + this.getDirection() + ", entityFilters=" + this.getEntityFilters() + ", entityTraversalFilters=" + this.getEntityTraversalFilters() + ", relationshipTraversalFilters=" + this.getRelationshipTraversalFilters() + ", attributes=" + this.getAttributes() + ", from=" + this.getFrom() + ", size=" + this.getSize() + ", excludeMeanings=" + this.getExcludeMeanings() + ", excludeAtlanTags=" + this.getExcludeAtlanTags() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class LineageListRequestBuilderImpl
    extends LineageListRequestBuilder<LineageListRequest, LineageListRequestBuilderImpl> {
        @Generated
        private LineageListRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected LineageListRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LineageListRequest build() {
            return new LineageListRequest(this);
        }
    }

    @Generated
    public static abstract class LineageListRequestBuilder<C extends LineageListRequest, B extends LineageListRequestBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String guid;
        @Generated
        private boolean depth$set;
        @Generated
        private Integer depth$value;
        @Generated
        private boolean direction$set;
        @Generated
        private AtlanLineageDirection direction$value;
        @Generated
        private FilterList entityFilters;
        @Generated
        private FilterList entityTraversalFilters;
        @Generated
        private FilterList relationshipTraversalFilters;
        @Generated
        private ArrayList<String> attributes;
        @Generated
        private boolean from$set;
        @Generated
        private Integer from$value;
        @Generated
        private boolean size$set;
        @Generated
        private Integer size$value;
        @Generated
        private boolean excludeMeanings$set;
        @Generated
        private Boolean excludeMeanings$value;
        @Generated
        private boolean excludeAtlanTags$set;
        @Generated
        private Boolean excludeAtlanTags$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LineageListRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LineageListRequest instance, LineageListRequestBuilder<?, ?> b) {
            b.guid(instance.guid);
            b.depth(instance.depth);
            b.direction(instance.direction);
            b.entityFilters(instance.entityFilters);
            b.entityTraversalFilters(instance.entityTraversalFilters);
            b.relationshipTraversalFilters(instance.relationshipTraversalFilters);
            b.attributes(instance.attributes == null ? Collections.emptyList() : instance.attributes);
            b.from(instance.from);
            b.size(instance.size);
            b.excludeMeanings(instance.excludeMeanings);
            b.excludeAtlanTags(instance.excludeAtlanTags);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B guid(String guid) {
            this.guid = guid;
            return (B)this.self();
        }

        @Generated
        public B depth(Integer depth) {
            this.depth$value = depth;
            this.depth$set = true;
            return (B)this.self();
        }

        @Generated
        public B direction(AtlanLineageDirection direction) {
            this.direction$value = direction;
            this.direction$set = true;
            return (B)this.self();
        }

        @Generated
        public B entityFilters(FilterList entityFilters) {
            this.entityFilters = entityFilters;
            return (B)this.self();
        }

        @Generated
        public B entityTraversalFilters(FilterList entityTraversalFilters) {
            this.entityTraversalFilters = entityTraversalFilters;
            return (B)this.self();
        }

        @Generated
        public B relationshipTraversalFilters(FilterList relationshipTraversalFilters) {
            this.relationshipTraversalFilters = relationshipTraversalFilters;
            return (B)this.self();
        }

        @Generated
        public B attribute(String attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return (B)this.self();
        }

        @Generated
        public B attributes(Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return (B)this.self();
        }

        @Generated
        public B clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B from(Integer from) {
            this.from$value = from;
            this.from$set = true;
            return (B)this.self();
        }

        @Generated
        public B size(Integer size) {
            this.size$value = size;
            this.size$set = true;
            return (B)this.self();
        }

        @Generated
        public B excludeMeanings(Boolean excludeMeanings) {
            this.excludeMeanings$value = excludeMeanings;
            this.excludeMeanings$set = true;
            return (B)this.self();
        }

        @JsonProperty(value="excludeClassifications")
        @Generated
        public B excludeAtlanTags(Boolean excludeAtlanTags) {
            this.excludeAtlanTags$value = excludeAtlanTags;
            this.excludeAtlanTags$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LineageListRequest.LineageListRequestBuilder(super=" + super.toString() + ", guid=" + this.guid + ", depth$value=" + this.depth$value + ", direction$value=" + this.direction$value + ", entityFilters=" + this.entityFilters + ", entityTraversalFilters=" + this.entityTraversalFilters + ", relationshipTraversalFilters=" + this.relationshipTraversalFilters + ", attributes=" + this.attributes + ", from$value=" + this.from$value + ", size$value=" + this.size$value + ", excludeMeanings$value=" + this.excludeMeanings$value + ", excludeAtlanTags$value=" + this.excludeAtlanTags$value + ")";
        }
    }
}

