/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.lineage;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.lineage.LineageListRequest;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

@JsonDeserialize(builder=LineageListResponseBuilder.class)
public class LineageListResponse
extends ApiResource
implements Iterable<Asset> {
    private static final long serialVersionUID = 2L;
    private static final int CHARACTERISTICS = 1296;
    @JsonIgnore
    AtlanClient client;
    @JsonProperty(value="entities")
    List<Asset> assets;
    Boolean hasMore;
    Integer entityCount;
    LineageListRequest searchParameters;

    @JsonIgnore
    public LineageListResponse getNextPage() throws AtlanException {
        int from = this.searchParameters.getFrom() == null ? 0 : this.searchParameters.getFrom();
        int page = this.searchParameters.getSize() == null ? 10 : this.searchParameters.getSize();
        AtlanObject nextRequest = ((LineageListRequest.LineageListRequestBuilder)this.searchParameters.toBuilder().from(from + page)).build();
        return ((LineageListRequest)nextRequest).fetch(this.client);
    }

    @Override
    public Iterator<Asset> iterator() {
        return new LineageListResponseIterator(this);
    }

    public Stream<Asset> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1296), false);
    }

    @Generated
    LineageListResponse(AtlanClient client, List<Asset> assets, Boolean hasMore, Integer entityCount, LineageListRequest searchParameters) {
        this.client = client;
        this.assets = assets;
        this.hasMore = hasMore;
        this.entityCount = entityCount;
        this.searchParameters = searchParameters;
    }

    @Generated
    public static LineageListResponseBuilder builder() {
        return new LineageListResponseBuilder();
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public List<Asset> getAssets() {
        return this.assets;
    }

    @Generated
    public Boolean getHasMore() {
        return this.hasMore;
    }

    @Generated
    public Integer getEntityCount() {
        return this.entityCount;
    }

    @Generated
    public LineageListRequest getSearchParameters() {
        return this.searchParameters;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageListResponse)) {
            return false;
        }
        LineageListResponse other = (LineageListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hasMore = this.getHasMore();
        Boolean other$hasMore = other.getHasMore();
        if (this$hasMore == null ? other$hasMore != null : !((Object)this$hasMore).equals(other$hasMore)) {
            return false;
        }
        Integer this$entityCount = this.getEntityCount();
        Integer other$entityCount = other.getEntityCount();
        if (this$entityCount == null ? other$entityCount != null : !((Object)this$entityCount).equals(other$entityCount)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        List<Asset> this$assets = this.getAssets();
        List<Asset> other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets)) {
            return false;
        }
        LineageListRequest this$searchParameters = this.getSearchParameters();
        LineageListRequest other$searchParameters = other.getSearchParameters();
        return !(this$searchParameters == null ? other$searchParameters != null : !((Object)this$searchParameters).equals(other$searchParameters));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LineageListResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hasMore = this.getHasMore();
        result = result * 59 + ($hasMore == null ? 43 : ((Object)$hasMore).hashCode());
        Integer $entityCount = this.getEntityCount();
        result = result * 59 + ($entityCount == null ? 43 : ((Object)$entityCount).hashCode());
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        List<Asset> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        LineageListRequest $searchParameters = this.getSearchParameters();
        result = result * 59 + ($searchParameters == null ? 43 : ((Object)$searchParameters).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LineageListResponse(super=" + super.toString() + ", client=" + this.getClient() + ", assets=" + this.getAssets() + ", hasMore=" + this.getHasMore() + ", entityCount=" + this.getEntityCount() + ", searchParameters=" + this.getSearchParameters() + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class LineageListResponseBuilder {
        @Generated
        private AtlanClient client;
        @Generated
        private List<Asset> assets;
        @Generated
        private Boolean hasMore;
        @Generated
        private Integer entityCount;
        @Generated
        private LineageListRequest searchParameters;

        @Generated
        LineageListResponseBuilder() {
        }

        @JsonIgnore
        @Generated
        public LineageListResponseBuilder client(AtlanClient client) {
            this.client = client;
            return this;
        }

        @JsonProperty(value="entities")
        @Generated
        public LineageListResponseBuilder assets(List<Asset> assets) {
            this.assets = assets;
            return this;
        }

        @Generated
        public LineageListResponseBuilder hasMore(Boolean hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        @Generated
        public LineageListResponseBuilder entityCount(Integer entityCount) {
            this.entityCount = entityCount;
            return this;
        }

        @Generated
        public LineageListResponseBuilder searchParameters(LineageListRequest searchParameters) {
            this.searchParameters = searchParameters;
            return this;
        }

        @Generated
        public LineageListResponse build() {
            return new LineageListResponse(this.client, this.assets, this.hasMore, this.entityCount, this.searchParameters);
        }

        @Generated
        public String toString() {
            return "LineageListResponse.LineageListResponseBuilder(client=" + this.client + ", assets=" + this.assets + ", hasMore=" + this.hasMore + ", entityCount=" + this.entityCount + ", searchParameters=" + this.searchParameters + ")";
        }
    }

    private static class LineageListResponseIterator
    implements Iterator<Asset> {
        private LineageListResponse response;
        private int i;

        public LineageListResponseIterator(LineageListResponse response) {
            this.response = response;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getAssets() != null && this.response.getAssets().size() > this.i) {
                return true;
            }
            if (!this.response.getHasMore().booleanValue()) {
                return false;
            }
            try {
                this.response = this.response.getNextPage();
                this.i = 0;
                return this.response.getAssets() != null && this.response.getAssets().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of lineage results.", e);
            }
        }

        @Override
        public Asset next() {
            return this.response.getAssets().get(this.i++);
        }
    }
}

