/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.lineage;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.enums.AtlanLineageDirection;
import com.atlan.model.lineage.LineageGraph;
import com.atlan.model.lineage.LineageRelation;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@JsonDeserialize(builder=LineageResponseBuilder.class)
public class LineageResponse
extends ApiResource {
    private static final long serialVersionUID = 2L;
    String baseEntityGuid;
    AtlanLineageDirection lineageDirection;
    Integer lineageDepth;
    Long limit;
    Long offset;
    Boolean hasMoreUpstreamVertices;
    Boolean hasMoreDownstreamVertices;
    @JsonProperty(value="guidEntityMap")
    Map<String, Asset> assetDetails;
    Set<LineageRelation> relations;
    @Deprecated
    Object childrenCounts;
    Object vertexChildrenInfo;
    @JsonIgnore
    private transient LineageGraph graph;

    @JsonIgnore
    private LineageGraph getGraph() throws InvalidRequestException {
        if (this.graph == null) {
            this.graph = new LineageGraph();
            for (LineageRelation relation : this.relations) {
                if (relation.isFullLink()) {
                    this.graph.addRelation(relation);
                    continue;
                }
                throw new InvalidRequestException(ErrorCode.NO_GRAPH_WITH_PROCESS);
            }
        }
        return this.graph;
    }

    @JsonIgnore
    public Set<String> getDownstreamAssetGuids() throws InvalidRequestException {
        return this.getDownstreamAssetGuids(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<Asset> getDownstreamAssets() throws InvalidRequestException {
        return this.getDownstreamAssets(this.baseEntityGuid);
    }

    @JsonIgnore
    public Set<String> getDownstreamProcessGuids() throws InvalidRequestException {
        return this.getDownstreamProcessGuids(this.baseEntityGuid);
    }

    @JsonIgnore
    public Set<String> getUpstreamAssetGuids() throws InvalidRequestException {
        return this.getUpstreamAssetGuids(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<Asset> getUpstreamAssets() throws InvalidRequestException {
        return this.getUpstreamAssets(this.baseEntityGuid);
    }

    @JsonIgnore
    public Set<String> getUpstreamProcessGuids() throws InvalidRequestException {
        return this.getUpstreamProcessGuids(this.baseEntityGuid);
    }

    @JsonIgnore
    public Set<String> getDownstreamAssetGuids(String guid) throws InvalidRequestException {
        return this.getGraph().getDownstreamAssetGuids(guid);
    }

    @JsonIgnore
    public Set<String> getDownstreamProcessGuids(String guid) throws InvalidRequestException {
        return this.getGraph().getDownstreamProcessGuids(guid);
    }

    @JsonIgnore
    public Set<String> getUpstreamAssetGuids(String guid) throws InvalidRequestException {
        return this.getGraph().getUpstreamAssetGuids(guid);
    }

    @JsonIgnore
    public Set<String> getUpstreamProcessGuids(String guid) throws InvalidRequestException {
        return this.getGraph().getUpstreamProcessGuids(guid);
    }

    @JsonIgnore
    public List<Asset> getDownstreamAssets(String guid) throws InvalidRequestException {
        ArrayList<Asset> downstream = new ArrayList<Asset>();
        Set<String> downstreamGuids = this.getDownstreamAssetGuids(guid);
        for (String downstreamGuid : downstreamGuids) {
            Asset one = this.assetDetails.get(downstreamGuid);
            if (one == null) continue;
            downstream.add(one);
        }
        return Collections.unmodifiableList(downstream);
    }

    @JsonIgnore
    public List<Asset> getUpstreamAssets(String guid) throws InvalidRequestException {
        ArrayList<Asset> upstream = new ArrayList<Asset>();
        Set<String> upstreamGuids = this.getUpstreamAssetGuids(guid);
        for (String upstreamGuid : upstreamGuids) {
            Asset one = this.assetDetails.get(upstreamGuid);
            if (one == null) continue;
            upstream.add(one);
        }
        return Collections.unmodifiableList(upstream);
    }

    @JsonIgnore
    public List<String> getAllDownstreamAssetGuidsDFS() throws InvalidRequestException {
        return this.getAllDownstreamAssetGuidsDFS(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<String> getAllDownstreamAssetGuidsDFS(String guid) throws InvalidRequestException {
        return this.getGraph().getAllDownstreamAssetGuidsDFS(guid);
    }

    @JsonIgnore
    public List<Asset> getAllDownstreamAssetsDFS() throws InvalidRequestException {
        return this.getAllDownstreamAssetsDFS(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<Asset> getAllDownstreamAssetsDFS(String guid) throws InvalidRequestException {
        ArrayList<Asset> downstream = new ArrayList<Asset>();
        List<String> downstreamGuids = this.getAllDownstreamAssetGuidsDFS(guid);
        for (String downstreamGuid : downstreamGuids) {
            Asset one = this.assetDetails.get(downstreamGuid);
            if (one == null) continue;
            downstream.add(one);
        }
        return Collections.unmodifiableList(downstream);
    }

    @JsonIgnore
    public List<String> getAllUpstreamAssetGuidsDFS() throws InvalidRequestException {
        return this.getAllUpstreamAssetGuidsDFS(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<String> getAllUpstreamAssetGuidsDFS(String guid) throws InvalidRequestException {
        return this.getGraph().getAllUpstreamAssetGuidsDFS(guid);
    }

    @JsonIgnore
    public List<Asset> getAllUpstreamAssetsDFS() throws InvalidRequestException {
        return this.getAllUpstreamAssetsDFS(this.baseEntityGuid);
    }

    @JsonIgnore
    public List<Asset> getAllUpstreamAssetsDFS(String guid) throws InvalidRequestException {
        ArrayList<Asset> upstream = new ArrayList<Asset>();
        List<String> upstreamGuids = this.getAllUpstreamAssetGuidsDFS(guid);
        for (String upstreamGuid : upstreamGuids) {
            Asset one = this.assetDetails.get(upstreamGuid);
            if (one == null) continue;
            upstream.add(one);
        }
        return Collections.unmodifiableList(upstream);
    }

    @Generated
    LineageResponse(String baseEntityGuid, AtlanLineageDirection lineageDirection, Integer lineageDepth, Long limit, Long offset, Boolean hasMoreUpstreamVertices, Boolean hasMoreDownstreamVertices, Map<String, Asset> assetDetails, Set<LineageRelation> relations, Object childrenCounts, Object vertexChildrenInfo, LineageGraph graph) {
        this.baseEntityGuid = baseEntityGuid;
        this.lineageDirection = lineageDirection;
        this.lineageDepth = lineageDepth;
        this.limit = limit;
        this.offset = offset;
        this.hasMoreUpstreamVertices = hasMoreUpstreamVertices;
        this.hasMoreDownstreamVertices = hasMoreDownstreamVertices;
        this.assetDetails = assetDetails;
        this.relations = relations;
        this.childrenCounts = childrenCounts;
        this.vertexChildrenInfo = vertexChildrenInfo;
        this.graph = graph;
    }

    @Generated
    public static LineageResponseBuilder builder() {
        return new LineageResponseBuilder();
    }

    @Generated
    public String getBaseEntityGuid() {
        return this.baseEntityGuid;
    }

    @Generated
    public AtlanLineageDirection getLineageDirection() {
        return this.lineageDirection;
    }

    @Generated
    public Integer getLineageDepth() {
        return this.lineageDepth;
    }

    @Generated
    public Long getLimit() {
        return this.limit;
    }

    @Generated
    public Long getOffset() {
        return this.offset;
    }

    @Generated
    public Boolean getHasMoreUpstreamVertices() {
        return this.hasMoreUpstreamVertices;
    }

    @Generated
    public Boolean getHasMoreDownstreamVertices() {
        return this.hasMoreDownstreamVertices;
    }

    @Generated
    public Map<String, Asset> getAssetDetails() {
        return this.assetDetails;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageResponse)) {
            return false;
        }
        LineageResponse other = (LineageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$lineageDepth = this.getLineageDepth();
        Integer other$lineageDepth = other.getLineageDepth();
        if (this$lineageDepth == null ? other$lineageDepth != null : !((Object)this$lineageDepth).equals(other$lineageDepth)) {
            return false;
        }
        Long this$limit = this.getLimit();
        Long other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Long this$offset = this.getOffset();
        Long other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Boolean this$hasMoreUpstreamVertices = this.getHasMoreUpstreamVertices();
        Boolean other$hasMoreUpstreamVertices = other.getHasMoreUpstreamVertices();
        if (this$hasMoreUpstreamVertices == null ? other$hasMoreUpstreamVertices != null : !((Object)this$hasMoreUpstreamVertices).equals(other$hasMoreUpstreamVertices)) {
            return false;
        }
        Boolean this$hasMoreDownstreamVertices = this.getHasMoreDownstreamVertices();
        Boolean other$hasMoreDownstreamVertices = other.getHasMoreDownstreamVertices();
        if (this$hasMoreDownstreamVertices == null ? other$hasMoreDownstreamVertices != null : !((Object)this$hasMoreDownstreamVertices).equals(other$hasMoreDownstreamVertices)) {
            return false;
        }
        String this$baseEntityGuid = this.getBaseEntityGuid();
        String other$baseEntityGuid = other.getBaseEntityGuid();
        if (this$baseEntityGuid == null ? other$baseEntityGuid != null : !this$baseEntityGuid.equals(other$baseEntityGuid)) {
            return false;
        }
        AtlanLineageDirection this$lineageDirection = this.getLineageDirection();
        AtlanLineageDirection other$lineageDirection = other.getLineageDirection();
        if (this$lineageDirection == null ? other$lineageDirection != null : !this$lineageDirection.equals(other$lineageDirection)) {
            return false;
        }
        Map<String, Asset> this$assetDetails = this.getAssetDetails();
        Map<String, Asset> other$assetDetails = other.getAssetDetails();
        if (this$assetDetails == null ? other$assetDetails != null : !((Object)this$assetDetails).equals(other$assetDetails)) {
            return false;
        }
        Set<LineageRelation> this$relations = this.getRelations();
        Set<LineageRelation> other$relations = other.getRelations();
        if (this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations)) {
            return false;
        }
        Object this$childrenCounts = this.getChildrenCounts();
        Object other$childrenCounts = other.getChildrenCounts();
        if (this$childrenCounts == null ? other$childrenCounts != null : !this$childrenCounts.equals(other$childrenCounts)) {
            return false;
        }
        Object this$vertexChildrenInfo = this.getVertexChildrenInfo();
        Object other$vertexChildrenInfo = other.getVertexChildrenInfo();
        return !(this$vertexChildrenInfo == null ? other$vertexChildrenInfo != null : !this$vertexChildrenInfo.equals(other$vertexChildrenInfo));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LineageResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $lineageDepth = this.getLineageDepth();
        result = result * 59 + ($lineageDepth == null ? 43 : ((Object)$lineageDepth).hashCode());
        Long $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Long $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Boolean $hasMoreUpstreamVertices = this.getHasMoreUpstreamVertices();
        result = result * 59 + ($hasMoreUpstreamVertices == null ? 43 : ((Object)$hasMoreUpstreamVertices).hashCode());
        Boolean $hasMoreDownstreamVertices = this.getHasMoreDownstreamVertices();
        result = result * 59 + ($hasMoreDownstreamVertices == null ? 43 : ((Object)$hasMoreDownstreamVertices).hashCode());
        String $baseEntityGuid = this.getBaseEntityGuid();
        result = result * 59 + ($baseEntityGuid == null ? 43 : $baseEntityGuid.hashCode());
        AtlanLineageDirection $lineageDirection = this.getLineageDirection();
        result = result * 59 + ($lineageDirection == null ? 43 : $lineageDirection.hashCode());
        Map<String, Asset> $assetDetails = this.getAssetDetails();
        result = result * 59 + ($assetDetails == null ? 43 : ((Object)$assetDetails).hashCode());
        Set<LineageRelation> $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        Object $childrenCounts = this.getChildrenCounts();
        result = result * 59 + ($childrenCounts == null ? 43 : $childrenCounts.hashCode());
        Object $vertexChildrenInfo = this.getVertexChildrenInfo();
        result = result * 59 + ($vertexChildrenInfo == null ? 43 : $vertexChildrenInfo.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LineageResponse(super=" + super.toString() + ", baseEntityGuid=" + this.getBaseEntityGuid() + ", lineageDirection=" + this.getLineageDirection() + ", lineageDepth=" + this.getLineageDepth() + ", limit=" + this.getLimit() + ", offset=" + this.getOffset() + ", hasMoreUpstreamVertices=" + this.getHasMoreUpstreamVertices() + ", hasMoreDownstreamVertices=" + this.getHasMoreDownstreamVertices() + ", assetDetails=" + this.getAssetDetails() + ", relations=" + this.getRelations() + ", childrenCounts=" + this.getChildrenCounts() + ", vertexChildrenInfo=" + this.getVertexChildrenInfo() + ")";
    }

    @Generated
    private Set<LineageRelation> getRelations() {
        return this.relations;
    }

    @Deprecated
    @Generated
    private Object getChildrenCounts() {
        return this.childrenCounts;
    }

    @Generated
    private Object getVertexChildrenInfo() {
        return this.vertexChildrenInfo;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class LineageResponseBuilder {
        @Generated
        private String baseEntityGuid;
        @Generated
        private AtlanLineageDirection lineageDirection;
        @Generated
        private Integer lineageDepth;
        @Generated
        private Long limit;
        @Generated
        private Long offset;
        @Generated
        private Boolean hasMoreUpstreamVertices;
        @Generated
        private Boolean hasMoreDownstreamVertices;
        @Generated
        private Map<String, Asset> assetDetails;
        @Generated
        private Set<LineageRelation> relations;
        @Generated
        private Object childrenCounts;
        @Generated
        private Object vertexChildrenInfo;
        @Generated
        private LineageGraph graph;

        @Generated
        LineageResponseBuilder() {
        }

        @Generated
        public LineageResponseBuilder baseEntityGuid(String baseEntityGuid) {
            this.baseEntityGuid = baseEntityGuid;
            return this;
        }

        @Generated
        public LineageResponseBuilder lineageDirection(AtlanLineageDirection lineageDirection) {
            this.lineageDirection = lineageDirection;
            return this;
        }

        @Generated
        public LineageResponseBuilder lineageDepth(Integer lineageDepth) {
            this.lineageDepth = lineageDepth;
            return this;
        }

        @Generated
        public LineageResponseBuilder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public LineageResponseBuilder offset(Long offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public LineageResponseBuilder hasMoreUpstreamVertices(Boolean hasMoreUpstreamVertices) {
            this.hasMoreUpstreamVertices = hasMoreUpstreamVertices;
            return this;
        }

        @Generated
        public LineageResponseBuilder hasMoreDownstreamVertices(Boolean hasMoreDownstreamVertices) {
            this.hasMoreDownstreamVertices = hasMoreDownstreamVertices;
            return this;
        }

        @JsonProperty(value="guidEntityMap")
        @Generated
        public LineageResponseBuilder assetDetails(Map<String, Asset> assetDetails) {
            this.assetDetails = assetDetails;
            return this;
        }

        @Generated
        public LineageResponseBuilder relations(Set<LineageRelation> relations) {
            this.relations = relations;
            return this;
        }

        @Deprecated
        @Generated
        public LineageResponseBuilder childrenCounts(Object childrenCounts) {
            this.childrenCounts = childrenCounts;
            return this;
        }

        @Generated
        public LineageResponseBuilder vertexChildrenInfo(Object vertexChildrenInfo) {
            this.vertexChildrenInfo = vertexChildrenInfo;
            return this;
        }

        @JsonIgnore
        @Generated
        public LineageResponseBuilder graph(LineageGraph graph) {
            this.graph = graph;
            return this;
        }

        @Generated
        public LineageResponse build() {
            return new LineageResponse(this.baseEntityGuid, this.lineageDirection, this.lineageDepth, this.limit, this.offset, this.hasMoreUpstreamVertices, this.hasMoreDownstreamVertices, this.assetDetails, this.relations, this.childrenCounts, this.vertexChildrenInfo, this.graph);
        }

        @Generated
        public String toString() {
            return "LineageResponse.LineageResponseBuilder(baseEntityGuid=" + this.baseEntityGuid + ", lineageDirection=" + this.lineageDirection + ", lineageDepth=" + this.lineageDepth + ", limit=" + this.limit + ", offset=" + this.offset + ", hasMoreUpstreamVertices=" + this.hasMoreUpstreamVertices + ", hasMoreDownstreamVertices=" + this.hasMoreDownstreamVertices + ", assetDetails=" + this.assetDetails + ", relations=" + this.relations + ", childrenCounts=" + this.childrenCounts + ", vertexChildrenInfo=" + this.vertexChildrenInfo + ", graph=" + this.graph + ")";
        }
    }
}

