/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCrawler {
    static Map<String, List<String>> buildHierarchicalFilter(Map<String, List<String>> rawFilter) {
        HashMap<String, List<String>> toInclude = new HashMap<String, List<String>>();
        if (rawFilter != null) {
            for (Map.Entry<String, List<String>> entry : rawFilter.entrySet()) {
                String dbName = entry.getKey();
                List<String> schemas = entry.getValue();
                ArrayList<CallSite> exactSchemas = new ArrayList<CallSite>();
                for (String schema : schemas) {
                    exactSchemas.add((CallSite)((Object)("^" + schema + "$")));
                }
                toInclude.put("^" + dbName + "$", exactSchemas);
            }
        }
        return toInclude;
    }

    static Map<String, Map<String, String>> buildFlatFilter(List<String> rawFilter) {
        HashMap<String, Map<String, String>> toInclude = new HashMap<String, Map<String, String>>();
        if (rawFilter != null) {
            for (String entry : rawFilter) {
                toInclude.put(entry, Collections.emptyMap());
            }
        }
        return toInclude;
    }

    static Map<String, Map<String, Map<String, String>>> buildDbtCloudFilter(Map<String, List<String>> rawFilter) {
        HashMap<String, Map<String, Map<String, String>>> toInclude = new HashMap<String, Map<String, Map<String, String>>>();
        if (rawFilter != null) {
            for (Map.Entry<String, List<String>> entry : rawFilter.entrySet()) {
                String accountId = entry.getKey();
                if (!toInclude.containsKey(accountId)) {
                    toInclude.put(accountId, new HashMap());
                }
                List<String> projects = entry.getValue();
                for (String projectId : projects) {
                    ((Map)toInclude.get(accountId)).put(projectId, Collections.emptyMap());
                }
            }
        }
        return toInclude;
    }
}

