/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowParameters;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DbtCrawler
extends AbstractCrawler {
    public static final String PREFIX = "atlan-dbt";

    public static Workflow mtCloudAuth(AtlanClient client, String connectionName, String apiToken) throws AtlanException {
        return DbtCrawler.mtCloudAuth(client, connectionName, apiToken, List.of(client.getRoleCache().getIdForName("$admin")), null, null, null, null, null);
    }

    public static Workflow mtCloudAuth(AtlanClient client, String connectionName, String apiToken, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, String includeAssets, String excludeAssets, String limitToConnection) throws AtlanException {
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.DBT, adminRoles, adminGroups, adminUsers).allowQuery(true)).allowQueryPreview(true)).rowLimit(10000L)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo("https://assets.atlan.com/assets/dbt-new.svg")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        HashMap<String, Object> credentialBody = new HashMap<String, Object>();
        credentialBody.put("name", "default-dbt-" + epoch + "-0");
        credentialBody.put("host", "https://cloud.getdbt.com");
        credentialBody.put("port", 443);
        credentialBody.put("authType", "token");
        credentialBody.put("username", "");
        credentialBody.put("password", apiToken);
        credentialBody.put("extra", Collections.emptyMap());
        credentialBody.put("connectorConfigName", "atlan-connectors-dbt");
        Object argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)WorkflowParameters.builder().parameter(NameValuePair.of("connection", connection.toJson(client)))).parameter(NameValuePair.of("extraction-method", "api"))).parameter(NameValuePair.of("deployment-type", "multi"))).parameter(NameValuePair.of("core-extraction-method", "s3"))).parameter(NameValuePair.of("api-credential-guid", "{{credentialGuid}}"))).parameter(NameValuePair.of("include-filter", includeAssets))).parameter(NameValuePair.of("exclude-filter", excludeAssets))).parameter(NameValuePair.of("include-filter-core", "*"))).parameter(NameValuePair.of("exclude-filter-core", "*"));
        if (limitToConnection != null && limitToConnection.length() > 0) {
            argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).parameter(NameValuePair.of("connection-qualified-name", limitToConnection));
        }
        return DbtCrawler.buildWorkflow(epoch, argsBuilder, List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(credentialBody).build()));
    }

    public static Workflow coreCrawler(AtlanClient client, String connectionName, String bucketName, String s3Prefix, String region, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, String includeAssets, String excludeAssets, String limitToConnection, boolean enrichMaterializedAssets) throws AtlanException {
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.DBT, adminRoles, adminGroups, adminUsers).allowQuery(true)).allowQueryPreview(true)).rowLimit(10000L)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo("https://assets.atlan.com/assets/dbt-new.svg")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        if (includeAssets == null) {
            includeAssets = "*";
        }
        if (excludeAssets == null) {
            excludeAssets = "*";
        }
        Object argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)WorkflowParameters.builder().parameter(NameValuePair.of("connection", connection.toJson(client)))).parameter(NameValuePair.of("extraction-method", "core"))).parameter(NameValuePair.of("deployment-type", "multi"))).parameter(NameValuePair.of("core-extraction-method", "s3"))).parameter(NameValuePair.of("core-extraction-s3-bucket", bucketName))).parameter(NameValuePair.of("core-extraction-s3-prefix", s3Prefix))).parameter(NameValuePair.of("core-extraction-s3-region", region))).parameter(NameValuePair.of("include-filter", "{}"))).parameter(NameValuePair.of("exclude-filter", "{}"))).parameter(NameValuePair.of("include-filter-core", includeAssets))).parameter(NameValuePair.of("exclude-filter-core", excludeAssets))).parameter(NameValuePair.of("enrich-materialised-sql-assets", enrichMaterializedAssets));
        if (limitToConnection != null && limitToConnection.length() > 0) {
            argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).parameter(NameValuePair.of("connection-qualified-name", limitToConnection));
        }
        return DbtCrawler.buildWorkflow(epoch, argsBuilder, Collections.emptyList());
    }

    private static Workflow buildWorkflow(String epoch, WorkflowParameters.WorkflowParametersBuilder<?, ?> argsBuilder, List<PackageParameter> payload) {
        String name = "atlan-dbt-" + epoch;
        String runName = "atlan-dbt-default-dbt-" + epoch;
        return ((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)Workflow.builder().metadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().label("orchestration.atlan.com/certified", "true")).label("orchestration.atlan.com/source", "dbt")).label("orchestration.atlan.com/sourceCategory", "elt")).label("orchestration.atlan.com/type", "connector")).label("orchestration.atlan.com/verified", "true")).label("package.argoproj.io/installer", "argopm")).label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hdbt")).label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")).label("orchestration.atlan.com/default-dbt-" + epoch, "true")).label("orchestration.atlan.com/atlan-ui", "true")).annotation("orchestration.atlan.com/allowSchedule", "true")).annotation("orchestration.atlan.com/dependentPackage", "")).annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6335824578705")).annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")).annotation("orchestration.atlan.com/icon", "https://assets.atlan.com/assets/dbt-new.svg")).annotation("orchestration.atlan.com/logo", "https://assets.atlan.com/assets/dbt-new.svg")).annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/dbt")).annotation("orchestration.atlan.com/name", "dbt Assets")).annotation("orchestration.atlan.com/usecase", "crawling")).annotation("package.argoproj.io/author", "Atlan")).annotation("package.argoproj.io/description", "Package to crawl dbt Assets and publish to Atlan for discovery.")).annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/dbt")).annotation("package.argoproj.io/keywords", "[\"connector\",\"crawler\",\"dbt\"]")).annotation("package.argoproj.io/name", "@atlan/dbt")).annotation("package.argoproj.io/registry", "https://packages.atlan.com")).annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git")).annotation("package.argoproj.io/support", "support@atlan.com")).annotation("orchestration.atlan.com/atlanName", runName)).name(name)).namespace("default")).build())).spec((WorkflowSpec)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)WorkflowSpec.builder().templates(List.of(((WorkflowTemplate.WorkflowTemplateBuilder)((WorkflowTemplate.WorkflowTemplateBuilder)WorkflowTemplate.builder().name("main")).dag((WorkflowDAG)((WorkflowDAG.WorkflowDAGBuilder)WorkflowDAG.builder().task((WorkflowTask)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)WorkflowTask.builder().name("run")).arguments((WorkflowParameters)argsBuilder.build())).templateRef((WorkflowTemplateRef)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)WorkflowTemplateRef.builder().name(PREFIX)).template("main")).clusterScope(true)).build())).build())).build())).build()))).entrypoint("main")).workflowMetadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().annotation("package.argoproj.io/name", "@atlan/dbt")).build())).build())).payload(payload)).build();
    }
}

