/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowParameters;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostgreSQLCrawler
extends AbstractCrawler {
    public static final String PREFIX = "atlan-postgres";

    public static Workflow directBasicAuth(AtlanClient client, String connectionName, String hostname, String username, String password, String database) throws AtlanException {
        return PostgreSQLCrawler.directBasicAuth(client, connectionName, hostname, 5432, username, password, database, List.of(client.getRoleCache().getIdForName("$admin")), null, null, true, true, 10000L, null, null);
    }

    public static Workflow directBasicAuth(AtlanClient client, String connectionName, String hostname, int port, String username, String password, String database, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, boolean allowQuery, boolean allowQueryPreview, long rowLimit, Map<String, List<String>> includeAssets, Map<String, List<String>> excludeAssets) throws AtlanException {
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.POSTGRES, adminRoles, adminGroups, adminUsers).allowQuery(allowQuery)).allowQueryPreview(allowQueryPreview)).rowLimit(rowLimit)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo("https://www.postgresql.org/media/img/about/press/elephant.png")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        HashMap<String, Object> credentialBody = new HashMap<String, Object>();
        credentialBody.put("name", "default-postgres-" + epoch + "-0");
        credentialBody.put("host", hostname);
        credentialBody.put("port", port);
        credentialBody.put("authType", "basic");
        credentialBody.put("username", username);
        credentialBody.put("password", password);
        credentialBody.put("extra", Map.of("database", database));
        credentialBody.put("connectorConfigName", "atlan-connectors-postgres");
        Map<String, List<String>> toInclude = PostgreSQLCrawler.buildHierarchicalFilter(includeAssets);
        Map<String, List<String>> toExclude = PostgreSQLCrawler.buildHierarchicalFilter(excludeAssets);
        Object argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)WorkflowParameters.builder().parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("credential-guid")).value("{{credentialGuid}}")).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("connection")).value(connection.toJson(client))).build());
        try {
            if (!toInclude.isEmpty()) {
                argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("include-filter")).value(Serde.allInclusiveMapper.writeValueAsString(toInclude))).build());
            }
            if (!toExclude.isEmpty()) {
                argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("exclude-filter")).value(Serde.allInclusiveMapper.writeValueAsString(toExclude))).build());
            }
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
        }
        argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("publish-mode")).value("production")).build())).parameter((NameValuePair)((NameValuePair.NameValuePairBuilder)((NameValuePair.NameValuePairBuilder)NameValuePair.builder().name("extraction-method")).value("direct")).build());
        String atlanName = "atlan-postgres-default-postgres-" + epoch;
        String runName = "atlan-postgres-" + epoch;
        return ((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)Workflow.builder().metadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().label("orchestration.atlan.com/certified", "true")).label("orchestration.atlan.com/source", "postgres")).label("orchestration.atlan.com/sourceCategory", "database")).label("orchestration.atlan.com/type", "connector")).label("orchestration.atlan.com/verified", "true")).label("package.argoproj.io/installer", "argopm")).label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hpostgres")).label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")).label("orchestration.atlan.com/default-postgres-" + epoch, "true")).label("orchestration.atlan.com/atlan-ui", "true")).annotation("orchestration.atlan.com/allowSchedule", "true")).annotation("orchestration.atlan.com/categories", "postgres,crawler")).annotation("orchestration.atlan.com/dependentPackage", "")).annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6329557275793")).annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")).annotation("orchestration.atlan.com/icon", "https://www.postgresql.org/media/img/about/press/elephant.png")).annotation("orchestration.atlan.com/logo", "https://www.postgresql.org/media/img/about/press/elephant.png")).annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/postgres")).annotation("orchestration.atlan.com/name", "Postgres Assets")).annotation("package.argoproj.io/author", "Atlan")).annotation("package.argoproj.io/description", "Package to crawl PostgreSQL assets and publish to Atlan for discovery")).annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/postgres")).annotation("package.argoproj.io/keywords", "[\"postgres\",\"database\",\"sql\",\"connector\",\"crawler\"]")).annotation("package.argoproj.io/name", "@atlan/postgres")).annotation("package.argoproj.io/registry", "https://packages.atlan.com")).annotation("package.argoproj.io/support", "support@atlan.com")).annotation("orchestration.atlan.com/atlanName", atlanName)).name(runName)).namespace("default")).build())).spec((WorkflowSpec)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)WorkflowSpec.builder().templates(List.of(((WorkflowTemplate.WorkflowTemplateBuilder)((WorkflowTemplate.WorkflowTemplateBuilder)WorkflowTemplate.builder().name("main")).dag((WorkflowDAG)((WorkflowDAG.WorkflowDAGBuilder)WorkflowDAG.builder().task((WorkflowTask)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)WorkflowTask.builder().name("run")).arguments((WorkflowParameters)((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).build())).templateRef((WorkflowTemplateRef)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)WorkflowTemplateRef.builder().name(PREFIX)).template("main")).clusterScope(true)).build())).build())).build())).build()))).entrypoint("main")).workflowMetadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().annotation("package.argoproj.io/name", "@atlan/postgres")).build())).build())).payload(List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(credentialBody).build()))).build();
    }
}

