/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowParameters;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SigmaCrawler
extends AbstractCrawler {
    public static final String PREFIX = "atlan-sigma";

    public static Workflow tokenBased(AtlanClient client, String connectionName, String hostname, String clientId, String apiToken) throws AtlanException {
        return SigmaCrawler.tokenBased(client, connectionName, hostname, 443, clientId, apiToken, List.of(client.getRoleCache().getIdForName("$admin")), null, null, "{}", "{}");
    }

    public static Workflow tokenBased(AtlanClient client, String connectionName, String hostname, int port, String clientId, String apiToken, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, String includeFilter, String excludeFilter) throws AtlanException {
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.SIGMA, adminRoles, adminGroups, adminUsers).allowQuery(true)).allowQueryPreview(true)).rowLimit(10000L)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo("http://assets.atlan.com/assets/sigma.svg")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        HashMap<String, Object> credentialBody = new HashMap<String, Object>();
        credentialBody.put("name", "default-sigma-" + epoch + "-0");
        credentialBody.put("host", hostname);
        credentialBody.put("port", port);
        credentialBody.put("authType", "api_token");
        credentialBody.put("username", clientId);
        credentialBody.put("password", apiToken);
        credentialBody.put("extra", Collections.emptyMap());
        credentialBody.put("connectorConfigName", "atlan-connectors-sigma");
        Object argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)WorkflowParameters.builder().parameter(NameValuePair.of("credential-guid", "{{credentialGuid}}"))).parameter(NameValuePair.of("atlas-auth-type", "internal"))).parameter(NameValuePair.of("include-filter", includeFilter))).parameter(NameValuePair.of("exclude-filter", excludeFilter))).parameter(NameValuePair.of("connection", connection.toJson(client)))).parameter(NameValuePair.of("publish-mode", "production"));
        String atlanName = "atlan-sigma-default-sigma-" + epoch;
        String runName = "atlan-sigma-" + epoch;
        return ((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)Workflow.builder().metadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().label("orchestration.atlan.com/certified", "true")).label("orchestration.atlan.com/source", "sigma")).label("orchestration.atlan.com/sourceCategory", "bi")).label("orchestration.atlan.com/type", "connector")).label("orchestration.atlan.com/verified", "true")).label("package.argoproj.io/installer", "argopm")).label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hsigma")).label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")).label("orchestration.atlan.com/default-sigma-" + epoch, "true")).label("orchestration.atlan.com/atlan-ui", "true")).annotation("orchestration.atlan.com/allowSchedule", "true")).annotation("orchestration.atlan.com/categories", "sigma,crawler")).annotation("orchestration.atlan.com/dependentPackage", "")).annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/8731744918813")).annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")).annotation("orchestration.atlan.com/icon", "http://assets.atlan.com/assets/sigma.svg")).annotation("orchestration.atlan.com/logo", "http://assets.atlan.com/assets/sigma.svg")).annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/sigma")).annotation("orchestration.atlan.com/name", "Sigma Assets")).annotation("package.argoproj.io/author", "Atlan")).annotation("package.argoproj.io/description", "Package to crawl Sigma assets and publish to Atlan for discovery")).annotation("package.argoproj.io/homepage", "https://github.com/atlanhq/marketplace-packages#readme")).annotation("package.argoproj.io/keywords", "[\"sigma\",\"bi\",\"connector\",\"crawler\"]")).annotation("package.argoproj.io/name", "@atlan/sigma")).annotation("package.argoproj.io/registry", "https://packages.atlan.com")).annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git")).annotation("package.argoproj.io/support", "support@atlan.com")).annotation("orchestration.atlan.com/atlanName", atlanName)).name(runName)).namespace("default")).build())).spec((WorkflowSpec)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)WorkflowSpec.builder().templates(List.of(((WorkflowTemplate.WorkflowTemplateBuilder)((WorkflowTemplate.WorkflowTemplateBuilder)WorkflowTemplate.builder().name("main")).dag((WorkflowDAG)((WorkflowDAG.WorkflowDAGBuilder)WorkflowDAG.builder().task((WorkflowTask)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)WorkflowTask.builder().name("run")).arguments((WorkflowParameters)((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).build())).templateRef((WorkflowTemplateRef)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)WorkflowTemplateRef.builder().name(PREFIX)).template("main")).clusterScope(true)).build())).build())).build())).build()))).entrypoint("main")).workflowMetadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().annotation("package.argoproj.io/name", "@atlan/sigma")).build())).build())).payload(List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(credentialBody).build()))).build();
    }
}

