/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowParameters;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SnowflakeCrawler
extends AbstractCrawler {
    public static final String PREFIX = "atlan-snowflake";

    public static Workflow infoSchemaBasicAuth(AtlanClient client, String connectionName, String hostname, String username, String password, String role, String warehouse) throws AtlanException {
        return SnowflakeCrawler.infoSchemaBasicAuth(client, connectionName, hostname, 443, username, password, role, warehouse, List.of(client.getRoleCache().getIdForName("$admin")), null, null, true, true, 10000L, null, null);
    }

    public static Workflow infoSchemaBasicAuth(AtlanClient client, String connectionName, String hostname, int port, String username, String password, String role, String warehouse, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, boolean allowQuery, boolean allowQueryPreview, long rowLimit, Map<String, List<String>> includeAssets, Map<String, List<String>> excludeAssets) throws AtlanException {
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.SNOWFLAKE, adminRoles, adminGroups, adminUsers).allowQuery(allowQuery)).allowQueryPreview(allowQueryPreview)).rowLimit(rowLimit)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo("https://docs.snowflake.com/en/_images/logo-snowflake-sans-text.png")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        HashMap<String, Object> credentialBody = new HashMap<String, Object>();
        credentialBody.put("name", "default-snowflake-" + epoch + "-0");
        credentialBody.put("host", hostname);
        credentialBody.put("port", port);
        credentialBody.put("authType", "basic");
        credentialBody.put("username", username);
        credentialBody.put("password", password);
        credentialBody.put("extra", Map.of("role", role, "warehouse", warehouse));
        credentialBody.put("connectorConfigName", "atlan-connectors-snowflake");
        Map<String, List<String>> toInclude = SnowflakeCrawler.buildHierarchicalFilter(includeAssets);
        Map<String, List<String>> toExclude = SnowflakeCrawler.buildHierarchicalFilter(excludeAssets);
        Object argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)WorkflowParameters.builder().parameter(NameValuePair.of("credential-guid", "{{credentialGuid}}"))).parameter(NameValuePair.of("extract-strategy", "information-schema"))).parameter(NameValuePair.of("account-usage-database-name", "SNOWFLAKE"))).parameter(NameValuePair.of("account-usage-schema-name", "ACCOUNT_USAGE"))).parameter(NameValuePair.of("control-config-strategy", "default"))).parameter(NameValuePair.of("enable-lineage", true))).parameter(NameValuePair.of("enable-snowflake-tags", false))).parameter(NameValuePair.of("connection", connection.toJson(client)));
        try {
            if (!toInclude.isEmpty()) {
                argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).parameter(NameValuePair.of("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            if (!toExclude.isEmpty()) {
                argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).parameter(NameValuePair.of("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
        }
        String atlanName = "atlan-snowflake-default-snowflake-" + epoch;
        String runName = "atlan-snowflake-" + epoch;
        return ((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)Workflow.builder().metadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().label("orchestration.atlan.com/certified", "true")).label("orchestration.atlan.com/source", "snowflake")).label("orchestration.atlan.com/sourceCategory", "warehouse")).label("orchestration.atlan.com/type", "connector")).label("orchestration.atlan.com/verified", "true")).label("package.argoproj.io/installer", "argopm")).label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hsnowflake")).label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")).label("orchestration.atlan.com/default-snowflake-" + epoch, "true")).label("orchestration.atlan.com/atlan-ui", "true")).annotation("orchestration.atlan.com/allowSchedule", "true")).annotation("orchestration.atlan.com/categories", "warehouse,crawler")).annotation("orchestration.atlan.com/dependentPackage", "")).annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6037440864145")).annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")).annotation("orchestration.atlan.com/icon", "https://docs.snowflake.com/en/_images/logo-snowflake-sans-text.png")).annotation("orchestration.atlan.com/logo", "https://1amiydhcmj36tz3733v94f15-wpengine.netdna-ssl.com/wp-content/themes/snowflake/assets/img/logo-blue.svg")).annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/snowflake")).annotation("orchestration.atlan.com/name", "Snowflake Assets")).annotation("package.argoproj.io/author", "Atlan")).annotation("package.argoproj.io/description", "Package to crawl snowflake assets and publish to Atlan for discovery")).annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/snowflake")).annotation("package.argoproj.io/keywords", "[\"snowflake\",\"warehouse\",\"connector\",\"crawler\"]")).annotation("package.argoproj.io/name", "@atlan/snowflake")).annotation("package.argoproj.io/registry", "https://packages.atlan.com")).annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git")).annotation("package.argoproj.io/support", "support@atlan.com")).annotation("orchestration.atlan.com/atlanName", atlanName)).name(runName)).namespace("default")).build())).spec((WorkflowSpec)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)WorkflowSpec.builder().templates(List.of(((WorkflowTemplate.WorkflowTemplateBuilder)((WorkflowTemplate.WorkflowTemplateBuilder)WorkflowTemplate.builder().name("main")).dag((WorkflowDAG)((WorkflowDAG.WorkflowDAGBuilder)WorkflowDAG.builder().task((WorkflowTask)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)WorkflowTask.builder().name("run")).arguments((WorkflowParameters)((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).build())).templateRef((WorkflowTemplateRef)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)WorkflowTemplateRef.builder().name(PREFIX)).template("main")).clusterScope(true)).build())).build())).build())).build()))).entrypoint("main")).workflowMetadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().annotation("package.argoproj.io/name", "@atlan/snowflake")).build())).build())).payload(List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(credentialBody).build()))).build();
    }
}

