/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowParameters;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableauCrawler
extends AbstractCrawler {
    public static final String PREFIX = "atlan-tableau";

    public static Workflow basicAuth(AtlanClient client, String connectionName, String hostname, String username, String password) throws AtlanException {
        return TableauCrawler.basicAuth(client, connectionName, hostname, 443, username, password, null, List.of(client.getRoleCache().getIdForName("$admin")), null, null, null, null);
    }

    public static Workflow basicAuth(AtlanClient client, String connectionName, String hostname, int port, String username, String password, String defaultSite, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, List<String> includeProjects, List<String> excludeProjects) throws AtlanException {
        Asset connection = ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(connectionName, AtlanConnectorType.TABLEAU, adminRoles, adminGroups, adminUsers).allowQuery(true)).allowQueryPreview(true)).rowLimit(10000L)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo("https://img.icons8.com/color/480/000000/tableau-software.png")).isDiscoverable(true)).isEditable(false)).build();
        String epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("protocol", "https");
        if (defaultSite != null) {
            extra.put("defaultSite", defaultSite);
        }
        HashMap<String, Object> credentialBody = new HashMap<String, Object>();
        credentialBody.put("name", "default-tableau-" + epoch + "-0");
        credentialBody.put("host", hostname);
        credentialBody.put("port", port);
        credentialBody.put("authType", "basic");
        credentialBody.put("username", username);
        credentialBody.put("password", password);
        credentialBody.put("extra", extra);
        credentialBody.put("connectorConfigName", "atlan-connectors-tableau");
        Map<String, Map<String, String>> toIncludeProjects = TableauCrawler.buildFlatFilter(includeProjects);
        Map<String, Map<String, String>> toExcludeProjects = TableauCrawler.buildFlatFilter(excludeProjects);
        Object argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)WorkflowParameters.builder().parameter(NameValuePair.of("credential-guid", "{{credentialGuid}}"))).parameter(NameValuePair.of("connection", connection.toJson(client)))).parameter(NameValuePair.of("atlas-auth-type", "internal"))).parameter(NameValuePair.of("crawl-unpublished-worksheets-dashboards", "true"))).parameter(NameValuePair.of("publish-mode", "production"));
        try {
            argsBuilder = ((WorkflowParameters.WorkflowParametersBuilder)((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).parameter(NameValuePair.of("include-filter", Serde.allInclusiveMapper.writeValueAsString(toIncludeProjects)))).parameter(NameValuePair.of("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExcludeProjects)));
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
        }
        String atlanName = "atlan-tableau-default-tableau-" + epoch;
        String runName = "atlan-tableau-" + epoch;
        return ((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)((Workflow.WorkflowBuilder)Workflow.builder().metadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().label("orchestration.atlan.com/certified", "true")).label("orchestration.atlan.com/source", "tableau")).label("orchestration.atlan.com/sourceCategory", "bi")).label("orchestration.atlan.com/type", "connector")).label("orchestration.atlan.com/verified", "true")).label("package.argoproj.io/installer", "argopm")).label("package.argoproj.io/name", "a-t-ratlans-l-a-s-htableau")).label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")).label("orchestration.atlan.com/default-tableau-" + epoch, "true")).label("orchestration.atlan.com/atlan-ui", "true")).annotation("orchestration.atlan.com/allowSchedule", "true")).annotation("orchestration.atlan.com/categories", "tableau,crawler")).annotation("orchestration.atlan.com/dependentPackage", "")).annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6332449996689")).annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")).annotation("orchestration.atlan.com/icon", "https://img.icons8.com/color/480/000000/tableau-software.png")).annotation("orchestration.atlan.com/logo", "https://img.icons8.com/color/480/000000/tableau-software.png")).annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/tableau")).annotation("orchestration.atlan.com/name", "Tableau Assets")).annotation("package.argoproj.io/author", "Atlan")).annotation("package.argoproj.io/description", "Package to crawl Tableau assets and publish to Atlan for discovery")).annotation("package.argoproj.io/homepage", "https://github.com/atlanhq/marketplace-packages#readme")).annotation("package.argoproj.io/keywords", "[\"tableau\",\"bi\",\"connector\",\"crawler\"]")).annotation("package.argoproj.io/name", "@atlan/tableau")).annotation("package.argoproj.io/registry", "https://packages.atlan.com")).annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git")).annotation("package.argoproj.io/support", "support@atlan.com")).annotation("orchestration.atlan.com/atlanName", atlanName)).name(runName)).namespace("default")).build())).spec((WorkflowSpec)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)((WorkflowSpec.WorkflowSpecBuilder)WorkflowSpec.builder().templates(List.of(((WorkflowTemplate.WorkflowTemplateBuilder)((WorkflowTemplate.WorkflowTemplateBuilder)WorkflowTemplate.builder().name("main")).dag((WorkflowDAG)((WorkflowDAG.WorkflowDAGBuilder)WorkflowDAG.builder().task((WorkflowTask)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)((WorkflowTask.WorkflowTaskBuilder)WorkflowTask.builder().name("run")).arguments((WorkflowParameters)((WorkflowParameters.WorkflowParametersBuilder)argsBuilder).build())).templateRef((WorkflowTemplateRef)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)((WorkflowTemplateRef.WorkflowTemplateRefBuilder)WorkflowTemplateRef.builder().name(PREFIX)).template("main")).clusterScope(true)).build())).build())).build())).build()))).entrypoint("main")).workflowMetadata((WorkflowMetadata)((WorkflowMetadata.WorkflowMetadataBuilder)WorkflowMetadata.builder().annotation("package.argoproj.io/name", "@atlan/tableau")).build())).build())).payload(List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(credentialBody).build()))).build();
    }
}

