/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.AuditSearchResponse;
import com.atlan.model.search.IndexSearchDSL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class AuditSearchRequest
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    private static final SortOptions LATEST_FIRST = SortOptions.of(s -> s.field(FieldSort.of(f -> f.field("created").order(SortOrder.Desc))));
    IndexSearchDSL dsl;
    List<String> attributes;

    public AuditSearchResponse search() throws AtlanException {
        return this.search(Atlan.getDefaultClient());
    }

    public AuditSearchResponse search(AtlanClient client) throws AtlanException {
        return client.assets.auditLogs(this);
    }

    public static AuditSearchRequestBuilder<?, ?> byGuid(String guid, int size) {
        return AuditSearchRequest.builder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)IndexSearchDSL.builder(BoolQuery.of(b -> b.filter(TermQuery.of(t -> t.field("entityId").value(guid))._toQuery(), new Query[0]))._toQuery()).size(size)).sortOption(LATEST_FIRST)).build());
    }

    public static AuditSearchRequestBuilder<?, ?> byQualifiedName(String typeName, String qualifiedName, int size) {
        return AuditSearchRequest.builder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)IndexSearchDSL.builder(BoolQuery.of(b -> b.must(List.of(TermQuery.of(t -> t.field("entityQualifiedName").value(qualifiedName))._toQuery(), TermQuery.of(t -> t.field("typeName").value(typeName))._toQuery())))._toQuery()).size(size)).sortOption(LATEST_FIRST)).build());
    }

    public static AuditSearchRequestBuilder<?, ?> byUser(String userName, int size) {
        return AuditSearchRequest.builder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)IndexSearchDSL.builder(BoolQuery.of(b -> b.must(List.of(TermQuery.of(t -> t.field("user").value(userName))._toQuery())))._toQuery()).size(size)).sortOption(LATEST_FIRST)).build());
    }

    @Generated
    protected AuditSearchRequest(AuditSearchRequestBuilder<?, ?> b) {
        super(b);
        List<Object> attributes;
        this.dsl = b.dsl;
        switch (b.attributes == null ? 0 : b.attributes.size()) {
            case 0: {
                attributes = Collections.emptyList();
                break;
            }
            case 1: {
                attributes = Collections.singletonList(b.attributes.get(0));
                break;
            }
            default: {
                attributes = Collections.unmodifiableList(new ArrayList<String>(b.attributes));
            }
        }
        this.attributes = attributes;
    }

    @Generated
    public static AuditSearchRequestBuilder<?, ?> builder() {
        return new AuditSearchRequestBuilderImpl();
    }

    @Generated
    public AuditSearchRequestBuilder<?, ?> toBuilder() {
        return new AuditSearchRequestBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public IndexSearchDSL getDsl() {
        return this.dsl;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditSearchRequest)) {
            return false;
        }
        AuditSearchRequest other = (AuditSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexSearchDSL this$dsl = this.getDsl();
        IndexSearchDSL other$dsl = other.getDsl();
        if (this$dsl == null ? other$dsl != null : !((Object)this$dsl).equals(other$dsl)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuditSearchRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IndexSearchDSL $dsl = this.getDsl();
        result = result * 59 + ($dsl == null ? 43 : ((Object)$dsl).hashCode());
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AuditSearchRequest(super=" + super.toString() + ", dsl=" + this.getDsl() + ", attributes=" + this.getAttributes() + ")";
    }

    @Generated
    private static final class AuditSearchRequestBuilderImpl
    extends AuditSearchRequestBuilder<AuditSearchRequest, AuditSearchRequestBuilderImpl> {
        @Generated
        private AuditSearchRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected AuditSearchRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AuditSearchRequest build() {
            return new AuditSearchRequest(this);
        }
    }

    @Generated
    public static abstract class AuditSearchRequestBuilder<C extends AuditSearchRequest, B extends AuditSearchRequestBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private IndexSearchDSL dsl;
        @Generated
        private ArrayList<String> attributes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AuditSearchRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AuditSearchRequest instance, AuditSearchRequestBuilder<?, ?> b) {
            b.dsl(instance.dsl);
            b.attributes(instance.attributes == null ? Collections.emptyList() : instance.attributes);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B dsl(IndexSearchDSL dsl) {
            this.dsl = dsl;
            return (B)this.self();
        }

        @Generated
        public B attribute(String attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return (B)this.self();
        }

        @Generated
        public B attributes(Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return (B)this.self();
        }

        @Generated
        public B clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AuditSearchRequest.AuditSearchRequestBuilder(super=" + super.toString() + ", dsl=" + this.dsl + ", attributes=" + this.attributes + ")";
        }
    }
}

