/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.enums.AtlanStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class CompoundQuery {
    public static final Query ACTIVE = Asset.STATUS.eq(AtlanStatus.ACTIVE);
    public static final Query ARCHIVED = Asset.STATUS.eq(AtlanStatus.DELETED);
    public static final Query WITH_LINEAGE = Asset.HAS_LINEAGE.eq(true);
    public static final Query WITHOUT_LINEAGE = ((CompoundQuery)((CompoundQueryBuilder)CompoundQuery.builder().whereNot(WITH_LINEAGE)).build()).toQuery();
    private List<Query> wheres;
    private List<Query> whereNots;
    private List<Query> whereSomes;
    private int minSomes;

    public static Query assetType(String typeName) {
        return Asset.TYPE_NAME.eq(typeName);
    }

    public static Query assetTypes(Collection<String> typeNames) {
        return Asset.TYPE_NAME.in(typeNames);
    }

    public static Query superType(String typeName) {
        return Asset.SUPER_TYPE_NAMES.eq(typeName);
    }

    public static Query superTypes(Collection<String> typeNames) {
        return Asset.SUPER_TYPE_NAMES.in(typeNames);
    }

    public static Query tagged(AtlanClient client, Collection<String> atlanTagNames) throws AtlanException {
        ArrayList<String> values = new ArrayList<String>();
        for (String name : atlanTagNames) {
            values.add(client.getAtlanTagCache().getIdForName(name));
        }
        return ((CompoundQuery)((CompoundQueryBuilder)((CompoundQueryBuilder)((CompoundQueryBuilder)CompoundQuery.builder().whereSome(Asset.ATLAN_TAGS.in(values))).whereSome(Asset.PROPAGATED_ATLAN_TAGS.in(values))).minSomes(1)).build()).toQuery();
    }

    public static Query tagged(boolean directly) {
        if (directly) {
            return Asset.ATLAN_TAGS.hasAnyValue();
        }
        return ((CompoundQuery)((CompoundQueryBuilder)((CompoundQueryBuilder)((CompoundQueryBuilder)CompoundQuery.builder().whereSome(Asset.ATLAN_TAGS.hasAnyValue())).whereSome(Asset.PROPAGATED_ATLAN_TAGS.hasAnyValue())).minSomes(1)).build()).toQuery();
    }

    public static Query assignedTerm() {
        return Asset.ASSIGNED_TERMS.hasAnyValue();
    }

    public static Query assignedTerm(Collection<String> termQualifiedNames) {
        return Asset.ASSIGNED_TERMS.in(termQualifiedNames);
    }

    public Query toQuery() {
        BoolQuery.Builder builder = new BoolQuery.Builder();
        if (this.wheres != null && !this.wheres.isEmpty()) {
            builder.filter(this.wheres);
        }
        if (this.whereNots != null && !this.whereNots.isEmpty()) {
            builder.mustNot(this.whereNots);
        }
        if (this.whereSomes != null && !this.whereSomes.isEmpty()) {
            builder.should(this.whereSomes).minimumShouldMatch("" + this.minSomes);
        }
        return builder.build()._toQuery();
    }

    @Generated
    private static int $default$minSomes() {
        return 1;
    }

    @Generated
    protected CompoundQuery(CompoundQueryBuilder<?, ?> b) {
        List<Object> whereSomes;
        List<Object> whereNots;
        List<Object> wheres;
        switch (b.wheres == null ? 0 : b.wheres.size()) {
            case 0: {
                wheres = Collections.emptyList();
                break;
            }
            case 1: {
                wheres = Collections.singletonList(b.wheres.get(0));
                break;
            }
            default: {
                wheres = Collections.unmodifiableList(new ArrayList<Query>(b.wheres));
            }
        }
        this.wheres = wheres;
        switch (b.whereNots == null ? 0 : b.whereNots.size()) {
            case 0: {
                whereNots = Collections.emptyList();
                break;
            }
            case 1: {
                whereNots = Collections.singletonList(b.whereNots.get(0));
                break;
            }
            default: {
                whereNots = Collections.unmodifiableList(new ArrayList<Query>(b.whereNots));
            }
        }
        this.whereNots = whereNots;
        switch (b.whereSomes == null ? 0 : b.whereSomes.size()) {
            case 0: {
                whereSomes = Collections.emptyList();
                break;
            }
            case 1: {
                whereSomes = Collections.singletonList(b.whereSomes.get(0));
                break;
            }
            default: {
                whereSomes = Collections.unmodifiableList(new ArrayList<Query>(b.whereSomes));
            }
        }
        this.whereSomes = whereSomes;
        this.minSomes = b.minSomes$set ? b.minSomes$value : CompoundQuery.$default$minSomes();
    }

    @Generated
    public static CompoundQueryBuilder<?, ?> builder() {
        return new CompoundQueryBuilderImpl();
    }

    @Generated
    private static final class CompoundQueryBuilderImpl
    extends CompoundQueryBuilder<CompoundQuery, CompoundQueryBuilderImpl> {
        @Generated
        private CompoundQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected CompoundQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CompoundQuery build() {
            return new CompoundQuery(this);
        }
    }

    @Generated
    public static abstract class CompoundQueryBuilder<C extends CompoundQuery, B extends CompoundQueryBuilder<C, B>> {
        @Generated
        private ArrayList<Query> wheres;
        @Generated
        private ArrayList<Query> whereNots;
        @Generated
        private ArrayList<Query> whereSomes;
        @Generated
        private boolean minSomes$set;
        @Generated
        private int minSomes$value;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B where(Query where) {
            if (this.wheres == null) {
                this.wheres = new ArrayList();
            }
            this.wheres.add(where);
            return this.self();
        }

        @Generated
        public B wheres(Collection<? extends Query> wheres) {
            if (wheres == null) {
                throw new NullPointerException("wheres cannot be null");
            }
            if (this.wheres == null) {
                this.wheres = new ArrayList();
            }
            this.wheres.addAll(wheres);
            return this.self();
        }

        @Generated
        public B clearWheres() {
            if (this.wheres != null) {
                this.wheres.clear();
            }
            return this.self();
        }

        @Generated
        public B whereNot(Query whereNot) {
            if (this.whereNots == null) {
                this.whereNots = new ArrayList();
            }
            this.whereNots.add(whereNot);
            return this.self();
        }

        @Generated
        public B whereNots(Collection<? extends Query> whereNots) {
            if (whereNots == null) {
                throw new NullPointerException("whereNots cannot be null");
            }
            if (this.whereNots == null) {
                this.whereNots = new ArrayList();
            }
            this.whereNots.addAll(whereNots);
            return this.self();
        }

        @Generated
        public B clearWhereNots() {
            if (this.whereNots != null) {
                this.whereNots.clear();
            }
            return this.self();
        }

        @Generated
        public B whereSome(Query whereSome) {
            if (this.whereSomes == null) {
                this.whereSomes = new ArrayList();
            }
            this.whereSomes.add(whereSome);
            return this.self();
        }

        @Generated
        public B whereSomes(Collection<? extends Query> whereSomes) {
            if (whereSomes == null) {
                throw new NullPointerException("whereSomes cannot be null");
            }
            if (this.whereSomes == null) {
                this.whereSomes = new ArrayList();
            }
            this.whereSomes.addAll(whereSomes);
            return this.self();
        }

        @Generated
        public B clearWhereSomes() {
            if (this.whereSomes != null) {
                this.whereSomes.clear();
            }
            return this.self();
        }

        @Generated
        public B minSomes(int minSomes) {
            this.minSomes$value = minSomes;
            this.minSomes$set = true;
            return this.self();
        }

        @Generated
        public String toString() {
            return "CompoundQuery.CompoundQueryBuilder(wheres=" + this.wheres + ", whereNots=" + this.whereNots + ", whereSomes=" + this.whereSomes + ", minSomes$value=" + this.minSomes$value + ")";
        }
    }
}

