/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class FluentSearch
extends CompoundQuery {
    AtlanClient client;
    List<SortOptions> sorts;
    Map<String, Aggregation> aggregations;
    Integer pageSize;
    List<AtlanField> includesOnResults;
    List<String> _includesOnResults;
    List<AtlanField> includesOnRelations;
    List<String> _includesOnRelations;

    public static FluentSearchBuilder<?, ?> builder(AtlanClient client) {
        return FluentSearch._internal().client(client);
    }

    protected IndexSearchDSL.IndexSearchDSLBuilder<?, ?> _dsl() {
        return IndexSearchDSL.builder(this.toQuery());
    }

    protected IndexSearchRequest.IndexSearchRequestBuilder<?, ?> _requestBuilder() {
        IndexSearchDSL.IndexSearchDSLBuilder<?, ?> dsl = this._dsl();
        if (this.pageSize != null) {
            dsl.size(this.pageSize);
        }
        if (this.sorts != null) {
            dsl.sort(this.sorts);
        }
        if (this.aggregations != null) {
            dsl.aggregations(this.aggregations);
        }
        IndexSearchRequest.IndexSearchRequestBuilder<?, ?> request = IndexSearchRequest.builder((IndexSearchDSL)dsl.build());
        if (this._includesOnResults != null) {
            request.attributes(this._includesOnResults);
        }
        if (this.includesOnResults != null) {
            request.attributes(this.includesOnResults.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        if (this._includesOnRelations != null) {
            request.relationAttributes(this._includesOnRelations);
        }
        if (this.includesOnRelations != null) {
            request.relationAttributes(this.includesOnRelations.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        return request;
    }

    @Generated
    protected FluentSearch(FluentSearchBuilder<?, ?> b) {
        super(b);
        List<Object> _includesOnRelations;
        List<Object> includesOnRelations;
        List<Object> _includesOnResults;
        List<Object> includesOnResults;
        Map<Object, Object> aggregations;
        List<Object> sorts;
        this.client = b.client;
        switch (b.sorts == null ? 0 : b.sorts.size()) {
            case 0: {
                sorts = Collections.emptyList();
                break;
            }
            case 1: {
                sorts = Collections.singletonList(b.sorts.get(0));
                break;
            }
            default: {
                sorts = Collections.unmodifiableList(new ArrayList<SortOptions>(b.sorts));
            }
        }
        this.sorts = sorts;
        switch (b.aggregations$key == null ? 0 : b.aggregations$key.size()) {
            case 0: {
                aggregations = Collections.emptyMap();
                break;
            }
            case 1: {
                aggregations = Collections.singletonMap(b.aggregations$key.get(0), b.aggregations$value.get(0));
                break;
            }
            default: {
                aggregations = new LinkedHashMap(b.aggregations$key.size() < 0x40000000 ? 1 + b.aggregations$key.size() + (b.aggregations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.aggregations$key.size(); ++$i) {
                    aggregations.put(b.aggregations$key.get($i), b.aggregations$value.get($i));
                }
                aggregations = Collections.unmodifiableMap(aggregations);
            }
        }
        this.aggregations = aggregations;
        this.pageSize = b.pageSize;
        switch (b.includesOnResults == null ? 0 : b.includesOnResults.size()) {
            case 0: {
                includesOnResults = Collections.emptyList();
                break;
            }
            case 1: {
                includesOnResults = Collections.singletonList(b.includesOnResults.get(0));
                break;
            }
            default: {
                includesOnResults = Collections.unmodifiableList(new ArrayList<AtlanField>(b.includesOnResults));
            }
        }
        this.includesOnResults = includesOnResults;
        switch (b._includesOnResults == null ? 0 : b._includesOnResults.size()) {
            case 0: {
                _includesOnResults = Collections.emptyList();
                break;
            }
            case 1: {
                _includesOnResults = Collections.singletonList(b._includesOnResults.get(0));
                break;
            }
            default: {
                _includesOnResults = Collections.unmodifiableList(new ArrayList<String>(b._includesOnResults));
            }
        }
        this._includesOnResults = _includesOnResults;
        switch (b.includesOnRelations == null ? 0 : b.includesOnRelations.size()) {
            case 0: {
                includesOnRelations = Collections.emptyList();
                break;
            }
            case 1: {
                includesOnRelations = Collections.singletonList(b.includesOnRelations.get(0));
                break;
            }
            default: {
                includesOnRelations = Collections.unmodifiableList(new ArrayList<AtlanField>(b.includesOnRelations));
            }
        }
        this.includesOnRelations = includesOnRelations;
        switch (b._includesOnRelations == null ? 0 : b._includesOnRelations.size()) {
            case 0: {
                _includesOnRelations = Collections.emptyList();
                break;
            }
            case 1: {
                _includesOnRelations = Collections.singletonList(b._includesOnRelations.get(0));
                break;
            }
            default: {
                _includesOnRelations = Collections.unmodifiableList(new ArrayList<String>(b._includesOnRelations));
            }
        }
        this._includesOnRelations = _includesOnRelations;
    }

    @Generated
    public static FluentSearchBuilder<?, ?> _internal() {
        return new FluentSearchBuilderImpl();
    }

    @Generated
    private static final class FluentSearchBuilderImpl
    extends FluentSearchBuilder<FluentSearch, FluentSearchBuilderImpl> {
        @Generated
        private FluentSearchBuilderImpl() {
        }

        @Override
        @Generated
        protected FluentSearchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FluentSearch build() {
            return new FluentSearch(this);
        }
    }

    public static abstract class FluentSearchBuilder<C extends FluentSearch, B extends FluentSearchBuilder<C, B>>
    extends CompoundQuery.CompoundQueryBuilder<C, B> {
        @Generated
        private AtlanClient client;
        @Generated
        private ArrayList<SortOptions> sorts;
        @Generated
        private ArrayList<String> aggregations$key;
        @Generated
        private ArrayList<Aggregation> aggregations$value;
        @Generated
        private Integer pageSize;
        @Generated
        private ArrayList<AtlanField> includesOnResults;
        @Generated
        private ArrayList<String> _includesOnResults;
        @Generated
        private ArrayList<AtlanField> includesOnRelations;
        @Generated
        private ArrayList<String> _includesOnRelations;

        public IndexSearchRequest.IndexSearchRequestBuilder<?, ?> toRequestBuilder() {
            return ((FluentSearch)this.build())._requestBuilder();
        }

        public IndexSearchRequest toRequest() {
            return this.toRequestBuilder().build();
        }

        public long count() throws AtlanException {
            if (this.client == null) {
                throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
            }
            AtlanObject request = IndexSearchRequest.builder((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((FluentSearch)this.build())._dsl().size(1)).clearAggregations()).build()).build();
            return ((IndexSearchRequest)request).search(this.client).getApproximateCount();
        }

        public Stream<Asset> stream() throws AtlanException {
            return this.stream(false);
        }

        public Stream<Asset> stream(boolean parallel) throws AtlanException {
            if (this.client == null) {
                throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
            }
            IndexSearchRequest request = this.toRequest();
            if (parallel) {
                return request.search(this.client).parallelStream();
            }
            return request.search(this.client).stream();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B client(AtlanClient client) {
            this.client = client;
            return (B)this.self();
        }

        @Generated
        public B sort(SortOptions sort) {
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.add(sort);
            return (B)this.self();
        }

        @Generated
        public B sorts(Collection<? extends SortOptions> sorts) {
            if (sorts == null) {
                throw new NullPointerException("sorts cannot be null");
            }
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.addAll(sorts);
            return (B)this.self();
        }

        @Generated
        public B clearSorts() {
            if (this.sorts != null) {
                this.sorts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B aggregate(String aggregateKey, Aggregation aggregateValue) {
            if (this.aggregations$key == null) {
                this.aggregations$key = new ArrayList();
                this.aggregations$value = new ArrayList();
            }
            this.aggregations$key.add(aggregateKey);
            this.aggregations$value.add(aggregateValue);
            return (B)this.self();
        }

        @Generated
        public B aggregations(Map<? extends String, ? extends Aggregation> aggregations) {
            if (aggregations == null) {
                throw new NullPointerException("aggregations cannot be null");
            }
            if (this.aggregations$key == null) {
                this.aggregations$key = new ArrayList();
                this.aggregations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Aggregation> $lombokEntry : aggregations.entrySet()) {
                this.aggregations$key.add($lombokEntry.getKey());
                this.aggregations$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAggregations() {
            if (this.aggregations$key != null) {
                this.aggregations$key.clear();
                this.aggregations$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return (B)this.self();
        }

        @Generated
        public B includeOnResults(AtlanField includeOnResults) {
            if (this.includesOnResults == null) {
                this.includesOnResults = new ArrayList();
            }
            this.includesOnResults.add(includeOnResults);
            return (B)this.self();
        }

        @Generated
        public B includesOnResults(Collection<? extends AtlanField> includesOnResults) {
            if (includesOnResults == null) {
                throw new NullPointerException("includesOnResults cannot be null");
            }
            if (this.includesOnResults == null) {
                this.includesOnResults = new ArrayList();
            }
            this.includesOnResults.addAll(includesOnResults);
            return (B)this.self();
        }

        @Generated
        public B clearIncludesOnResults() {
            if (this.includesOnResults != null) {
                this.includesOnResults.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B _includeOnResults(String _includeOnResults) {
            if (this._includesOnResults == null) {
                this._includesOnResults = new ArrayList();
            }
            this._includesOnResults.add(_includeOnResults);
            return (B)this.self();
        }

        @Generated
        public B _includesOnResults(Collection<? extends String> _includesOnResults) {
            if (_includesOnResults == null) {
                throw new NullPointerException("_includesOnResults cannot be null");
            }
            if (this._includesOnResults == null) {
                this._includesOnResults = new ArrayList();
            }
            this._includesOnResults.addAll(_includesOnResults);
            return (B)this.self();
        }

        @Generated
        public B clear_includesOnResults() {
            if (this._includesOnResults != null) {
                this._includesOnResults.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B includeOnRelations(AtlanField includeOnRelations) {
            if (this.includesOnRelations == null) {
                this.includesOnRelations = new ArrayList();
            }
            this.includesOnRelations.add(includeOnRelations);
            return (B)this.self();
        }

        @Generated
        public B includesOnRelations(Collection<? extends AtlanField> includesOnRelations) {
            if (includesOnRelations == null) {
                throw new NullPointerException("includesOnRelations cannot be null");
            }
            if (this.includesOnRelations == null) {
                this.includesOnRelations = new ArrayList();
            }
            this.includesOnRelations.addAll(includesOnRelations);
            return (B)this.self();
        }

        @Generated
        public B clearIncludesOnRelations() {
            if (this.includesOnRelations != null) {
                this.includesOnRelations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B _includeOnRelations(String _includeOnRelations) {
            if (this._includesOnRelations == null) {
                this._includesOnRelations = new ArrayList();
            }
            this._includesOnRelations.add(_includeOnRelations);
            return (B)this.self();
        }

        @Generated
        public B _includesOnRelations(Collection<? extends String> _includesOnRelations) {
            if (_includesOnRelations == null) {
                throw new NullPointerException("_includesOnRelations cannot be null");
            }
            if (this._includesOnRelations == null) {
                this._includesOnRelations = new ArrayList();
            }
            this._includesOnRelations.addAll(_includesOnRelations);
            return (B)this.self();
        }

        @Generated
        public B clear_includesOnRelations() {
            if (this._includesOnRelations != null) {
                this._includesOnRelations.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "FluentSearch.FluentSearchBuilder(super=" + super.toString() + ", client=" + this.client + ", sorts=" + this.sorts + ", aggregations$key=" + this.aggregations$key + ", aggregations$value=" + this.aggregations$value + ", pageSize=" + this.pageSize + ", includesOnResults=" + this.includesOnResults + ", _includesOnResults=" + this._includesOnResults + ", includesOnRelations=" + this.includesOnRelations + ", _includesOnRelations=" + this._includesOnRelations + ")";
        }
    }
}

