/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=IndexSearchRequestBuilderImpl.class)
public class IndexSearchRequest
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    IndexSearchDSL dsl;
    List<String> attributes;
    List<String> relationAttributes;
    Boolean suppressLogs;
    Boolean showSearchScore;
    Boolean excludeMeanings;
    @JsonProperty(value="excludeClassifications")
    Boolean excludeAtlanTags;

    public static IndexSearchRequestBuilder<?, ?> builder(Query query) {
        return IndexSearchRequest.builder(IndexSearchDSL.of(query));
    }

    public static IndexSearchRequestBuilder<?, ?> builder(IndexSearchDSL dsl) {
        return IndexSearchRequest._internal().dsl(dsl);
    }

    public IndexSearchResponse search() throws AtlanException {
        return this.search(Atlan.getDefaultClient());
    }

    public IndexSearchResponse search(AtlanClient client) throws AtlanException {
        return client.assets.search(this);
    }

    @Generated
    private static Boolean $default$suppressLogs() {
        return true;
    }

    @Generated
    private static Boolean $default$showSearchScore() {
        return false;
    }

    @Generated
    private static Boolean $default$excludeMeanings() {
        return false;
    }

    @Generated
    private static Boolean $default$excludeAtlanTags() {
        return false;
    }

    @Generated
    protected IndexSearchRequest(IndexSearchRequestBuilder<?, ?> b) {
        super(b);
        List<Object> relationAttributes;
        List<Object> attributes;
        this.dsl = b.dsl;
        switch (b.attributes == null ? 0 : b.attributes.size()) {
            case 0: {
                attributes = Collections.emptyList();
                break;
            }
            case 1: {
                attributes = Collections.singletonList(b.attributes.get(0));
                break;
            }
            default: {
                attributes = Collections.unmodifiableList(new ArrayList<String>(b.attributes));
            }
        }
        this.attributes = attributes;
        switch (b.relationAttributes == null ? 0 : b.relationAttributes.size()) {
            case 0: {
                relationAttributes = Collections.emptyList();
                break;
            }
            case 1: {
                relationAttributes = Collections.singletonList(b.relationAttributes.get(0));
                break;
            }
            default: {
                relationAttributes = Collections.unmodifiableList(new ArrayList<String>(b.relationAttributes));
            }
        }
        this.relationAttributes = relationAttributes;
        this.suppressLogs = b.suppressLogs$set ? b.suppressLogs$value : IndexSearchRequest.$default$suppressLogs();
        this.showSearchScore = b.showSearchScore$set ? b.showSearchScore$value : IndexSearchRequest.$default$showSearchScore();
        this.excludeMeanings = b.excludeMeanings$set ? b.excludeMeanings$value : IndexSearchRequest.$default$excludeMeanings();
        this.excludeAtlanTags = b.excludeAtlanTags$set ? b.excludeAtlanTags$value : IndexSearchRequest.$default$excludeAtlanTags();
    }

    @Generated
    public static IndexSearchRequestBuilder<?, ?> _internal() {
        return new IndexSearchRequestBuilderImpl();
    }

    @Generated
    public IndexSearchRequestBuilder<?, ?> toBuilder() {
        return new IndexSearchRequestBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public IndexSearchDSL getDsl() {
        return this.dsl;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<String> getRelationAttributes() {
        return this.relationAttributes;
    }

    @Generated
    public Boolean getSuppressLogs() {
        return this.suppressLogs;
    }

    @Generated
    public Boolean getShowSearchScore() {
        return this.showSearchScore;
    }

    @Generated
    public Boolean getExcludeMeanings() {
        return this.excludeMeanings;
    }

    @Generated
    public Boolean getExcludeAtlanTags() {
        return this.excludeAtlanTags;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexSearchRequest)) {
            return false;
        }
        IndexSearchRequest other = (IndexSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$suppressLogs = this.getSuppressLogs();
        Boolean other$suppressLogs = other.getSuppressLogs();
        if (this$suppressLogs == null ? other$suppressLogs != null : !((Object)this$suppressLogs).equals(other$suppressLogs)) {
            return false;
        }
        Boolean this$showSearchScore = this.getShowSearchScore();
        Boolean other$showSearchScore = other.getShowSearchScore();
        if (this$showSearchScore == null ? other$showSearchScore != null : !((Object)this$showSearchScore).equals(other$showSearchScore)) {
            return false;
        }
        Boolean this$excludeMeanings = this.getExcludeMeanings();
        Boolean other$excludeMeanings = other.getExcludeMeanings();
        if (this$excludeMeanings == null ? other$excludeMeanings != null : !((Object)this$excludeMeanings).equals(other$excludeMeanings)) {
            return false;
        }
        Boolean this$excludeAtlanTags = this.getExcludeAtlanTags();
        Boolean other$excludeAtlanTags = other.getExcludeAtlanTags();
        if (this$excludeAtlanTags == null ? other$excludeAtlanTags != null : !((Object)this$excludeAtlanTags).equals(other$excludeAtlanTags)) {
            return false;
        }
        IndexSearchDSL this$dsl = this.getDsl();
        IndexSearchDSL other$dsl = other.getDsl();
        if (this$dsl == null ? other$dsl != null : !((Object)this$dsl).equals(other$dsl)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<String> this$relationAttributes = this.getRelationAttributes();
        List<String> other$relationAttributes = other.getRelationAttributes();
        return !(this$relationAttributes == null ? other$relationAttributes != null : !((Object)this$relationAttributes).equals(other$relationAttributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexSearchRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $suppressLogs = this.getSuppressLogs();
        result = result * 59 + ($suppressLogs == null ? 43 : ((Object)$suppressLogs).hashCode());
        Boolean $showSearchScore = this.getShowSearchScore();
        result = result * 59 + ($showSearchScore == null ? 43 : ((Object)$showSearchScore).hashCode());
        Boolean $excludeMeanings = this.getExcludeMeanings();
        result = result * 59 + ($excludeMeanings == null ? 43 : ((Object)$excludeMeanings).hashCode());
        Boolean $excludeAtlanTags = this.getExcludeAtlanTags();
        result = result * 59 + ($excludeAtlanTags == null ? 43 : ((Object)$excludeAtlanTags).hashCode());
        IndexSearchDSL $dsl = this.getDsl();
        result = result * 59 + ($dsl == null ? 43 : ((Object)$dsl).hashCode());
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<String> $relationAttributes = this.getRelationAttributes();
        result = result * 59 + ($relationAttributes == null ? 43 : ((Object)$relationAttributes).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IndexSearchRequest(super=" + super.toString() + ", dsl=" + this.getDsl() + ", attributes=" + this.getAttributes() + ", relationAttributes=" + this.getRelationAttributes() + ", suppressLogs=" + this.getSuppressLogs() + ", showSearchScore=" + this.getShowSearchScore() + ", excludeMeanings=" + this.getExcludeMeanings() + ", excludeAtlanTags=" + this.getExcludeAtlanTags() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class IndexSearchRequestBuilderImpl
    extends IndexSearchRequestBuilder<IndexSearchRequest, IndexSearchRequestBuilderImpl> {
        @Generated
        private IndexSearchRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected IndexSearchRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IndexSearchRequest build() {
            return new IndexSearchRequest(this);
        }
    }

    @Generated
    public static abstract class IndexSearchRequestBuilder<C extends IndexSearchRequest, B extends IndexSearchRequestBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private IndexSearchDSL dsl;
        @Generated
        private ArrayList<String> attributes;
        @Generated
        private ArrayList<String> relationAttributes;
        @Generated
        private boolean suppressLogs$set;
        @Generated
        private Boolean suppressLogs$value;
        @Generated
        private boolean showSearchScore$set;
        @Generated
        private Boolean showSearchScore$value;
        @Generated
        private boolean excludeMeanings$set;
        @Generated
        private Boolean excludeMeanings$value;
        @Generated
        private boolean excludeAtlanTags$set;
        @Generated
        private Boolean excludeAtlanTags$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            IndexSearchRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(IndexSearchRequest instance, IndexSearchRequestBuilder<?, ?> b) {
            b.dsl(instance.dsl);
            b.attributes(instance.attributes == null ? Collections.emptyList() : instance.attributes);
            b.relationAttributes(instance.relationAttributes == null ? Collections.emptyList() : instance.relationAttributes);
            b.suppressLogs(instance.suppressLogs);
            b.showSearchScore(instance.showSearchScore);
            b.excludeMeanings(instance.excludeMeanings);
            b.excludeAtlanTags(instance.excludeAtlanTags);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B dsl(IndexSearchDSL dsl) {
            this.dsl = dsl;
            return (B)this.self();
        }

        @Generated
        public B attribute(String attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return (B)this.self();
        }

        @Generated
        public B attributes(Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return (B)this.self();
        }

        @Generated
        public B clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B relationAttribute(String relationAttribute) {
            if (this.relationAttributes == null) {
                this.relationAttributes = new ArrayList();
            }
            this.relationAttributes.add(relationAttribute);
            return (B)this.self();
        }

        @Generated
        public B relationAttributes(Collection<? extends String> relationAttributes) {
            if (relationAttributes == null) {
                throw new NullPointerException("relationAttributes cannot be null");
            }
            if (this.relationAttributes == null) {
                this.relationAttributes = new ArrayList();
            }
            this.relationAttributes.addAll(relationAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearRelationAttributes() {
            if (this.relationAttributes != null) {
                this.relationAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B suppressLogs(Boolean suppressLogs) {
            this.suppressLogs$value = suppressLogs;
            this.suppressLogs$set = true;
            return (B)this.self();
        }

        @Generated
        public B showSearchScore(Boolean showSearchScore) {
            this.showSearchScore$value = showSearchScore;
            this.showSearchScore$set = true;
            return (B)this.self();
        }

        @Generated
        public B excludeMeanings(Boolean excludeMeanings) {
            this.excludeMeanings$value = excludeMeanings;
            this.excludeMeanings$set = true;
            return (B)this.self();
        }

        @JsonProperty(value="excludeClassifications")
        @Generated
        public B excludeAtlanTags(Boolean excludeAtlanTags) {
            this.excludeAtlanTags$value = excludeAtlanTags;
            this.excludeAtlanTags$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "IndexSearchRequest.IndexSearchRequestBuilder(super=" + super.toString() + ", dsl=" + this.dsl + ", attributes=" + this.attributes + ", relationAttributes=" + this.relationAttributes + ", suppressLogs$value=" + this.suppressLogs$value + ", showSearchScore$value=" + this.showSearchScore$value + ", excludeMeanings$value=" + this.excludeMeanings$value + ", excludeAtlanTags$value=" + this.excludeAtlanTags$value + ")";
        }
    }
}

