/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.AtlanClient;
import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ConflictException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.exception.PermissionException;
import com.atlan.exception.RateLimitException;
import com.atlan.model.core.AtlanError;
import com.atlan.model.core.AtlanResponseInterface;
import com.atlan.net.ApiResource;
import com.atlan.net.AtlanRequest;
import com.atlan.net.AtlanResponse;
import com.atlan.net.AtlanResponseGetter;
import com.atlan.net.HttpClient;
import com.atlan.net.HttpURLConnectionClient;
import com.atlan.net.RequestOptions;
import com.atlan.serde.Serde;
import java.io.IOException;
import java.io.InputStream;

public class LiveAtlanResponseGetter
implements AtlanResponseGetter {
    private final HttpClient httpClient;

    public LiveAtlanResponseGetter() {
        this(null);
    }

    public LiveAtlanResponseGetter(HttpClient httpClient) {
        this.httpClient = httpClient != null ? httpClient : LiveAtlanResponseGetter.buildDefaultHttpClient();
    }

    @Override
    public <T extends AtlanResponseInterface> T request(AtlanClient client, ApiResource.RequestMethod method, String url, String body, Class<T> clazz, RequestOptions options, String requestId) throws AtlanException {
        AtlanRequest request = new AtlanRequest(client, method, url, body, options, requestId);
        return this.request(request, clazz);
    }

    @Override
    public <T extends AtlanResponseInterface> T request(AtlanClient client, ApiResource.RequestMethod method, String url, InputStream upload, String filename, Class<T> clazz, RequestOptions options, String requestId) throws AtlanException {
        AtlanRequest request = new AtlanRequest(client, method, url, upload, filename, options, requestId);
        return this.request(request, clazz);
    }

    private <T extends AtlanResponseInterface> T request(AtlanRequest request, Class<T> clazz) throws AtlanException {
        AtlanResponse response = this.httpClient.requestWithRetries(request);
        int responseCode = response.code();
        String responseBody = (String)response.body();
        if (responseCode < 200 || responseCode >= 300) {
            LiveAtlanResponseGetter.handleApiError(response);
        }
        AtlanResponseInterface resource = null;
        if (clazz != null) {
            try {
                resource = (AtlanResponseInterface)request.client().readValue(responseBody, clazz);
            }
            catch (IOException e) {
                LiveAtlanResponseGetter.raiseMalformedJsonError(responseBody, responseCode, e);
            }
        }
        if (resource != null) {
            resource.setLastResponse(response);
        }
        return (T)resource;
    }

    private static HttpClient buildDefaultHttpClient() {
        return new HttpURLConnectionClient();
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode, Throwable e) throws ApiException {
        String details = e == null ? "none" : e.getMessage();
        throw new ApiException(ErrorCode.JSON_ERROR, e, responseBody, "" + responseCode, details);
    }

    private static void handleApiError(AtlanResponse response) throws AtlanException {
        AtlanError error = null;
        AtlanException exception = null;
        int rc = response.code();
        if (rc == 500) {
            throw new ApiException(ErrorCode.ERROR_PASSTHROUGH, null, "" + rc, response.body() == null ? "" : (String)response.body());
        }
        try {
            error = (AtlanError)Serde.allInclusiveMapper.readValue((String)response.body(), AtlanError.class);
        }
        catch (IOException e) {
            LiveAtlanResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), e);
        }
        if (error == null) {
            LiveAtlanResponseGetter.raiseMalformedJsonError((String)response.body(), response.code(), null);
        }
        switch (response.code()) {
            case 400: {
                exception = new InvalidRequestException(ErrorCode.INVALID_REQUEST_PASSTHROUGH, new String[]{error.getErrorCode() == null ? "" + error.getCode() : error.getErrorCode(), error.getErrorMessage() == null ? error.getMessage() : error.getErrorMessage()});
                break;
            }
            case 404: {
                exception = new NotFoundException(ErrorCode.NOT_FOUND_PASSTHROUGH, new String[]{error.getErrorCode() == null ? "" + error.getCode() : error.getErrorCode(), error.getErrorMessage() == null ? error.getMessage() : error.getErrorMessage()});
                break;
            }
            case 401: {
                exception = new AuthenticationException(ErrorCode.AUTHENTICATION_PASSTHROUGH, new String[]{error.getErrorCode() == null ? "" + error.getCode() : error.getErrorCode(), error.getErrorMessage() == null ? error.getMessage() : error.getErrorMessage()});
                break;
            }
            case 403: {
                exception = new PermissionException(ErrorCode.PERMISSION_PASSTHROUGH, new String[]{error.getErrorCode() == null ? "" + error.getCode() : error.getErrorCode(), error.getErrorMessage() == null ? error.getMessage() : error.getErrorMessage()});
                break;
            }
            case 409: {
                exception = new ConflictException(ErrorCode.CONFLICT_PASSTHROUGH, new String[]{error.getErrorCode() == null ? "" + error.getCode() : error.getErrorCode(), error.getErrorMessage() == null ? error.getMessage() : error.getErrorMessage()});
                break;
            }
            case 429: {
                exception = new RateLimitException(ErrorCode.RATE_LIMIT_PASSTHROUGH, new String[]{error.getErrorCode() == null ? "" + error.getCode() : error.getErrorCode(), error.getErrorMessage() == null ? error.getMessage() : error.getErrorMessage()});
                break;
            }
            default: {
                exception = new ApiException(ErrorCode.ERROR_PASSTHROUGH, null, new String[]{error.getErrorCode() == null ? "" + error.getCode() : error.getErrorCode(), error.getErrorMessage() == null ? error.getMessage() : error.getErrorMessage()});
            }
        }
        exception.setAtlanError(error);
        throw exception;
    }
}

