/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.net.AbstractAtlanResponse;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;

public class RequestMetrics {
    public static final String UPSTREAM_HEADER = "X-Kong-Upstream-Latency";
    public static final String PROXY_HEADER = "X-Kong-Proxy-Latency";
    private final Long requestDurationUpstreamMs;
    private final Long requestDurationProxyMs;
    private final long requestDurationTotalMs;

    private RequestMetrics(Long upstream, Long proxy, long elapsed) {
        this.requestDurationUpstreamMs = upstream;
        this.requestDurationProxyMs = proxy;
        this.requestDurationTotalMs = elapsed;
    }

    public static void embed(AbstractAtlanResponse<?> response, Duration elapsed) {
        Optional<String> upstream = response.headers().firstValue(UPSTREAM_HEADER);
        Optional<String> proxy = response.headers().firstValue(PROXY_HEADER);
        RequestMetrics metrics = new RequestMetrics(upstream.isEmpty() ? null : Long.valueOf(upstream.get()), proxy.isEmpty() ? null : Long.valueOf(proxy.get()), elapsed.toMillis());
        response.metrics(metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.requestDurationUpstreamMs != null) {
            sb.append(this.requestDurationUpstreamMs).append("/");
        }
        if (this.requestDurationProxyMs != null) {
            sb.append(this.requestDurationProxyMs).append("/");
        }
        sb.append(this.requestDurationTotalMs).append("ms");
        return sb.toString();
    }

    @Generated
    public Long getRequestDurationUpstreamMs() {
        return this.requestDurationUpstreamMs;
    }

    @Generated
    public Long getRequestDurationProxyMs() {
        return this.requestDurationProxyMs;
    }

    @Generated
    public long getRequestDurationTotalMs() {
        return this.requestDurationTotalMs;
    }
}

