/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.model.search.AggregationBucketDetails;
import com.atlan.model.search.AggregationBucketResult;
import com.atlan.model.search.AggregationHitsResult;
import com.atlan.model.search.AggregationMetricResult;
import com.atlan.model.search.AggregationResult;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.List;

public class AggregationResultDeserializer
extends StdDeserializer<AggregationResult> {
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public AggregationResultDeserializer(AtlanClient client) {
        this(AggregationResult.class, client);
    }

    public AggregationResultDeserializer(Class<?> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public AggregationResult deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode value = root.get("value");
        JsonNode buckets = root.get("buckets");
        JsonNode hits = root.get("hits");
        if (root.has("value") && (value == null || value.isNull()) || root.has("buckets") && (buckets == null || buckets.isNull()) || root.has("hits") && (hits == null || hits.isNull())) {
            return null;
        }
        if (value != null && value.isNumber()) {
            return AggregationMetricResult.builder().value(value.asDouble()).build();
        }
        if (buckets != null) {
            return AggregationBucketResult.builder().docCountErrorUpperBound(JacksonUtils.deserializeLong(root, "doc_count_error_upper_bound")).sumOtherDocCount(JacksonUtils.deserializeLong(root, "sum_other_doc_count")).buckets(JacksonUtils.deserializeObject(this.client, root, "buckets", new TypeReference<List<AggregationBucketDetails>>(){})).build();
        }
        if (hits != null) {
            return AggregationHitsResult.builder().hits(JacksonUtils.deserializeObject(this.client, root, "hits", new TypeReference<AggregationHitsResult.Hits>(){})).build();
        }
        throw new IOException("Aggregation currently not handled: " + root);
    }
}

