/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IndistinctAsset;
import com.atlan.model.assets.Meaning;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.serde.Removable;
import com.atlan.serde.Serde;
import com.atlan.util.JacksonUtils;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetDeserializer
extends StdDeserializer<Asset> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDeserializer.class);
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public AssetDeserializer(AtlanClient client) {
        this(Asset.class, client);
    }

    public AssetDeserializer(Class<?> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public Asset deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize((JsonNode)parser.getCodec().readTree(parser));
    }

    Asset deserialize(JsonNode root) throws IOException {
        Object value;
        Method method;
        Object deserializeName;
        Iterator itr;
        TreeSet<String> pendingTasks;
        TreeSet<Meaning> meanings;
        TreeSet<String> meaningNames;
        Class assetClass;
        Asset.AssetBuilder builder;
        JsonNode attributes = root.get("attributes");
        JsonNode relationshipGuid = root.get("relationshipGuid");
        JsonNode relationshipAttributes = root.get("relationshipAttributes");
        JsonNode businessAttributes = root.get("businessAttributes");
        JsonNode classificationNames = root.get("classificationNames");
        JsonNode typeNameJson = root.get("typeName");
        String typeName = null;
        if (typeNameJson == null || typeNameJson.isNull()) {
            builder = IndistinctAsset._internal();
            assetClass = IndistinctAsset.class;
        } else {
            typeName = root.get("typeName").asText();
            try {
                assetClass = Serde.getAssetClassForType(typeName);
                Method method2 = assetClass.getMethod("_internal", new Class[0]);
                Object result = method2.invoke(null, new Object[0]);
                builder = (Asset.AssetBuilder)result;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Unable to dynamically retrieve asset for typeName {}, falling back to an IndistinctAsset.", (Object)typeName, (Object)e);
                builder = IndistinctAsset._internal();
                assetClass = IndistinctAsset.class;
            }
        }
        ((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)((Asset.AssetBuilder)builder.typeName(JacksonUtils.deserializeString(root, "typeName"))).guid(JacksonUtils.deserializeString(root, "guid"))).displayText(JacksonUtils.deserializeString(root, "displayText"))).entityStatus(JacksonUtils.deserializeString(root, "entityStatus"))).relationshipType(JacksonUtils.deserializeString(root, "relationshipType"))).relationshipGuid(JacksonUtils.deserializeString(root, "relationshipGuid"))).relationshipStatus(JacksonUtils.deserializeObject(this.client, root, "relationshipStatus", new TypeReference<AtlanStatus>(){}))).uniqueAttributes(JacksonUtils.deserializeObject(this.client, root, "uniqueAttributes", new TypeReference<UniqueAttributes>(){}))).status(JacksonUtils.deserializeObject(this.client, root, "status", new TypeReference<AtlanStatus>(){}))).createdBy(JacksonUtils.deserializeString(root, "createdBy"))).updatedBy(JacksonUtils.deserializeString(root, "updatedBy"))).createTime(JacksonUtils.deserializeLong(root, "createTime"))).updateTime(JacksonUtils.deserializeLong(root, "updateTime"))).deleteHandler(JacksonUtils.deserializeString(root, "deleteHandler"))).isIncomplete(JacksonUtils.deserializeBoolean(root, "isIncomplete"));
        Set<AtlanTag> atlanTags = JacksonUtils.deserializeObject(this.client, root, "classifications", new TypeReference<Set<AtlanTag>>(){});
        if (atlanTags != null) {
            builder.atlanTags(atlanTags);
        }
        if ((meaningNames = JacksonUtils.deserializeObject(this.client, root, "meaningNames", new TypeReference<TreeSet<String>>(){})) != null) {
            builder.meaningNames(meaningNames);
        }
        if ((meanings = JacksonUtils.deserializeObject(this.client, root, "meanings", new TypeReference<TreeSet<Meaning>>(){})) != null) {
            builder.meanings(meanings);
        }
        if ((pendingTasks = JacksonUtils.deserializeObject(this.client, root, "pendingTasks", new TypeReference<TreeSet<String>>(){})) != null) {
            builder.pendingTasks(pendingTasks);
        }
        Class<?> builderClass = builder.getClass();
        HashMap<String, JsonNode> leftOverAttributes = new HashMap<String, JsonNode>();
        HashSet<Object> processedAttributes = new HashSet<Object>();
        if ((relationshipGuid == null || relationshipGuid.isNull()) && relationshipAttributes != null && !relationshipAttributes.isNull()) {
            itr = relationshipAttributes.fieldNames();
            while (itr.hasNext()) {
                String relnKey = (String)itr.next();
                deserializeName = ReflectionCache.getDeserializedName(assetClass, relnKey);
                method = ReflectionCache.getSetter(builderClass, (String)deserializeName);
                if (method == null) continue;
                try {
                    value = this.deserialize(relationshipAttributes.get(relnKey), method, (String)deserializeName);
                    boolean set = ReflectionCache.setValue(builder, (String)deserializeName, value);
                    if (!set) continue;
                    processedAttributes.add(deserializeName);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Missing fromValue method for enum.", e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IOException("Failed to deserialize through reflection.", e);
                }
            }
        }
        if (attributes != null && !attributes.isNull()) {
            itr = attributes.fieldNames();
            while (itr.hasNext()) {
                String attrKey = (String)itr.next();
                deserializeName = ReflectionCache.getDeserializedName(assetClass, attrKey);
                if (processedAttributes.contains(deserializeName)) continue;
                method = ReflectionCache.getSetter(builderClass, (String)deserializeName);
                if (method != null) {
                    try {
                        value = this.deserialize(attributes.get(attrKey), method, (String)deserializeName);
                        ReflectionCache.setValue(builder, (String)deserializeName, value);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        throw new IOException("Missing fromValue method for enum.", e);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IOException("Failed to deserialize through reflection.", e);
                    }
                }
                leftOverAttributes.put(attrKey, attributes.get(attrKey));
            }
        }
        Map<String, CustomMetadataAttributes> cm = null;
        if (!leftOverAttributes.isEmpty()) {
            try {
                cm = this.client.getCustomMetadataCache().getCustomMetadataFromSearchResult(leftOverAttributes);
            }
            catch (AtlanException e) {
                throw new IOException("Unable to deserialize custom metadata from search result.", e);
            }
        }
        if (businessAttributes != null) {
            try {
                cm = this.client.getCustomMetadataCache().getCustomMetadataFromBusinessAttributes(businessAttributes);
            }
            catch (AtlanException e) {
                throw new IOException("Unable to deserialize custom metadata.", e);
            }
        }
        HashSet<String> clsNames = null;
        if (classificationNames != null && classificationNames.isArray()) {
            clsNames = new HashSet<String>();
            try {
                for (JsonNode element : classificationNames) {
                    String name = this.client.getAtlanTagCache().getNameForId(element.asText());
                    clsNames.add(name);
                }
            }
            catch (AtlanException e) {
                throw new IOException("Unable to deserialize Atlan tag name.", e);
            }
        }
        if (typeName != null && typeName.equals("Readme")) {
            builder.description(StringUtils.decodeContent(((Asset)builder.build()).getDescription()));
        }
        if (cm != null) {
            builder.customMetadataSets(cm);
        }
        if (clsNames != null) {
            builder.atlanTagNames(clsNames);
        }
        return builder.build();
    }

    private Object deserialize(JsonNode jsonNode, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (jsonNode.isValueNode()) {
            return this.deserializePrimitive(jsonNode, method, fieldName);
        }
        if (jsonNode.isArray()) {
            return this.deserializeList((ArrayNode)jsonNode, method, fieldName);
        }
        if (jsonNode.isObject()) {
            return this.deserializeObject(jsonNode, method);
        }
        return null;
    }

    private Collection<?> deserializeList(ArrayNode array, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        Class<?> paramClass = ReflectionCache.getParameterOfMethod(method);
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonNode element : array) {
            Object deserialized = this.deserializeElement(element, method, fieldName);
            list.add(deserialized);
        }
        if (paramClass == Collection.class || paramClass == List.class) {
            return list;
        }
        if (paramClass == Set.class || paramClass == SortedSet.class) {
            return new TreeSet(list);
        }
        throw new IOException("Unable to deserialize JSON list to Java class: " + paramClass.getCanonicalName());
    }

    private Object deserializeObject(JsonNode jsonObject, Method method) {
        Class<?> paramClass = ReflectionCache.getParameterOfMethod(method);
        if (paramClass == Map.class && ReflectionCache.getParameterizedTypeOfMethod(method).getTypeName().equals("java.util.Map<? extends java.lang.String, ? extends java.lang.Long>")) {
            return this.client.convertValue(jsonObject, new TypeReference<Map<String, Long>>(){});
        }
        return this.client.convertValue(jsonObject, paramClass);
    }

    private Object deserializeElement(JsonNode element, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        Type paramType = ReflectionCache.getParameterizedTypeOfMethod(method);
        Class<?> innerClass = ReflectionCache.getClassOfParameterizedType(paramType);
        if (element.isValueNode()) {
            if (fieldName.equals("purposeAtlanTags")) {
                String value;
                try {
                    value = this.client.getAtlanTagCache().getNameForId(element.asText());
                }
                catch (NotFoundException e) {
                    value = "(DELETED)";
                }
                catch (AtlanException e) {
                    throw new IOException("Unable to deserialize purposeAtlanTags.", e);
                }
                return value;
            }
            return JacksonUtils.deserializePrimitive(element, method, innerClass);
        }
        if (element.isArray()) {
            throw new IOException("Directly-nested arrays are not supported.");
        }
        if (element.isObject()) {
            return this.client.convertValue(element, innerClass);
        }
        return null;
    }

    private Object deserializePrimitive(JsonNode primitive, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (primitive.isNull()) {
            return Removable.NULL;
        }
        Object value = JacksonUtils.deserializePrimitive(primitive, method);
        if (fieldName.equals("mappedAtlanTagName")) {
            try {
                value = this.client.getAtlanTagCache().getNameForId(primitive.asText());
            }
            catch (NotFoundException e) {
                value = "(DELETED)";
            }
            catch (AtlanException e) {
                throw new IOException("Unable to deserialize mappedAtlanTagName.", e);
            }
        }
        return value;
    }
}

