/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.serde.Removable;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class AssetSerializer
extends StdSerializer<Asset> {
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public AssetSerializer(AtlanClient client) {
        this(Asset.class, client);
    }

    public AssetSerializer(Class<Asset> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public void serializeWithType(Asset value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }

    public void serialize(Asset asset, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
        Class<?> clazz = asset.getClass();
        Set<String> nullFields = asset.getNullFields();
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> businessAttributes = new LinkedHashMap<String, Map<String, Object>>();
        gen.writeStartObject();
        try {
            for (String fieldName : ReflectionCache.getFieldNames(clazz)) {
                Object attrValue;
                if (ReflectionCache.isAttribute(clazz, fieldName)) {
                    boolean skip;
                    Class<?> type;
                    attrValue = nullFields.contains(fieldName) ? ((type = ReflectionCache.getFieldType(clazz, fieldName)) == List.class || type == Set.class || type == SortedSet.class ? Removable.EMPTY_LIST : Removable.NULL) : ReflectionCache.getValue(asset, fieldName);
                    if (attrValue == null || (skip = attrValue instanceof Collection && ((Collection)attrValue).isEmpty() || attrValue instanceof Map && ((Map)attrValue).isEmpty())) continue;
                    if (fieldName.equals("mappedAtlanTagName")) {
                        String mappedName;
                        try {
                            mappedName = this.client.getAtlanTagCache().getIdForName(attrValue.toString());
                        }
                        catch (NotFoundException e) {
                            mappedName = "(DELETED)";
                        }
                        catch (AtlanException e) {
                            throw new IOException("Unable to serialize mappedAtlanTagName.", e);
                        }
                        attrValue = mappedName;
                    } else if (fieldName.equals("purposeAtlanTags") && attrValue instanceof Collection) {
                        ArrayList<String> mappedNames = new ArrayList<String>();
                        for (Object one : (Collection)attrValue) {
                            try {
                                mappedNames.add(this.client.getAtlanTagCache().getIdForName(one.toString()));
                            }
                            catch (NotFoundException e) {
                                mappedNames.add("(DELETED)");
                            }
                            catch (AtlanException e) {
                                throw new IOException("Unable to serialize purposeAtlanTags.", e);
                            }
                        }
                        attrValue = mappedNames;
                    }
                    String serializeName = ReflectionCache.getSerializedName(clazz, fieldName);
                    attributes.put(serializeName, attrValue);
                    continue;
                }
                if (fieldName.equals("customMetadataSets")) {
                    Map<String, CustomMetadataAttributes> cm = asset.getCustomMetadataSets();
                    if (cm == null || cm.isEmpty()) continue;
                    this.client.getCustomMetadataCache().getBusinessAttributesFromCustomMetadata(cm, businessAttributes);
                    continue;
                }
                attrValue = ReflectionCache.getValue(asset, fieldName);
                if (attrValue == null || attrValue instanceof Collection && ((Collection)attrValue).isEmpty()) continue;
                String serializeName = ReflectionCache.getSerializedName(clazz, fieldName);
                sp.defaultSerializeField(serializeName, attrValue, gen);
            }
        }
        catch (AtlanException e) {
            throw new IOException("Unable to retrieve the available custom metadata in Atlan.", e);
        }
        if (!attributes.isEmpty()) {
            if (asset.getTypeName() != null && asset.getTypeName().equals("Readme")) {
                String unencoded = (String)attributes.get("description");
                attributes.put("description", StringUtils.encodeContent(unencoded));
            }
            sp.defaultSerializeField("attributes", attributes, gen);
        }
        if (!businessAttributes.isEmpty()) {
            sp.defaultSerializeField("businessAttributes", businessAttributes, gen);
        }
        gen.writeEndObject();
    }
}

