/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;

public class AtlanTagDeserializer
extends StdDeserializer<AtlanTag> {
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public AtlanTagDeserializer(AtlanClient client) {
        super(AtlanTag.class);
        this.client = client;
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public AtlanTag deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize((JsonNode)parser.getCodec().readTree(parser));
    }

    AtlanTag deserialize(JsonNode root) throws IOException {
        String clsId = root.get("typeName").asText();
        if (clsId == null) {
            throw new IOException("Unable to deserialize Atlan tag from: " + root);
        }
        String clsName = null;
        try {
            clsName = this.client.getAtlanTagCache().getNameForId(clsId);
        }
        catch (NotFoundException notFoundException) {
        }
        catch (AtlanException e) {
            throw new IOException("Unable to find Atlan tag with ID-string: " + clsId, e);
        }
        if (clsName == null) {
            return ((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)AtlanTag.builder().typeName("(DELETED)")).entityGuid(JacksonUtils.deserializeString(root, "entityGuid"))).entityStatus(JacksonUtils.deserializeObject(this.client, root, "entityStatus", new TypeReference<AtlanStatus>(){}))).propagate(JacksonUtils.deserializeBoolean(root, "propagate"))).removePropagationsOnEntityDelete(JacksonUtils.deserializeBoolean(root, "removePropagationsOnEntityDelete"))).restrictPropagationThroughLineage(JacksonUtils.deserializeBoolean(root, "restrictPropagationThroughLineage"))).build();
        }
        return ((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)AtlanTag.builder().typeName(clsName)).entityGuid(JacksonUtils.deserializeString(root, "entityGuid"))).entityStatus(JacksonUtils.deserializeObject(this.client, root, "entityStatus", new TypeReference<AtlanStatus>(){}))).propagate(JacksonUtils.deserializeBoolean(root, "propagate"))).removePropagationsOnEntityDelete(JacksonUtils.deserializeBoolean(root, "removePropagationsOnEntityDelete"))).restrictPropagationThroughLineage(JacksonUtils.deserializeBoolean(root, "restrictPropagationThroughLineage"))).build();
    }
}

