/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class ClientAwareDeserializationContext
extends DefaultDeserializationContext {
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public ClientAwareDeserializationContext(DeserializerFactory df, DeserializerCache cache, AtlanClient client) {
        super(df, cache);
        this.client = client;
    }

    private ClientAwareDeserializationContext(ClientAwareDeserializationContext src, DeserializerFactory factory) {
        super((DefaultDeserializationContext)src, factory);
        this.client = src.client;
    }

    private ClientAwareDeserializationContext(ClientAwareDeserializationContext src) {
        super((DefaultDeserializationContext)src);
        this.client = src.client;
    }

    private ClientAwareDeserializationContext(ClientAwareDeserializationContext src, DeserializationConfig config, JsonParser p, InjectableValues values) {
        super((DefaultDeserializationContext)src, config, p, values);
        this.client = src.client;
    }

    private ClientAwareDeserializationContext(ClientAwareDeserializationContext src, DeserializationConfig config) {
        super((DefaultDeserializationContext)src, config);
        this.client = src.client;
    }

    public DefaultDeserializationContext with(DeserializerFactory factory) {
        return new ClientAwareDeserializationContext(this, factory);
    }

    public DefaultDeserializationContext copy() {
        ClassUtil.verifyMustOverride(ClientAwareDeserializationContext.class, (Object)((Object)this), (String)"copy");
        return new ClientAwareDeserializationContext(this);
    }

    public DefaultDeserializationContext createInstance(DeserializationConfig config, JsonParser p, InjectableValues values) {
        return new ClientAwareDeserializationContext(this, config, p, values);
    }

    public DefaultDeserializationContext createDummyInstance(DeserializationConfig config) {
        return new ClientAwareDeserializationContext(this, config);
    }

    public JsonDeserializer<Object> deserializerInstance(Annotated ann, Object deserDef) throws JsonMappingException {
        JsonDeserializer deser;
        if (deserDef == null) {
            return null;
        }
        if (deserDef instanceof JsonDeserializer) {
            deser = (JsonDeserializer)deserDef;
        } else {
            if (!(deserDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + deserDef.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
            }
            Class deserClass = (Class)deserDef;
            if (deserClass == JsonDeserializer.None.class || ClassUtil.isBogusClass((Class)deserClass)) {
                return null;
            }
            if (!JsonDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + deserClass.getName() + "; expected Class<JsonDeserializer>");
            }
            HandlerInstantiator hi = this._config.getHandlerInstantiator();
            JsonDeserializer jsonDeserializer = deser = hi == null ? null : hi.deserializerInstance(this._config, ann, deserClass);
            if (deser == null) {
                Constructor ctor = ClientAwareDeserializationContext.findClientAwareConstructor(deserClass, this._config.canOverrideAccessModifiers());
                if (ctor == null) {
                    deser = (JsonDeserializer)ClassUtil.createInstance((Class)deserClass, (boolean)this._config.canOverrideAccessModifiers());
                } else {
                    try {
                        deser = (JsonDeserializer)ctor.newInstance(this.client);
                    }
                    catch (Exception e) {
                        ClassUtil.unwrapAndThrowAsIAE((Throwable)e, (String)("Failed to instantiate class " + deserClass.getName() + ", problem: " + e.getMessage()));
                        return null;
                    }
                }
            }
        }
        if (deser instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)deser).resolve((DeserializationContext)this);
        }
        return deser;
    }

    private static <T> Constructor<T> findClientAwareConstructor(Class<T> cls, boolean forceAccess) {
        try {
            Constructor<T> ctor = cls.getDeclaredConstructor(AtlanClient.class);
            if (forceAccess) {
                ClassUtil.checkAndFixAccess(ctor, (boolean)forceAccess);
            } else if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + cls.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: cannot instantiate type");
            }
            return ctor;
        }
        catch (NoSuchMethodException ctor) {
        }
        catch (Exception e) {
            ClassUtil.unwrapAndThrowAsIAE((Throwable)e, (String)("Failed to find default constructor of class " + cls.getName() + ", problem: " + e.getMessage()));
        }
        return null;
    }
}

