/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMetadataMapSerializer
extends StdSerializer<Map<String, CustomMetadataAttributes>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomMetadataMapSerializer.class);
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public CustomMetadataMapSerializer(AtlanClient client) {
        this(null, client);
    }

    public CustomMetadataMapSerializer(Class<Map<String, CustomMetadataAttributes>> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public void serializeWithType(Map<String, CustomMetadataAttributes> value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }

    public void serialize(Map<String, CustomMetadataAttributes> cmMap, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
        gen.writeStartObject();
        if (cmMap != null) {
            for (Map.Entry<String, CustomMetadataAttributes> entry : cmMap.entrySet()) {
                String cmId;
                String cmName = entry.getKey();
                if (cmName == null) continue;
                CustomMetadataAttributes cma = entry.getValue();
                if (cmName.equals("(DELETED)")) {
                    cmId = "(DELETED)";
                    JacksonUtils.serializeObject(gen, cmId, Collections.emptyMap());
                    continue;
                }
                try {
                    cmId = this.client.getCustomMetadataCache().getIdForName(cmName);
                    if (cma != null) {
                        HashMap<String, Object> idToValue = new HashMap<String, Object>();
                        this.client.getCustomMetadataCache().getIdMapFromNameMap(cmName, cma.getAttributes(), idToValue);
                        JacksonUtils.serializeObject(gen, cmId, idToValue);
                        continue;
                    }
                    JacksonUtils.serializeObject(gen, cmId, Collections.emptyMap());
                }
                catch (AtlanException e) {
                    log.error("Unable to find custom metadata with name {}, or translate one of its attributes.", (Object)cmName, (Object)e);
                }
            }
        }
        gen.writeEndObject();
    }
}

