/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import com.atlan.AtlanClient;
import com.atlan.model.assets.Asset;
import com.atlan.model.structs.AtlanStruct;
import com.atlan.serde.ClientAwareDeserializationContext;
import com.atlan.serde.ClientAwareSerializerProvider;
import com.atlan.serde.ElasticAggregationDeserializer;
import com.atlan.serde.ElasticObjectSerializer;
import com.atlan.serde.ElasticQueryDeserializer;
import com.atlan.serde.ElasticSortOptionsDeserializer;
import com.atlan.serde.StructDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serde {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Serde.class);
    public static final String DELETED_AUDIT_OBJECT = "(DELETED)";
    private static final Set<Module> SIMPLE_MODULES = Serde.createModules();
    public static final ObjectMapper allInclusiveMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS);
    static final JsonpMapper jsonpMapper = new JacksonJsonpMapper();
    private static final Map<String, JsonDeserializer<?>> deserializerCache = new ConcurrentHashMap();
    private static final Map<String, Class<?>> assetClasses = Serde.scanAssets();

    private static Map<String, Class<?>> scanAssets() {
        HashMap assetMap = new HashMap();
        try (ScanResult scanResult = new ClassGraph().enableExternalClasses().scan();){
            for (ClassInfo info : scanResult.getSubclasses(Asset.class)) {
                String fullName = info.getName();
                try {
                    Class<?> typeClass = Class.forName(fullName);
                    String typeName = (String)typeClass.getField("TYPE_NAME").get(null);
                    assetMap.put(typeName, typeClass);
                }
                catch (ClassNotFoundException e) {
                    log.error("Unable to load class: {}", (Object)fullName, (Object)e);
                }
                catch (NoSuchFieldException e) {
                    log.error("Asset class is missing the static TYPE_NAME giving its type: {}", (Object)fullName, (Object)e);
                }
                catch (IllegalAccessException e) {
                    log.error("Unable to access the static TYPE_NAME for the asset class: {}", (Object)fullName, (Object)e);
                }
            }
        }
        return Collections.unmodifiableMap(assetMap);
    }

    public static Class<?> getAssetClassForType(String typeName) throws ClassNotFoundException {
        Class result = assetClasses.getOrDefault(typeName, null);
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException("Unable to find asset class for typeName: " + typeName);
    }

    private static Set<Module> createModules() {
        LinkedHashSet<Module> set = new LinkedHashSet<Module>();
        SimpleModule elastic = new SimpleModule().addSerializer(Aggregation.class, new ElasticObjectSerializer()).addDeserializer(Aggregation.class, (JsonDeserializer)new ElasticAggregationDeserializer()).addSerializer(Query.class, new ElasticObjectSerializer()).addDeserializer(Query.class, (JsonDeserializer)new ElasticQueryDeserializer()).addSerializer(SortOptions.class, new ElasticObjectSerializer()).addDeserializer(SortOptions.class, (JsonDeserializer)new ElasticSortOptionsDeserializer());
        set.add((Module)elastic);
        SimpleModule structs = new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                Class<?> enclosing = beanDesc.getBeanClass().getEnclosingClass();
                if (enclosing != null && enclosing.getSuperclass() == AtlanStruct.class) {
                    if (!deserializerCache.containsKey(beanDesc.getBeanClass().getCanonicalName())) {
                        deserializerCache.put(beanDesc.getBeanClass().getCanonicalName(), (JsonDeserializer<?>)new StructDeserializer(deserializer));
                    }
                    return deserializerCache.get(beanDesc.getBeanClass().getCanonicalName());
                }
                return deserializer;
            }
        });
        set.add((Module)structs);
        return set;
    }

    public static ObjectMapper createMapper(AtlanClient client) {
        ObjectMapper om = new ObjectMapper(null, null, (DefaultDeserializationContext)new ClientAwareDeserializationContext((DeserializerFactory)BeanDeserializerFactory.instance, null, client)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (Module m : SIMPLE_MODULES) {
            om.registerModule(m);
        }
        ClientAwareSerializerProvider casp = new ClientAwareSerializerProvider(client);
        om.setSerializerProvider((DefaultSerializerProvider)casp);
        return om;
    }
}

