/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IndistinctAsset;
import com.atlan.model.core.AssetMutationResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetBatch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetBatch.class);
    private final AtlanClient client;
    private List<Asset> _batch;
    private final String typeName;
    private final int maxSize;
    private final boolean replaceAtlanTags;
    private final CustomMetadataHandling customMetadataHandling;
    private final boolean captureFailures;
    private final List<Asset> created;
    private final List<Asset> updated;
    private final List<FailedBatch> failures;

    public AssetBatch(AtlanClient client, String typeName, int maxSize) {
        this(client, typeName, maxSize, false, CustomMetadataHandling.IGNORE);
    }

    public AssetBatch(AtlanClient client, String typeName, int maxSize, boolean replaceAtlanTags, CustomMetadataHandling customMetadataHandling) {
        this(client, typeName, maxSize, replaceAtlanTags, customMetadataHandling, false);
    }

    public AssetBatch(AtlanClient client, String typeName, int maxSize, boolean replaceAtlanTags, CustomMetadataHandling customMetadataHandling, boolean captureFailures) {
        this.client = client;
        this._batch = Collections.synchronizedList(new ArrayList());
        this.failures = Collections.synchronizedList(new ArrayList());
        this.typeName = typeName;
        this.maxSize = maxSize;
        this.replaceAtlanTags = replaceAtlanTags;
        this.customMetadataHandling = customMetadataHandling;
        this.created = Collections.synchronizedList(new ArrayList());
        this.updated = Collections.synchronizedList(new ArrayList());
        this.captureFailures = captureFailures;
    }

    public AssetMutationResponse add(Asset single) throws AtlanException {
        this._batch.add(single);
        return this.process();
    }

    private AssetMutationResponse process() throws AtlanException {
        if (this._batch.size() == this.maxSize) {
            return this.flush();
        }
        return null;
    }

    public AssetMutationResponse flush() throws AtlanException {
        AssetMutationResponse response = null;
        if (!this._batch.isEmpty()) {
            try {
                log.debug("... saving next batch of ({}) {}s...", (Object)this._batch.size(), (Object)this.typeName);
                switch (this.customMetadataHandling) {
                    case IGNORE: {
                        response = this.client.assets.save(this._batch, this.replaceAtlanTags);
                        break;
                    }
                    case OVERWRITE: {
                        response = this.client.assets.saveReplacingCM(this._batch, this.replaceAtlanTags);
                        break;
                    }
                    case MERGE: {
                        response = this.client.assets.saveMergingCM(this._batch, this.replaceAtlanTags);
                    }
                }
            }
            catch (AtlanException e) {
                if (this.captureFailures) {
                    this.failures.add(new FailedBatch(this._batch, e));
                }
                throw e;
            }
            this._batch = Collections.synchronizedList(new ArrayList());
        }
        this.trackResponse(response);
        return response;
    }

    private void trackResponse(AssetMutationResponse response) {
        if (response != null) {
            response.getCreatedAssets().forEach(a -> this.track(this.created, (Asset)a));
            response.getUpdatedAssets().forEach(a -> this.track(this.updated, (Asset)a));
        }
    }

    private void track(List<Asset> tracker, Asset candidate) {
        try {
            tracker.add((Asset)((Asset.AssetBuilder)candidate.trimToRequired().name(candidate.getName())).build());
        }
        catch (InvalidRequestException e) {
            tracker.add(((IndistinctAsset.IndistinctAssetBuilder)((IndistinctAsset.IndistinctAssetBuilder)IndistinctAsset._internal().typeName(candidate.getTypeName()).guid(candidate.getGuid())).qualifiedName(candidate.getQualifiedName())).build());
        }
    }

    @Generated
    public List<Asset> getCreated() {
        return this.created;
    }

    @Generated
    public List<Asset> getUpdated() {
        return this.updated;
    }

    @Generated
    public List<FailedBatch> getFailures() {
        return this.failures;
    }

    public static final class FailedBatch {
        private final List<Asset> failedAssets;
        private final Exception failureReason;

        public FailedBatch(List<Asset> failedAssets, Exception failureReason) {
            this.failedAssets = Collections.unmodifiableList(failedAssets);
            this.failureReason = failureReason;
        }

        @Generated
        public List<Asset> getFailedAssets() {
            return this.failedAssets;
        }

        @Generated
        public Exception getFailureReason() {
            return this.failureReason;
        }
    }

    public static enum CustomMetadataHandling {
        IGNORE,
        OVERWRITE,
        MERGE;

    }
}

