/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern whitespacePattern = Pattern.compile("\\s");
    private static final Pattern connectionQNPrefix = Pattern.compile("(default/[a-z0-9-]+/[0-9]{10})/.*");
    private static final Pattern uuidPattern = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");

    public static boolean containsWhitespace(String str) {
        Objects.requireNonNull(str);
        return whitespacePattern.matcher(str).find();
    }

    public static boolean secureCompare(String a, String b) {
        byte[] digesta = a.getBytes(StandardCharsets.UTF_8);
        byte[] digestb = b.getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(digesta, digestb);
    }

    public static String getFieldNameFromMethodName(String methodName) {
        if (methodName.length() > 3 && (methodName.startsWith("set") || methodName.startsWith("get"))) {
            StringBuilder sb = new StringBuilder(methodName);
            sb.delete(0, 3);
            sb.replace(0, 1, sb.substring(0, 1).toLowerCase(Locale.ROOT));
            return sb.toString();
        }
        return null;
    }

    public static String encodeContent(String decoded) {
        return decoded == null ? null : URLEncoder.encode(decoded, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static String decodeContent(String encoded) {
        return encoded == null ? null : URLDecoder.decode(encoded.replace("%20", "+"), StandardCharsets.UTF_8);
    }

    public static String getConnectionQualifiedName(String qualifiedName) {
        Matcher m;
        if (qualifiedName != null && (m = connectionQNPrefix.matcher(qualifiedName)).find() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    public static String getNameFromQualifiedName(String qualifiedName) {
        if (qualifiedName != null && qualifiedName.indexOf("/") > 0) {
            return qualifiedName.substring(qualifiedName.lastIndexOf("/") + 1);
        }
        return null;
    }

    public static String getParentQualifiedNameFromQualifiedName(String qualifiedName) {
        if (qualifiedName != null && qualifiedName.indexOf("/") > 0) {
            return qualifiedName.substring(0, qualifiedName.lastIndexOf("/"));
        }
        return null;
    }

    public static String trimPathDelimiters(String toTrim) {
        if (toTrim == null) {
            return "";
        }
        if (toTrim.startsWith("/")) {
            toTrim = toTrim.substring(1);
        }
        if (toTrim.endsWith("/")) {
            toTrim = toTrim.substring(0, toTrim.length() - 1);
        }
        return toTrim;
    }

    public static boolean isUUID(String str) {
        return str != null && uuidPattern.matcher(str).find();
    }
}

