/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanFile;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class FilesEndpoint
extends HeraclesEndpoint {
    private static final String endpoint = "/files";

    public FilesEndpoint(AtlanClient client) {
        super(client);
    }

    public AtlanFile upload(String fromUrl) throws AtlanException, MalformedURLException, IOException {
        return this.upload(fromUrl, null);
    }

    public AtlanFile upload(String fromUrl, RequestOptions options) throws AtlanException, MalformedURLException, IOException {
        URL url = new URL(fromUrl);
        return this.upload(url.openStream(), url.getFile(), options);
    }

    public AtlanFile upload(File file) throws AtlanException, IOException {
        return this.upload(file, null);
    }

    public AtlanFile upload(File file, RequestOptions options) throws AtlanException, IOException {
        return this.upload(new FileInputStream(file), file.getName(), options);
    }

    public AtlanFile upload(InputStream fileSrc, String filename) throws AtlanException {
        return this.upload(fileSrc, filename, null);
    }

    public AtlanFile upload(InputStream fileSrc, String filename, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        Map<String, String> extras = Map.of("name", "name", "prefix", "custom_file_upload", "force", "false", "excludePrefix", "false");
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, fileSrc, filename, AtlanFile.class, extras, options);
    }
}

