/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.ObjectName;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAssetCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAssetCache.class);
    private final Map<String, String> qualifiedName2Guid = new ConcurrentHashMap<String, String>();
    private final Map<ObjectName, String> name2Guid = new ConcurrentHashMap<ObjectName, String>();
    private final Map<String, Asset> guid2Asset = new ConcurrentHashMap<String, Asset>();
    protected final AtlanClient client;

    protected AbstractAssetCache(AtlanClient client) {
        this.client = client;
    }

    public abstract void lookupByGuid(String var1) throws AtlanException;

    public abstract void lookupByQualifiedName(String var1) throws AtlanException;

    public abstract void lookupByName(ObjectName var1) throws AtlanException;

    public abstract ObjectName getName(Asset var1);

    protected String cache(Asset asset) {
        ObjectName name;
        if (asset != null && (name = this.getName(asset)) != null) {
            String guid = asset.getGuid();
            this.name2Guid.put(name, asset.getGuid());
            this.guid2Asset.put(guid, asset);
            this.qualifiedName2Guid.put(asset.getQualifiedName(), guid);
            this.name2Guid.put(name, guid);
            return guid;
        }
        return null;
    }

    public boolean isGuidKnown(String guid) {
        return this.guid2Asset.containsKey(guid);
    }

    public boolean isQualifiedNameKnown(String qualifiedName) {
        return this.qualifiedName2Guid.containsKey(qualifiedName);
    }

    public boolean isNameKnown(ObjectName name) {
        return this.name2Guid.containsKey(name);
    }

    public Asset getByGuid(String guid) throws AtlanException {
        return this.getByGuid(guid, true);
    }

    public Asset getByGuid(String guid, boolean allowRefresh) throws AtlanException {
        if (guid != null && !guid.isEmpty()) {
            Asset found = this.guid2Asset.get(guid);
            if (found == null && allowRefresh) {
                this.lookupByGuid(guid);
                found = this.guid2Asset.get(guid);
            }
            if (found == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, guid);
            }
            return found;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public Asset getByQualifiedName(String qualifiedName) throws AtlanException {
        return this.getByQualifiedName(qualifiedName, true);
    }

    public Asset getByQualifiedName(String qualifiedName, boolean allowRefresh) throws AtlanException {
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            String guid = this.qualifiedName2Guid.get(qualifiedName);
            if (guid == null && allowRefresh) {
                this.lookupByQualifiedName(qualifiedName);
                guid = this.qualifiedName2Guid.get(qualifiedName);
            }
            if (guid == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, qualifiedName);
            }
            return this.getByGuid(guid, false);
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public Asset getByName(ObjectName name) throws AtlanException {
        return this.getByName(name, true);
    }

    public Asset getByName(ObjectName name, boolean allowRefresh) throws AtlanException {
        if (name != null) {
            String guid = this.name2Guid.get(name);
            if (guid == null && allowRefresh) {
                this.lookupByName(name);
                guid = this.name2Guid.get(name);
            }
            if (guid == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, name.toString());
            }
            return this.getByGuid(guid, false);
        }
        throw new InvalidRequestException(ErrorCode.MISSING_NAME);
    }
}

