/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.core.AtlanObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMassCache<T extends AtlanObject> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMassCache.class);
    protected final Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    protected final Map<String, T> mapIdToObject = new ConcurrentHashMap<String, T>();
    protected AtomicBoolean bulkRefresh = new AtomicBoolean(true);

    public synchronized void refreshCache() throws AtlanException {
        this.mapIdToName.clear();
        this.mapNameToId.clear();
        this.mapIdToObject.clear();
    }

    public abstract void lookupById(String var1) throws AtlanException;

    public abstract void lookupByName(String var1) throws AtlanException;

    protected void cache(String id, String name, T object) {
        this.mapIdToName.put(id, name);
        this.mapNameToId.put(name, id);
        if (object != null) {
            this.mapIdToObject.put(id, object);
        }
    }

    public boolean isNameKnown(String name) {
        return this.mapNameToId.containsKey(name);
    }

    public boolean isIdKnown(String id) {
        return this.mapIdToName.containsKey(id);
    }

    public String getIdForName(String name) throws AtlanException {
        return this.getIdForName(name, true);
    }

    public String getIdForName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String id = this.mapNameToId.get(name);
            if (id == null && allowRefresh) {
                if (this.bulkRefresh.get()) {
                    this.refreshCache();
                } else {
                    this.lookupByName(name);
                }
                id = this.mapNameToId.get(name);
            }
            if (id == null) {
                throw new NotFoundException(ErrorCode.ID_NOT_FOUND_BY_NAME, name);
            }
            return id;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_NAME);
    }

    public String getNameForId(String id) throws AtlanException {
        return this.getNameForId(id, true);
    }

    public String getNameForId(String id, boolean allowRefresh) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            String name = this.mapIdToName.get(id);
            if (name == null && allowRefresh) {
                if (this.bulkRefresh.get()) {
                    this.refreshCache();
                } else {
                    this.lookupById(id);
                }
                name = this.mapIdToName.get(id);
            }
            if (name == null) {
                throw new NotFoundException(ErrorCode.NAME_NOT_FOUND_BY_ID, id);
            }
            return name;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public T getById(String id) throws AtlanException {
        return this.getById(id, true);
    }

    public T getById(String id, boolean allowRefresh) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            AtlanObject result = (AtlanObject)this.mapIdToObject.get(id);
            if (result == null && allowRefresh) {
                if (this.bulkRefresh.get()) {
                    this.refreshCache();
                } else {
                    this.lookupById(id);
                }
                result = (AtlanObject)this.mapIdToObject.get(id);
            }
            if (result == null) {
                throw new NotFoundException(ErrorCode.NAME_NOT_FOUND_BY_ID, id);
            }
            return (T)result;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public T getByName(String name) throws AtlanException {
        return this.getByName(name, true);
    }

    public T getByName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String id = this.getIdForName(name, allowRefresh);
            return this.getById(id, false);
        }
        throw new InvalidRequestException(ErrorCode.MISSING_NAME);
    }

    @Generated
    public AtomicBoolean getBulkRefresh() {
        return this.bulkRefresh;
    }
}

